/*
 * Decompiled with CFR 0.152.
 */
package com.android.opengles;

import android.graphics.Bitmap;
import android.opengl.GLSurfaceView;
import android.util.Log;
import com.android.opengles.FrameBuffer;
import com.android.opengles.OpenglesAgent;
import ipc.android.sdk.impl.PlayCtrlAgent;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class OpenglesRender
implements GLSurfaceView.Renderer {
    final String TAG = "OpenglesRender";
    private Vector<FrameBuffer> mFrameVector;
    private GLSurfaceView mSurface;
    public int mBranchNO = 0;
    public boolean mIsRecording;
    private boolean mIsStartRender;
    private boolean mIsStartShot;
    private boolean m_isDrawFrame = false;
    private String mShotFileName;
    public int mViewWidth;
    public int mViewHeight;
    public int mStartX;
    public int mStartY;
    public int mScaleBitmapW;
    public int mScaleBitmapH;
    public int mSrcBitmapW;
    public int mSrcBitmapH;
    public float mTargetX;
    public float mTargetY;
    public float mTargetW;
    public float mTargetH;
    public static final int VIDEO_STATE_NONE = -1;
    public static final int VIDEO_STATE_STOP = 0;
    public static final int VIDEO_STATE_START = 1;
    public static final int VIDEO_STATE_PLAYING = 2;
    public static final int VIDEO_MODE_NONE = 0;
    public static final int VIDEO_MODE_FIT = 1;
    public static final int VIDEO_MODE_CENTER = 2;
    public static final int VIDEO_MODE_FILL = 3;
    public static final int VIDEO_MODE_CUSTOM = 4;
    private int mVideoMode = 1;
    public boolean mIsStopVideo;
    private int m_max_frame_size = 3;
    private PlayCtrlAgent mPlayCtrlAgent;
    OpenglesAgent mOpenglesAgent;
    public float bitmapScale = 1.0f;
    private ISnapshotCallback m_snapshotCb;
    private CheckCallback mCheckCallback;
    public int mVideoState;
    private boolean mIsStartCheck;
    private Thread mCheckThread;
    private final int MAX_TIME_OUT = 5;
    private final int CHECK_INTERVAL_TIME = 500;
    private final int MAX_TIMEOUT_NUMS = 10;
    private int mTimeOutNums = 0;

    public OpenglesRender(GLSurfaceView gLSurfaceView) {
        this(gLSurfaceView, 0);
    }

    public OpenglesRender(GLSurfaceView gLSurfaceView, int n) {
        this.mSurface = gLSurfaceView;
        this.mBranchNO = n;
        this.start();
    }

    public void start() {
        if (!this.mIsStartRender || this.mOpenglesAgent == null) {
            this.mFrameVector = new Vector();
            this.mOpenglesAgent = new OpenglesAgent(this.mBranchNO);
            this.mIsStartRender = true;
        }
    }

    public void destory() {
        this.mIsStartRender = false;
        if (this.mFrameVector != null) {
            this.mFrameVector.clear();
        }
        if (this.mOpenglesAgent != null) {
            this.mOpenglesAgent.realseGL(this.mBranchNO);
            this.mOpenglesAgent = null;
        }
    }

    public void onDrawFrame(GL10 gL10) {
        Log.i((String)"OpenglesRender", (String)(System.currentTimeMillis() + "-OpenglesRender@onDrawFrame:" + this.mBranchNO + ", " + "" + "FrameSize=" + this.mFrameVector.size() + ",mIsStartRender=" + this.mIsStartRender + ",mIsStopVideo" + this.mIsStopVideo));
        long l = System.currentTimeMillis();
        if (this.mIsStartRender && this.mFrameVector != null && this.mFrameVector.size() > 0) {
            if (this.mIsStopVideo) {
                this.mFrameVector.clear();
                gL10.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
                this.mSurface.setBackgroundColor(-16777216);
                this.m_isDrawFrame = false;
                return;
            }
            FrameBuffer frameBuffer = this.mFrameVector.remove(0);
            if (this.mIsStartShot && frameBuffer != null) {
                try {
                    Log.e((String)"OpenglesRender", (String)"startShot...begin");
                    int n = frameBuffer.width;
                    int n2 = frameBuffer.height;
                    int[] nArray = new int[n * n2 * 16 / 8];
                    if (this.mPlayCtrlAgent == null) {
                        this.mPlayCtrlAgent = PlayCtrlAgent.getInstance();
                    }
                    this.mPlayCtrlAgent.YUV2IntRGBAgent(n, n2, frameBuffer.fData, nArray, 16);
                    if (nArray.length > 0) {
                        Log.e((String)"OpenglesRender", (String)"startShot@setdata...begin");
                        Bitmap bitmap = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.RGB_565);
                        bitmap.setPixels(nArray, 0, n, 0, 0, n, n2);
                        this.savePicture(bitmap, this.mShotFileName);
                        bitmap.recycle();
                        bitmap = null;
                        if (null != this.m_snapshotCb) {
                            this.m_snapshotCb.onResult(this.mShotFileName);
                        }
                        Log.e((String)"OpenglesRender", (String)"startShot@setdata...end");
                    }
                    nArray = null;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    System.gc();
                    Log.e((String)"OpenglesRender", (String)"OpenglesRender@doH264Decode.mIsStartShot-->memory overflow");
                    outOfMemoryError.printStackTrace();
                    return;
                }
                this.mIsStartShot = false;
                Log.e((String)"OpenglesRender", (String)"startShot...end");
            }
            this.onDrawByVideoMode(this.mViewWidth, this.mViewHeight, frameBuffer.width, frameBuffer.height);
            Log.i((String)"OpenglesRender", (String)("call renderFrame,mBranchNO" + this.mBranchNO));
            this.mOpenglesAgent.renderFrame(frameBuffer.fData, frameBuffer.width, frameBuffer.height, this.mBranchNO);
            frameBuffer = null;
            long l2 = System.currentTimeMillis();
            Log.i((String)"OpenglesRender", (String)(System.currentTimeMillis() + "-onShow:size=" + this.mFrameVector.size() + ",showTime=" + (l2 - l) + "ms"));
            if (this.mFrameVector.size() > 0 && this.mIsStartRender) {
                this.mSurface.requestRender();
            }
            this.m_isDrawFrame = true;
        }
    }

    public void onSurfaceChanged(GL10 gL10, int n, int n2) {
        this.mViewWidth = n;
        this.mViewHeight = n2;
        this.resetScaleInfo();
        if (this.mOpenglesAgent != null) {
            this.mOpenglesAgent.setupGraphics(this.mViewWidth, this.mViewHeight, this.mBranchNO);
            this.mOpenglesAgent.setViewPort(this.mStartX, this.mStartY, this.mViewWidth, this.mViewHeight, this.mBranchNO);
        }
    }

    public void onDrawByVideoMode(int n, int n2, int n3, int n4) {
        this.onDrawByVideoMode(n, n2, n3, n4, this.getVideoMode());
    }

    public String concatString(String string, Object ... objectArray) {
        if (objectArray == null) {
            return null;
        }
        int n = objectArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n - 1; ++i) {
            stringBuffer.append(objectArray[i]);
            stringBuffer.append(string);
        }
        stringBuffer.append(objectArray[n - 1]);
        return stringBuffer.toString();
    }

    public void onDrawByVideoMode(int n, int n2, int n3, int n4, int n5) {
        if (this.mOpenglesAgent == null) {
            return;
        }
        Log.i((String)"OpenglesRender", (String)("onDrawByVideoMode:viewW=" + n + ",viewH=" + n2 + ",bitmapW=" + n3 + ",bitmapH=" + n4 + ",videoMode" + n5));
        switch (n5) {
            case 0: 
            case 2: {
                float f = (n > n3 ? Math.abs(n - n3) : 0) / 2;
                float f2 = (n2 > n4 ? Math.abs(n2 - n4) : 0) / 2;
                float f3 = f + (float)n3 > (float)n ? (float)n : (float)n3;
                float f4 = f2 + (float)n4 > (float)n2 ? (float)n2 : (float)n4;
                Log.i((String)"VideoMode", (String)("[NO:" + this.mBranchNO + "---->x,y,w,h:" + this.concatString(",", Float.valueOf(f), Float.valueOf(f2), Float.valueOf(f3), Float.valueOf(f4)) + "]"));
                this.mOpenglesAgent.setViewPort((int)f, (int)f2, (int)f3, (int)f4, this.mBranchNO);
                break;
            }
            case 1: {
                float f = (float)n / (float)n3;
                float f5 = (float)n2 / (float)n4;
                float f6 = f < f5 ? f : f5;
                float f7 = (float)n3 * f6;
                float f8 = (float)n4 * f6;
                float f9 = 0.0f;
                float f10 = 0.0f;
                if ((float)n / f7 > (float)n2 / f8) {
                    f9 = ((float)n - f7) / 2.0f;
                } else {
                    f10 = ((float)n2 - f8) / 2.0f;
                }
                Log.i((String)"VideoMode", (String)("[NO:" + this.mBranchNO + "---->x,y,w,h:" + this.concatString(",", Float.valueOf(f9 + 1.0f), Float.valueOf(f10 + 1.0f), Float.valueOf(f9 + f7 - 2.0f), Float.valueOf(f10 + f8 - 2.0f)) + "]"));
                this.mOpenglesAgent.setViewPort((int)(f9 + 1.0f), (int)(f10 + 1.0f), (int)(f7 - 2.0f), (int)(f8 - 2.0f), this.mBranchNO);
                break;
            }
            case 3: {
                Log.i((String)"VideoMode", (String)("[NO:" + this.mBranchNO + "---->x,y,w,h:" + this.concatString(",", 0, 0, n, n2) + "]"));
                this.mOpenglesAgent.setViewPort(0, 0, n, n2, this.mBranchNO);
                break;
            }
            case 4: {
                float f = (float)n / (float)n3;
                float f11 = (float)n2 / (float)n4;
                float f12 = f < f11 ? f : f11;
                float f13 = (float)n3 * f12;
                float f14 = (float)n4 * f12;
                float f15 = 0.0f;
                float f16 = 0.0f;
                if ((float)n / f13 > (float)n2 / f14) {
                    f15 = ((float)n - f13) / 2.0f;
                } else {
                    f16 = ((float)n2 - f14) / 2.0f;
                }
                this.mTargetX = f15;
                this.mTargetY = f16;
                this.mTargetW = f13;
                this.mTargetH = f14;
                this.mSrcBitmapW = n3;
                this.mSrcBitmapH = n4;
                this.mScaleBitmapW = (int)((f13 - 2.0f) * this.bitmapScale);
                this.mScaleBitmapH = (int)((f14 - 2.0f) * this.bitmapScale);
                this.mOpenglesAgent.setViewPort((int)(f15 + 1.0f + (float)this.mStartX), (int)(f16 + 1.0f + (float)this.mStartY), this.mScaleBitmapW, this.mScaleBitmapH, this.mBranchNO);
                break;
            }
        }
    }

    public void resetScaleInfo() {
        this.bitmapScale = 1.0f;
        this.mStartY = 0;
        this.mStartX = 0;
    }

    public void onSurfaceCreated(GL10 gL10, EGLConfig eGLConfig) {
    }

    public void setMaxFrameBufferSize(int n) {
        this.m_max_frame_size = n;
    }

    public void updateView(FrameBuffer frameBuffer) {
        Log.i((String)"OpenglesRender", (String)(System.currentTimeMillis() + "-updateView, FrameSize=" + this.mFrameVector.size()));
        if (this.mFrameVector.size() > this.m_max_frame_size) {
            Log.w((String)"OpenglesRender", (String)("updateView, FrameSize > " + this.m_max_frame_size + ",FrameSize=" + this.mFrameVector.size()));
        }
        if (this.mIsStartRender) {
            if (null != frameBuffer) {
                this.mFrameVector.add(frameBuffer);
            }
            this.mSurface.requestRender();
        }
    }

    public void savePicture(Bitmap bitmap, String string) {
        Log.d((String)"OpenglesRender", (String)("savePicture,fileName=" + string));
        if (bitmap == null || "".equals(string)) {
            return;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            bitmap.compress(Bitmap.CompressFormat.PNG, 75, (OutputStream)fileOutputStream);
            fileOutputStream.flush();
            fileOutputStream.close();
            Log.d((String)"OpenglesRender", (String)("savePicture succeed,fileName=" + string));
        }
        catch (IOException iOException) {
            Log.d((String)"OpenglesRender", (String)("savePicture exception,fileName=" + string));
            iOException.printStackTrace();
        }
    }

    public boolean startShot(String string) {
        if (!this.m_isDrawFrame) {
            return false;
        }
        this.mIsStartShot = true;
        this.mShotFileName = string;
        return true;
    }

    public void setSnapshotCallback(ISnapshotCallback iSnapshotCallback) {
        this.m_snapshotCb = iSnapshotCallback;
    }

    public int getVideoMode() {
        return this.mVideoMode;
    }

    public void setVideoMode(int n) {
        this.mVideoMode = n;
    }

    public GLSurfaceView getSurface() {
        return this.mSurface;
    }

    public boolean isSurfaceVisible() {
        return null != this.mSurface && this.mSurface.getVisibility() == 0;
    }

    public int getFrameBufferSize() {
        return this.mFrameVector.size();
    }

    public void addCheckCallback(CheckCallback checkCallback) {
        this.mCheckCallback = checkCallback;
    }

    public void startCheckThread() {
        if (this.mVideoState != 2) {
            return;
        }
        if (this.mCheckThread == null) {
            this.mIsStartCheck = true;
            this.mTimeOutNums = 0;
            this.mCheckThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    OpenglesRender.this.checkTimeOut();
                }
            });
            this.mCheckThread.start();
        }
    }

    public void stopCheckTread() {
        if (this.mCheckThread != null) {
            this.mCheckThread.interrupt();
            this.mIsStartCheck = false;
            this.mTimeOutNums = 0;
            this.mCheckThread = null;
        }
    }

    public void checkTimeOut() {
        while (this.mIsStartCheck) {
            if (this.mTimeOutNums > 10) {
                if (this.mCheckCallback != null) {
                    this.mCheckCallback.recvDataTimout(this.mBranchNO, this);
                }
                this.stopCheckTread();
                break;
            }
            if (this.mVideoState == 0) {
                this.stopCheckTread();
                break;
            }
            ++this.mTimeOutNums;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static interface CheckCallback {
        public void recvDataTimout(int var1, OpenglesRender var2);
    }

    public static interface ISnapshotCallback {
        public void onResult(String var1);
    }
}

