/*
 * Decompiled with CFR 0.152.
 */
package com.android.opengles;

import android.util.Log;

public class FrameBuffer {
    public byte[] fData;
    public int width;
    public int height;
    public int size;

    public FrameBuffer(int n, int n2) {
        try {
            this.width = n;
            this.height = n2;
            this.size = n * n2 / 2 * 3;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Log.e((String)"MSG", (String)"FrameBuffer.buf is OutOfMemoryError...");
            this.fData = null;
            System.gc();
        }
    }

    public static FrameBuffer copy(FrameBuffer frameBuffer) {
        if (frameBuffer == null) {
            return null;
        }
        FrameBuffer frameBuffer2 = new FrameBuffer(frameBuffer.width, frameBuffer.height);
        System.arraycopy(frameBuffer.fData, 0, frameBuffer2.fData, 0, frameBuffer2.size);
        return frameBuffer2;
    }
}

