/*
 * Decompiled with CFR 0.152.
 */
package com.android.audio;

import android.media.AudioRecord;
import android.media.AudioTrack;
import android.util.Log;
import com.android.audio.AudioBuffer;
import com.android.audio.WebRtcAgent;
import ipc.android.sdk.impl.PlayCtrlAgent;
import java.util.Vector;

public class AudioPlayer {
    static final String TAG = "AudioPlayer";
    private Vector<AudioBuffer> mAudioVector;
    private MyAudioParameter mAudioParameter;
    private AudioTrack mAudioTrack;
    private AudioRecord mAudioRecord;
    public boolean mIsStartOutVoice;
    public boolean mIsStartInVoice;
    public int mBranchNO = 0;
    public boolean mIsAecm = false;
    public final int DEFAULT_PER_SAMPLE_SIZE = this.mIsAecm ? 160 : 1024;
    public static boolean mIsHSP = false;
    private PlayCtrlAgent mPlayCtrlAgent;
    private WebRtcAgent mWebRtcAgent;
    private Thread mDecodeThread;
    private Thread mEncodeThread;
    private final Object mOutLock = new Object();
    private final Object mInLock = new Object();
    boolean mbIsAecmhandler = false;
    MyRecordCallback mRecordCallback;

    public AudioPlayer(int n) {
        this.mAudioVector = new Vector();
        this.mBranchNO = n;
    }

    public void initAudioParameter(MyAudioParameter myAudioParameter) {
        this.mAudioParameter = myAudioParameter;
    }

    public int startTalk() {
        this.startInAudio();
        return 1;
    }

    public void stopTalk() {
        this.stopInAudio();
    }

    public int startInAudio() {
        if (this.mIsStartInVoice) {
            this.stopInAudio();
        }
        this.mIsStartInVoice = true;
        if (this.mAudioRecord == null) {
            if (this.mAudioParameter == null) {
                this.mAudioParameter = new MyAudioParameter();
            }
            int n = this.mAudioParameter.sampleRate;
            int n2 = this.mAudioParameter.channelConfig;
            int n3 = this.mAudioParameter.audioFormat;
            int n4 = AudioRecord.getMinBufferSize((int)n, (int)n2, (int)n3);
            Log.i((String)TAG, (String)("AudioRecord's min=" + n4));
            if (n4 > 0) {
                this.mAudioRecord = new AudioRecord(1, n, n2, n3, n4 <= 1024 ? this.DEFAULT_PER_SAMPLE_SIZE * 2 : n4 * 2);
                if (this.mAudioRecord != null && this.mAudioRecord.getState() == 1) {
                    if (this.mAudioRecord.getState() == 3) {
                        Log.w((String)TAG, (String)"other app is recording...");
                    } else {
                        this.mAudioRecord.startRecording();
                        this.startEncodeThread();
                    }
                } else {
                    Log.w((String)TAG, (String)"startRecording is fail...");
                }
            }
        }
        return 1;
    }

    public void stopInAudio() {
        try {
            this.mIsStartInVoice = false;
            if (this.mAudioRecord != null) {
                if (this.mAudioRecord.getState() == 1) {
                    this.mAudioRecord.stop();
                }
                this.mAudioRecord.release();
                this.mAudioRecord = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized int startOutAudio() {
        if (this.mIsStartOutVoice) {
            this.stopOutAudio();
        }
        this.mIsStartOutVoice = true;
        if (this.mAudioTrack == null) {
            if (this.mAudioParameter == null) {
                this.mAudioParameter = new MyAudioParameter();
            }
            int n = this.mAudioParameter.sampleRate;
            int n2 = this.mAudioParameter.channelConfig;
            int n3 = this.mAudioParameter.audioFormat;
            int n4 = AudioTrack.getMinBufferSize((int)n, (int)n2, (int)n3);
            Log.i((String)TAG, (String)("startOutAudio,sample rate=" + n + ",channel=" + n2 + "," + "format=" + n3 + ",AudioTrack's maxjitter = " + n4));
            if (n4 > 0) {
                this.mAudioTrack = new AudioTrack(3, n, n2, n3, n4 * 4, 1);
                this.mAudioTrack.setPlaybackPositionUpdateListener(new AudioTrack.OnPlaybackPositionUpdateListener(){

                    public void onMarkerReached(AudioTrack audioTrack) {
                        Log.d((String)AudioPlayer.TAG, (String)"onMarkerReached...");
                    }

                    public void onPeriodicNotification(AudioTrack audioTrack) {
                        Log.d((String)AudioPlayer.TAG, (String)"onPeriodicNotification...");
                    }
                });
                if (this.mAudioTrack.getState() == 1) {
                    this.mAudioTrack.play();
                    this.startDecodeThread();
                } else {
                    Log.w((String)TAG, (String)"play audio is fail...");
                }
            }
        } else if (this.mAudioTrack.getState() != 3) {
            this.mAudioTrack.play();
        }
        return 1;
    }

    public synchronized void stopOutAudio() {
        this.notiryDecodeThread();
        this.mIsStartOutVoice = false;
        if (this.mAudioTrack != null) {
            if (this.mAudioTrack.getState() == 1) {
                Log.i((String)TAG, (String)"stop out audio");
                this.mAudioTrack.stop();
            }
            this.mAudioTrack.release();
            this.mAudioTrack = null;
        }
        if (this.mAudioVector != null) {
            this.mAudioVector.clear();
        }
    }

    public Vector<AudioBuffer> sliceBuf(AudioBuffer audioBuffer, int n) {
        Vector vector = null;
        if (audioBuffer != null && audioBuffer.mAudioBuf != null) {
            int n2;
            vector = new Vector();
            for (int i = n2 = audioBuffer.mDataLen; i > 0; i -= n) {
            }
        }
        return vector;
    }

    public static Vector<AudioBuffer> spilAudioBuffer(AudioBuffer audioBuffer, int n) {
        byte[] byArray = audioBuffer.mAudioBuf;
        Vector<Object> vector = null;
        if (byArray != null) {
            vector = new Vector<Object>();
            int n2 = byArray.length;
            if (n2 <= n || n < 1) {
                vector.add(audioBuffer);
            } else if (n2 > n) {
                Object object;
                int n3 = n2 / n;
                for (int i = 0; i < n3; ++i) {
                    object = new byte[n];
                    System.arraycopy(byArray, i * n, object, 0, ((byte[])object).length);
                    AudioBuffer audioBuffer2 = new AudioBuffer((byte[])object, ((byte[])object).length);
                    vector.add(audioBuffer2);
                }
                if (n2 % n > 0) {
                    byte[] byArray2 = new byte[n2 % n];
                    System.arraycopy(byArray, n3 * n, byArray2, 0, byArray2.length);
                    object = new AudioBuffer(byArray2, byArray2.length);
                    vector.add(object);
                }
            }
        }
        return vector;
    }

    public synchronized void addToBuf(AudioBuffer audioBuffer) {
        Log.i((String)TAG, (String)("addToBuf,isStartOutVoice=" + this.mIsStartOutVoice + ",bufLen=" + audioBuffer.mDataLen + ",mBranchNO=" + this.mBranchNO));
        if (this.mIsStartOutVoice) {
            Vector<AudioBuffer> vector = AudioPlayer.spilAudioBuffer(audioBuffer, this.DEFAULT_PER_SAMPLE_SIZE);
            this.mAudioVector.addAll(vector);
            if (this.mAudioVector.size() > 2) {
                this.notiryDecodeThread();
            }
        }
        Log.i((String)TAG, (String)"addToBuf,end...");
    }

    public void addToInBuf(AudioBuffer audioBuffer) {
        if (this.mIsStartOutVoice) {
            this.mAudioVector.add(audioBuffer);
            this.notiryDecodeThread();
        }
    }

    public void startDecodeThread() {
        if (this.mDecodeThread != null) {
            return;
        }
        this.mDecodeThread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (AudioPlayer.this.mIsAecm) {
                    if (!AudioPlayer.this.mbIsAecmhandler) {
                        AudioPlayer.this.doAecmHand();
                    }
                } else {
                    AudioPlayer.this.doDecode();
                }
                AudioPlayer.this.mDecodeThread = null;
            }
        });
        this.mDecodeThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notiryDecodeThread() {
        Object object = this.mOutLock;
        synchronized (object) {
            Log.i((String)TAG, (String)"notifyDecodeThread");
            this.mOutLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doDecode() {
        Log.i((String)TAG, (String)("doDecode begin..., bufSize=" + this.mAudioVector.size()));
        try {
            while (this.mIsStartOutVoice) {
                Object object;
                if (this.mAudioVector == null || this.mAudioVector.size() <= 0) {
                    object = this.mOutLock;
                    synchronized (object) {
                        this.mOutLock.wait();
                        continue;
                    }
                }
                while (!this.mAudioVector.isEmpty() && this.mIsStartOutVoice) {
                    object = this.mAudioVector.remove(0);
                    if (null == ((AudioBuffer)object).mAudioBuf) continue;
                    long l = System.currentTimeMillis();
                    int n = ((AudioBuffer)object).mDataLen;
                    if (n > 0) {
                        if (this.mAudioTrack == null) continue;
                        int n2 = this.mAudioTrack.write(((AudioBuffer)object).mAudioBuf, 0, n);
                        long l2 = System.currentTimeMillis();
                        Log.i((String)TAG, (String)("\u97f3\u9891\u89e3\u7801\u4e00\u5e27\u6570\u636e\u6210\u529f...decodeThreadID=" + Thread.currentThread().getId() + ",pcmSize=" + n + ",writeSize=" + n2 + ",bufSize=" + this.mAudioVector.size() + ",totalTime=" + (l2 - l) + "ms"));
                        continue;
                    }
                    Log.e((String)TAG, (String)("\u97f3\u9891\u89e3\u7801\u4e00\u5e27\u6570\u636e\u5931\u8d25...decodeLen=" + n));
                }
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        Log.i((String)TAG, (String)("doDecode end..., bufSize=" + this.mAudioVector.size()));
    }

    public void startEncodeThread() {
        this.mEncodeThread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (AudioPlayer.this.mIsAecm) {
                    if (!AudioPlayer.this.mbIsAecmhandler) {
                        AudioPlayer.this.doAecmHand();
                    }
                } else {
                    AudioPlayer.this.doEncode();
                }
            }
        });
        this.mEncodeThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notiryEncodeThread() {
        Object object = this.mInLock;
        synchronized (object) {
            this.mInLock.notify();
        }
    }

    public void doEncode() {
        while (this.mIsStartInVoice) {
            int n;
            int n2 = n = this.DEFAULT_PER_SAMPLE_SIZE;
            short[] sArray = new short[n2];
            if (null == this.mAudioRecord) break;
            int n3 = this.mAudioRecord.read(sArray, 0, n2);
            Log.e((String)TAG, (String)("WebAcem:doEncode------------>" + n3));
            if (n3 == n2) {
                int n4;
                if (!mIsHSP) {
                    this.clearNoise(sArray, 0, n2);
                }
                byte[] byArray = new byte[n2];
                if (this.mPlayCtrlAgent == null) {
                    this.mPlayCtrlAgent = PlayCtrlAgent.getInstance();
                }
                if ((n4 = this.mPlayCtrlAgent.G711EncodeAgent(byArray, sArray, (short)n2)) == 0 && this.mRecordCallback != null) {
                    this.mRecordCallback.recvRecordData(byArray, n, this.mBranchNO);
                }
                Log.i((String)TAG, (String)("doEncode is success num=" + n3));
                continue;
            }
            Log.i((String)TAG, (String)("doEncode is fail num=" + n3));
        }
    }

    public short[] byte2ShortAry(byte[] byArray) {
        short[] sArray = null;
        if (byArray != null) {
            int n = byArray.length;
            sArray = new short[n];
            for (int i = 0; i < n; ++i) {
                sArray[i] = byArray[i];
            }
        }
        return sArray;
    }

    public byte[] short2ByteAry(short[] sArray) {
        byte[] byArray = null;
        if (sArray != null) {
            int n = sArray.length;
            byArray = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray[i] = (byte)sArray[i];
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAecmHand() {
        Object object = this.mOutLock;
        synchronized (object) {
            short[] sArray = new short[this.DEFAULT_PER_SAMPLE_SIZE];
            short[] sArray2 = null;
            while (this.mIsStartInVoice || this.mIsStartOutVoice) {
                int n;
                int n2;
                Log.e((String)TAG, (String)"WebAcem:doAecmHand is running....");
                this.mbIsAecmhandler = true;
                long l = -1L;
                long l2 = -1L;
                if (this.mIsStartOutVoice) {
                    if (this.mAudioVector != null && this.mAudioVector.size() > 0) {
                        AudioBuffer audioBuffer = this.mAudioVector.remove(0);
                        int n3 = n2 = audioBuffer == null ? -1 : audioBuffer.mDataLen;
                        if (n2 > 0) {
                            if (this.mAudioTrack != null && audioBuffer.mAudioBuf != null) {
                                this.mAudioTrack.write(audioBuffer.mAudioBuf, 0, n2);
                                l = System.currentTimeMillis();
                                sArray2 = this.byte2ShortAry(audioBuffer.mAudioBuf);
                            }
                        } else {
                            Log.e((String)TAG, (String)("\u97f3\u9891\u89e3\u7801\u4e00\u5e27\u6570\u636e\u5931\u8d25...decodeLen=" + n2));
                        }
                    } else if (!this.mIsStartInVoice) {
                        try {
                            this.mOutLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                    } else if (this.mAudioTrack != null) {
                        if (sArray == null || sArray.length < this.DEFAULT_PER_SAMPLE_SIZE) {
                            sArray = new short[this.DEFAULT_PER_SAMPLE_SIZE];
                        }
                        this.mAudioTrack.write(sArray, 0, sArray.length);
                        l = System.currentTimeMillis();
                        sArray2 = sArray;
                    }
                }
                if (!this.mIsStartInVoice) continue;
                n2 = n = this.DEFAULT_PER_SAMPLE_SIZE;
                short[] sArray3 = new short[n2];
                int n4 = this.mAudioRecord.read(sArray3, 0, n2);
                l2 = System.currentTimeMillis();
                Log.e((String)TAG, (String)("WebAcem:doEncode------------>" + n4 + ",(recordTime-playTime)=" + (l2 - l)));
                if (n4 == n2) {
                    int n5;
                    Object[] objectArray;
                    if (this.mIsStartOutVoice && l2 - l < 500L) {
                        int n6;
                        if (this.mWebRtcAgent == null) {
                            this.mWebRtcAgent = WebRtcAgent.getInstance(this.mAudioParameter.sampleRate);
                        }
                        objectArray = new short[n2];
                        n5 = this.mWebRtcAgent.BufferFarendOrProcessAgent(sArray2, sArray3, (short[])objectArray, (short)n2, (short)(this.DEFAULT_PER_SAMPLE_SIZE / 2), (short)(l2 - l));
                        if (this.mPlayCtrlAgent == null) {
                            this.mPlayCtrlAgent = PlayCtrlAgent.getInstance();
                        }
                        if ((n6 = this.mPlayCtrlAgent.G711EncodeShortAgent((short[])objectArray, sArray3, (short)n2)) == 0 && this.mRecordCallback != null) {
                            this.mRecordCallback.recvRecordData(this.short2ByteAry((short[])objectArray), n, this.mBranchNO);
                        }
                        Log.i((String)TAG, (String)("doEncode is success num=" + n4 + ",isAecm=" + n5));
                        continue;
                    }
                    if (this.mIsStartOutVoice) continue;
                    objectArray = new byte[n2];
                    if (this.mPlayCtrlAgent == null) {
                        this.mPlayCtrlAgent = PlayCtrlAgent.getInstance();
                    }
                    if ((n5 = this.mPlayCtrlAgent.G711EncodeAgent((byte[])objectArray, sArray3, (short)n2)) == 0 && this.mRecordCallback != null) {
                        this.mRecordCallback.recvRecordData((byte[])objectArray, n, this.mBranchNO);
                    }
                    Log.i((String)TAG, (String)("doEncode is success num=" + n4));
                    continue;
                }
                Log.i((String)TAG, (String)("doEncode is fail num=" + n4));
            }
            this.mbIsAecmhandler = false;
        }
    }

    public void clearNoise(short[] sArray, int n, int n2) {
        for (int i = n; i < n2 + n; ++i) {
            sArray[i] = (short)(sArray[i] >> 2);
        }
    }

    public void addRecordCallback(MyRecordCallback myRecordCallback) {
        this.mRecordCallback = myRecordCallback;
    }

    public void removeRecordCallback() {
        this.mRecordCallback = null;
    }

    public static interface MyRecordCallback {
        public void recvRecordData(byte[] var1, int var2, int var3);
    }

    public static class MyAudioParameter {
        public int sampleRate;
        public int channelConfig;
        public int audioFormat;

        public MyAudioParameter() {
            this(8000);
        }

        public MyAudioParameter(int n) {
            this.sampleRate = n;
            this.channelConfig = 2;
            this.audioFormat = 2;
        }

        public MyAudioParameter(int n, int n2, int n3) {
            this.sampleRate = n < 4000 || n > 48000 ? 8000 : n;
            this.channelConfig = n2 == 2 ? 3 : 2;
            this.audioFormat = n3 == 8 ? 3 : 2;
        }
    }
}

