/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mobilesecuritysdk.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Environment;
import android.util.Base64;
import android.util.Log;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.json.JSONObject;

@SuppressLint(value={"SimpleDateFormat"})
public class CommonUtils {
    public static boolean outOfDate(long sourceMillion, long unitMillion, int range) {
        if (unitMillion <= 0L) {
            return true;
        }
        long result = (System.currentTimeMillis() - sourceMillion) / unitMillion;
        return result >= (long)range;
    }

    public static boolean isNetWorkActive(Context inContext) {
        Context context = inContext.getApplicationContext();
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetInfo != null && activeNetInfo.isConnected() && activeNetInfo.getType() == 1;
    }

    public static String convertDate2String(Date d) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        return sdf.format(d);
    }

    public static boolean isBlank(String str) {
        int length;
        if (str == null || (length = str.length()) == 0) {
            return true;
        }
        int i = 0;
        while (i < length) {
            if (!Character.isWhitespace(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean IsEmpty(String str) {
        return str == null || str.length() <= 0;
    }

    public static boolean isBlankCollection(List<String> str) {
        if (str == null) {
            return true;
        }
        if (str.size() <= 0) {
            return true;
        }
        for (String inner : str) {
            if (CommonUtils.isBlank(inner)) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equalsIgnoreCase(str2);
    }

    public static int string2int(String numbers) {
        block3: {
            try {
                if (!CommonUtils.isBlank(numbers)) break block3;
                return 0;
            }
            catch (Exception e) {
                return 0;
            }
        }
        return Integer.parseInt(numbers);
    }

    public static long string2long(String numbers) {
        block3: {
            try {
                if (!CommonUtils.isBlank(numbers)) break block3;
                return 0L;
            }
            catch (Exception e) {
                return 0L;
            }
        }
        return Long.parseLong(numbers);
    }

    public static String MD5(String str) {
        block4: {
            if (!CommonUtils.isBlank(str)) break block4;
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes("UTF-8"));
            byte[] tmp = md.digest();
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < 16) {
                sb.append(String.format("%02x", tmp[i]));
                ++i;
            }
            return sb.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static JSONObject GetJsonFromFile(String str) {
        return null;
    }

    public static String ReadFile(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bf = null;
        try {
            String line;
            bf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF-8"));
            while ((line = bf.readLine()) != null) {
                stringBuilder.append(line);
            }
            bf.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return stringBuilder.toString();
    }

    public static void WriteFile(String filePath, String sets) throws IOException {
        File file = new File(filePath);
        OutputStreamWriter fw = null;
        if (file != null) {
            try {
                try {
                    fw = new FileWriter(file, false);
                    fw.write(sets);
                }
                catch (Exception e) {
                    Log.d((String)"ConfigNameEnum.CONFIGS.getValue()", (String)e.getLocalizedMessage());
                    fw.close();
                }
            }
            finally {
                fw.close();
            }
        }
    }

    public static String textCompress(String text) {
        try {
            byte[] blockcopy = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(text.length()).array();
            ByteArrayOutputStream os = new ByteArrayOutputStream(text.length());
            GZIPOutputStream gos = new GZIPOutputStream(os);
            gos.write(text.getBytes("UTF-8"));
            gos.close();
            os.close();
            byte[] compressed = new byte[4 + os.toByteArray().length];
            System.arraycopy(blockcopy, 0, compressed, 0, 4);
            System.arraycopy(os.toByteArray(), 0, compressed, 4, os.toByteArray().length);
            return Base64.encodeToString((byte[])compressed, (int)8);
        }
        catch (Exception e) {
            Log.i((String)"ALP", (String)e.getMessage());
            return "";
        }
    }

    public static boolean GetSdCardFile() {
        File sdCardFile;
        String mountedProperty = Environment.getExternalStorageState();
        return !CommonUtils.IsEmpty(mountedProperty) && (mountedProperty.equals("mounted") || mountedProperty.equals("mounted_ro")) && (sdCardFile = Environment.getExternalStorageDirectory()) != null;
    }
}

