/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mobilesecuritysdk.model;

import HttpUtils.HttpFetcher;
import android.content.Context;
import android.util.Log;
import com.alipay.mobilesecuritysdk.datainfo.GeoResponseInfo;
import com.alipay.mobilesecuritysdk.datainfo.SdkConfig;
import com.alipay.mobilesecuritysdk.datainfo.UploadInfo;
import com.alipay.mobilesecuritysdk.face.SecurityClientMobile;
import com.alipay.mobilesecuritysdk.model.DataProfile;
import com.alipay.mobilesecuritysdk.util.CommonUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;

public class Upload {
    private Context mcontext;
    private DataProfile profile = new DataProfile();
    private UploadInfo info;

    public UploadInfo getInfo() {
        return this.info;
    }

    public void setInfo(UploadInfo info) {
        this.info = info;
    }

    public Upload(Context context) {
        this.mcontext = context;
    }

    public GeoResponseInfo uploadData(List<String> tid, SdkConfig loadConfig) {
        String str;
        GeoResponseInfo ret = new GeoResponseInfo();
        if (CommonUtils.isBlankCollection(tid)) {
            ret.setSuccess(false);
            return ret;
        }
        if (this.info.getAppinfos().size() > 0) {
            this.profile.setTid(tid);
            str = this.profile.AppToString(String.valueOf(this.mcontext.getFilesDir().getPath()) + File.separator + "appupload.xml", this.info.getAppinfos());
            if (SecurityClientMobile.isDebug()) {
                Log.i((String)"str app info", (String)str);
            }
            if (str != null && str.length() > 0) {
                ret = this.uploadCollectedData("mobileClient", str, "1");
            }
            if (!ret.isSuccess()) {
                try {
                    CommonUtils.WriteFile(String.valueOf(this.mcontext.getFilesDir().getPath()) + File.separator + "appupload.xml", str);
                }
                catch (IOException e) {
                    Log.d((String)"app write file", (String)e.getLocalizedMessage());
                }
            } else {
                this.profile.cleanUploadFiles(String.valueOf(this.mcontext.getFilesDir().getPath()) + File.separator + "appupload.xml");
                Log.i((String)"app write file", (String)"upload  suceess  delete file");
            }
        }
        if (this.info.getLocates().size() > 0) {
            this.profile.setTid(tid);
            str = this.profile.LocationToString(String.valueOf(this.mcontext.getFilesDir().getPath()) + File.separator + "locationupload.xml", this.info.getLocates());
            if (SecurityClientMobile.isDebug()) {
                Log.i((String)"str aloc info", (String)str);
            }
            if (str != null && str.length() > 0) {
                ret = this.uploadCollectedData("mobileClient", str, "1");
            }
            if (!ret.isSuccess()) {
                try {
                    CommonUtils.WriteFile(String.valueOf(this.mcontext.getFilesDir().getPath()) + File.separator + "locationupload.xml", str);
                }
                catch (IOException e) {
                    Log.d((String)"location write file", (String)e.getLocalizedMessage());
                }
            } else {
                this.profile.cleanUploadFiles(String.valueOf(this.mcontext.getFilesDir().getPath()) + File.separator + "locationupload.xml");
                Log.i((String)"location write file", (String)"upload  suceess  delete file");
            }
        }
        return ret;
    }

    public GeoResponseInfo communicateSwitch() {
        GeoResponseInfo result = new GeoResponseInfo();
        if (!CommonUtils.isNetWorkActive(this.mcontext)) {
            return result;
        }
        try {
            HttpGet httpRequest = new HttpGet("http://secclientgw.alipay.com/mobile/switch.xml");
            HttpFetcher fetcher = new HttpFetcher();
            HttpResponse httpResponse = fetcher.getHttpClient().execute((HttpUriRequest)httpRequest);
            if (httpResponse.getStatusLine().getStatusCode() == 200) {
                return this.profile.analysisServerRespond(EntityUtils.toString((HttpEntity)httpResponse.getEntity()));
            }
            result.setSuccess(false);
        }
        catch (Exception e) {
            result.setSuccess(false);
        }
        return result;
    }

    public GeoResponseInfo uploadCollectedData(String serviceID, String upinfo, String ver) {
        GeoResponseInfo result = new GeoResponseInfo();
        try {
            HttpFetcher fetcher = new HttpFetcher();
            HttpResponse httpResponse = fetcher.uploadCollectedData(this.mcontext, "https://seccliprod.alipay.com/api/do.htm", serviceID, upinfo, ver, true);
            if (httpResponse != null && httpResponse.getStatusLine().getStatusCode() == 200) {
                return this.profile.analysisServerRespond(EntityUtils.toString((HttpEntity)httpResponse.getEntity()));
            }
            result.setSuccess(false);
        }
        catch (IOException e) {
            Log.i((String)"upload data  error", (String)e.getLocalizedMessage());
        }
        return result;
    }
}

