/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mobilesecuritysdk.model;

import android.util.Log;
import com.alipay.mobilesecuritysdk.constant.ConfigNameEnum;
import com.alipay.mobilesecuritysdk.constant.LocationNameEnum;
import com.alipay.mobilesecuritysdk.datainfo.AppInfo;
import com.alipay.mobilesecuritysdk.datainfo.GeoResponseInfo;
import com.alipay.mobilesecuritysdk.datainfo.LocationInfo;
import com.alipay.mobilesecuritysdk.datainfo.SdkConfig;
import com.alipay.mobilesecuritysdk.datainfo.WifiCollectInfo;
import com.alipay.mobilesecuritysdk.face.SecurityClientMobile;
import com.alipay.mobilesecuritysdk.util.CommonUtils;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

public class DataProfile {
    private List<String> tid;

    public List<String> getTid() {
        return this.tid;
    }

    public void setTid(List<String> tid) {
        this.tid = tid;
    }

    public SdkConfig getConfigs(String path) {
        if (path.length() != 0) {
            File fp = new File(String.valueOf(path) + File.separator + "seccliconfig.xml");
            if (!fp.exists()) {
                return this.GetDefaultConfig();
            }
            String str = CommonUtils.ReadFile(fp.getPath());
            if (str.length() <= 0) {
                Log.d((String)"read json", (String)"file size o");
                return this.GetDefaultConfig();
            }
            SdkConfig sdkconfig = SdkConfig.getInstance();
            try {
                JSONObject obj = new JSONObject(str);
                JSONObject cf = obj.getJSONObject("configs");
                if (cf == null) {
                    return this.GetDefaultConfig();
                }
                int appinterval = cf.getInt(ConfigNameEnum.APP_INTERVAL.getValue());
                sdkconfig.setAppInterval(appinterval);
                sdkconfig.setAppLUT(cf.getLong(ConfigNameEnum.APP_LUT.getValue()));
                sdkconfig.setLocateInterval(cf.getInt(ConfigNameEnum.LOCATE_INTERVAL.getValue()));
                sdkconfig.setLocateLUT(cf.getLong(ConfigNameEnum.LOCATE_LUT.getValue()));
                sdkconfig.setLocationMaxLines(cf.getInt(ConfigNameEnum.LOCATION_MAX_LINES.getValue()));
                sdkconfig.setMainSwitchInterval(cf.getInt(ConfigNameEnum.MAIN_SWITCH_INTERVAL.getValue()));
                sdkconfig.setMainSwitchLUT(cf.getLong(ConfigNameEnum.MAIN_SWITCH_LUT.getValue()));
                sdkconfig.setMainSwitchState(cf.getString(ConfigNameEnum.MAIN_SWITCH_STATE.getValue()));
                return sdkconfig;
            }
            catch (Exception e) {
                try {
                    return this.GetDefaultConfig();
                }
                catch (Exception e2) {
                    SecurityClientMobile.setError(true);
                    return this.GetDefaultConfig();
                }
            }
        }
        return null;
    }

    public void saveConfigs(SdkConfig loadConfig, String path) {
        try {
            JSONObject obj = new JSONObject();
            obj.put(ConfigNameEnum.MAIN_SWITCH_LUT.getValue(), loadConfig.getMainSwitchLUT());
            obj.put(ConfigNameEnum.MAIN_SWITCH_STATE.getValue(), (Object)loadConfig.getMainSwitchState());
            obj.put(ConfigNameEnum.MAIN_SWITCH_INTERVAL.getValue(), loadConfig.getMainSwitchInterval());
            obj.put(ConfigNameEnum.LOCATE_LUT.getValue(), loadConfig.getLocateLUT());
            obj.put(ConfigNameEnum.LOCATE_INTERVAL.getValue(), loadConfig.getLocateInterval());
            obj.put(ConfigNameEnum.LOCATION_MAX_LINES.getValue(), loadConfig.getLocationMaxLines());
            obj.put(ConfigNameEnum.APP_LUT.getValue(), loadConfig.getAppLUT());
            obj.put(ConfigNameEnum.APP_INTERVAL.getValue(), loadConfig.getAppInterval());
            JSONObject config = new JSONObject();
            config.put(ConfigNameEnum.CONFIGS.getValue(), (Object)obj);
            if (SecurityClientMobile.isDebug()) {
                Log.i((String)"ALP", (String)("loadConfig" + config.toString()));
            }
            CommonUtils.WriteFile(path, config.toString());
        }
        catch (Exception e) {
            SecurityClientMobile.setError(true);
        }
    }

    public GeoResponseInfo analysisServerRespond(String string) {
        GeoResponseInfo ret = new GeoResponseInfo();
        try {
            XmlPullParserFactory pullParserFactory = XmlPullParserFactory.newInstance();
            XmlPullParser xmlPullParser = pullParserFactory.newPullParser();
            xmlPullParser.setInput((Reader)new StringReader(string));
            int eventType = xmlPullParser.getEventType();
            try {
                while (eventType != 1) {
                    String nodeName = xmlPullParser.getName();
                    if (eventType == 2) {
                        if (CommonUtils.equalsIgnoreCase(nodeName, ConfigNameEnum.MAIN_SWITCH_STATE.getValue())) {
                            ret.setMainSwitchState(xmlPullParser.nextText());
                        } else if (CommonUtils.equalsIgnoreCase(nodeName, ConfigNameEnum.MAIN_SWITCH_INTERVAL.getValue())) {
                            ret.setMainSwitchInterval(CommonUtils.string2int(xmlPullParser.nextText()));
                        } else if (CommonUtils.equalsIgnoreCase(nodeName, ConfigNameEnum.LOCATE_INTERVAL.getValue())) {
                            ret.setLocateInterval(CommonUtils.string2int(xmlPullParser.nextText()));
                        } else if (CommonUtils.equalsIgnoreCase(nodeName, ConfigNameEnum.LOCATION_MAX_LINES.getValue())) {
                            ret.setLocationMaxLines(CommonUtils.string2int(xmlPullParser.nextText()));
                        } else if (CommonUtils.equalsIgnoreCase(nodeName, ConfigNameEnum.APP_INTERVAL.getValue())) {
                            ret.setAppInterval(CommonUtils.string2int(xmlPullParser.nextText()));
                        }
                    }
                    eventType = xmlPullParser.next();
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            Log.i((String)"ALP", (String)e.getMessage());
        }
        ret.setSuccess(true);
        return ret;
    }

    private SdkConfig GetDefaultConfig() {
        SdkConfig sdkconfig = SdkConfig.getInstance();
        sdkconfig.setMainSwitchLUT(0L);
        sdkconfig.setMainSwitchState("on");
        sdkconfig.setMainSwitchInterval(1);
        sdkconfig.setLocateLUT(0L);
        sdkconfig.setLocateInterval(30);
        sdkconfig.setLocationMaxLines(24);
        sdkconfig.setAppLUT(0L);
        sdkconfig.setAppInterval(7);
        return sdkconfig;
    }

    public String AppToString(String path, List<AppInfo> info) {
        File fp = new File(path);
        if (fp.length() > 51200L) {
            fp.delete();
            Log.i((String)"delete file", (String)("app file size > 50k, file path is" + path));
        }
        JSONArray apps = new JSONArray();
        JSONObject ar = new JSONObject();
        JSONObject ob = new JSONObject();
        JSONArray applist = new JSONArray();
        for (AppInfo item : info) {
            try {
                JSONObject temp = new JSONObject();
                temp.put(ConfigNameEnum.PKG_NAME.getValue(), (Object)item.getPkgName());
                temp.put(ConfigNameEnum.PUB_KEY_HASH.getValue(), (Object)item.getPkeyhash());
                applist.put((Object)temp);
            }
            catch (JSONException e) {
                Log.d((String)"appinfo", (String)e.getLocalizedMessage());
            }
        }
        try {
            if (this.GetTIDJson() == null) {
                ob.put("tid", (Object)"");
            } else {
                ob.put("tid", (Object)this.GetTIDJson());
            }
            ob.put("appList", (Object)applist);
            ob.put("timestamp", (Object)CommonUtils.convertDate2String(new Date()));
            ar.put("type", (Object)ConfigNameEnum.START_TAG.getValue());
            ar.put("model", (Object)ob);
        }
        catch (JSONException e) {
            Log.i((String)"apptojason", (String)e.getLocalizedMessage());
        }
        apps.put((Object)ar);
        return apps.toString();
    }

    public String LocationToString(String path, List<LocationInfo> info) {
        Log.i((String)"LocationToString path is ", (String)path);
        JSONArray ar = null;
        File file = new File(path);
        if (file.length() > 51200L) {
            file.delete();
            Log.i((String)"delete file", (String)"lc file size > 50k");
        } else if (path.length() > 0 && !file.isDirectory() && file.exists()) {
            ar = this.GetJsonFromFile(path);
        }
        if (ar == null) {
            ar = new JSONArray();
        }
        JSONObject locs = new JSONObject();
        for (LocationInfo litem : info) {
            try {
                JSONObject temp = new JSONObject();
                temp.put(LocationNameEnum.LOCATE_LATITUDE.getValue(), (Object)litem.getLatitude());
                temp.put(LocationNameEnum.LOCATE_LONGITUDE.getValue(), (Object)litem.getLongitude());
                temp.put(LocationNameEnum.LOCATE_CELL_ID.getValue(), (Object)litem.getCid());
                temp.put(LocationNameEnum.LOCATE_LAC.getValue(), (Object)litem.getLac());
                temp.put(LocationNameEnum.TIME_STAMP.getValue(), (Object)litem.getTime());
                temp.put("tid", (Object)this.GetTIDJson());
                temp.put(LocationNameEnum.MCC.getValue(), (Object)litem.getMcc());
                temp.put(LocationNameEnum.MNC.getValue(), (Object)litem.getMnc());
                temp.put(LocationNameEnum.PHONETYPE.getValue(), (Object)litem.getPhonetype());
                JSONArray obj = null;
                if (litem.getWifi() != null) {
                    obj = this.GetWifiToJson(litem.getWifi());
                }
                if (obj != null) {
                    temp.put(LocationNameEnum.LOCATE_WIFI.getValue(), (Object)obj);
                }
                locs.put("type", (Object)LocationNameEnum.START_TAG.getValue());
                locs.put("model", (Object)temp);
            }
            catch (JSONException e) {
                Log.d((String)"location", (String)e.getLocalizedMessage());
            }
        }
        ar.put((Object)locs);
        return ar.toString();
    }

    private JSONArray GetWifiToJson(List<WifiCollectInfo> info) {
        JSONArray locs = new JSONArray();
        for (WifiCollectInfo item : info) {
            try {
                JSONObject temp = new JSONObject();
                if (item.getMbssid() == null) {
                    temp.put(LocationNameEnum.BSSID.getValue(), (Object)"");
                } else {
                    temp.put(LocationNameEnum.BSSID.getValue(), (Object)item.getMbssid());
                }
                if (item.getMssid() == null) {
                    temp.put(LocationNameEnum.SSID.getValue(), (Object)"");
                } else {
                    temp.put(LocationNameEnum.SSID.getValue(), (Object)item.getMssid());
                }
                temp.put(LocationNameEnum.CURRENT.getValue(), item.isMiscurrent());
                temp.put(LocationNameEnum.LEVEL.getValue(), item.getMlevel());
                locs.put((Object)temp);
            }
            catch (JSONException e) {
                Log.d((String)"location", (String)e.getLocalizedMessage());
            }
        }
        return locs;
    }

    public JSONArray GetTIDJson() {
        if (this.tid == null || this.tid.isEmpty()) {
            return null;
        }
        JSONArray jsonArray = new JSONArray();
        for (String item : this.tid) {
            jsonArray.put((Object)item);
        }
        return jsonArray;
    }

    public JSONArray GetJsonFromFile(String path) {
        if (path.length() > 0) {
            String str = CommonUtils.ReadFile(path);
            JSONArray ar = null;
            if (str.length() <= 0) {
                return null;
            }
            try {
                ar = new JSONArray(str);
            }
            catch (JSONException e) {
                Log.d((String)"getjsonfromfile", (String)e.getLocalizedMessage());
            }
            return ar;
        }
        return null;
    }

    public void cleanUploadFiles(String path) {
        try {
            File floc = new File(path);
            if (floc.exists()) {
                floc.delete();
            }
        }
        catch (Exception e) {
            Log.i((String)"ALP", (String)e.getMessage());
        }
    }
}

