/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mobilesecuritysdk.model;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Looper;
import android.telephony.TelephonyManager;
import android.telephony.cdma.CdmaCellLocation;
import android.telephony.gsm.GsmCellLocation;
import android.util.Base64;
import android.util.Log;
import com.alipay.mobilesecuritysdk.constant.LocationNameEnum;
import com.alipay.mobilesecuritysdk.datainfo.AppInfo;
import com.alipay.mobilesecuritysdk.datainfo.LocationInfo;
import com.alipay.mobilesecuritysdk.datainfo.WifiCollectInfo;
import com.alipay.mobilesecuritysdk.model.DataProfile;
import com.alipay.mobilesecuritysdk.model.SecLocationListener;
import com.alipay.mobilesecuritysdk.util.CommonUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CollectedInfo {
    private final int MODULUS_FIX = 8;
    private DataProfile profile = new DataProfile();

    public String GetLocationInfo(Context context, List<String> tid) {
        List<LocationInfo> info = this.collectLocateInfos(context);
        this.profile.setTid(tid);
        return this.profile.LocationToString(String.valueOf(context.getFilesDir().getPath()) + File.separator, info);
    }

    public List<LocationInfo> collectLocateInfos(Context context) {
        ArrayList<LocationInfo> lclist = new ArrayList<LocationInfo>();
        try {
            List<WifiCollectInfo> info;
            TelephonyManager mTelephonyManager;
            boolean isNetworkLocate = false;
            LocationInfo locatedto = new LocationInfo();
            locatedto.setTime(CommonUtils.convertDate2String(new Date()));
            locatedto.setCid("");
            locatedto.setLac("");
            locatedto.setLatitude("");
            locatedto.setLongitude("");
            locatedto.setMcc("");
            locatedto.setMnc("");
            locatedto.setPhonetype("");
            LocationManager lm = (LocationManager)context.getSystemService("location");
            if (lm.isProviderEnabled("network")) {
                SecLocationListener ls = new SecLocationListener();
                lm.requestLocationUpdates("network", 300000L, 0.0f, (LocationListener)ls, Looper.getMainLooper());
                lm.removeUpdates((LocationListener)ls);
                Location locationdata = lm.getLastKnownLocation("network");
                if (locationdata != null) {
                    isNetworkLocate = true;
                    locatedto.setLatitude(locationdata.getLatitude());
                    locatedto.setLongitude(locationdata.getLongitude());
                }
            }
            if ((mTelephonyManager = (TelephonyManager)context.getSystemService("phone")).getPhoneType() == 2) {
                locatedto.setPhonetype(LocationNameEnum.CDMA.getValue());
                if (!isNetworkLocate) {
                    this.SetPhoneType(mTelephonyManager, locatedto, 2);
                }
            } else {
                locatedto.setPhonetype(LocationNameEnum.GSM.getValue());
                this.SetPhoneType(mTelephonyManager, locatedto, 1);
            }
            if ((info = this.GetWifiInfos(context)) != null && info.size() > 0) {
                locatedto.setWifi(info);
            }
            lclist.add(locatedto);
            if (lclist.size() > 0) {
                return lclist;
            }
            return null;
        }
        catch (Exception e) {
            Log.i((String)"ALP", (String)e.getMessage());
            return null;
        }
    }

    private void SetPhoneType(TelephonyManager mTelephonyManager, LocationInfo lc, int type) {
        String mcc = "";
        String mnc = "";
        String cid = "";
        String lac = "";
        if (type == 2) {
            try {
                CdmaCellLocation cdma = (CdmaCellLocation)mTelephonyManager.getCellLocation();
                if (cdma != null && CommonUtils.isBlank(lc.getLatitude()) && CommonUtils.isBlank(lc.getLongitude())) {
                    lac = String.valueOf(cdma.getNetworkId());
                    mcc = mTelephonyManager.getNetworkOperator().substring(0, 3);
                    mnc = String.valueOf(cdma.getSystemId());
                    cid = String.valueOf(cdma.getBaseStationId());
                    lc.setLatitude(cdma.getBaseStationLatitude());
                    lc.setLongitude(cdma.getBaseStationLongitude());
                }
            }
            catch (Exception e) {
                Log.i((String)"gettelphonetype PHONE_TYPE_CDMA", (String)e.getLocalizedMessage());
            }
        } else {
            try {
                GsmCellLocation mGsmCellLocation = (GsmCellLocation)mTelephonyManager.getCellLocation();
                if (mGsmCellLocation != null) {
                    mcc = mTelephonyManager.getNetworkOperator().substring(0, 3);
                    mnc = mTelephonyManager.getNetworkOperator().substring(3, 5);
                    cid = String.valueOf(mGsmCellLocation.getCid());
                    lac = String.valueOf(mGsmCellLocation.getLac());
                }
            }
            catch (Exception e) {
                Log.i((String)"gettelphonetype", (String)e.getLocalizedMessage());
            }
        }
        lc.setMcc(mcc);
        lc.setMnc(mnc);
        lc.setCid(cid);
        lc.setLac(lac);
    }

    public List<AppInfo> collectappInfos(Context context) {
        try {
            ArrayList<AppInfo> appinfos = new ArrayList<AppInfo>();
            PackageManager pm = context.getPackageManager();
            List packagesList = pm.getInstalledPackages(4096);
            for (PackageInfo item : packagesList) {
                if (pm.checkPermission("android.permission.READ_SMS", item.packageName) != 0 && pm.checkPermission("android.permission.RECEIVE_SMS", item.packageName) != 0 || pm.checkPermission("android.permission.SEND_SMS", item.packageName) != 0 && pm.checkPermission("android.permission.INTERNET", item.packageName) != 0) continue;
                AppInfo app = new AppInfo();
                app.setPkgName(item.packageName);
                app.setPkeyhash(this.getSignatureHash(pm.getPackageInfo((String)item.packageName, (int)64).signatures[0].toByteArray()));
                if (!app.validate()) continue;
                appinfos.add(app);
            }
            return appinfos;
        }
        catch (Exception e) {
            Log.i((String)"ALP", (String)e.getMessage());
            return null;
        }
    }

    private String getSignatureHash(byte[] signature) {
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(signature));
            String pubKey = cert.getPublicKey().toString();
            int modulusstart = pubKey.indexOf("modulus");
            int modulusend1 = pubKey.indexOf("\n", modulusstart + 8);
            int modulusend2 = pubKey.indexOf(",", modulusstart + 8);
            int modulusend = -1;
            if (modulusend1 < 0 && modulusend2 > 0) {
                modulusend = modulusend2;
            } else if (modulusend2 < 0 && modulusend1 > 0) {
                modulusend = modulusend1;
            } else if (modulusend1 < modulusend2) {
                modulusend = modulusend1;
            } else if (modulusend2 < modulusend1) {
                modulusend = modulusend2;
            }
            String modulus = modulusend < 0 ? pubKey.substring(modulusstart + 8).trim() : pubKey.substring(modulusstart + 8, modulusend).trim();
            return CommonUtils.MD5(modulus);
        }
        catch (Exception e) {
            Log.i((String)"ALP", (String)e.getMessage());
            return null;
        }
    }

    private List<WifiCollectInfo> GetWifiInfos(Context context) {
        ArrayList<WifiCollectInfo> wifilist = new ArrayList<WifiCollectInfo>();
        WifiManager wm = (WifiManager)context.getSystemService("wifi");
        try {
            if (wm.isWifiEnabled()) {
                WifiInfo wi = wm.getConnectionInfo();
                WifiCollectInfo cuwit = new WifiCollectInfo();
                cuwit.setMbssid(wi.getBSSID());
                cuwit.setMssid(Base64.encodeToString((byte[])wi.getSSID().getBytes(), (int)8));
                cuwit.setMlevel(wi.getRssi());
                cuwit.setMiscurrent(true);
                wifilist.add(cuwit);
                List sclist = wm.getScanResults();
                for (ScanResult sr : sclist) {
                    if (sr.BSSID.equals(wi.getBSSID()) || sr.SSID.equals(wi.getSSID())) continue;
                    WifiCollectInfo wit = new WifiCollectInfo();
                    wit.setMbssid(sr.BSSID);
                    wit.setMssid(Base64.encodeToString((byte[])sr.SSID.getBytes(), (int)8));
                    wit.setMlevel(sr.level);
                    wit.setMiscurrent(false);
                    wifilist.add(wit);
                }
                return wifilist;
            }
        }
        catch (Exception e) {
            Log.d((String)"GetWifiInfos", (String)e.getLocalizedMessage());
        }
        return null;
    }
}

