/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mobilesecuritysdk.deviceID;

import android.content.SharedPreferences;
import android.util.Log;
import com.alipay.mobilesecuritysdk.deviceID.IdResponseInfo;
import com.alipay.mobilesecuritysdk.deviceID.LOG;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class Profile {
    public static final String devicever = "0";

    public String generatePrivateData(Map<String, String> str) throws JSONException {
        return this.MaptoString(str);
    }

    private String MaptoString(Map<String, String> str) throws JSONException {
        if (str != null && str.size() > 0) {
            Iterator<Map.Entry<String, String>> iter = str.entrySet().iterator();
            JSONObject obj = new JSONObject();
            while (iter.hasNext()) {
                Map.Entry<String, String> pairs = iter.next();
                String key = pairs.getKey();
                String value = pairs.getValue();
                try {
                    obj.put(key, (Object)value);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            return obj.toString();
        }
        return null;
    }

    public String generateUploadData(Map<String, Object> str) {
        JSONObject dev = new JSONObject();
        JSONObject model = new JSONObject();
        JSONObject obj = new JSONObject();
        try {
            if (str != null && str.size() > 0) {
                for (Map.Entry<String, Object> pairs : str.entrySet()) {
                    String key = pairs.getKey();
                    if (key.equals("deviceInfo")) {
                        Map m = (Map)pairs.getValue();
                        String strJson = this.MaptoString(m);
                        obj.put(key, (Object)new JSONObject(strJson));
                        continue;
                    }
                    String value = (String)pairs.getValue();
                    obj.put(key, (Object)value);
                }
            }
            model.put("os", (Object)"android");
            model.put("data", (Object)obj);
            dev.put("type", (Object)"deviceinfo");
            dev.put("model", (Object)model);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return dev.toString();
    }

    public IdResponseInfo ParseResponse(String str) {
        if (str == null) {
            return null;
        }
        Log.i((String)"deviceid", (String)("server response is" + str));
        IdResponseInfo re = new IdResponseInfo();
        try {
            JSONObject ob = new JSONObject(str);
            re.setMsuccess(ob.getBoolean("success"));
            if (!re.isMsuccess()) {
                return re;
            }
            JSONObject data = ob.getJSONObject("data");
            if (data != null) {
                re.setMversion(data.getString("version"));
                re.setMapdid(data.getString("apdid"));
                re.setMapdtk(data.getString("apdtk"));
                JSONObject rule = data.getJSONObject("rule");
                if (rule != null) {
                    re.setFuction(rule.getString("function"));
                }
                re.setMrule(rule.toString());
                re.setMtime(data.getString("time"));
                re.setMcheckcode(data.getString("checkcode"));
            }
        }
        catch (JSONException e) {
            ArrayList<String> arr = new ArrayList<String>();
            arr.add("");
            arr.add("");
            arr.add("");
            arr.add(LOG.getStackString(e));
            LOG.logMessage(arr);
        }
        return re;
    }

    public Map<String, String> getMap(String jsonString) {
        try {
            JSONObject jsonObject = new JSONObject(jsonString);
            Iterator keyIter = jsonObject.keys();
            HashMap<String, String> valueMap = new HashMap<String, String>();
            while (keyIter.hasNext()) {
                String key = (String)keyIter.next();
                String value = (String)jsonObject.get(key);
                valueMap.put(key, value);
            }
            return valueMap;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    String GetDataFromSharedPre(SharedPreferences pref, String name) {
        return pref.getString(name, "");
    }

    void SetDataToSharePre(SharedPreferences pref, Map<String, String> args) {
        SharedPreferences.Editor editorTmp;
        if (pref != null && args != null && (editorTmp = pref.edit()) != null) {
            editorTmp.clear();
            for (Map.Entry<String, String> e : args.entrySet()) {
                String key = e.getKey();
                String value = e.getValue();
                if (value instanceof String) {
                    editorTmp.putString(key, value);
                    continue;
                }
                if (value instanceof Integer) {
                    editorTmp.putInt(key, ((Integer)((Object)value)).intValue());
                    continue;
                }
                if (value instanceof Long) {
                    editorTmp.putLong(key, ((Long)((Object)value)).longValue());
                    continue;
                }
                if (value instanceof Float) {
                    editorTmp.putFloat(key, ((Float)((Object)value)).floatValue());
                    continue;
                }
                if (!(value instanceof Boolean)) continue;
                editorTmp.putBoolean(key, ((Boolean)((Object)value)).booleanValue());
            }
            editorTmp.commit();
        }
    }
}

