/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mobilesecuritysdk.deviceID;

import HttpUtils.HttpFetcher;
import android.content.Context;
import android.os.Build;
import android.util.Log;
import com.alipay.mobilesecuritysdk.util.CommonUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.http.HttpResponse;
import org.json.JSONException;
import org.json.JSONObject;

public class LOG {
    private static File logFileDir = null;
    private static File logFileName = null;
    private static String model = null;
    private static String pkgName = null;
    public static boolean DBG = true;
    private static String TAG = "logger";
    private static Context mcontext = null;

    public static synchronized void init(Context ctx) {
        mcontext = ctx;
        if (logFileDir == null) {
            logFileDir = new File(String.valueOf(ctx.getFilesDir().getAbsolutePath()) + "/log/ap");
            LOG.getInfo(ctx);
        }
        if (logFileDir.exists()) {
            if (!logFileDir.isDirectory()) {
                throw new IllegalStateException(String.format("<%s> exists but not a Directory!", logFileDir.getAbsoluteFile()));
            }
        } else {
            logFileDir.mkdirs();
        }
    }

    public static synchronized void uploadLogFile() {
        String latest;
        if (logFileDir == null) {
            throw new IllegalStateException("logFileDir can not be null! call 'LOG.init' first!");
        }
        if (!logFileDir.exists() || !logFileDir.isDirectory() || logFileDir.list().length == 0) {
            if (DBG) {
                Log.d((String)TAG, (String)"log Dir not exist or no log");
            }
            return;
        }
        ArrayList<String> logList = new ArrayList<String>();
        String[] stringArray = logFileDir.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            logList.add(file);
            ++n2;
        }
        Collections.sort(logList);
        String upload = latest = (String)logList.get(logList.size() - 1);
        int needDelete = logList.size();
        boolean uploadSuccess = false;
        if (latest.equals(LOG.getCurLogFileName())) {
            if (logList.size() < 2) {
                if (DBG) {
                    Log.d((String)TAG, (String)"only log of today");
                }
                return;
            }
            upload = (String)logList.get(logList.size() - 2);
            --needDelete;
        }
        if (!(uploadSuccess = LOG.doUpload(LOG.toJsonString(upload)))) {
            --needDelete;
        } else if (DBG) {
            Log.d((String)TAG, (String)"upload success");
        }
        int i = 0;
        while (i < needDelete) {
            String file = (String)logList.get(i);
            File tobeDelete = new File(logFileDir, file);
            tobeDelete.delete();
            ++i;
        }
    }

    private static boolean doUpload(String upload) {
        if (upload == null) {
            Log.e((String)TAG, (String)"logFile to JosonString is null");
            return false;
        }
        if (DBG) {
            Log.d((String)TAG, (String)upload);
        }
        if (mcontext == null) {
            return false;
        }
        if (!CommonUtils.isNetWorkActive(mcontext)) {
            return false;
        }
        HttpFetcher fetcher = new HttpFetcher();
        HttpResponse re = fetcher.uploadCollectedData(mcontext, "https://seccliprod.alipay.com/api/do.htm", "bugTrack", upload, "1", true);
        if (re == null) {
            return false;
        }
        return re.getStatusLine().getStatusCode() == 200;
    }

    public static synchronized void logMessage(List<String> mesInfo) {
        block16: {
            if (logFileDir == null) {
                throw new IllegalStateException("logFileDir can not be null! call 'LOG.init' first!");
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
            StringBuffer sb = new StringBuffer(sdf.format(Calendar.getInstance().getTime()));
            sb.append("," + model);
            sb.append("," + pkgName);
            for (String string : mesInfo) {
                sb.append("," + string);
            }
            OutputStreamWriter file = null;
            try {
                try {
                    long logFileSize = LOG.checkLogFile();
                    if (DBG) {
                        Log.d((String)TAG, (String)("logFileSize=" + logFileSize));
                    }
                    file = (long)sb.length() + logFileSize <= 51200L ? new FileWriter(logFileName, true) : new FileWriter(logFileName);
                    sb.append("\n");
                    if (DBG) {
                        Log.d((String)TAG, (String)("sb=" + sb.toString()));
                    }
                    file.write(sb.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (file == null) break block16;
                    try {
                        file.close();
                    }
                    catch (IOException e2) {
                        Log.e((String)TAG, (String)"close logfile failed");
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (IOException e) {
                        Log.e((String)TAG, (String)"close logfile failed");
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private static synchronized long checkLogFile() {
        logFileName = new File(logFileDir, LOG.getCurLogFileName());
        if (DBG) {
            Log.d((String)TAG, (String)("current logfile is:" + logFileName.getAbsolutePath()));
        }
        if (!logFileName.exists()) {
            try {
                logFileName.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return 0L;
        }
        return logFileName.length();
    }

    private static String getCurLogFileName() {
        Date curDate = Calendar.getInstance().getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String curTime = sdf.format(curDate);
        return String.valueOf(curTime) + ".log";
    }

    private static void getInfo(Context ctx) {
        model = Build.MODEL;
        pkgName = ctx.getApplicationContext().getApplicationInfo().packageName;
        if (DBG) {
            Log.d((String)TAG, (String)(String.valueOf(pkgName) + "," + model));
        }
    }

    private static String toJsonString(String file) {
        JSONObject jsonObject = new JSONObject();
        File logFileToUpload = new File(logFileDir, file);
        if (logFileToUpload == null || !logFileToUpload.exists() || logFileToUpload.length() == 0L) {
            return null;
        }
        char[] buffer = new char[(int)logFileToUpload.length()];
        FileReader fReader = null;
        try {
            try {
                fReader = new FileReader(logFileToUpload);
                fReader.read(buffer);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (fReader != null) {
                    try {
                        fReader.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                return null;
            }
            catch (IOException e) {
                block21: {
                    e.printStackTrace();
                    if (fReader == null) break block21;
                    try {
                        fReader.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
                return null;
            }
        }
        finally {
            if (fReader != null) {
                try {
                    fReader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            jsonObject.put("type", (Object)"id");
            jsonObject.put("error", (Object)String.valueOf(buffer));
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)e.getMessage());
            return null;
        }
        return jsonObject.toString();
    }

    public static String getStackString(Throwable e) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        e.printStackTrace(printWriter);
        return ((Object)result).toString();
    }
}

