/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mobilesecuritysdk.deviceID;

import HttpUtils.HttpFetcher;
import android.content.Context;
import android.os.Environment;
import com.alipay.mobilesecuritysdk.deviceID.CollectDeviceInfo;
import com.alipay.mobilesecuritysdk.deviceID.DeviceMetaData;
import com.alipay.mobilesecuritysdk.deviceID.IdResponseInfo;
import com.alipay.mobilesecuritysdk.deviceID.LOG;
import com.alipay.mobilesecuritysdk.deviceID.Profile;
import com.alipay.mobilesecuritysdk.deviceID.SecurityUtils;
import com.alipay.mobilesecuritysdk.util.CommonUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DeviceIdModel {
    public static final String PREFS_NAME = "profiles";
    public static final String PRIVATE_NAME = "deviceid";
    public static final String SERVICEID = "deviceFingerprint";
    public static final String VER = "1";
    public static final String mah1 = "AH1";
    public static final String mah2 = "AH2";
    public static final String mah3 = "AH3";
    public static final String mah4 = "AH4";
    public static final String mah5 = "AH5";
    public static final String mah6 = "AH6";
    public static final String mah7 = "AH7";
    public static final String mah8 = "AH8";
    public static final String mah9 = "AH9";
    public static final String mah10 = "AH10";
    public static final String mas1 = "AS1";
    public static final String mas2 = "AS2";
    public static final String mas3 = "AS3";
    public static final String mas4 = "AS4";
    public static final String mtid = "AC1";
    public static final String mutdid = "AC2";
    public static final String mAppId = "appId";
    public static final String mDeviceInfo = "deviceInfo";
    public static final String mDeviceId = "deviceId";
    public static final String mPriDeviceId = "priDeviceId";
    public static final String mtime = "time";
    public static final String mApdtk = "apdtk";
    public static final String mRule = "rule";
    public static final String mCheckCode = "checkcode";
    private DeviceMetaData dv = new DeviceMetaData();
    private Profile profile = new Profile();

    public void Init(Context context, Map<String, String> arg) {
        CollectDeviceInfo info = CollectDeviceInfo.getInstance();
        LOG.init(context);
        try {
            Map<String, String> map;
            if (arg != null && arg.size() > 0) {
                if (!CommonUtils.isBlank(arg.get("tid"))) {
                    this.dv.setMtid(arg.get("tid"));
                }
                if (!CommonUtils.isBlank(arg.get("utdid"))) {
                    this.dv.setMutdid(arg.get("utdid"));
                }
            }
            if (!CommonUtils.isBlank(info.getImei(context))) {
                this.dv.setMah1(info.getImei(context));
            }
            if (!CommonUtils.isBlank(info.getImsi(context))) {
                this.dv.setMah2(info.getImsi(context));
            }
            if (!CommonUtils.isBlank(info.getMacAddress(context))) {
                this.dv.setMah3(info.getMacAddress(context));
            }
            if (!CommonUtils.isBlank(info.getCpuFre())) {
                this.dv.setMah4(info.getCpuFre());
            }
            if (!CommonUtils.isBlank(info.getCpuNum())) {
                this.dv.setMah5(info.getCpuNum());
            }
            if (!CommonUtils.isBlank(info.getBluMac())) {
                this.dv.setMah6(info.getBluMac());
            }
            if (!CommonUtils.isBlank(Long.toString(info.getTotalMemory()))) {
                this.dv.setMah7(Long.toString(info.getTotalMemory()));
            }
            if (!CommonUtils.isBlank(Long.toString(info.getSDCardMemory()))) {
                this.dv.setMah8(Long.toString(info.getSDCardMemory()));
            }
            if (!CommonUtils.isBlank(info.getDeviceMx(context))) {
                this.dv.setMah9(info.getDeviceMx(context));
            }
            if (!CommonUtils.isBlank(info.getPhoneModel())) {
                this.dv.setMah10(info.getPhoneModel());
            }
            if (!CommonUtils.isBlank(info.getRomName())) {
                this.dv.setMas1(info.getRomName());
            }
            if (!CommonUtils.isBlank(info.getSDKVer())) {
                this.dv.setMas2(info.getSDKVer());
            }
            if (!CommonUtils.isBlank(info.getBandVer())) {
                this.dv.setMas3(info.getBandVer());
            }
            if (!CommonUtils.isBlank(info.getOsVer())) {
                this.dv.setMas4(info.getOsVer());
            }
            if (!CommonUtils.isBlank(info.getPackageName(context))) {
                this.dv.setMappId(info.getPackageName(context));
            }
            if ((map = this.GetPrivateData(context)) != null && map.size() > 0) {
                if (!CommonUtils.isBlank(map.get(mApdtk))) {
                    this.dv.setMapdtk(map.get(mApdtk));
                }
                if (!CommonUtils.isBlank(map.get(mDeviceId))) {
                    this.dv.setMpriDeviceId(map.get(mDeviceId));
                }
                if (!CommonUtils.isBlank(map.get(mtime))) {
                    this.dv.setMtime(map.get(mtime));
                }
                if (!CommonUtils.isBlank(map.get(mRule))) {
                    this.dv.setMrule(map.get(mRule));
                }
            }
            if (!CommonUtils.isBlank(this.readDataFromSettings()) && this.readDataFromSettings().length() > 32) {
                this.dv.setMdeviceId(this.readDataFromSettings().substring(0, 32));
            } else if (!CommonUtils.isBlank(this.readDataFromSdCard()) && this.readDataFromSdCard().length() > 32) {
                this.dv.setMdeviceId(this.readDataFromSdCard().substring(0, 32));
            }
        }
        catch (Exception e) {
            this.Log(LOG.getStackString(e));
        }
    }

    public String UpdateId(Context cx, Map<String, String> arg) {
        if (arg == null) {
            return this.UpdateId(cx);
        }
        boolean hasApdidInshare = this.hasInPublic();
        if (this.CheckPrivateData(arg)) {
            if (!(hasApdidInshare || CommonUtils.isBlank(arg.get(mPriDeviceId)) || CommonUtils.isBlank(arg.get(mtime)))) {
                String str = String.valueOf(arg.get(mPriDeviceId)) + arg.get(mtime);
                this.WriteDataToSettings(str);
                this.WriteDataToSdCard(str);
            }
            String srcCode = arg.get(mCheckCode);
            String newCode = this.generaterCheckCode();
            if (this.checkApdid() && this.checkCheckCode(srcCode, newCode)) {
                return arg.get("apdid");
            }
        }
        return this.UpdateId(cx);
    }

    public Map<String, Object> GetUploadInfo() {
        HashMap<String, Object> device = new HashMap<String, Object>();
        HashMap<String, String> obj = new HashMap<String, String>();
        if (!CommonUtils.isBlank(this.dv.getMah1())) {
            obj.put(mah1, this.dv.getMah1());
        } else {
            obj.put(mah1, "");
        }
        if (!CommonUtils.isBlank(this.dv.getMah2())) {
            obj.put(mah2, this.dv.getMah2());
        } else {
            obj.put(mah2, "");
        }
        if (!CommonUtils.isBlank(this.dv.getMah3())) {
            obj.put(mah3, this.dv.getMah3());
        } else {
            obj.put(mah3, "");
        }
        if (!CommonUtils.isBlank(this.dv.getMah4())) {
            obj.put(mah4, this.dv.getMah4());
        } else {
            obj.put(mah4, "");
        }
        if (!CommonUtils.isBlank(this.dv.getMah5())) {
            obj.put(mah5, this.dv.getMah5());
        } else {
            obj.put(mah4, "");
        }
        if (!CommonUtils.isBlank(this.dv.getMah6())) {
            obj.put(mah6, this.dv.getMah6());
        } else {
            obj.put(mah6, "");
        }
        if (!CommonUtils.isBlank(this.dv.getMah7())) {
            obj.put(mah7, this.dv.getMah7());
        } else {
            obj.put(mah7, "");
        }
        if (!CommonUtils.isBlank(this.dv.getMah8())) {
            obj.put(mah8, this.dv.getMah8());
        } else {
            obj.put(mah8, "");
        }
        if (!CommonUtils.isBlank(this.dv.getMah9())) {
            obj.put(mah9, this.dv.getMah9());
        } else {
            obj.put(mah9, "");
        }
        if (!CommonUtils.isBlank(this.dv.getMah10())) {
            obj.put(mah10, this.dv.getMah10());
        } else {
            obj.put(mah10, "");
        }
        if (!CommonUtils.isBlank(this.dv.getMas1())) {
            obj.put(mas1, this.dv.getMas1());
        } else {
            obj.put(mas1, "");
        }
        if (!CommonUtils.isBlank(this.dv.getMas2())) {
            obj.put(mas2, this.dv.getMas2());
        } else {
            obj.put(mas2, "");
        }
        if (!CommonUtils.isBlank(this.dv.getMas3())) {
            obj.put(mas3, this.dv.getMas3());
        } else {
            obj.put(mas3, "");
        }
        if (!CommonUtils.isBlank(this.dv.getMas4())) {
            obj.put(mas4, this.dv.getMas4());
        } else {
            obj.put(mas4, "");
        }
        if (!CommonUtils.isBlank(this.dv.getMtid())) {
            obj.put(mtid, this.dv.getMtid());
        } else {
            obj.put(mtid, "");
        }
        if (!CommonUtils.isBlank(this.dv.getMutdid())) {
            obj.put(mutdid, this.dv.getMutdid());
        } else {
            obj.put(mutdid, "");
        }
        device.put(mDeviceInfo, obj);
        if (!CommonUtils.isBlank(this.dv.getMdeviceId())) {
            device.put(mDeviceId, this.dv.getMdeviceId());
        }
        if (!CommonUtils.isBlank(this.dv.getMpriDeviceId())) {
            device.put(mPriDeviceId, this.dv.getMpriDeviceId());
        }
        if (!CommonUtils.isBlank(this.dv.getMappId())) {
            device.put(mAppId, this.dv.getMappId());
        }
        if (!CommonUtils.isBlank(this.dv.getMtime())) {
            device.put(mtime, this.dv.getMtime());
        }
        if (!CommonUtils.isBlank(this.dv.getMapdtk())) {
            device.put(mApdtk, this.dv.getMapdtk());
        }
        return device;
    }

    public Map<String, Object> GetLocalInfo() {
        HashMap<String, Object> device = new HashMap<String, Object>();
        device.put(mDeviceId, this.dv.getMdeviceId());
        device.put(mPriDeviceId, this.dv.getMpriDeviceId());
        device.put(mAppId, this.dv.getMappId());
        device.put(mtime, this.dv.getMtime());
        device.put(mApdtk, this.dv.getMapdtk());
        return device;
    }

    public boolean CheckPrivateData(Map<String, String> arg) {
        if (arg == null || arg.size() < 0) {
            return false;
        }
        return arg.containsKey(mDeviceId) && arg.containsKey(mCheckCode) && arg.containsKey(mApdtk) && arg.containsKey(mtime) && arg.containsKey(mRule);
    }

    public Map<String, String> GetPrivateData(Context context) {
        String str = this.profile.GetDataFromSharedPre(context.getSharedPreferences(PREFS_NAME, 0), PRIVATE_NAME);
        if (CommonUtils.isBlank(str)) {
            return null;
        }
        String desryptStr = SecurityUtils.decrypt(SecurityUtils.getSeed(), str);
        if (CommonUtils.isBlank(desryptStr)) {
            return null;
        }
        Profile profile = new Profile();
        Map<String, String> pridata = profile.getMap(desryptStr);
        return pridata;
    }

    public Map<String, String> GetShareData(Context context) {
        return null;
    }

    public void WritePrivateData(Context context, String str) {
        String desryptStr = SecurityUtils.encrypt(SecurityUtils.getSeed(), str);
        if (CommonUtils.isBlank(desryptStr)) {
            return;
        }
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(PRIVATE_NAME, desryptStr);
        this.profile.SetDataToSharePre(context.getSharedPreferences(PREFS_NAME, 0), data);
    }

    public boolean hasInPublic() {
        return this.hasDataInSettings() && this.hasDataInSdcard();
    }

    public String readDataFromSettings() {
        String str = System.getProperty(PRIVATE_NAME);
        if (!CommonUtils.isBlank(str)) {
            String de = null;
            try {
                JSONObject obj = new JSONObject(str);
                de = obj.getString("device");
            }
            catch (JSONException e) {
                this.Log(LOG.getStackString(e));
            }
            if (!CommonUtils.isBlank(de)) {
                return SecurityUtils.decrypt(SecurityUtils.getSeed(), de);
            }
        }
        return null;
    }

    public void WriteDataToSettings(String str) {
        if (CommonUtils.isBlank(str)) {
            return;
        }
        String desryptStr = SecurityUtils.encrypt(SecurityUtils.getSeed(), str);
        if (CommonUtils.isBlank(desryptStr)) {
            return;
        }
        try {
            JSONObject ob = new JSONObject();
            ob.put("device", (Object)desryptStr);
            System.setProperty(PRIVATE_NAME, ob.toString());
        }
        catch (JSONException e) {
            this.Log(LOG.getStackString(e));
        }
    }

    public void WriteDataToSdCard(String str) {
        block7: {
            try {
                if (!CommonUtils.GetSdCardFile()) break block7;
                String strenc = SecurityUtils.encrypt(SecurityUtils.getSeed(), str);
                File file = new File(Environment.getExternalStorageDirectory(), ".SystemConfig");
                if (file == null) break block7;
                if (!file.exists()) {
                    file.mkdir();
                }
                JSONObject ob = new JSONObject();
                try {
                    ob.put("device", (Object)strenc);
                }
                catch (JSONException e) {
                    this.Log(LOG.getStackString(e));
                }
                try {
                    CommonUtils.WriteFile(String.valueOf(file.getAbsolutePath()) + File.separator + "data", ob.toString());
                }
                catch (IOException e) {
                    this.Log(LOG.getStackString(e));
                }
            }
            catch (Exception e) {
                this.Log(LOG.getStackString(e));
            }
        }
    }

    public String readDataFromSdCard() {
        block7: {
            String str;
            block8: {
                if (!CommonUtils.GetSdCardFile()) break block7;
                File file = new File(Environment.getExternalStorageDirectory(), ".SystemConfig");
                if (file != null && !file.exists()) {
                    file.mkdir();
                }
                if (!CommonUtils.isBlank(str = CommonUtils.ReadFile(String.valueOf(file.getAbsolutePath()) + File.separator + "data"))) break block8;
                return null;
            }
            try {
                String de = null;
                try {
                    JSONObject obj = new JSONObject(str);
                    de = obj.getString("device");
                }
                catch (JSONException e) {
                    this.Log(LOG.getStackString(e));
                }
                if (!CommonUtils.isBlank(de)) {
                    return SecurityUtils.decrypt(SecurityUtils.getSeed(), de);
                }
            }
            catch (Exception e) {
                this.Log(LOG.getStackString(e));
            }
        }
        return null;
    }

    private boolean hasDataInSettings() {
        if (CommonUtils.isBlank(this.readDataFromSettings())) {
            return false;
        }
        return this.readDataFromSettings().length() > 0;
    }

    private boolean hasDataInSdcard() {
        if (CommonUtils.isBlank(this.readDataFromSdCard())) {
            return false;
        }
        return this.readDataFromSdCard().length() > 0;
    }

    public boolean checkCheckCode(String srccheckcode, String newcheckcode) {
        if (srccheckcode == null || newcheckcode == null) {
            return false;
        }
        return srccheckcode.equals(newcheckcode);
    }

    public String generaterCheckCode() {
        String md5;
        String str = this.getCheckCodeString();
        if (str == null) {
            str = "";
        }
        if ((md5 = CommonUtils.MD5(str)) == null) {
            return "";
        }
        return md5;
    }

    private String getCheckCodeString() {
        JSONArray arr;
        block21: {
            if (CommonUtils.isBlank(this.dv.getMrule())) {
                return null;
            }
            JSONObject obj = new JSONObject(this.dv.getMrule());
            arr = obj.getJSONArray("params");
            if (arr != null) break block21;
            return null;
        }
        try {
            String str = new String();
            int i = 0;
            while (i != arr.length()) {
                if (arr.getString(i).equals(mtid)) {
                    str = !CommonUtils.isBlank(this.dv.getMtid()) ? String.valueOf(str) + this.dv.getMtid() : String.valueOf(str);
                }
                if (arr.getString(i).equals(mutdid)) {
                    str = !CommonUtils.isBlank(this.dv.getMutdid()) ? String.valueOf(str) + this.dv.getMutdid() : String.valueOf(str);
                }
                if (arr.getString(i).equals(mah1)) {
                    str = !CommonUtils.isBlank(this.dv.getMah1()) ? String.valueOf(str) + this.dv.getMah1() : String.valueOf(str);
                }
                if (arr.getString(i).equals(mah2)) {
                    str = !CommonUtils.isBlank(this.dv.getMah2()) ? String.valueOf(str) + this.dv.getMah2() : String.valueOf(str);
                }
                if (arr.getString(i).equals(mah3)) {
                    str = !CommonUtils.isBlank(this.dv.getMah3()) ? String.valueOf(str) + this.dv.getMah3() : String.valueOf(str);
                }
                if (arr.getString(i).equals(mah4)) {
                    str = !CommonUtils.isBlank(this.dv.getMah4()) ? String.valueOf(str) + this.dv.getMah4() : String.valueOf(str);
                }
                if (arr.getString(i).equals(mah5)) {
                    str = !CommonUtils.isBlank(this.dv.getMah5()) ? String.valueOf(str) + this.dv.getMah5() : String.valueOf(str);
                }
                if (arr.getString(i).equals(mah6)) {
                    str = !CommonUtils.isBlank(this.dv.getMah6()) ? String.valueOf(str) + this.dv.getMah6() : String.valueOf(str);
                }
                if (arr.getString(i).equals(mah7)) {
                    str = !CommonUtils.isBlank(this.dv.getMah7()) ? String.valueOf(str) + this.dv.getMah7() : String.valueOf(str);
                }
                if (arr.getString(i).equals(mah8)) {
                    str = !CommonUtils.isBlank(this.dv.getMah8()) ? String.valueOf(str) + this.dv.getMah8() : String.valueOf(str);
                }
                if (arr.getString(i).equals(mah9)) {
                    str = !CommonUtils.isBlank(this.dv.getMah9()) ? String.valueOf(str) + this.dv.getMah9() : String.valueOf(str);
                }
                if (arr.getString(i).equals(mah10)) {
                    str = !CommonUtils.isBlank(this.dv.getMah10()) ? String.valueOf(str) + this.dv.getMah10() : String.valueOf(str);
                }
                if (arr.getString(i).equals(mas1)) {
                    str = !CommonUtils.isBlank(this.dv.getMas1()) ? String.valueOf(str) + this.dv.getMas1() : String.valueOf(str);
                }
                if (arr.getString(i).equals(mas2)) {
                    str = !CommonUtils.isBlank(this.dv.getMas2()) ? String.valueOf(str) + this.dv.getMas2() : String.valueOf(str);
                }
                if (arr.getString(i).equals(mas3)) {
                    str = !CommonUtils.isBlank(this.dv.getMas3()) ? String.valueOf(str) + this.dv.getMas3() : String.valueOf(str);
                }
                if (arr.getString(i).equals(mas4)) {
                    str = !CommonUtils.isBlank(this.dv.getMas4()) ? String.valueOf(str) + this.dv.getMas4() : String.valueOf(str);
                }
                ++i;
            }
            return str;
        }
        catch (JSONException e) {
            this.Log(LOG.getStackString(e));
            return null;
        }
    }

    public boolean checkApdid() {
        String strS = this.readDataFromSettings();
        String strD = this.readDataFromSdCard();
        if (!CommonUtils.isBlank(strS)) {
            return this.dv.getMpriDeviceId().equals(strS.substring(0, 32));
        }
        if (!CommonUtils.isBlank(strD)) {
            return this.dv.getMpriDeviceId().equals(strD.subSequence(0, 32));
        }
        return false;
    }

    public IdResponseInfo UploadData(Context context) {
        IdResponseInfo result = new IdResponseInfo();
        result.setMsuccess(false);
        String upInfo = this.profile.generateUploadData(this.GetUploadInfo());
        if (upInfo == null || upInfo.length() < 0) {
            return result;
        }
        try {
            HttpFetcher fetcher = new HttpFetcher();
            HttpResponse httpResponse = fetcher.uploadCollectedData(context, "https://seccliprod.alipay.com/api/do.htm", SERVICEID, upInfo, VER, false);
            if (httpResponse != null && httpResponse.getStatusLine().getStatusCode() == 200) {
                Profile profile = new Profile();
                return profile.ParseResponse(EntityUtils.toString((HttpEntity)httpResponse.getEntity()));
            }
            result.setMsuccess(false);
        }
        catch (IOException e) {
            this.Log(LOG.getStackString(e));
        }
        return result;
    }

    public String UpdateId(Context context) {
        block4: {
            IdResponseInfo res = this.UploadData(context);
            try {
                if (res == null || !res.isMsuccess()) break block4;
                String data = String.valueOf(res.getMapdid()) + res.getMtime();
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(mDeviceId, res.getMapdid());
                map.put(mPriDeviceId, res.getMapdid());
                map.put(mtime, res.getMtime());
                map.put(mCheckCode, res.getMcheckcode());
                map.put(mRule, res.getMrule());
                map.put(mApdtk, res.getMapdtk());
                Profile profile = new Profile();
                try {
                    String str = profile.generatePrivateData(map);
                    this.WritePrivateData(context, str);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                this.WriteDataToSettings(data);
                this.WriteDataToSdCard(data);
                return res.getMapdid();
            }
            catch (Exception e) {
                this.Log(LOG.getStackString(e));
            }
        }
        return null;
    }

    private void Log(String ex) {
        ArrayList<String> arr = new ArrayList<String>();
        if (CommonUtils.isBlank(this.dv.getMtid())) {
            arr.add(this.dv.getMtid().substring(0, 20));
        }
        if (CommonUtils.isBlank(this.dv.getMutdid())) {
            arr.add(this.dv.getMutdid().substring(0, 20));
        }
        if (CommonUtils.isBlank(this.dv.getMappId())) {
            arr.add(this.dv.getMappId().substring(0, 20));
        }
        arr.add(ex);
        LOG.logMessage(arr);
    }
}

