/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mobilesecuritysdk.deviceID;

import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;

public class CollectDeviceInfo {
    private static CollectDeviceInfo collectSingleton = new CollectDeviceInfo();

    private CollectDeviceInfo() {
    }

    public static CollectDeviceInfo getInstance() {
        return collectSingleton;
    }

    public String getMacAddress(Context context) {
        String result = "";
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        WifiInfo wifiInfo = wifiManager.getConnectionInfo();
        result = wifiInfo.getMacAddress();
        return result;
    }

    public String getCpuNum() {
        String str = "";
        FileReader localFileReader = null;
        BufferedReader localBufferedReader = null;
        try {
            localFileReader = new FileReader("/proc/cpuinfo");
            if (localFileReader != null) {
                try {
                    localBufferedReader = new BufferedReader(localFileReader, 1024);
                    str = localBufferedReader.readLine();
                    localBufferedReader.close();
                    localFileReader.close();
                }
                catch (IOException e) {
                    Log.i((String)"deviceid", (String)("getCpuNum" + e.getLocalizedMessage()));
                }
            }
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        if (str != null) {
            int i = str.indexOf(58) + 1;
            str = str.substring(i);
            return str.trim();
        }
        return "";
    }

    public String getSDKVer() {
        int SDK_INT = 2;
        try {
            SDK_INT = Build.VERSION.class.getField("SDK_INT").getInt(null);
        }
        catch (Exception e) {
            try {
                SDK_INT = Integer.parseInt((String)Build.VERSION.class.getField("SDK").get(null));
            }
            catch (Exception e2) {
                SDK_INT = 2;
            }
        }
        return Integer.toString(SDK_INT);
    }

    public String getOsVer() {
        return Build.VERSION.RELEASE;
    }

    public String getPhoneModel() {
        return Build.MODEL;
    }

    public String getResolution(Context context) {
        DisplayMetrics dm = context.getResources().getDisplayMetrics();
        return dm.toString();
    }

    public String getNetworkType(Context context) {
        TelephonyManager phoneMgr = (TelephonyManager)context.getSystemService("phone");
        int mNetworkType = phoneMgr.getNetworkType();
        return Integer.toString(mNetworkType);
    }

    public String getImei(Context context) {
        String imei = null;
        if (context != null) {
            try {
                TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
                if (tm != null) {
                    imei = tm.getDeviceId();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return imei;
    }

    public String getImsi(Context context) {
        String imsi = null;
        if (context != null) {
            try {
                TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
                if (tm != null) {
                    imsi = tm.getSubscriberId();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return imsi;
    }

    public String getCpuFre() {
        String str1 = "/proc/cpuinfo";
        String str2 = "";
        String[] cpuInfo = new String[]{"", ""};
        try {
            FileReader fr = new FileReader(str1);
            BufferedReader localBufferedReader = new BufferedReader(fr, 8192);
            str2 = localBufferedReader.readLine();
            String[] arrayOfString = str2.split("\\s+");
            int i = 2;
            while (i < arrayOfString.length) {
                cpuInfo[0] = String.valueOf(cpuInfo[0]) + arrayOfString[i] + " ";
                ++i;
            }
            str2 = localBufferedReader.readLine();
            arrayOfString = str2.split("\\s+");
            cpuInfo[1] = String.valueOf(cpuInfo[1]) + arrayOfString[2];
            localBufferedReader.close();
            return cpuInfo[1];
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public long getTotalMemory() {
        String str1 = "/proc/meminfo";
        long initial_memory = 0L;
        try {
            FileReader localFileReader = new FileReader(str1);
            BufferedReader localBufferedReader = new BufferedReader(localFileReader, 8192);
            String str2 = localBufferedReader.readLine();
            String[] arrayOfString = str2.split("\\s+");
            initial_memory = Integer.valueOf(arrayOfString[1]).intValue();
            localBufferedReader.close();
        }
        catch (IOException e) {
            Log.i((String)"deviceid", (String)("getTotalMemory" + e.getLocalizedMessage()));
        }
        return initial_memory;
    }

    public long getSDCardMemory() {
        long[] sdCardInfo = new long[2];
        try {
            String state = Environment.getExternalStorageState();
            if ("mounted".equals(state)) {
                File sdcardDir = Environment.getExternalStorageDirectory();
                StatFs sf = new StatFs(sdcardDir.getPath());
                long bSize = sf.getBlockSize();
                long bCount = sf.getBlockCount();
                long availBlocks = sf.getAvailableBlocks();
                sdCardInfo[0] = bSize * bCount;
                sdCardInfo[1] = bSize * availBlocks;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sdCardInfo[0];
    }

    public String getRomName() {
        return Build.DISPLAY;
    }

    public String getBluMac() {
        BluetoothAdapter bAdapt;
        block3: {
            try {
                bAdapt = BluetoothAdapter.getDefaultAdapter();
                if (bAdapt == null || bAdapt.isEnabled()) break block3;
                return "";
            }
            catch (Exception exception) {
                return null;
            }
        }
        return bAdapt.getAddress();
    }

    public String getDeviceMx(Context context) {
        try {
            DisplayMetrics dm = context.getResources().getDisplayMetrics();
            String dp = String.valueOf(Integer.toString(dm.widthPixels)) + "*" + Integer.toString(dm.heightPixels);
            return dp;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getBandVer() {
        String ver = null;
        try {
            Class<?> cl = Class.forName("android.os.SystemProperties");
            Object invoker = cl.newInstance();
            Method m = cl.getMethod("get", String.class, String.class);
            Object result = m.invoke(invoker, "gsm.version.baseband", "no message");
            ver = (String)result;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ver;
    }

    public String getPackageName(Context context) {
        return context.getPackageName();
    }
}

