/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mobilesecuritysdk.datainfo;

import com.alipay.mobilesecuritysdk.datainfo.WifiCollectInfo;
import com.alipay.mobilesecuritysdk.util.CommonUtils;
import java.math.BigDecimal;
import java.util.List;

public class LocationInfo {
    private final int DEFINE_NUM = 14400;
    private final double MAX_LONGITUDE = 180.0;
    private final double MIN_LONGITUDE = -180.0;
    private final double MAX_LATITUDE = 90.0;
    private final double MIN_LATITUDE = -90.0;
    private List<WifiCollectInfo> wifi;
    private List<String> tid;
    private String time;
    private String longitude;
    private String latitude;
    private String cid;
    private String lac;
    private String phonetype;
    private String mcc;
    private String mnc;

    public List<String> getTid() {
        return this.tid;
    }

    public void setTid(List<String> tid) {
        this.tid = tid;
    }

    public List<WifiCollectInfo> getWifi() {
        return this.wifi;
    }

    public void setWifi(List<WifiCollectInfo> wifi) {
        this.wifi = wifi;
    }

    public String getPhonetype() {
        return this.phonetype;
    }

    public void setPhonetype(String phonetype) {
        this.phonetype = phonetype;
    }

    public String getMcc() {
        return this.mcc;
    }

    public void setMcc(String mcc) {
        this.mcc = mcc;
    }

    public String getMnc() {
        return this.mnc;
    }

    public void setMnc(String mnc) {
        this.mnc = mnc;
    }

    public boolean validate() {
        return !CommonUtils.isBlank(this.latitude) && !CommonUtils.isBlank(this.longitude) || !CommonUtils.isBlank(this.cid) && !CommonUtils.isBlank(this.lac);
    }

    private String toString(double d) {
        BigDecimal b = new BigDecimal(d);
        double f = b.setScale(5, 4).doubleValue();
        return String.valueOf(f);
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public String getLongitude() {
        return this.longitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public void setLongitude(double longitude) {
        if (longitude < 180.0 && longitude > -180.0) {
            this.longitude = this.toString(longitude);
        }
    }

    public void setLongitude(int longitude) {
        this.setLongitude((double)longitude / 14400.0);
    }

    public String getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        if (latitude < 90.0 && latitude > -90.0) {
            this.latitude = this.toString(latitude);
        }
    }

    public void setLatitude(int latitude) {
        this.setLatitude((double)latitude / 14400.0);
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public String getCid() {
        return this.cid;
    }

    public void setCid(String cid) {
        this.cid = cid;
    }

    public String getLac() {
        return this.lac;
    }

    public void setLac(String lac) {
        this.lac = lac;
    }
}

