/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.ContainerOrderFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyEditor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.explorer.view.NodeRenderer;
import org.openide.explorer.view.NodeTableModel;
import org.openide.explorer.view.NodeTreeModel;
import org.openide.explorer.view.TableSheetCell;
import org.openide.explorer.view.TreeTableModelAdapter;
import org.openide.explorer.view.TreeView;
import org.openide.explorer.view.ViewUtil;
import org.openide.explorer.view.Visualizer;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

class TreeTable
extends JTable
implements Runnable {
    private static final String ACTION_FOCUS_NEXT = "focusNext";
    private static Color unfocusedSelBg = null;
    private static Color unfocusedSelFg = null;
    private TreeTableCellRenderer tree;
    private NodeTableModel tableModel;
    private int treeColumnIndex = -1;
    private int lastRow = -1;
    private boolean canEdit;
    private boolean ignoreScrolling = false;
    private boolean ignoreClearSelection = false;
    private int positionX;
    private boolean treeHScrollingEnabled = true;
    private final ListToTreeSelectionModelWrapper selectionWrapper;
    private boolean edCreated = false;
    boolean inSelectAll = false;
    private boolean needCalcRowHeight = true;
    boolean inEditRequest = false;
    boolean inEditorChangeRequest = false;
    int editRow = -1;
    private boolean inRemoveRequest = false;
    private TableSheetCell tableCell;

    public TreeTable(NodeTreeModel nodeTreeModel, NodeTableModel nodeTableModel) {
        this.setSurrendersFocusOnKeystroke(true);
        this.tree = new TreeTableCellRenderer(nodeTreeModel);
        this.tableModel = new TreeTableModelAdapter(this.tree, nodeTableModel);
        this.tree.setCellRenderer(new NodeRenderer());
        this.setModel(this.tableModel);
        this.selectionWrapper = new ListToTreeSelectionModelWrapper();
        this.tree.setSelectionModel(this.selectionWrapper);
        this.setSelectionModel(this.selectionWrapper.getListSelectionModel());
        this.getTableHeader().setReorderingAllowed(false);
        this.setDefaultRenderer(TreeTableModelAdapter.class, this.tree);
        this.tableCell = new TableSheetCell(this.tableModel);
        this.tableCell.setFlat(true);
        this.setDefaultRenderer(Node.Property.class, this.tableCell);
        this.setDefaultEditor(Node.Property.class, this.tableCell);
        this.getTableHeader().setDefaultRenderer(this.tableCell);
        this.getAccessibleContext().setAccessibleName(NbBundle.getBundle(TreeTable.class).getString("ACSN_TreeTable"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(TreeTable.class).getString("ACSD_TreeTable"));
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new STPolicy());
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        this.initKeysAndActions();
    }

    private void initKeysAndActions() {
        this.setFocusTraversalKeys(0, Collections.emptySet());
        this.setFocusTraversalKeys(1, Collections.emptySet());
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 1));
        InputMap inputMap = this.getInputMap(0);
        InputMap inputMap2 = this.getInputMap(1);
        ActionMap actionMap = this.getActionMap();
        inputMap2.put(KeyStroke.getKeyStroke("control C"), "none");
        inputMap2.put(KeyStroke.getKeyStroke("control V"), "none");
        inputMap2.put(KeyStroke.getKeyStroke("control X"), "none");
        inputMap2.put(KeyStroke.getKeyStroke("COPY"), "none");
        inputMap2.put(KeyStroke.getKeyStroke("PASTE"), "none");
        inputMap2.put(KeyStroke.getKeyStroke("CUT"), "none");
        inputMap.put(KeyStroke.getKeyStroke(9, 3, false), ACTION_FOCUS_NEXT);
        inputMap.put(KeyStroke.getKeyStroke(9, 2, false), ACTION_FOCUS_NEXT);
        CTRLTabAction cTRLTabAction = new CTRLTabAction();
        actionMap.put(ACTION_FOCUS_NEXT, cTRLTabAction);
        this.getActionMap().put("selectNextColumn", new TreeTableAction(this.tree.getActionMap().get("selectChild"), this.getActionMap().get("selectNextColumn")));
        this.getActionMap().put("selectPreviousColumn", new TreeTableAction(this.tree.getActionMap().get("selectParent"), this.getActionMap().get("selectPreviousColumn")));
        this.getAccessibleContext().setAccessibleName(NbBundle.getBundle(TreeTable.class).getString("ACSN_TreeTable"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(TreeTable.class).getString("ACSD_TreeTable"));
        inputMap.put(KeyStroke.getKeyStroke(32, 0, false), "beginEdit");
        this.getActionMap().put("beginEdit", new EditAction());
        inputMap2.put(KeyStroke.getKeyStroke(27, 0, false), "cancelEdit");
        this.getActionMap().put("cancelEdit", new CancelEditAction());
        inputMap.put(KeyStroke.getKeyStroke(10, 0, false), "enter");
        this.getActionMap().put("enter", new EnterAction());
        inputMap.put(KeyStroke.getKeyStroke(9, 0), "next");
        inputMap.put(KeyStroke.getKeyStroke(9, 64), "previous");
        actionMap.put("next", new NavigationAction(true));
        actionMap.put("previous", new NavigationAction(false));
    }

    public TableCellEditor getDefaultEditor(Class clazz) {
        if (!this.edCreated && clazz == TreeTableModelAdapter.class) {
            this.setDefaultEditor(TreeTableModelAdapter.class, new TreeTableCellEditor());
            this.edCreated = true;
        }
        return super.getDefaultEditor(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectAll() {
        this.inSelectAll = true;
        try {
            super.selectAll();
        }
        finally {
            this.inSelectAll = false;
            this.selectionWrapper.updateSelectedPathsFromSelectedRows();
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
        }
        if (null != this.tableCell) {
            this.tableCell.updateUI();
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
        if (UIManager.getColor("Table.selectionBackground") == null) {
            UIManager.put("Table.selectionBackground", new JTable().getSelectionBackground());
        }
        if (UIManager.getColor("Table.selectionForeground") == null) {
            UIManager.put("Table.selectionForeground", new JTable().getSelectionForeground());
        }
        if (UIManager.getColor("Table.gridColor") == null) {
            UIManager.put("Table.gridColor", new JTable().getGridColor());
        }
        this.setUI(new TreeTableUI());
        this.needCalcRowHeight = true;
    }

    @Override
    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == TreeTableModelAdapter.class ? -1 : this.editingRow;
    }

    @Override
    protected final void configureEnclosingScrollPane() {
        Container container;
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport == null || jViewport.getView() != this) {
                return;
            }
            JTableHeader jTableHeader = this.getTableHeader();
            if (jTableHeader != null) {
                jTableHeader.setBorder(null);
            }
            jScrollPane.setColumnHeaderView(jTableHeader);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        new GuardedActions(0, graphics);
    }

    public void paintImpl(Graphics graphics) {
        if (this.needCalcRowHeight) {
            this.calcRowHeight(graphics);
            return;
        }
        super.paint(graphics);
    }

    @Override
    protected void validateTree() {
        new GuardedActions(1, null);
    }

    @Override
    public Dimension getPreferredSize() {
        return (Dimension)(TreeTable)this.new GuardedActions((int)5, null).ret;
    }

    @Override
    public void doLayout() {
        new GuardedActions(2, null);
    }

    @Override
    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        return (Boolean)(TreeTable)this.new GuardedActions((int)10, (Object)new Object[]{keyStroke, keyEvent, Integer.valueOf((int)n), Boolean.valueOf((boolean)bl)}).ret;
    }

    private void calcRowHeight(Graphics graphics) {
        Font font = this.getFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n = fontMetrics.getHeight() + fontMetrics.getMaxDescent();
        this.needCalcRowHeight = false;
        n = Math.max(20, n);
        this.tree.setRowHeight(n);
        this.setRowHeight(n);
    }

    JTree getTree() {
        return this.tree;
    }

    int getTreeColumnIndex() {
        return this.treeColumnIndex;
    }

    void setTreeColumnIndex(int n) {
        if (this.treeColumnIndex == n) {
            return;
        }
        int n2 = this.treeColumnIndex;
        this.treeColumnIndex = n;
        this.firePropertyChange("treeColumnIndex", n2, this.treeColumnIndex);
    }

    @Override
    public void clearSelection() {
        if (!this.ignoreClearSelection) {
            super.clearSelection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        int n = this.getTreeColumnIndex();
        if (tableModelEvent.getFirstRow() <= 0 && n != -1 && this.getColumnCount() > 0) {
            String string = this.getModel().getColumnName(n);
            TableColumn tableColumn = this.getColumnModel().getColumn(n);
            tableColumn.setHeaderValue(string);
        }
        this.ignoreClearSelection = true;
        try {
            super.tableChanged(tableModelEvent);
            if (null != this.getTree()) {
                this.firePropertyChange("positionX", -1, this.getPositionX());
            }
        }
        finally {
            this.ignoreClearSelection = false;
        }
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        if (this.isEditing() && (keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 38)) {
            return;
        }
        if (!this.isEditing() || keyEvent.getKeyCode() != 9 && keyEvent.getKeyCode() != 27 || (keyEvent.getModifiers() & 2) != 0) {
            super.processKeyEvent(keyEvent);
        } else {
            this.processKeyBinding(KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiersEx(), keyEvent.getID() == 402), keyEvent, 0, keyEvent.getID() == 401);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        boolean bl;
        MouseEvent mouseEvent;
        if (eventObject instanceof MouseEvent && n2 != 0 && (!SwingUtilities.isLeftMouseButton(mouseEvent = (MouseEvent)eventObject) || mouseEvent.getID() != 501)) {
            return false;
        }
        if (n >= this.getRowCount() || n < 0 || n2 > this.getColumnCount() || n2 < 0) {
            return false;
        }
        this.inEditRequest = true;
        this.editRow = n;
        if (this.editingRow == n && this.editingColumn == n2 && this.isEditing()) {
            this.inEditRequest = false;
            return false;
        }
        if (this.isEditing()) {
            this.inEditorChangeRequest = true;
            try {
                this.removeEditor();
                this.changeSelection(n, n2, false, false);
            }
            finally {
                this.inEditorChangeRequest = false;
            }
        }
        if ((bl = this.getModel().isCellEditable(n, n2)) && (eventObject == null || eventObject instanceof KeyEvent) && n2 == 0) {
            bl = false;
            n2 = 1;
        }
        boolean bl2 = false;
        if (!bl && (eventObject instanceof KeyEvent || eventObject == null)) {
            for (int i = n2; i < this.getColumnCount(); ++i) {
                if (!this.getModel().isCellEditable(n, i)) continue;
                bl2 = i != n2;
                n2 = i;
                this.changeSelection(n, n2, false, false);
                break;
            }
        }
        final Rectangle rectangle = this.getCellRect(n, n2, true);
        boolean bl3 = !bl2 && eventObject instanceof MouseEvent ? ((MouseEvent)eventObject).getX() > rectangle.x + rectangle.width - 24 && ((MouseEvent)eventObject).getX() < rectangle.x + rectangle.width : true;
        try {
            boolean bl4;
            this.canEdit = this.lastRow == n;
            Object object = this.getValueAt(n, n2);
            if (object instanceof Node.Property) {
                Action action;
                PropertyPanel propertyPanel;
                PropertyEditor propertyEditor;
                Node.Property property = (Node.Property)object;
                if (property.canWrite() && (property.getValueType() == Boolean.class || property.getValueType() == Boolean.TYPE)) {
                    try {
                        Boolean bl5 = (Boolean)property.getValue();
                        if (Boolean.FALSE.equals(bl5)) {
                            property.setValue((Object)Boolean.TRUE);
                        } else {
                            property.setValue((Object)Boolean.FALSE);
                        }
                        this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        boolean bl6 = false;
                        return bl6;
                    }
                    catch (Exception exception) {
                        Logger.getLogger(TreeTable.class.getName()).log(Level.WARNING, null, exception);
                        boolean bl7 = false;
                        this.inEditRequest = false;
                        return bl7;
                    }
                }
                if (bl3 && !Boolean.TRUE.equals(property.getValue("suppressCustomEditor")) && (propertyEditor = (propertyPanel = new PropertyPanel(property)).getPropertyEditor()) != null && propertyEditor.supportsCustomEditor() && (action = propertyPanel.getActionMap().get("invokeCustomEditor")) != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            rectangle.x = 0;
                            rectangle.width = TreeTable.this.getWidth();
                            TreeTable.this.repaint(rectangle);
                        }
                    });
                    action.actionPerformed(null);
                    boolean bl8 = false;
                    return bl8;
                }
                if (!property.canWrite()) {
                    boolean bl9 = false;
                    return bl9;
                }
            }
            if (bl4 = super.editCellAt(n, n2, eventObject)) {
                if (n2 == this.getTreeColumnIndex()) {
                    this.ignoreScrolling = true;
                    this.tree.scrollRectToVisible(this.tree.getRowBounds(n));
                    this.ignoreScrolling = false;
                } else {
                    SwingUtilities.invokeLater(this);
                }
            }
            boolean bl10 = bl4;
            return bl10;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.inEditRequest = false;
        }
    }

    @Override
    public void run() {
        if (this.editorComp != null && this.editorComp.isShowing()) {
            this.editorComp.requestFocus();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.lastRow = this.getSelectedRowCount() == 1 ? this.getSelectedRow() : -1;
        super.valueChanged(listSelectionEvent);
    }

    @Override
    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        super.columnAdded(tableColumnModelEvent);
        this.updateTreeColumnIndex();
    }

    @Override
    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        super.columnRemoved(tableColumnModelEvent);
        this.updateTreeColumnIndex();
    }

    @Override
    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        super.columnMoved(tableColumnModelEvent);
        this.updateTreeColumnIndex();
        int n = tableColumnModelEvent.getFromIndex();
        int n2 = tableColumnModelEvent.getToIndex();
        if (n != n2) {
            this.firePropertyChange("column_moved", n, n2);
        }
    }

    private void updateTreeColumnIndex() {
        for (int i = this.getColumnCount() - 1; i >= 0; --i) {
            if (this.getColumnClass(i) != TreeTableModelAdapter.class) continue;
            this.setTreeColumnIndex(i);
            return;
        }
        this.setTreeColumnIndex(-1);
    }

    public int getPositionX() {
        return this.positionX;
    }

    public void setPositionX(int n) {
        if (n == this.positionX || !this.treeHScrollingEnabled) {
            return;
        }
        int n2 = this.positionX;
        this.positionX = n;
        this.firePropertyChange("positionX", n2, n);
        if (this.isEditing() && this.getEditingColumn() == this.getTreeColumnIndex()) {
            TableCellEditor tableCellEditor = this.getCellEditor();
            if (this.ignoreScrolling && tableCellEditor instanceof TreeTableCellEditor) {
                ((TreeTableCellEditor)tableCellEditor).revalidateTextField();
            } else {
                this.removeEditor();
            }
        }
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.hasFocus() && this.getSelectedColumn() == 0 && this.getSelectedRow() > 0) {
            Color color = UIManager.getColor("Tree.selectionBorderColor");
            if (color == null) {
                color = this.getForeground().equals(Color.BLACK) ? this.getBackground().darker() : this.getForeground().darker();
            }
            graphics.setColor(color);
            Rectangle rectangle = this.getCellRect(this.getSelectedRow(), this.getSelectedColumn(), false);
            graphics.drawRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 3, rectangle.height - 3);
        }
    }

    void setTreeHScrollingEnabled(boolean bl) {
        this.treeHScrollingEnabled = bl;
    }

    boolean isKnownComponent(Component component) {
        if (component == null) {
            return false;
        }
        if (this.isAncestorOf(component)) {
            return true;
        }
        if (component == this.editorComp) {
            return true;
        }
        return this.editorComp != null && this.editorComp instanceof Container && ((Container)this.editorComp).isAncestorOf(component);
    }

    public boolean isValidationRoot() {
        return true;
    }

    @Override
    public void paintImmediately(int n, int n2, int n3, int n4) {
        if (this.inEditorChangeRequest) {
            return;
        }
        super.paintImmediately(n, n2, n3, n4);
    }

    @Override
    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (!(focusEvent.getID() != 1005 || focusEvent.isTemporary() || this.inRemoveRequest || this.inEditRequest)) {
            boolean bl;
            boolean bl2 = bl = focusEvent.getOppositeComponent() != this.getParent() && !this.isKnownComponent(focusEvent.getOppositeComponent()) && focusEvent.getOppositeComponent() != null;
            if (bl) {
                this.removeEditor();
            }
        }
        if (!this.inRemoveRequest && !this.inEditRequest) {
            this.repaintSelection(focusEvent.getID() == 1004);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEditor() {
        this.inRemoveRequest = true;
        try {
            Object object = this.getTreeLock();
            synchronized (object) {
                super.removeEditor();
            }
        }
        finally {
            this.inRemoveRequest = false;
        }
    }

    private void repaintSelection(boolean bl) {
        if (Children.MUTEX.isReadAccess() || Children.MUTEX.isWriteAccess()) {
            int n = this.getSelectionModel().getMinSelectionIndex();
            int n2 = this.getSelectionModel().getMaxSelectionIndex();
            if (n2 != -1) {
                if (n2 != n) {
                    Rectangle rectangle = this.getCellRect(n, 0, false);
                    Rectangle rectangle2 = this.getCellRect(n2, 0, false);
                    rectangle2.y = rectangle.y;
                    rectangle2.x = 0;
                    rectangle2.width = this.getWidth();
                    rectangle2.height = rectangle2.y + rectangle2.height - rectangle.y;
                    this.repaint(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                } else {
                    Rectangle rectangle = this.getCellRect(n, 0, false);
                    rectangle.width = this.getWidth();
                    rectangle.x = 0;
                    this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            }
            if (this.isEditing() && this.editorComp != null) {
                this.editorComp.setBackground(bl ? this.getSelectionBackground() : TreeTable.getUnfocusedSelectedBackground());
                this.editorComp.setForeground(bl ? this.getSelectionForeground() : TreeTable.getUnfocusedSelectedForeground());
            }
        } else {
            new GuardedActions(3, bl);
        }
    }

    static Color getUnfocusedSelectedBackground() {
        if (unfocusedSelBg == null && (unfocusedSelBg = UIManager.getColor("nb.explorer.unfocusedSelBg")) == null) {
            unfocusedSelBg = UIManager.getColor("controlShadow");
            if (unfocusedSelBg == null) {
                unfocusedSelBg = Color.lightGray;
            }
            unfocusedSelBg = unfocusedSelBg.brighter();
        }
        return unfocusedSelBg;
    }

    static Color getUnfocusedSelectedForeground() {
        if (unfocusedSelFg == null && (unfocusedSelFg = UIManager.getColor("nb.explorer.unfocusedSelFg")) == null && (unfocusedSelFg = UIManager.getColor("textText")) == null) {
            unfocusedSelFg = Color.BLACK;
        }
        return unfocusedSelFg;
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new TreeTableHeader(this.getColumnModel());
    }

    private class CTRLTabAction
    extends AbstractAction {
        private CTRLTabAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TreeTable.this.setFocusCycleRoot(false);
            try {
                Container container = TreeTable.this.getFocusCycleRootAncestor();
                if (container != null) {
                    Component component;
                    Container container2 = TreeTable.this;
                    if (TreeTable.this.getParent() instanceof JViewport && (container2 = TreeTable.this.getParent().getParent()) == container) {
                        container2 = TreeTable.this;
                    }
                    AWTEvent aWTEvent = EventQueue.getCurrentEvent();
                    boolean bl = false;
                    if (aWTEvent instanceof KeyEvent) {
                        bl = (((KeyEvent)aWTEvent).getModifiers() & 1) != 0 && (((KeyEvent)aWTEvent).getModifiersEx() & 0x40) != 0;
                    }
                    Component component2 = component = bl ? container.getFocusTraversalPolicy().getComponentAfter(container, TreeTable.this) : container.getFocusTraversalPolicy().getComponentAfter(container, TreeTable.this);
                    if (component == TreeTable.this) {
                        component = bl ? container.getFocusTraversalPolicy().getFirstComponent(container) : container.getFocusTraversalPolicy().getLastComponent(container);
                    }
                    component.requestFocus();
                }
            }
            finally {
                TreeTable.this.setFocusCycleRoot(true);
            }
        }
    }

    private class EnterAction
    extends AbstractAction {
        private EnterAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton;
            JRootPane jRootPane = TreeTable.this.getRootPane();
            if (jRootPane != null && (jButton = TreeTable.this.getRootPane().getDefaultButton()) != null && jButton.isEnabled()) {
                jButton.doClick();
            }
        }

        @Override
        public boolean isEnabled() {
            return !TreeTable.this.isEditing() && !TreeTable.this.inRemoveRequest;
        }
    }

    private class CancelEditAction
    extends AbstractAction {
        private CancelEditAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Action action;
            if (TreeTable.this.isEditing() || TreeTable.this.editorComp != null) {
                TreeTable.this.removeEditor();
                return;
            }
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            InputMap inputMap = TreeTable.this.getRootPane().getInputMap(1);
            ActionMap actionMap = TreeTable.this.getRootPane().getActionMap();
            KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
            Object object = inputMap.get(keyStroke);
            if (object == null) {
                object = "Cancel";
            }
            if (object != null && (action = actionMap.get(object)) != null) {
                String string = (String)action.getValue("ActionCommandKey");
                if (string == null) {
                    string = object.toString();
                }
                action.actionPerformed(new ActionEvent(this, 1001, string));
            }
        }

        @Override
        public boolean isEnabled() {
            return TreeTable.this.isEditing();
        }
    }

    private class EditAction
    extends AbstractAction {
        private EditAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = TreeTable.this.getSelectedRow();
            int n2 = TreeTable.this.getSelectedColumn();
            if (n2 == 0) {
                n2 = 1;
            }
            TreeTable.this.editCellAt(n, n2, null);
        }

        @Override
        public boolean isEnabled() {
            return TreeTable.this.getSelectedRow() != -1 && TreeTable.this.getSelectedColumn() != -1 && !TreeTable.this.isEditing() && TreeTable.this.getSelectedColumn() != TreeTable.this.getTreeColumnIndex();
        }
    }

    private final class NavigationAction
    extends AbstractAction {
        private boolean direction;

        public NavigationAction(boolean bl) {
            this.direction = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int n2;
            if (TreeTable.this.isEditing()) {
                TreeTable.this.removeEditor();
            }
            if (this.direction) {
                if (TreeTable.this.getSelectedColumn() == TreeTable.this.getColumnCount() - 1) {
                    n2 = 0;
                    n = TreeTable.this.getSelectedRow() + 1;
                } else {
                    n2 = TreeTable.this.getSelectedColumn() + 1;
                    n = TreeTable.this.getSelectedRow();
                }
            } else if (TreeTable.this.getSelectedColumn() <= 0) {
                n2 = TreeTable.this.getColumnCount() - 1;
                n = TreeTable.this.getSelectedRow() - 1;
            } else {
                n = TreeTable.this.getSelectedRow();
                n2 = TreeTable.this.getSelectedColumn() - 1;
            }
            if (n >= TreeTable.this.getRowCount() || n < 0) {
                JButton jButton;
                Container container;
                Component component;
                Container container2 = TreeTable.this.getFocusCycleRootAncestor();
                Component component2 = component = this.direction ? container2.getFocusTraversalPolicy().getComponentAfter(container2, TreeTable.this.getParent()) : container2.getFocusTraversalPolicy().getComponentBefore(container2, TreeTable.this);
                if (component == TreeTable.this && (container = container2.getFocusCycleRootAncestor()) != null) {
                    component = this.direction ? container.getFocusTraversalPolicy().getComponentAfter(container, container2) : container.getFocusTraversalPolicy().getComponentBefore(container, container2);
                    container2 = container;
                }
                if (component == TreeTable.this && container2.getFocusTraversalPolicy().getFirstComponent(container2) != null) {
                    component = container2.getFocusTraversalPolicy().getFirstComponent(container2);
                }
                if (component == TreeTable.this && (jButton = ((JRootPane)(container = TreeTable.this.getRootPane())).getDefaultButton()) != null) {
                    component = jButton;
                }
                if (component != null) {
                    if (component == TreeTable.this) {
                        TreeTable.this.changeSelection(this.direction ? 0 : TreeTable.this.getRowCount() - 1, this.direction ? 0 : TreeTable.this.getColumnCount() - 1, false, false);
                    } else {
                        component.requestFocus();
                    }
                    return;
                }
            }
            TreeTable.this.changeSelection(n, n2, false, false);
        }
    }

    private class STPolicy
    extends ContainerOrderFocusTraversalPolicy {
        private STPolicy() {
        }

        @Override
        public Component getComponentAfter(Container container, Component component) {
            if (TreeTable.this.inRemoveRequest) {
                return TreeTable.this;
            }
            Component component2 = super.getComponentAfter(container, component);
            return component2;
        }

        @Override
        public Component getComponentBefore(Container container, Component component) {
            if (TreeTable.this.inRemoveRequest) {
                return TreeTable.this;
            }
            return super.getComponentBefore(container, component);
        }

        @Override
        public Component getFirstComponent(Container container) {
            if (!TreeTable.this.inRemoveRequest && TreeTable.this.isEditing()) {
                return TreeTable.this.editorComp;
            }
            return TreeTable.this;
        }

        @Override
        public Component getDefaultComponent(Container container) {
            if (TreeTable.this.inRemoveRequest && TreeTable.this.isEditing() && TreeTable.this.editorComp.isShowing()) {
                return TreeTable.this.editorComp;
            }
            return TreeTable.this;
        }

        @Override
        protected boolean accept(Component component) {
            if (TreeTable.this.isEditing() && TreeTable.this.inEditRequest) {
                return TreeTable.this.isKnownComponent(component);
            }
            return super.accept(component) && component.isShowing();
        }
    }

    class TreeTableAction
    extends AbstractAction {
        Action treeAction;
        Action tableAction;

        TreeTableAction(Action action, Action action2) {
            this.treeAction = action;
            this.tableAction = action2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (TreeTable.this.getSelectedColumn() == TreeTable.this.getTreeColumnIndex()) {
                actionEvent.setSource(TreeTable.this.getTree());
                this.treeAction.actionPerformed(actionEvent);
            } else {
                this.tableAction.actionPerformed(actionEvent);
            }
        }
    }

    class TreeTableUI
    extends BasicTableUI {
        TreeTableUI() {
        }

        @Override
        protected MouseInputListener createMouseInputListener() {
            return new TreeTableMouseInputHandler();
        }

        public class TreeTableMouseInputHandler
        extends BasicTableUI.MouseInputHandler {
            private Component dispatchComponent;

            public TreeTableMouseInputHandler() {
                super(TreeTableUI.this);
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                this.processMouseEvent(mouseEvent);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.processMouseEvent(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (this.shouldIgnore(mouseEvent)) {
                    return;
                }
                this.repostEvent(mouseEvent);
                this.dispatchComponent = null;
                this.setValueIsAdjusting(false);
                if (!TreeTable.this.isEditing()) {
                    this.processMouseEvent(mouseEvent);
                }
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
            }

            private void setDispatchComponent(MouseEvent mouseEvent) {
                Component component = TreeTableUI.this.table.getEditorComponent();
                Point point = mouseEvent.getPoint();
                Point point2 = SwingUtilities.convertPoint(TreeTableUI.this.table, point, component);
                this.dispatchComponent = SwingUtilities.getDeepestComponentAt(component, point2.x, point2.y);
            }

            private boolean repostEvent(MouseEvent mouseEvent) {
                if (this.dispatchComponent == null) {
                    return false;
                }
                MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(TreeTableUI.this.table, mouseEvent, this.dispatchComponent);
                this.dispatchComponent.dispatchEvent(mouseEvent2);
                return true;
            }

            private void setValueIsAdjusting(boolean bl) {
                TreeTableUI.this.table.getSelectionModel().setValueIsAdjusting(bl);
                TreeTableUI.this.table.getColumnModel().getSelectionModel().setValueIsAdjusting(bl);
            }

            private boolean shouldIgnore(MouseEvent mouseEvent) {
                return !TreeTableUI.this.table.isEnabled() || mouseEvent.getButton() == 3 && mouseEvent.getClickCount() == 1 && !mouseEvent.isPopupTrigger();
            }

            private boolean isTreeColumn(int n) {
                return TreeTable.this.getColumnClass(n) == TreeTableModelAdapter.class;
            }

            private void processMouseEvent(MouseEvent mouseEvent) {
                Object object;
                if (this.shouldIgnore(mouseEvent)) {
                    return;
                }
                Point point = mouseEvent.getPoint();
                int n = TreeTableUI.this.table.rowAtPoint(point);
                int n2 = TreeTableUI.this.table.columnAtPoint(point);
                if (n2 == -1 || n == -1) {
                    return;
                }
                if (TreeTable.this.getEditingColumn() == n2 && TreeTable.this.getEditingRow() == n) {
                    return;
                }
                boolean bl = true;
                if (this.isTreeColumn(n2)) {
                    object = TreeTable.this.tree.getPathForRow(TreeTable.this.rowAtPoint(mouseEvent.getPoint()));
                    Rectangle rectangle = TreeTable.this.tree.getPathBounds((TreePath)object);
                    if (mouseEvent.getX() >= rectangle.x - TreeTable.this.positionX && mouseEvent.getX() <= rectangle.x - TreeTable.this.positionX + rectangle.width || this.isLocationInExpandControl((TreePath)object, point) || mouseEvent.getID() == 502 || mouseEvent.getID() == 500) {
                        bl = false;
                    }
                }
                if (TreeTableUI.this.table.getSelectionModel().isSelectedIndex(n) && mouseEvent.isPopupTrigger()) {
                    return;
                }
                if (TreeTableUI.this.table.editCellAt(n, n2, mouseEvent)) {
                    this.setDispatchComponent(mouseEvent);
                    this.repostEvent(mouseEvent);
                }
                if (mouseEvent.getID() == 501) {
                    TreeTableUI.this.table.requestFocus();
                }
                object = TreeTableUI.this.table.getCellEditor();
                if (bl && (object == null || object.shouldSelectCell(mouseEvent))) {
                    this.setValueIsAdjusting(true);
                    TreeTableUI.this.table.changeSelection(n, n2, Utilities.isMac() ? mouseEvent.isMetaDown() : mouseEvent.isControlDown(), mouseEvent.isShiftDown());
                    this.setValueIsAdjusting(false);
                }
            }

            private boolean isLocationInExpandControl(TreePath treePath, Point point) {
                if (TreeTable.this.tree.getModel().isLeaf(treePath.getLastPathComponent())) {
                    return false;
                }
                Rectangle rectangle = TreeTable.this.tree.getPathBounds(treePath);
                int n = 8;
                Insets insets = TreeTable.this.tree.getInsets();
                int n2 = 0;
                if (TreeTable.this.tree.getUI() instanceof BasicTreeUI) {
                    BasicTreeUI basicTreeUI = (BasicTreeUI)TreeTable.this.tree.getUI();
                    if (null != basicTreeUI.getExpandedIcon()) {
                        n = basicTreeUI.getExpandedIcon().getIconWidth();
                    }
                    n2 = basicTreeUI.getLeftChildIndent();
                }
                int n3 = TreeTable.this.tree.getComponentOrientation().isLeftToRight() ? rectangle.x - TreeTable.this.positionX - n2 - n : rectangle.x - TreeTable.this.positionX + n2 + rectangle.width;
                return point.getX() >= (double)n3 && point.getX() <= (double)(n3 + n);
            }
        }
    }

    class TreeTableSelectionModel
    extends DefaultListSelectionModel {
        TreeTableSelectionModel() {
        }

        @Override
        public void setAnchorSelectionIndex(int n) {
            if (TreeTable.this.ignoreClearSelection) {
                return;
            }
            super.setAnchorSelectionIndex(n);
        }

        @Override
        public void setLeadSelectionIndex(int n) {
            if (TreeTable.this.ignoreClearSelection) {
                return;
            }
            super.setLeadSelectionIndex(n);
        }
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.listSelectionModel = new TreeTableSelectionModel();
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int n = this.listSelectionModel.getMinSelectionIndex();
                    int n2 = this.listSelectionModel.getMaxSelectionIndex();
                    if (n == 0 && n2 == TreeTable.this.getRowCount()) {
                        int[] nArray = new int[n2];
                        for (int i = 0; i < nArray.length; ++i) {
                            nArray[i] = i;
                        }
                        TreeTable.this.tree.setSelectionRows(nArray);
                    } else {
                        ArrayList<Integer> arrayList = new ArrayList<Integer>(11);
                        for (int i = n; i <= n2; ++i) {
                            if (!this.listSelectionModel.isSelectedIndex(i)) continue;
                            arrayList.add(i);
                        }
                        if (arrayList.isEmpty()) {
                            this.clearSelection();
                        } else {
                            int[] nArray = (int[])Utilities.toPrimitiveArray((Object[])arrayList.toArray(new Integer[arrayList.size()]));
                            TreeTable.this.tree.setSelectionRows(nArray);
                        }
                    }
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (TreeTable.this.inSelectAll || listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }

    static class TreeTableTextField
    extends JTextField {
        public int offset;

        TreeTableTextField() {
        }

        @Override
        public void setBounds(int n, int n2, int n3, int n4) {
            int n5 = Math.max(n, this.offset);
            super.setBounds(n5, n2, n3 - (n5 - n), n4);
        }
    }

    class TreeTableCellEditor
    extends DefaultCellEditor
    implements TreeSelectionListener,
    ActionListener,
    FocusListener,
    CellEditorListener {
        protected transient int offset;
        protected transient Timer timer;

        public TreeTableCellEditor() {
            super(new TreeTableTextField());
            TreeTable.this.tree.addTreeSelectionListener(this);
            this.addCellEditorListener(this);
            super.getComponent().addFocusListener(this);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            this.determineOffset(object, bl, n);
            ((TreeTableTextField)this.getComponent()).offset = this.offset;
            return component;
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            Serializable serializable;
            if (TreeTable.this.lastRow != -1) {
                Node node;
                serializable = TreeTable.this.tree.getPathForRow(TreeTable.this.lastRow);
                Node node2 = node = serializable != null ? Visualizer.findNode(((TreePath)serializable).getLastPathComponent()) : null;
                if (node == null || !node.canRename()) {
                    TreeTable.this.canEdit = false;
                }
            }
            if (TreeTable.this.canEdit && eventObject != null && eventObject.getSource() instanceof Timer) {
                return true;
            }
            if (TreeTable.this.canEdit && this.shouldStartEditingTimer(eventObject)) {
                this.startEditingTimer();
            } else if (this.shouldStopEditingTimer(eventObject)) {
                this.timer.stop();
            }
            if (eventObject instanceof MouseEvent) {
                Serializable serializable2;
                serializable = (MouseEvent)eventObject;
                int n = TreeTable.this.getTreeColumnIndex();
                if (SwingUtilities.isLeftMouseButton((MouseEvent)serializable) && ((MouseEvent)serializable).getClickCount() == 2) {
                    serializable2 = TreeTable.this.tree.getPathForRow(TreeTable.this.rowAtPoint(((MouseEvent)serializable).getPoint()));
                    Rectangle rectangle = TreeTable.this.tree.getPathBounds((TreePath)serializable2);
                    if (((MouseEvent)serializable).getX() < rectangle.x - TreeTable.this.positionX || ((MouseEvent)serializable).getX() > rectangle.x - TreeTable.this.positionX + rectangle.width) {
                        ((MouseEvent)serializable).translatePoint(rectangle.x - ((MouseEvent)serializable).getX(), 0);
                    }
                }
                serializable2 = new MouseEvent(TreeTable.this.tree, ((AWTEvent)serializable).getID(), ((InputEvent)serializable).getWhen(), ((InputEvent)serializable).getModifiers() + ((MouseEvent)serializable).getModifiersEx(), ((MouseEvent)serializable).getX() - TreeTable.this.getCellRect((int)0, (int)n, (boolean)true).x + TreeTable.this.positionX, ((MouseEvent)serializable).getY(), ((MouseEvent)serializable).getClickCount(), ((MouseEvent)serializable).isPopupTrigger());
                TreeTable.this.tree.dispatchEvent((AWTEvent)serializable2);
            }
            return false;
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (this.timer != null) {
                this.timer.stop();
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (TreeTable.this.lastRow != -1) {
                TreeTable.this.editCellAt(TreeTable.this.lastRow, TreeTable.this.getTreeColumnIndex(), new EventObject(this.timer));
            }
        }

        private boolean shouldStartEditingTimer(EventObject eventObject) {
            if (eventObject instanceof MouseEvent && SwingUtilities.isLeftMouseButton((MouseEvent)eventObject)) {
                MouseEvent mouseEvent = (MouseEvent)eventObject;
                return mouseEvent.getID() == 501 && mouseEvent.getClickCount() == 1 && this.inHitRegion(mouseEvent);
            }
            return false;
        }

        private boolean shouldStopEditingTimer(EventObject eventObject) {
            if (this.timer == null) {
                return false;
            }
            if (eventObject instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)eventObject;
                return !SwingUtilities.isLeftMouseButton(mouseEvent) || mouseEvent.getClickCount() > 1;
            }
            return false;
        }

        private void startEditingTimer() {
            if (this.timer == null) {
                this.timer = new Timer(1200, this);
                this.timer.setRepeats(false);
            }
            this.timer.start();
        }

        private boolean inHitRegion(MouseEvent mouseEvent) {
            this.determineOffset(mouseEvent);
            return mouseEvent.getX() > this.offset;
        }

        private void determineOffset(MouseEvent mouseEvent) {
            int n = TreeTable.this.rowAtPoint(mouseEvent.getPoint());
            if (n == -1) {
                this.offset = 0;
                return;
            }
            this.determineOffset(TreeTable.this.tree.getPathForRow(n).getLastPathComponent(), TreeTable.this.isRowSelected(n), n);
        }

        private void determineOffset(Object object, boolean bl, int n) {
            Icon icon;
            Object object2;
            JTree jTree = TreeTable.this.getTree();
            boolean bl2 = jTree.isRootVisible();
            int n2 = n;
            if (!bl2 && n > 0) {
                --n2;
            }
            Rectangle rectangle = jTree.getRowBounds(n2);
            this.offset = rectangle.x;
            TreeCellRenderer treeCellRenderer = jTree.getCellRenderer();
            Component component = treeCellRenderer.getTreeCellRendererComponent(jTree, object2 = jTree.getPathForRow(n2).getLastPathComponent(), bl, jTree.isExpanded(n2), jTree.getModel().isLeaf(object2), n2, false);
            if (component instanceof JLabel && (icon = ((JLabel)component).getIcon()) != null) {
                this.offset += ((JLabel)component).getIconTextGap() + icon.getIconWidth();
            }
            this.offset -= TreeTable.this.positionX;
        }

        private void revalidateTextField() {
            int n = TreeTable.this.editingRow;
            if (n == -1) {
                this.offset = 0;
                return;
            }
            this.determineOffset(TreeTable.this.tree.getPathForRow(n).getLastPathComponent(), TreeTable.this.isRowSelected(n), n);
            ((TreeTableTextField)super.getComponent()).offset = this.offset;
            this.getComponent().setBounds(TreeTable.this.getCellRect(n, TreeTable.this.getTreeColumnIndex(), false));
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            ((TreeTableTextField)super.getComponent()).selectAll();
        }

        @Override
        public void editingStopped(ChangeEvent changeEvent) {
            Node node;
            TreePath treePath = TreeTable.this.tree.getPathForRow(TreeTable.this.lastRow);
            if (treePath != null && (node = Visualizer.findNode(treePath.getLastPathComponent())) != null && node.canRename()) {
                String string = (String)this.getCellEditorValue();
                ViewUtil.nodeRename(node, string);
            }
        }

        @Override
        public void editingCanceled(ChangeEvent changeEvent) {
        }
    }

    class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        protected int visibleRow;
        private int oldWidth;
        private int transY;

        public TreeTableCellRenderer(TreeModel treeModel) {
            super(treeModel);
            this.transY = 0;
            this.setToggleClickCount(0);
            this.putClientProperty("JTree.lineStyle", "None");
        }

        @Override
        public void validate() {
        }

        @Override
        public void repaint(long l, int n, int n2, int n3, int n4) {
        }

        @Override
        public void addHierarchyListener(HierarchyListener hierarchyListener) {
        }

        @Override
        public void addComponentListener(ComponentListener componentListener) {
        }

        TreeTable getTreeTable() {
            return TreeTable.this;
        }

        @Override
        public void setRowHeight(int n) {
            if (n > 0) {
                super.setRowHeight(n);
                TreeTable.this.setRowHeight(n);
            }
        }

        @Override
        public void setBounds(int n, int n2, int n3, int n4) {
            this.transY = -n2;
            int n5 = this.getWidth();
            super.setBounds(0, 0, TreeTable.this.getColumnModel().getColumn(0).getWidth(), TreeTable.this.getHeight());
            if (n5 != n3) {
                this.firePropertyChange("width", n5, n3);
            }
        }

        @Override
        public void paint(Graphics graphics) {
            graphics.translate(-TreeTable.this.getPositionX(), this.transY);
            super.paint(graphics);
        }

        @Override
        public Rectangle getVisibleRect() {
            Rectangle rectangle = TreeTable.this.getVisibleRect();
            rectangle.x = TreeTable.this.positionX;
            rectangle.width = TreeTable.this.getColumnModel().getColumn(TreeTable.this.getTreeColumnIndex()).getWidth();
            return rectangle;
        }

        @Override
        public void scrollRectToVisible(Rectangle rectangle) {
            Rectangle rectangle2 = this.getVisibleRect();
            rectangle2.y = rectangle.y;
            rectangle2.height = rectangle.height;
            TreeTable.this.scrollRectToVisible(rectangle2);
            int n = rectangle2.x;
            if (rectangle.width > rectangle2.width) {
                n = rectangle.x;
            } else if (rectangle.x < rectangle2.x) {
                n = rectangle.x;
            } else if (rectangle.x + rectangle.width > rectangle2.x + rectangle2.width) {
                n = rectangle.x + rectangle.width - rectangle2.width;
            }
            TreeTable.this.setPositionX(n);
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            if (mouseEvent != null) {
                Point point = mouseEvent.getPoint();
                point.translate(TreeTable.this.positionX, this.visibleRow * this.getRowHeight());
                int n = this.getRowForLocation(point.x, point.y);
                if (n != -1) {
                    TreePath treePath = this.getPathForRow(n);
                    VisualizerNode visualizerNode = (VisualizerNode)treePath.getLastPathComponent();
                    String string = visualizerNode.getShortDescription();
                    String string2 = visualizerNode.getDisplayName();
                    if (string != null && !string.equals(string2)) {
                        return string;
                    }
                }
            }
            return null;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                boolean bl3 = component == this || component == TreeTable.this || TreeTable.this.isAncestorOf(component) || component instanceof JRootPane;
                this.setBackground(bl3 ? jTable.getSelectionBackground() : TreeTable.getUnfocusedSelectedBackground());
                this.setForeground(bl3 ? jTable.getSelectionForeground() : TreeTable.getUnfocusedSelectedForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            this.visibleRow = n;
            return this;
        }

        @Override
        protected TreeModelListener createTreeModelListener() {
            return new JTree.TreeModelHandler(){

                @Override
                public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                    TreePath treePath;
                    if (TreeTable.this.tree.getSelectionCount() == 0 && (treePath = TreeView.findSiblingTreePath(treeModelEvent.getTreePath(), treeModelEvent.getChildIndices())) != null && treePath.getPathCount() > 0) {
                        TreeTable.this.tree.setSelectionPath(treePath);
                    }
                }
            };
        }

        @Override
        public void fireTreeCollapsed(TreePath treePath) {
            super.fireTreeCollapsed(treePath);
            this.firePropertyChange("width", -1, this.getWidth());
        }

        @Override
        public void fireTreeExpanded(TreePath treePath) {
            super.fireTreeExpanded(treePath);
            this.firePropertyChange("width", -1, this.getWidth());
        }

        boolean treeTableHasFocus() {
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            boolean bl = component == this || component == TreeTable.this || TreeTable.this.isAncestorOf(component) || component instanceof JRootPane;
            return bl;
        }
    }

    private static class TreeTableHeader
    extends JTableHeader {
        public TreeTableHeader(TableColumnModel tableColumnModel) {
            super(tableColumnModel);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            Component component = this.getDefaultRenderer().getTableCellRendererComponent(this.getTable(), "X", false, false, -1, 0);
            int n = component.getPreferredSize().height;
            dimension.height = Math.max(dimension.height, n);
            return dimension;
        }
    }

    private class GuardedActions
    implements Mutex.Action<Object> {
        private int type;
        private Object p1;
        final Object ret;

        public GuardedActions(int n, Object object) {
            this.type = n;
            this.p1 = object;
            this.ret = Children.MUTEX.readAccess((Mutex.Action)this);
        }

        public Object run() {
            switch (this.type) {
                case 0: {
                    TreeTable.this.paintImpl((Graphics)this.p1);
                    break;
                }
                case 1: {
                    TreeTable.super.validateTree();
                    break;
                }
                case 2: {
                    TreeTable.super.doLayout();
                    break;
                }
                case 3: {
                    TreeTable.this.repaintSelection((Boolean)this.p1);
                    break;
                }
                case 4: {
                    TreeTable.super.processEvent((AWTEvent)this.p1);
                    break;
                }
                case 5: {
                    return TreeTable.super.getPreferredSize();
                }
                case 6: 
                case 10: {
                    Object[] objectArray = (Object[])this.p1;
                    return TreeTable.super.processKeyBinding((KeyStroke)objectArray[0], (KeyEvent)objectArray[1], (Integer)objectArray[2], (Boolean)objectArray[3]);
                }
                default: {
                    throw new IllegalStateException("type: " + this.type);
                }
            }
            return null;
        }
    }
}

