/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.components.impl.android.\u7011\u5e03\u6d41\u5217\u8868\u6846\u7c7b\u5e93;

import android.content.Context;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.SparseBooleanArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.widget.ListAdapter;
import com.e4a.runtime.components.impl.android.\u7011\u5e03\u6d41\u5217\u8868\u6846\u7c7b\u5e93.PLA_AbsListView;
import com.e4a.runtime.components.impl.android.\u7011\u5e03\u6d41\u5217\u8868\u6846\u7c7b\u5e93.PLA_AdapterView;
import com.e4a.runtime.components.impl.android.\u7011\u5e03\u6d41\u5217\u8868\u6846\u7c7b\u5e93.PLA_HeaderViewListAdapter;
import java.util.ArrayList;

public class PLA_ListView
extends PLA_AbsListView {
    static final int NO_POSITION = -1;
    private static final float MAX_SCROLL_FACTOR = 0.33f;
    private ArrayList<FixedViewInfo> mHeaderViewInfos = new ArrayList();
    private ArrayList<FixedViewInfo> mFooterViewInfos = new ArrayList();
    Drawable mDivider;
    int mDividerHeight;
    Drawable mOverScrollHeader;
    Drawable mOverScrollFooter;
    private boolean mIsCacheColorOpaque;
    private boolean mDividerIsOpaque;
    private boolean mClipDivider;
    private boolean mHeaderDividersEnabled;
    private boolean mFooterDividersEnabled;
    private boolean mAreAllItemsSelectable = true;
    private boolean mItemsCanFocus = false;
    private final Rect mTempRect = new Rect();
    private Paint mDividerPaint;

    public PLA_ListView(Context context) {
        super(context);
    }

    public PLA_ListView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public PLA_ListView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.mHeaderDividersEnabled = true;
        this.mFooterDividersEnabled = true;
    }

    public int getMaxScrollAmount() {
        return (int)(0.33f * (float)(this.getBottom() - this.getTop()));
    }

    private void adjustViewsUpOrDown() {
        int n = this.getChildCount();
        if (n > 0) {
            int n2;
            if (!this.mStackFromBottom) {
                int n3 = this.getScrollChildTop();
                n2 = n3 - this.mListPadding.top;
                if (this.mFirstPosition != 0) {
                    n2 -= this.mDividerHeight;
                }
                if (n2 < 0) {
                    n2 = 0;
                }
            } else {
                int n4 = this.getScrollChildBottom();
                n2 = n4 - (this.getHeight() - this.mListPadding.bottom);
                if (this.mFirstPosition + n < this.mItemCount) {
                    n2 += this.mDividerHeight;
                }
                if (n2 > 0) {
                    n2 = 0;
                }
            }
            if (n2 != 0) {
                this.tryOffsetChildrenTopAndBottom(-n2);
            }
        }
    }

    public void addHeaderView(View view, Object object, boolean bl) {
        if (this.mAdapter != null) {
            throw new IllegalStateException("Cannot add header view to list -- setAdapter has already been called.");
        }
        FixedViewInfo fixedViewInfo = new FixedViewInfo();
        fixedViewInfo.view = view;
        fixedViewInfo.data = object;
        fixedViewInfo.isSelectable = bl;
        this.mHeaderViewInfos.add(fixedViewInfo);
    }

    public void addHeaderView(View view) {
        this.addHeaderView(view, null, true);
    }

    @Override
    public int getHeaderViewsCount() {
        return this.mHeaderViewInfos.size();
    }

    public boolean isFixedView(View view) {
        FixedViewInfo fixedViewInfo;
        int n;
        ArrayList<FixedViewInfo> arrayList = this.mHeaderViewInfos;
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            fixedViewInfo = arrayList.get(n);
            if (fixedViewInfo.view != view) continue;
            return true;
        }
        arrayList = this.mFooterViewInfos;
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            fixedViewInfo = arrayList.get(n);
            if (fixedViewInfo.view != view) continue;
            return true;
        }
        return false;
    }

    public boolean removeHeaderView(View view) {
        if (this.mHeaderViewInfos.size() > 0) {
            boolean bl = false;
            if (((PLA_HeaderViewListAdapter)this.mAdapter).removeHeader(view)) {
                this.mDataSetObserver.onChanged();
                bl = true;
            }
            this.removeFixedViewInfo(view, this.mHeaderViewInfos);
            return bl;
        }
        return false;
    }

    private void removeFixedViewInfo(View view, ArrayList<FixedViewInfo> arrayList) {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            FixedViewInfo fixedViewInfo = arrayList.get(i);
            if (fixedViewInfo.view != view) continue;
            arrayList.remove(i);
            break;
        }
    }

    public void addFooterView(View view, Object object, boolean bl) {
        FixedViewInfo fixedViewInfo = new FixedViewInfo();
        fixedViewInfo.view = view;
        fixedViewInfo.data = object;
        fixedViewInfo.isSelectable = bl;
        this.mFooterViewInfos.add(fixedViewInfo);
        if (this.mDataSetObserver != null) {
            this.mDataSetObserver.onChanged();
        }
    }

    public void addFooterView(View view) {
        this.addFooterView(view, null, true);
    }

    @Override
    public int getFooterViewsCount() {
        return this.mFooterViewInfos.size();
    }

    public boolean removeFooterView(View view) {
        if (this.mFooterViewInfos.size() > 0) {
            boolean bl = false;
            if (((PLA_HeaderViewListAdapter)this.mAdapter).removeFooter(view)) {
                this.mDataSetObserver.onChanged();
                bl = true;
            }
            this.removeFixedViewInfo(view, this.mFooterViewInfos);
            return bl;
        }
        return false;
    }

    @Override
    public ListAdapter getAdapter() {
        return this.mAdapter;
    }

    @Override
    public void setAdapter(ListAdapter listAdapter) {
        if (null != this.mAdapter) {
            this.mAdapter.unregisterDataSetObserver((DataSetObserver)this.mDataSetObserver);
        }
        this.resetList();
        this.mRecycler.clear();
        this.mAdapter = this.mHeaderViewInfos.size() > 0 || this.mFooterViewInfos.size() > 0 ? new PLA_HeaderViewListAdapter(this.mHeaderViewInfos, this.mFooterViewInfos, listAdapter) : listAdapter;
        this.mOldSelectedPosition = -1;
        this.mOldSelectedRowId = Long.MIN_VALUE;
        if (this.mAdapter != null) {
            this.mAreAllItemsSelectable = this.mAdapter.areAllItemsEnabled();
            this.mOldItemCount = this.mItemCount;
            this.mItemCount = this.mAdapter.getCount();
            this.mDataSetObserver = new PLA_AdapterView.AdapterDataSetObserver();
            this.mAdapter.registerDataSetObserver((DataSetObserver)this.mDataSetObserver);
            this.mRecycler.setViewTypeCount(this.mAdapter.getViewTypeCount());
        } else {
            this.mAreAllItemsSelectable = true;
        }
        this.requestLayout();
    }

    @Override
    public int getFirstVisiblePosition() {
        return Math.max(0, this.mFirstPosition - this.getHeaderViewsCount());
    }

    @Override
    public int getLastVisiblePosition() {
        return Math.min(this.mFirstPosition + this.getChildCount() - 1, this.mAdapter.getCount() - 1);
    }

    @Override
    void resetList() {
        this.clearRecycledState(this.mHeaderViewInfos);
        this.clearRecycledState(this.mFooterViewInfos);
        super.resetList();
        this.mLayoutMode = 0;
    }

    private void clearRecycledState(ArrayList<FixedViewInfo> arrayList) {
        if (arrayList != null) {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                View view = arrayList.get((int)i).view;
                PLA_AbsListView.LayoutParams layoutParams = (PLA_AbsListView.LayoutParams)view.getLayoutParams();
                if (layoutParams == null) continue;
                layoutParams.recycledHeaderFooter = false;
            }
        }
    }

    private boolean showingTopFadingEdge() {
        int n = this.getScrollY() + this.mListPadding.top;
        return this.mFirstPosition > 0 || this.getChildAt(0).getTop() > n;
    }

    private boolean showingBottomFadingEdge() {
        int n = this.getChildCount();
        int n2 = this.getChildAt(n - 1).getBottom();
        int n3 = this.mFirstPosition + n - 1;
        int n4 = this.getScrollY() + this.getHeight() - this.mListPadding.bottom;
        return n3 < this.mItemCount - 1 || n2 < n4;
    }

    public boolean requestChildRectangleOnScreen(View view, Rect rect, boolean bl) {
        int n;
        int n2 = rect.top;
        rect.offset(view.getLeft(), view.getTop());
        rect.offset(-view.getScrollX(), -view.getScrollY());
        int n3 = this.getHeight();
        int n4 = this.getScrollY();
        int n5 = n4 + n3;
        int n6 = this.getVerticalFadingEdgeLength();
        if (this.showingTopFadingEdge() && n2 > n6) {
            n4 += n6;
        }
        int n7 = this.getChildCount();
        int n8 = this.getChildAt(n7 - 1).getBottom();
        if (this.showingBottomFadingEdge() && rect.bottom < n8 - n6) {
            n5 -= n6;
        }
        int n9 = 0;
        if (rect.bottom > n5 && rect.top > n4) {
            n9 = rect.height() > n3 ? (n9 += rect.top - n4) : (n9 += rect.bottom - n5);
            n = n8 - n5;
            n9 = Math.min(n9, n);
        } else if (rect.top < n4 && rect.bottom < n5) {
            n9 = rect.height() > n3 ? (n9 -= n5 - rect.bottom) : (n9 -= n4 - rect.top);
            n = this.getChildAt(0).getTop();
            int n10 = n - n4;
            n9 = Math.max(n9, n10);
        }
        int n11 = n = n9 != 0 ? 1 : 0;
        if (n != 0) {
            this.scrollListItemsBy(-n9);
            this.positionSelector(view);
            this.mSelectedTop = view.getTop();
            this.invalidate();
        }
        return n != 0;
    }

    protected int getItemLeft(int n) {
        return this.mListPadding.left;
    }

    protected int getItemTop(int n) {
        int n2 = this.getChildCount();
        return n2 > 0 ? this.getChildAt(n2 - 1).getBottom() + this.mDividerHeight : this.getListPaddingTop();
    }

    protected int getItemBottom(int n) {
        int n2 = this.getChildCount();
        return n2 > 0 ? this.getChildAt(0).getTop() - this.mDividerHeight : this.getHeight() - this.getListPaddingBottom();
    }

    @Override
    protected void fillGap(boolean bl) {
        int n = this.getChildCount();
        if (bl) {
            this.fillDown(this.mFirstPosition + n, this.getItemTop(this.mFirstPosition + n));
            this.onAdjustChildViews(bl);
        } else {
            this.fillUp(this.mFirstPosition - 1, this.getItemBottom(this.mFirstPosition - 1));
            this.onAdjustChildViews(bl);
        }
    }

    private View fillDown(int n, int n2) {
        int n3 = this.getBottom() - this.getTop() - this.mListPadding.bottom;
        int n4 = this.getFillChildBottom() + this.mDividerHeight;
        while (n4 < n3 && n < this.mItemCount) {
            this.makeAndAddView(n, this.getItemTop(n), true, false);
            ++n;
            n4 = this.getFillChildBottom() + this.mDividerHeight;
        }
        return null;
    }

    private View fillUp(int n, int n2) {
        int n3 = this.mListPadding.top;
        int n4 = this.getFillChildTop();
        while (n4 > n3 && n >= 0) {
            this.makeAndAddView(n, this.getItemBottom(n), false, false);
            n4 = this.getItemBottom(--n);
        }
        this.mFirstPosition = n + 1;
        return null;
    }

    private View fillFromTop(int n) {
        this.mFirstPosition = Math.min(this.mFirstPosition, -1);
        this.mFirstPosition = Math.min(this.mFirstPosition, this.mItemCount - 1);
        if (this.mFirstPosition < 0) {
            this.mFirstPosition = 0;
        }
        return this.fillDown(this.mFirstPosition, n);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        int n3 = View.MeasureSpec.getMode((int)n);
        int n4 = View.MeasureSpec.getMode((int)n2);
        int n5 = View.MeasureSpec.getSize((int)n);
        int n6 = View.MeasureSpec.getSize((int)n2);
        int n7 = 0;
        int n8 = 0;
        int n9 = this.mItemCount = this.mAdapter == null ? 0 : this.mAdapter.getCount();
        if (this.mItemCount > 0 && (n3 == 0 || n4 == 0)) {
            View view = this.obtainView(0, this.mIsScrap);
            this.measureScrapChild(view, 0, n);
            n7 = view.getMeasuredWidth();
            n8 = view.getMeasuredHeight();
            if (this.recycleOnMeasure() && this.mRecycler.shouldRecycleViewType(((PLA_AbsListView.LayoutParams)view.getLayoutParams()).viewType)) {
                this.mRecycler.addScrapView(view);
            }
        }
        if (n3 == 0) {
            n5 = this.mListPadding.left + this.mListPadding.right + n7 + this.getVerticalScrollbarWidth();
        }
        if (n4 == 0) {
            n6 = this.mListPadding.top + this.mListPadding.bottom + n8 + this.getVerticalFadingEdgeLength() * 2;
        }
        if (n4 == Integer.MIN_VALUE) {
            n6 = this.measureHeightOfChildren(n, 0, -1, n6, -1);
        }
        this.setMeasuredDimension(n5, n6);
        this.mWidthMeasureSpec = n;
    }

    private void measureScrapChild(View view, int n, int n2) {
        PLA_AbsListView.LayoutParams layoutParams = (PLA_AbsListView.LayoutParams)view.getLayoutParams();
        if (layoutParams == null) {
            layoutParams = new PLA_AbsListView.LayoutParams(-1, -2, 0);
            view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
        layoutParams.viewType = this.mAdapter.getItemViewType(n);
        layoutParams.forceAdd = true;
        int n3 = ViewGroup.getChildMeasureSpec((int)n2, (int)(this.mListPadding.left + this.mListPadding.right), (int)layoutParams.width);
        int n4 = layoutParams.height;
        int n5 = n4 > 0 ? View.MeasureSpec.makeMeasureSpec((int)n4, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        view.measure(n3, n5);
    }

    @ViewDebug.ExportedProperty(category="list")
    protected boolean recycleOnMeasure() {
        return true;
    }

    final int measureHeightOfChildren(int n, int n2, int n3, int n4, int n5) {
        ListAdapter listAdapter = this.mAdapter;
        if (listAdapter == null) {
            return this.mListPadding.top + this.mListPadding.bottom;
        }
        int n6 = this.mListPadding.top + this.mListPadding.bottom;
        int n7 = this.mDividerHeight > 0 && this.mDivider != null ? this.mDividerHeight : 0;
        int n8 = 0;
        n3 = n3 == -1 ? listAdapter.getCount() - 1 : n3;
        PLA_AbsListView.RecycleBin recycleBin = this.mRecycler;
        boolean bl = this.recycleOnMeasure();
        boolean[] blArray = this.mIsScrap;
        for (int i = n2; i <= n3; ++i) {
            View view = this.obtainView(i, blArray);
            this.measureScrapChild(view, i, n);
            if (i > 0) {
                n6 += n7;
            }
            if (bl && recycleBin.shouldRecycleViewType(((PLA_AbsListView.LayoutParams)view.getLayoutParams()).viewType)) {
                recycleBin.addScrapView(view);
            }
            if ((n6 += view.getMeasuredHeight()) >= n4) {
                return n5 >= 0 && i > n5 && n8 > 0 && n6 != n4 ? n8 : n4;
            }
            if (n5 < 0 || i < n5) continue;
            n8 = n6;
        }
        return n6;
    }

    @Override
    int findMotionRow(int n) {
        block4: {
            int n2 = this.getChildCount();
            if (n2 <= 0) break block4;
            if (!this.mStackFromBottom) {
                for (int i = 0; i < n2; ++i) {
                    View view = this.getChildAt(i);
                    if (n > view.getBottom()) continue;
                    return this.mFirstPosition + i;
                }
            } else {
                for (int i = n2 - 1; i >= 0; --i) {
                    View view = this.getChildAt(i);
                    if (n < view.getTop()) continue;
                    return this.mFirstPosition + i;
                }
            }
        }
        return -1;
    }

    private View fillSpecific(int n, int n2) {
        View view = this.makeAndAddView(n, n2, true, false);
        this.mFirstPosition = n;
        int n3 = this.mDividerHeight;
        if (!this.mStackFromBottom) {
            this.fillUp(n - 1, view.getTop() - n3);
            this.adjustViewsUpOrDown();
            this.fillDown(n + 1, view.getBottom() + n3);
            int n4 = this.getChildCount();
            if (n4 > 0) {
                this.correctTooHigh(n4);
            }
        } else {
            this.fillDown(n + 1, view.getBottom() + n3);
            this.adjustViewsUpOrDown();
            this.fillUp(n - 1, view.getTop() - n3);
            int n5 = this.getChildCount();
            if (n5 > 0) {
                this.correctTooLow(n5);
            }
        }
        return null;
    }

    private void correctTooHigh(int n) {
        int n2 = this.mFirstPosition + n - 1;
        if (n2 == this.mItemCount - 1 && n > 0) {
            int n3 = this.getScrollChildBottom();
            int n4 = this.getBottom() - this.getTop() - this.mListPadding.bottom;
            int n5 = n4 - n3;
            int n6 = this.getScrollChildTop();
            if (n5 > 0 && (this.mFirstPosition > 0 || n6 < this.mListPadding.top)) {
                if (this.mFirstPosition == 0) {
                    n5 = Math.min(n5, this.mListPadding.top - n6);
                }
                this.tryOffsetChildrenTopAndBottom(n5);
                if (this.mFirstPosition > 0) {
                    int n7 = this.getScrollChildTop();
                    this.fillUp(this.mFirstPosition - 1, n7 - this.mDividerHeight);
                    this.adjustViewsUpOrDown();
                }
            }
        }
    }

    private void correctTooLow(int n) {
        if (this.mFirstPosition == 0 && n > 0) {
            int n2 = this.getScrollChildTop();
            int n3 = this.mListPadding.top;
            int n4 = this.getBottom() - this.getTop() - this.mListPadding.bottom;
            int n5 = n2 - n3;
            int n6 = this.getScrollChildBottom();
            int n7 = this.mFirstPosition + n - 1;
            if (n5 > 0) {
                if (n7 < this.mItemCount - 1 || n6 > n4) {
                    if (n7 == this.mItemCount - 1) {
                        n5 = Math.min(n5, n6 - n4);
                    }
                    this.tryOffsetChildrenTopAndBottom(-n5);
                    if (n7 < this.mItemCount - 1) {
                        this.fillDown(n7 + 1, this.getFillChildTop() + this.mDividerHeight);
                        this.adjustViewsUpOrDown();
                    }
                } else if (n7 == this.mItemCount - 1) {
                    this.adjustViewsUpOrDown();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void layoutChildren() {
        boolean bl = this.mBlockLayoutRequests;
        if (bl) {
            return;
        }
        this.mBlockLayoutRequests = true;
        try {
            this.invalidate();
            if (this.mAdapter == null) {
                this.resetList();
                this.invokeOnItemScrollListener();
                return;
            }
            int n = this.mListPadding.top;
            int n2 = this.getBottom() - this.getTop() - this.mListPadding.bottom;
            int n3 = this.getChildCount();
            boolean bl2 = false;
            View view = null;
            switch (this.mLayoutMode) {
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                default: {
                    view = this.getChildAt(0);
                }
            }
            boolean bl3 = this.mDataChanged;
            if (bl3) {
                this.handleDataChanged();
            }
            if (this.mItemCount == 0) {
                this.resetList();
                this.invokeOnItemScrollListener();
                return;
            }
            if (this.mItemCount != this.mAdapter.getCount()) {
                throw new IllegalStateException("The content of the adapter has changed but ListView did not receive a notification. Make sure the content of your adapter is not modified from a background thread, but only from the UI thread. [in ListView(" + this.getId() + ", " + ((Object)((Object)this)).getClass() + ") with Adapter(" + this.mAdapter.getClass() + ")]");
            }
            int n4 = this.mFirstPosition;
            PLA_AbsListView.RecycleBin recycleBin = this.mRecycler;
            if (bl3) {
                for (int i = n3 - 1; i >= 0; --i) {
                    recycleBin.addScrapView(this.getChildAt(i));
                }
            } else {
                recycleBin.fillActiveViews(n3, n4);
            }
            switch (this.mLayoutMode) {
                case 5: {
                    this.onLayoutSync(this.mSyncPosition);
                    this.detachAllViewsFromParent();
                    this.fillSpecific(this.mSyncPosition, this.mSpecificTop);
                    this.onLayoutSyncFinished(this.mSyncPosition);
                    break;
                }
                case 3: {
                    this.detachAllViewsFromParent();
                    this.fillUp(this.mItemCount - 1, n2);
                    this.adjustViewsUpOrDown();
                    break;
                }
                case 1: {
                    this.detachAllViewsFromParent();
                    this.mFirstPosition = 0;
                    this.fillFromTop(n);
                    this.adjustViewsUpOrDown();
                    break;
                }
                case 4: {
                    this.detachAllViewsFromParent();
                    this.fillSpecific(this.reconcileSelectedPosition(), this.mSpecificTop);
                    break;
                }
                default: {
                    if (n3 == 0) {
                        this.detachAllViewsFromParent();
                        if (!this.mStackFromBottom) {
                            this.fillFromTop(n);
                            break;
                        }
                        this.fillUp(this.mItemCount - 1, n2);
                        break;
                    }
                    if (this.mFirstPosition < this.mItemCount) {
                        this.onLayoutSync(this.mFirstPosition);
                        this.detachAllViewsFromParent();
                        this.fillSpecific(this.mFirstPosition, view == null ? n : view.getTop());
                        this.onLayoutSyncFinished(this.mFirstPosition);
                        break;
                    }
                    this.onLayoutSync(0);
                    this.detachAllViewsFromParent();
                    this.fillSpecific(0, n);
                    this.onLayoutSyncFinished(0);
                }
            }
            recycleBin.scrapActiveViews();
            if (this.mTouchMode > 0 && this.mTouchMode < 3) {
                View view2 = this.getChildAt(this.mMotionPosition - this.mFirstPosition);
                if (view2 != null) {
                    this.positionSelector(view2);
                }
            } else {
                this.mSelectedTop = 0;
                this.mSelectorRect.setEmpty();
            }
            this.mLayoutMode = 0;
            this.mDataChanged = false;
            this.mNeedSync = false;
            if (this.mItemCount > 0) {
                this.checkSelectionChanged();
            }
            this.invokeOnItemScrollListener();
        }
        finally {
            if (!bl) {
                this.mBlockLayoutRequests = false;
            }
        }
    }

    private View makeAndAddView(int n, int n2, boolean bl, boolean bl2) {
        View view;
        if (!this.mDataChanged && (view = this.mRecycler.getActiveView(n)) != null) {
            int n3 = this.getItemLeft(n);
            this.setupChild(view, n, n2, bl, n3, bl2, true);
            return view;
        }
        this.onItemAddedToList(n, bl);
        int n4 = this.getItemLeft(n);
        view = this.obtainView(n, this.mIsScrap);
        this.setupChild(view, n, n2, bl, n4, bl2, this.mIsScrap[0]);
        return view;
    }

    protected void onItemAddedToList(int n, boolean bl) {
    }

    private void setupChild(View view, int n, int n2, boolean bl, int n3, boolean bl2, boolean bl3) {
        int n4;
        int n5;
        int n6;
        boolean bl4 = bl2 && this.shouldShowSelector();
        boolean bl5 = bl4 != view.isSelected();
        int n7 = this.mTouchMode;
        boolean bl6 = n7 > 0 && n7 < 3 && this.mMotionPosition == n;
        boolean bl7 = bl6 != view.isPressed();
        boolean bl8 = !bl3 || bl5 || view.isLayoutRequested();
        PLA_AbsListView.LayoutParams layoutParams = (PLA_AbsListView.LayoutParams)view.getLayoutParams();
        if (layoutParams == null) {
            layoutParams = new PLA_AbsListView.LayoutParams(-1, -2, 0);
        }
        layoutParams.viewType = this.mAdapter.getItemViewType(n);
        layoutParams.scrappedFromPosition = n;
        if (bl3 && !layoutParams.forceAdd || layoutParams.recycledHeaderFooter && layoutParams.viewType == -2) {
            this.attachViewToParent(view, bl ? -1 : 0, layoutParams);
        } else {
            layoutParams.forceAdd = false;
            if (layoutParams.viewType == -2) {
                layoutParams.recycledHeaderFooter = true;
            }
            this.addViewInLayout(view, bl ? -1 : 0, layoutParams, true);
        }
        if (bl5) {
            view.setSelected(bl4);
        }
        if (bl7) {
            view.setPressed(bl6);
        }
        if (bl8) {
            n6 = ViewGroup.getChildMeasureSpec((int)this.mWidthMeasureSpec, (int)(this.mListPadding.left + this.mListPadding.right), (int)layoutParams.width);
            n5 = layoutParams.height;
            n4 = n5 > 0 ? View.MeasureSpec.makeMeasureSpec((int)n5, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
            this.onMeasureChild(view, n, n6, n4);
        } else {
            this.cleanupLayoutState(view);
        }
        n6 = view.getMeasuredWidth();
        n5 = view.getMeasuredHeight();
        int n8 = n4 = bl ? n2 : n2 - n5;
        if (bl8) {
            int n9 = n3 + n6;
            int n10 = n4 + n5;
            this.onLayoutChild(view, n, n3, n4, n9, n10);
        } else {
            int n11 = n3 - view.getLeft();
            int n12 = n4 - view.getTop();
            this.onOffsetChild(view, n, n11, n12);
        }
        if (this.mCachingStarted && !view.isDrawingCacheEnabled()) {
            view.setDrawingCacheEnabled(true);
        }
    }

    protected void onOffsetChild(View view, int n, int n2, int n3) {
        view.offsetLeftAndRight(n2);
        view.offsetTopAndBottom(n3);
    }

    protected void onLayoutChild(View view, int n, int n2, int n3, int n4, int n5) {
        view.layout(n2, n3, n4, n5);
    }

    protected void onMeasureChild(View view, int n, int n2, int n3) {
        view.measure(n2, n3);
    }

    protected void onAdjustChildViews(boolean bl) {
        if (bl) {
            this.correctTooHigh(this.getChildCount());
        } else {
            this.correctTooLow(this.getChildCount());
        }
    }

    @Override
    protected boolean canAnimate() {
        return super.canAnimate() && this.mItemCount > 0;
    }

    @Override
    public void setSelection(int n) {
    }

    public void setSelectionFromTop(int n, int n2) {
        this.mLayoutMode = 4;
        this.mSpecificTop = this.mListPadding.top + n2;
        if (this.mNeedSync) {
            this.mSyncPosition = n;
            this.mSyncRowId = this.mAdapter.getItemId(n);
        }
        if (this.mPositionScroller != null) {
            this.mPositionScroller.stop();
        }
        this.requestLayout();
    }

    @Override
    int lookForSelectablePosition(int n, boolean bl) {
        ListAdapter listAdapter = this.mAdapter;
        if (listAdapter == null || this.isInTouchMode()) {
            return -1;
        }
        int n2 = listAdapter.getCount();
        if (!this.mAreAllItemsSelectable) {
            if (bl) {
                for (n = Math.max(0, n); n < n2 && !listAdapter.isEnabled(n); ++n) {
                }
            } else {
                for (n = Math.min(n, n2 - 1); n >= 0 && !listAdapter.isEnabled(n); --n) {
                }
            }
            if (n < 0 || n >= n2) {
                return -1;
            }
            return n;
        }
        if (n < 0 || n >= n2) {
            return -1;
        }
        return n;
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        boolean bl = super.dispatchPopulateAccessibilityEvent(accessibilityEvent);
        if (!bl) {
            int n = 0;
            int n2 = this.getSelectedItemPosition();
            ListAdapter listAdapter = this.getAdapter();
            if (listAdapter != null) {
                int n3 = listAdapter.getCount();
                if (n3 < 15) {
                    for (int i = 0; i < n3; ++i) {
                        if (listAdapter.isEnabled(i)) {
                            ++n;
                            continue;
                        }
                        if (i > n2) continue;
                        --n2;
                    }
                } else {
                    n = n3;
                }
            }
            accessibilityEvent.setItemCount(n);
            accessibilityEvent.setCurrentItemIndex(n2);
        }
        return bl;
    }

    public boolean fullScroll(int n) {
        boolean bl = false;
        if (n == 33) {
            int n2 = this.lookForSelectablePosition(0, true);
            if (n2 >= 0) {
                this.mLayoutMode = 1;
                this.invokeOnItemScrollListener();
                bl = true;
            }
        } else if (n == 130) {
            int n3 = this.lookForSelectablePosition(this.mItemCount - 1, true);
            if (n3 >= 0) {
                this.mLayoutMode = 3;
                this.invokeOnItemScrollListener();
            }
            bl = true;
        }
        if (bl && !this.awakenScrollBars()) {
            this.awakenScrollBars();
            this.invalidate();
        }
        return bl;
    }

    private void scrollListItemsBy(int n) {
        this.tryOffsetChildrenTopAndBottom(n);
        int n2 = this.getHeight() - this.mListPadding.bottom;
        int n3 = this.mListPadding.top;
        PLA_AbsListView.RecycleBin recycleBin = this.mRecycler;
        if (n < 0) {
            int n4;
            View view = this.getLastChild();
            int n5 = this.getChildCount();
            while (view.getBottom() < n2 && (n4 = this.mFirstPosition + n5 - 1) < this.mItemCount - 1) {
                this.addViewBelow(view, n4);
                view = this.getLastChild();
                ++n5;
            }
            if (view.getBottom() < n2) {
                this.tryOffsetChildrenTopAndBottom(n2 - view.getBottom());
            }
            View view2 = this.getChildAt(0);
            while (view2.getBottom() < n3) {
                PLA_AbsListView.LayoutParams layoutParams = (PLA_AbsListView.LayoutParams)view2.getLayoutParams();
                if (recycleBin.shouldRecycleViewType(layoutParams.viewType)) {
                    this.detachViewFromParent(view2);
                    recycleBin.addScrapView(view2);
                } else {
                    this.removeViewInLayout(view2);
                }
                view2 = this.getChildAt(0);
                ++this.mFirstPosition;
            }
        } else {
            View view = this.getChildAt(0);
            while (view.getTop() > n3 && this.mFirstPosition > 0) {
                view = this.addViewAbove(view, this.mFirstPosition);
                --this.mFirstPosition;
            }
            if (view.getTop() > n3) {
                this.tryOffsetChildrenTopAndBottom(n3 - view.getTop());
            }
            int n6 = this.getChildCount() - 1;
            View view3 = this.getChildAt(n6);
            while (view3.getTop() > n2) {
                PLA_AbsListView.LayoutParams layoutParams = (PLA_AbsListView.LayoutParams)view3.getLayoutParams();
                if (recycleBin.shouldRecycleViewType(layoutParams.viewType)) {
                    this.detachViewFromParent(view3);
                    recycleBin.addScrapView(view3);
                } else {
                    this.removeViewInLayout(view3);
                }
                view3 = this.getChildAt(--n6);
            }
        }
    }

    protected View getLastChild() {
        int n = this.getChildCount();
        return this.getChildAt(n - 1);
    }

    private View addViewAbove(View view, int n) {
        int n2 = n - 1;
        View view2 = this.obtainView(n2, this.mIsScrap);
        int n3 = view.getTop() - this.mDividerHeight;
        this.setupChild(view2, n2, n3, false, this.mListPadding.left, false, this.mIsScrap[0]);
        return view2;
    }

    private View addViewBelow(View view, int n) {
        int n2 = n + 1;
        View view2 = this.obtainView(n2, this.mIsScrap);
        int n3 = view.getBottom() + this.mDividerHeight;
        this.setupChild(view2, n2, n3, true, this.mListPadding.left, false, this.mIsScrap[0]);
        return view2;
    }

    public void setItemsCanFocus(boolean bl) {
        this.mItemsCanFocus = bl;
        if (!bl) {
            this.setDescendantFocusability(393216);
        }
    }

    public boolean getItemsCanFocus() {
        return this.mItemsCanFocus;
    }

    public boolean isOpaque() {
        return this.mCachingStarted && this.mIsCacheColorOpaque && this.mDividerIsOpaque || super.isOpaque();
    }

    @Override
    public void setCacheColorHint(int n) {
        boolean bl;
        this.mIsCacheColorOpaque = bl = n >>> 24 == 255;
        if (bl) {
            if (this.mDividerPaint == null) {
                this.mDividerPaint = new Paint();
            }
            this.mDividerPaint.setColor(n);
        }
        super.setCacheColorHint(n);
    }

    void drawOverscrollHeader(Canvas canvas, Drawable drawable, Rect rect) {
        int n = drawable.getMinimumHeight();
        canvas.save();
        canvas.clipRect(rect);
        int n2 = rect.bottom - rect.top;
        if (n2 < n) {
            rect.top = rect.bottom - n;
        }
        drawable.setBounds(rect);
        drawable.draw(canvas);
        canvas.restore();
    }

    void drawOverscrollFooter(Canvas canvas, Drawable drawable, Rect rect) {
        int n = drawable.getMinimumHeight();
        canvas.save();
        canvas.clipRect(rect);
        int n2 = rect.bottom - rect.top;
        if (n2 < n) {
            rect.bottom = rect.top + n;
        }
        drawable.setBounds(rect);
        drawable.draw(canvas);
        canvas.restore();
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        boolean bl;
        int n = this.mDividerHeight;
        Drawable drawable = this.mOverScrollHeader;
        Drawable drawable2 = this.mOverScrollFooter;
        boolean bl2 = drawable != null;
        boolean bl3 = drawable2 != null;
        boolean bl4 = bl = n > 0 && this.mDivider != null;
        if (bl || bl2 || bl3) {
            boolean bl5;
            Rect rect = this.mTempRect;
            rect.left = this.getPaddingLeft();
            rect.right = this.getRight() - this.getLeft() - this.getPaddingRight();
            int n2 = this.getChildCount();
            int n3 = this.mHeaderViewInfos.size();
            int n4 = this.mItemCount;
            int n5 = n4 - this.mFooterViewInfos.size() - 1;
            boolean bl6 = this.mHeaderDividersEnabled;
            boolean bl7 = this.mFooterDividersEnabled;
            int n6 = this.mFirstPosition;
            boolean bl8 = this.mAreAllItemsSelectable;
            ListAdapter listAdapter = this.mAdapter;
            boolean bl9 = bl5 = bl && this.isOpaque() && !super.isOpaque();
            if (bl5 && this.mDividerPaint == null && this.mIsCacheColorOpaque) {
                this.mDividerPaint = new Paint();
                this.mDividerPaint.setColor(this.getCacheColorHint());
            }
            Paint paint = this.mDividerPaint;
            int n7 = this.getBottom() - this.getTop() - this.mListPadding.bottom + this.getScrollY();
            if (!this.mStackFromBottom) {
                int n8;
                int n9 = 0;
                int n10 = this.getScrollY();
                if (n2 > 0 && n10 < 0) {
                    if (bl2) {
                        rect.bottom = 0;
                        rect.top = n10;
                        this.drawOverscrollHeader(canvas, drawable, rect);
                    } else if (bl) {
                        rect.bottom = 0;
                        rect.top = -n;
                        this.drawDivider(canvas, rect, -1);
                    }
                }
                for (n8 = 0; n8 < n2; ++n8) {
                    if (!bl6 && n6 + n8 < n3 || !bl7 && n6 + n8 >= n5) continue;
                    View view = this.getChildAt(n8);
                    n9 = view.getBottom();
                    if (!bl || n9 >= n7 || bl3 && n8 == n2 - 1) continue;
                    if (bl8 || listAdapter.isEnabled(n6 + n8) && (n8 == n2 - 1 || listAdapter.isEnabled(n6 + n8 + 1))) {
                        rect.top = n9;
                        rect.bottom = n9 + n;
                        this.drawDivider(canvas, rect, n8);
                        continue;
                    }
                    if (!bl5) continue;
                    rect.top = n9;
                    rect.bottom = n9 + n;
                    canvas.drawRect(rect, paint);
                }
                n8 = this.getBottom() + this.getScrollY();
                if (bl3 && n6 + n2 == n4 && n8 > n9) {
                    rect.top = n9;
                    rect.bottom = n8;
                    this.drawOverscrollFooter(canvas, drawable2, rect);
                }
            } else {
                int n11;
                int n12;
                int n13 = this.mListPadding.top;
                int n14 = this.getScrollY();
                if (n2 > 0 && bl2) {
                    rect.top = n14;
                    rect.bottom = this.getChildAt(0).getTop();
                    this.drawOverscrollHeader(canvas, drawable, rect);
                }
                for (n12 = n11 = bl2 ? 1 : 0; n12 < n2; ++n12) {
                    if (!bl6 && n6 + n12 < n3 || !bl7 && n6 + n12 >= n5) continue;
                    View view = this.getChildAt(n12);
                    int n15 = view.getTop();
                    if (!bl || n15 <= n13) continue;
                    if (bl8 || listAdapter.isEnabled(n6 + n12) && (n12 == n2 - 1 || listAdapter.isEnabled(n6 + n12 + 1))) {
                        rect.top = n15 - n;
                        rect.bottom = n15;
                        this.drawDivider(canvas, rect, n12 - 1);
                        continue;
                    }
                    if (!bl5) continue;
                    rect.top = n15 - n;
                    rect.bottom = n15;
                    canvas.drawRect(rect, paint);
                }
                if (n2 > 0 && n14 > 0) {
                    if (bl3) {
                        rect.top = n12 = this.getBottom();
                        rect.bottom = n12 + n14;
                        this.drawOverscrollFooter(canvas, drawable2, rect);
                    } else if (bl) {
                        rect.top = n7;
                        rect.bottom = n7 + n;
                        this.drawDivider(canvas, rect, -1);
                    }
                }
            }
        }
        super.dispatchDraw(canvas);
    }

    void drawDivider(Canvas canvas, Rect rect, int n) {
        Drawable drawable = this.mDivider;
        boolean bl = this.mClipDivider;
        if (!bl) {
            drawable.setBounds(rect);
        } else {
            canvas.save();
            canvas.clipRect(rect);
        }
        drawable.draw(canvas);
        if (bl) {
            canvas.restore();
        }
    }

    public Drawable getDivider() {
        return this.mDivider;
    }

    public void setDivider(Drawable drawable) {
        if (drawable != null) {
            this.mDividerHeight = drawable.getIntrinsicHeight();
            this.mClipDivider = drawable instanceof ColorDrawable;
        } else {
            this.mDividerHeight = 0;
            this.mClipDivider = false;
        }
        this.mDivider = drawable;
        this.mDividerIsOpaque = drawable == null || drawable.getOpacity() == -1;
        this.requestLayoutIfNecessary();
    }

    public int getDividerHeight() {
        return this.mDividerHeight;
    }

    public void setDividerHeight(int n) {
        this.mDividerHeight = n;
        this.requestLayoutIfNecessary();
    }

    public void setHeaderDividersEnabled(boolean bl) {
        this.mHeaderDividersEnabled = bl;
        this.invalidate();
    }

    public void setFooterDividersEnabled(boolean bl) {
        this.mFooterDividersEnabled = bl;
        this.invalidate();
    }

    public void setOverscrollHeader(Drawable drawable) {
        this.mOverScrollHeader = drawable;
        if (this.getScrollY() < 0) {
            this.invalidate();
        }
    }

    public Drawable getOverscrollHeader() {
        return this.mOverScrollHeader;
    }

    public void setOverscrollFooter(Drawable drawable) {
        this.mOverScrollFooter = drawable;
        this.invalidate();
    }

    public Drawable getOverscrollFooter() {
        return this.mOverScrollFooter;
    }

    protected void onFocusChanged(boolean bl, int n, Rect rect) {
        super.onFocusChanged(bl, n, rect);
        int n2 = -1;
        if (bl && rect != null) {
            rect.offset(this.getScrollX(), this.getScrollY());
            ListAdapter listAdapter = this.mAdapter;
            if (listAdapter.getCount() < this.getChildCount() + this.mFirstPosition) {
                this.mLayoutMode = 0;
                this.layoutChildren();
            }
            Rect rect2 = this.mTempRect;
            int n3 = Integer.MAX_VALUE;
            int n4 = this.getChildCount();
            int n5 = this.mFirstPosition;
            for (int i = 0; i < n4; ++i) {
                if (!listAdapter.isEnabled(n5 + i)) continue;
                View view = this.getChildAt(i);
                view.getDrawingRect(rect2);
                this.offsetDescendantRectToMyCoords(view, rect2);
                int n6 = PLA_ListView.getDistance(rect, rect2, n);
                if (n6 >= n3) continue;
                n3 = n6;
                n2 = i;
            }
        }
        if (n2 >= 0) {
            this.setSelection(n2 + this.mFirstPosition);
        } else {
            this.requestLayout();
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        int n = this.getChildCount();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                this.addHeaderView(this.getChildAt(i));
            }
            this.removeAllViews();
        }
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.mItemsCanFocus && motionEvent.getAction() == 0 && motionEvent.getEdgeFlags() != 0) {
            return false;
        }
        return super.onTouchEvent(motionEvent);
    }

    @Override
    public boolean performItemClick(View view, int n, long l) {
        boolean bl = false;
        return bl |= super.performItemClick(view, n, l);
    }

    public void setItemChecked(int n, boolean bl) {
    }

    public boolean isItemChecked(int n) {
        return false;
    }

    public int getCheckedItemPosition() {
        return -1;
    }

    public SparseBooleanArray getCheckedItemPositions() {
        return null;
    }

    @Deprecated
    public long[] getCheckItemIds() {
        if (this.mAdapter != null && this.mAdapter.hasStableIds()) {
            return this.getCheckedItemIds();
        }
        return new long[0];
    }

    public long[] getCheckedItemIds() {
        return new long[0];
    }

    public void clearChoices() {
    }

    public class FixedViewInfo {
        public View view;
        public Object data;
        public boolean isSelectable;
    }
}

