/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.components.impl.android.\u7011\u5e03\u6d41\u5217\u8868\u6846\u7c7b\u5e93;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.TransitionDrawable;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.ContextMenu;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.ListAdapter;
import android.widget.Scroller;
import com.e4a.runtime.components.impl.android.\u7011\u5e03\u6d41\u5217\u8868\u6846\u7c7b\u5e93.PLA_AdapterView;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public abstract class PLA_AbsListView
extends PLA_AdapterView<ListAdapter>
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnTouchModeChangeListener {
    public static final int TRANSCRIPT_MODE_DISABLED = 0;
    public static final int TRANSCRIPT_MODE_NORMAL = 1;
    public static final int TRANSCRIPT_MODE_ALWAYS_SCROLL = 2;
    static final int TOUCH_MODE_REST = -1;
    protected static final int TOUCH_MODE_DOWN = 0;
    protected static final int TOUCH_MODE_TAP = 1;
    protected static final int TOUCH_MODE_DONE_WAITING = 2;
    protected static final int TOUCH_MODE_SCROLL = 3;
    protected static final int TOUCH_MODE_FLING = 4;
    static final int LAYOUT_NORMAL = 0;
    static final int LAYOUT_FORCE_TOP = 1;
    static final int LAYOUT_SET_SELECTION = 2;
    static final int LAYOUT_FORCE_BOTTOM = 3;
    static final int LAYOUT_SPECIFIC = 4;
    static final int LAYOUT_SYNC = 5;
    static final int LAYOUT_MOVE_SELECTION = 6;
    int mLayoutMode = 0;
    PLA_AdapterView.AdapterDataSetObserver mDataSetObserver;
    protected ListAdapter mAdapter;
    boolean mDrawSelectorOnTop = false;
    Drawable mSelector;
    Rect mSelectorRect = new Rect();
    final RecycleBin mRecycler = new RecycleBin();
    int mSelectionLeftPadding = 0;
    int mSelectionTopPadding = 0;
    int mSelectionRightPadding = 0;
    int mSelectionBottomPadding = 0;
    protected Rect mListPadding = new Rect();
    protected int mWidthMeasureSpec = 0;
    protected boolean mCachingStarted;
    protected int mMotionPosition;
    int mMotionViewOriginalTop;
    int mMotionViewNewTop;
    int mMotionX;
    int mMotionY;
    protected int mTouchMode = -1;
    int mLastY;
    int mMotionCorrection;
    private VelocityTracker mVelocityTracker;
    private FlingRunnable mFlingRunnable;
    PositionScroller mPositionScroller;
    int mSelectedTop = 0;
    boolean mStackFromBottom;
    boolean mScrollingCacheEnabled;
    private OnScrollListener mOnScrollListener;
    private boolean mSmoothScrollbarEnabled = true;
    private Rect mTouchFrame;
    int mResurrectToPosition = -1;
    private ContextMenu.ContextMenuInfo mContextMenuInfo = null;
    private static final int TOUCH_MODE_UNKNOWN = -1;
    private static final int TOUCH_MODE_ON = 0;
    private static final int TOUCH_MODE_OFF = 1;
    private int mLastTouchMode = -1;
    private static final boolean PROFILE_SCROLLING = false;
    private boolean mScrollProfilingStarted = false;
    private static final boolean PROFILE_FLINGING = false;
    private boolean mFlingProfilingStarted = false;
    private Runnable mPendingCheckForTap;
    private PerformClick mPerformClick;
    private int mTranscriptMode;
    private int mCacheColorHint;
    private boolean mIsChildViewEnabled;
    private int mLastScrollState = 0;
    private int mTouchSlop;
    private Runnable mClearScrollingCache;
    private int mMinimumVelocity;
    private int mMaximumVelocity;
    final boolean[] mIsScrap = new boolean[1];
    private int mActivePointerId = -1;
    private static final int INVALID_POINTER = -1;

    public PLA_AbsListView(Context context) {
        super(context);
        this.initAbsListView();
        this.setVerticalScrollBarEnabled(true);
    }

    public PLA_AbsListView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public PLA_AbsListView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.initAbsListView();
        this.mDrawSelectorOnTop = false;
        this.setStackFromBottom(false);
        this.setScrollingCacheEnabled(true);
        this.setTranscriptMode(0);
        this.setCacheColorHint(0);
        this.setSmoothScrollbarEnabled(true);
    }

    private void initAbsListView() {
        this.setClickable(true);
        this.setFocusableInTouchMode(true);
        this.setWillNotDraw(false);
        this.setAlwaysDrawnWithCacheEnabled(false);
        this.setScrollingCacheEnabled(true);
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)this.getContext());
        this.mTouchSlop = viewConfiguration.getScaledTouchSlop();
        this.mMinimumVelocity = viewConfiguration.getScaledMinimumFlingVelocity();
        this.mMaximumVelocity = viewConfiguration.getScaledMaximumFlingVelocity();
    }

    public void setSmoothScrollbarEnabled(boolean bl) {
        this.mSmoothScrollbarEnabled = bl;
    }

    @ViewDebug.ExportedProperty
    public boolean isSmoothScrollbarEnabled() {
        return this.mSmoothScrollbarEnabled;
    }

    public void setOnScrollListener(OnScrollListener onScrollListener) {
        this.mOnScrollListener = onScrollListener;
        this.invokeOnItemScrollListener();
    }

    void invokeOnItemScrollListener() {
        if (this.mOnScrollListener != null) {
            this.mOnScrollListener.onScroll(this, this.mFirstPosition, this.getChildCount(), this.mItemCount);
        }
    }

    @ViewDebug.ExportedProperty
    public boolean isScrollingCacheEnabled() {
        return this.mScrollingCacheEnabled;
    }

    public void setScrollingCacheEnabled(boolean bl) {
        if (this.mScrollingCacheEnabled && !bl) {
            this.clearScrollingCache();
        }
        this.mScrollingCacheEnabled = bl;
    }

    public void getFocusedRect(Rect rect) {
        View view = this.getSelectedView();
        if (view != null && view.getParent() == this) {
            view.getFocusedRect(rect);
            this.offsetDescendantRectToMyCoords(view, rect);
        } else {
            super.getFocusedRect(rect);
        }
    }

    private void useDefaultSelector() {
        this.setSelector(this.getResources().getDrawable(17301602));
    }

    @ViewDebug.ExportedProperty
    public boolean isStackFromBottom() {
        return this.mStackFromBottom;
    }

    public void setStackFromBottom(boolean bl) {
        if (this.mStackFromBottom != bl) {
            this.mStackFromBottom = bl;
            this.requestLayoutIfNecessary();
        }
    }

    void requestLayoutIfNecessary() {
        if (this.getChildCount() > 0) {
            this.resetList();
            this.requestLayout();
            this.invalidate();
        }
    }

    public void onRestoreInstanceState(Parcelable parcelable) {
        super.onRestoreInstanceState(parcelable);
        this.mDataChanged = true;
        this.requestLayout();
    }

    public void requestLayout() {
        if (!this.mBlockLayoutRequests && !this.mInLayout) {
            super.requestLayout();
        }
    }

    void resetList() {
        this.removeAllViewsInLayout();
        this.mFirstPosition = 0;
        this.mDataChanged = false;
        this.mNeedSync = false;
        this.mOldSelectedPosition = -1;
        this.mOldSelectedRowId = Long.MIN_VALUE;
        this.mSelectedTop = 0;
        this.mSelectorRect.setEmpty();
        this.invalidate();
    }

    protected int computeVerticalScrollExtent() {
        int n = this.getChildCount();
        if (n > 0) {
            if (this.mSmoothScrollbarEnabled) {
                int n2 = n * 100;
                View view = this.getChildAt(0);
                int n3 = this.getFillChildTop();
                int n4 = view.getHeight();
                if (n4 > 0) {
                    n2 += n3 * 100 / n4;
                }
                view = this.getChildAt(n - 1);
                int n5 = this.getScrollChildBottom();
                n4 = view.getHeight();
                if (n4 > 0) {
                    n2 -= (n5 - this.getHeight()) * 100 / n4;
                }
                return n2;
            }
            return 1;
        }
        return 0;
    }

    protected int computeVerticalScrollOffset() {
        int n = this.mFirstPosition;
        int n2 = this.getChildCount();
        if (n >= 0 && n2 > 0) {
            if (this.mSmoothScrollbarEnabled) {
                View view = this.getChildAt(0);
                int n3 = this.getFillChildTop();
                int n4 = view.getHeight();
                if (n4 > 0) {
                    return Math.max(n * 100 - n3 * 100 / n4 + (int)((float)this.getScrollY() / (float)this.getHeight() * (float)this.mItemCount * 100.0f), 0);
                }
            } else {
                int n5 = this.mItemCount;
                int n6 = n == 0 ? 0 : (n + n2 == n5 ? n5 : n + n2 / 2);
                return (int)((float)n + (float)n2 * ((float)n6 / (float)n5));
            }
        }
        return 0;
    }

    protected int computeVerticalScrollRange() {
        int n = this.mSmoothScrollbarEnabled ? Math.max(this.mItemCount * 100, 0) : this.mItemCount;
        return n;
    }

    protected float getTopFadingEdgeStrength() {
        int n = this.getChildCount();
        float f = super.getTopFadingEdgeStrength();
        if (n == 0) {
            return f;
        }
        if (this.mFirstPosition > 0) {
            return 1.0f;
        }
        int n2 = this.getChildAt(0).getTop();
        float f2 = this.getVerticalFadingEdgeLength();
        return n2 < this.getPaddingTop() ? (float)(-(n2 - this.getPaddingTop())) / f2 : f;
    }

    protected float getBottomFadingEdgeStrength() {
        int n = this.getChildCount();
        float f = super.getBottomFadingEdgeStrength();
        if (n == 0) {
            return f;
        }
        if (this.mFirstPosition + n - 1 < this.mItemCount - 1) {
            return 1.0f;
        }
        int n2 = this.getChildAt(n - 1).getBottom();
        int n3 = this.getHeight();
        float f2 = this.getVerticalFadingEdgeLength();
        return n2 > n3 - this.getPaddingBottom() ? (float)(n2 - n3 + this.getPaddingBottom()) / f2 : f;
    }

    protected void onMeasure(int n, int n2) {
        if (this.mSelector == null) {
            this.useDefaultSelector();
        }
        Rect rect = this.mListPadding;
        rect.left = this.mSelectionLeftPadding + this.getPaddingLeft();
        rect.top = this.mSelectionTopPadding + this.getPaddingTop();
        rect.right = this.mSelectionRightPadding + this.getPaddingRight();
        rect.bottom = this.mSelectionBottomPadding + this.getPaddingBottom();
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        super.onLayout(bl, n, n2, n3, n4);
        this.mInLayout = true;
        if (bl) {
            int n5 = this.getChildCount();
            for (int i = 0; i < n5; ++i) {
                this.getChildAt(i).forceLayout();
            }
            this.mRecycler.markChildrenDirty();
        }
        this.layoutChildren();
        this.mInLayout = false;
    }

    protected void layoutChildren() {
    }

    @Override
    @ViewDebug.ExportedProperty
    public View getSelectedView() {
        return null;
    }

    public int getListPaddingTop() {
        return this.mListPadding.top;
    }

    public int getListPaddingBottom() {
        return this.mListPadding.bottom;
    }

    public int getListPaddingLeft() {
        return this.mListPadding.left;
    }

    public int getListPaddingRight() {
        return this.mListPadding.right;
    }

    View obtainView(int n, boolean[] blArray) {
        View view;
        blArray[0] = false;
        View view2 = this.mRecycler.getScrapView(n);
        if (view2 != null) {
            view = this.mAdapter.getView(n, view2, (ViewGroup)this);
            if (view != view2) {
                this.mRecycler.addScrapView(view2);
                if (this.mCacheColorHint != 0) {
                    view.setDrawingCacheBackgroundColor(this.mCacheColorHint);
                }
            } else {
                blArray[0] = true;
                this.dispatchFinishTemporaryDetach(view);
            }
        } else {
            view = this.mAdapter.getView(n, null, (ViewGroup)this);
            if (this.mCacheColorHint != 0) {
                view.setDrawingCacheBackgroundColor(this.mCacheColorHint);
            }
        }
        return view;
    }

    void positionSelector(View view) {
        Rect rect = this.mSelectorRect;
        rect.set(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
        this.positionSelector(rect.left, rect.top, rect.right, rect.bottom);
        boolean bl = this.mIsChildViewEnabled;
        if (view.isEnabled() != bl) {
            this.mIsChildViewEnabled = !bl;
            this.refreshDrawableState();
        }
    }

    private void positionSelector(int n, int n2, int n3, int n4) {
        this.mSelectorRect.set(n - this.mSelectionLeftPadding, n2 - this.mSelectionTopPadding, n3 + this.mSelectionRightPadding, n4 + this.mSelectionBottomPadding);
    }

    protected void dispatchDraw(Canvas canvas) {
        boolean bl = this.mDrawSelectorOnTop;
        if (!bl) {
            this.drawSelector(canvas);
        }
        super.dispatchDraw(canvas);
        if (bl) {
            this.drawSelector(canvas);
        }
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        if (this.getChildCount() > 0) {
            this.mDataChanged = true;
            this.rememberSyncState();
        }
    }

    boolean touchModeDrawsInPressedState() {
        switch (this.mTouchMode) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    protected boolean shouldShowSelector() {
        return this.hasFocus() && !this.isInTouchMode() || this.touchModeDrawsInPressedState();
    }

    private void drawSelector(Canvas canvas) {
        if (this.shouldShowSelector() && this.mSelectorRect != null && !this.mSelectorRect.isEmpty()) {
            Drawable drawable = this.mSelector;
            drawable.setBounds(this.mSelectorRect);
            drawable.draw(canvas);
        }
    }

    public void setDrawSelectorOnTop(boolean bl) {
        this.mDrawSelectorOnTop = bl;
    }

    public void setSelector(int n) {
        this.setSelector(this.getResources().getDrawable(n));
    }

    public void setSelector(Drawable drawable) {
        if (this.mSelector != null) {
            this.mSelector.setCallback(null);
            this.unscheduleDrawable(this.mSelector);
        }
        this.mSelector = drawable;
        Rect rect = new Rect();
        drawable.getPadding(rect);
        this.mSelectionLeftPadding = rect.left;
        this.mSelectionTopPadding = rect.top;
        this.mSelectionRightPadding = rect.right;
        this.mSelectionBottomPadding = rect.bottom;
        drawable.setCallback((Drawable.Callback)this);
        drawable.setState(this.getDrawableState());
    }

    public Drawable getSelector() {
        return this.mSelector;
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.mSelector != null) {
            this.mSelector.setState(this.getDrawableState());
        }
    }

    protected int[] onCreateDrawableState(int n) {
        if (this.mIsChildViewEnabled) {
            return super.onCreateDrawableState(n);
        }
        int n2 = ENABLED_STATE_SET[0];
        int[] nArray = super.onCreateDrawableState(n + 1);
        int n3 = -1;
        for (int i = nArray.length - 1; i >= 0; --i) {
            if (nArray[i] != n2) continue;
            n3 = i;
            break;
        }
        if (n3 >= 0) {
            System.arraycopy(nArray, n3 + 1, nArray, n3, nArray.length - n3 - 1);
        }
        return nArray;
    }

    public boolean verifyDrawable(Drawable drawable) {
        return this.mSelector == drawable || super.verifyDrawable(drawable);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        ViewTreeObserver viewTreeObserver = this.getViewTreeObserver();
        if (viewTreeObserver != null) {
            viewTreeObserver.addOnTouchModeChangeListener((ViewTreeObserver.OnTouchModeChangeListener)this);
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mRecycler.clear();
        ViewTreeObserver viewTreeObserver = this.getViewTreeObserver();
        if (viewTreeObserver != null) {
            viewTreeObserver.removeOnTouchModeChangeListener((ViewTreeObserver.OnTouchModeChangeListener)this);
        }
    }

    public void onWindowFocusChanged(boolean bl) {
        int n;
        super.onWindowFocusChanged(bl);
        int n2 = n = this.isInTouchMode() ? 0 : 1;
        if (!bl) {
            this.setChildrenDrawingCacheEnabled(false);
            if (this.mFlingRunnable != null) {
                this.removeCallbacks(this.mFlingRunnable);
                this.mFlingRunnable.endFling();
                if (this.getScrollY() != 0) {
                    this.scrollTo(this.getScrollX(), 0);
                    this.invalidate();
                }
            }
        } else if (n != this.mLastTouchMode && this.mLastTouchMode != -1) {
            this.mLayoutMode = 0;
            this.layoutChildren();
        }
        this.mLastTouchMode = n;
    }

    ContextMenu.ContextMenuInfo createContextMenuInfo(View view, int n, long l) {
        return new PLA_AdapterView.AdapterContextMenuInfo(view, n, l);
    }

    protected ContextMenu.ContextMenuInfo getContextMenuInfo() {
        return this.mContextMenuInfo;
    }

    public boolean showContextMenuForChild(View view) {
        int n = this.getPositionForView(view);
        if (n >= 0) {
            long l = this.mAdapter.getItemId(n);
            boolean bl = false;
            if (this.mOnItemLongClickListener != null) {
                bl = this.mOnItemLongClickListener.onItemLongClick(this, view, n, l);
            }
            if (!bl) {
                this.mContextMenuInfo = this.createContextMenuInfo(this.getChildAt(n - this.mFirstPosition), n, l);
                bl = super.showContextMenuForChild(view);
            }
            return bl;
        }
        return false;
    }

    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        return false;
    }

    protected void dispatchSetPressed(boolean bl) {
    }

    public int pointToPosition(int n, int n2) {
        Rect rect = this.mTouchFrame;
        if (rect == null) {
            rect = this.mTouchFrame = new Rect();
        }
        int n3 = this.getChildCount();
        for (int i = n3 - 1; i >= 0; --i) {
            View view = this.getChildAt(i);
            if (view.getVisibility() != 0) continue;
            view.getHitRect(rect);
            if (!rect.contains(n, n2)) continue;
            return this.mFirstPosition + i;
        }
        return -1;
    }

    public long pointToRowId(int n, int n2) {
        int n3 = this.pointToPosition(n, n2);
        if (n3 >= 0) {
            return this.mAdapter.getItemId(n3);
        }
        return Long.MIN_VALUE;
    }

    private boolean startScrollIfNeeded(int n) {
        int n2;
        int n3 = Math.abs(n);
        if (n3 > (n2 = this.mTouchSlop)) {
            this.createScrollingCache();
            this.mTouchMode = 3;
            this.mMotionCorrection = n;
            this.setPressed(false);
            View view = this.getChildAt(this.mMotionPosition - this.mFirstPosition);
            if (view != null) {
                view.setPressed(false);
            }
            this.reportScrollStateChange(1);
            this.requestDisallowInterceptTouchEvent(true);
            return true;
        }
        return false;
    }

    public void onTouchModeChanged(boolean bl) {
        if (bl && this.getHeight() > 0 && this.getChildCount() > 0) {
            this.layoutChildren();
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (!this.isEnabled()) {
            return this.isClickable() || this.isLongClickable();
        }
        int n = motionEvent.getAction();
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(motionEvent);
        switch (n & 0xFF) {
            case 0: {
                this.mActivePointerId = motionEvent.getPointerId(0);
                int n2 = (int)motionEvent.getX();
                int n3 = (int)motionEvent.getY();
                int n4 = this.pointToPosition(n2, n3);
                if (!this.mDataChanged) {
                    if (this.mTouchMode != 4 && n4 >= 0 && ((ListAdapter)this.getAdapter()).isEnabled(n4)) {
                        this.mTouchMode = 0;
                        if (this.mPendingCheckForTap == null) {
                            this.mPendingCheckForTap = new CheckForTap();
                        }
                        this.postDelayed(this.mPendingCheckForTap, ViewConfiguration.getTapTimeout());
                    } else {
                        if (motionEvent.getEdgeFlags() != 0 && n4 < 0) {
                            return false;
                        }
                        if (this.mTouchMode == 4) {
                            this.createScrollingCache();
                            this.mTouchMode = 3;
                            this.mMotionCorrection = 0;
                            n4 = this.findMotionRow(n3);
                            this.reportScrollStateChange(1);
                        }
                    }
                }
                if (n4 >= 0) {
                    View view = this.getChildAt(n4 - this.mFirstPosition);
                    this.mMotionViewOriginalTop = view.getTop();
                }
                this.mMotionX = n2;
                this.mMotionY = n3;
                this.mMotionPosition = n4;
                this.mLastY = Integer.MIN_VALUE;
                break;
            }
            case 2: {
                int n5 = motionEvent.findPointerIndex(this.mActivePointerId);
                int n6 = (int)motionEvent.getY(n5);
                int n7 = n6 - this.mMotionY;
                switch (this.mTouchMode) {
                    case 0: 
                    case 1: 
                    case 2: {
                        this.startScrollIfNeeded(n7);
                        break;
                    }
                    case 3: {
                        if (n6 == this.mLastY) break;
                        int n8 = this.mLastY != Integer.MIN_VALUE ? n6 - this.mLastY : (n7 -= this.mMotionCorrection);
                        boolean bl = false;
                        if (n8 != 0) {
                            bl = this.trackMotionScroll(n7, n8);
                        }
                        if (bl && this.getChildCount() > 0) {
                            int n9 = this.findMotionRow(n6);
                            if (n9 >= 0) {
                                View view = this.getChildAt(n9 - this.mFirstPosition);
                                this.mMotionViewOriginalTop = view.getTop();
                            }
                            this.mMotionY = n6;
                            this.mMotionPosition = n9;
                            this.invalidate();
                        }
                        this.mLastY = n6;
                    }
                }
                break;
            }
            case 1: {
                switch (this.mTouchMode) {
                    case 0: 
                    case 1: 
                    case 2: {
                        int n10 = this.mMotionPosition;
                        final View view = this.getChildAt(n10 - this.mFirstPosition);
                        if (view != null && !view.hasFocusable()) {
                            if (this.mTouchMode != 0) {
                                view.setPressed(false);
                            }
                            if (this.mPerformClick == null) {
                                this.mPerformClick = new PerformClick();
                            }
                            final PerformClick performClick = this.mPerformClick;
                            performClick.mChild = view;
                            performClick.mClickMotionPosition = n10;
                            performClick.rememberWindowAttachCount();
                            this.mResurrectToPosition = n10;
                            if (this.mTouchMode == 0 || this.mTouchMode == 1) {
                                this.mLayoutMode = 0;
                                if (!this.mDataChanged && this.mAdapter.isEnabled(n10)) {
                                    Drawable drawable;
                                    this.mTouchMode = 1;
                                    this.layoutChildren();
                                    view.setPressed(true);
                                    this.positionSelector(view);
                                    this.setPressed(true);
                                    if (this.mSelector != null && (drawable = this.mSelector.getCurrent()) != null && drawable instanceof TransitionDrawable) {
                                        ((TransitionDrawable)drawable).resetTransition();
                                    }
                                    this.postDelayed(new Runnable(){

                                        @Override
                                        public void run() {
                                            view.setPressed(false);
                                            PLA_AbsListView.this.setPressed(false);
                                            if (!PLA_AbsListView.this.mDataChanged) {
                                                PLA_AbsListView.this.post(performClick);
                                            }
                                            PLA_AbsListView.this.mTouchMode = -1;
                                        }
                                    }, ViewConfiguration.getPressedStateDuration());
                                } else {
                                    this.mTouchMode = -1;
                                }
                                return true;
                            }
                            if (!this.mDataChanged && this.mAdapter.isEnabled(n10)) {
                                this.post(performClick);
                            }
                        }
                        this.mTouchMode = -1;
                        break;
                    }
                    case 3: {
                        int n11 = this.getChildCount();
                        if (n11 > 0) {
                            int n12 = this.getFillChildTop();
                            int n13 = this.getFillChildBottom();
                            if (this.mFirstPosition == 0 && n12 >= this.mListPadding.top && this.mFirstPosition + n11 < this.mItemCount && n13 <= this.getHeight() - this.mListPadding.bottom) {
                                this.mTouchMode = -1;
                                this.reportScrollStateChange(0);
                                break;
                            }
                            VelocityTracker velocityTracker = this.mVelocityTracker;
                            velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                            int n14 = (int)velocityTracker.getYVelocity(this.mActivePointerId);
                            if (Math.abs(n14) > this.mMinimumVelocity) {
                                if (this.mFlingRunnable == null) {
                                    this.mFlingRunnable = new FlingRunnable();
                                }
                                this.reportScrollStateChange(2);
                                this.mFlingRunnable.start(-n14);
                                break;
                            }
                            this.mTouchMode = -1;
                            this.reportScrollStateChange(0);
                            break;
                        }
                        this.mTouchMode = -1;
                        this.reportScrollStateChange(0);
                    }
                }
                this.setPressed(false);
                this.invalidate();
                if (this.mVelocityTracker != null) {
                    this.mVelocityTracker.recycle();
                    this.mVelocityTracker = null;
                }
                this.mActivePointerId = -1;
                break;
            }
            case 3: {
                this.mTouchMode = -1;
                this.setPressed(false);
                View view = this.getChildAt(this.mMotionPosition - this.mFirstPosition);
                if (view != null) {
                    view.setPressed(false);
                }
                this.clearScrollingCache();
                if (this.mVelocityTracker != null) {
                    this.mVelocityTracker.recycle();
                    this.mVelocityTracker = null;
                }
                this.mActivePointerId = -1;
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(motionEvent);
                int n15 = this.mMotionX;
                int n16 = this.mMotionY;
                int n17 = this.pointToPosition(n15, n16);
                if (n17 >= 0) {
                    View view = this.getChildAt(n17 - this.mFirstPosition);
                    this.mMotionViewOriginalTop = view.getTop();
                    this.mMotionPosition = n17;
                }
                this.mLastY = n16;
                break;
            }
        }
        return true;
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        int n = motionEvent.getAction();
        switch (n & 0xFF) {
            case 0: {
                int n2 = this.mTouchMode;
                int n3 = (int)motionEvent.getX();
                int n4 = (int)motionEvent.getY();
                this.mActivePointerId = motionEvent.getPointerId(0);
                int n5 = this.findMotionRow(n4);
                if (n2 != 4 && n5 >= 0) {
                    View view = this.getChildAt(n5 - this.mFirstPosition);
                    this.mMotionViewOriginalTop = view.getTop();
                    this.mMotionX = n3;
                    this.mMotionY = n4;
                    this.mMotionPosition = n5;
                    this.mTouchMode = 0;
                    this.clearScrollingCache();
                }
                this.mLastY = Integer.MIN_VALUE;
                if (n2 != 4) break;
                return true;
            }
            case 2: {
                switch (this.mTouchMode) {
                    case 0: {
                        int n6 = motionEvent.findPointerIndex(this.mActivePointerId);
                        int n7 = (int)motionEvent.getY(n6);
                        if (!this.startScrollIfNeeded(n7 - this.mMotionY)) break;
                        return true;
                    }
                }
                break;
            }
            case 1: {
                this.mTouchMode = -1;
                this.mActivePointerId = -1;
                this.reportScrollStateChange(0);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(motionEvent);
            }
        }
        return false;
    }

    private void onSecondaryPointerUp(MotionEvent motionEvent) {
        int n = (motionEvent.getAction() & 0xFF00) >> 8;
        int n2 = motionEvent.getPointerId(n);
        if (n2 == this.mActivePointerId) {
            int n3 = n == 0 ? 1 : 0;
            this.mMotionX = (int)motionEvent.getX(n3);
            this.mMotionY = (int)motionEvent.getY(n3);
            this.mActivePointerId = motionEvent.getPointerId(n3);
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.clear();
            }
        }
    }

    public void addTouchables(ArrayList<View> arrayList) {
        int n = this.getChildCount();
        int n2 = this.mFirstPosition;
        ListAdapter listAdapter = this.mAdapter;
        if (listAdapter == null) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            View view = this.getChildAt(i);
            if (listAdapter.isEnabled(n2 + i)) {
                arrayList.add(view);
            }
            view.addTouchables(arrayList);
        }
    }

    void reportScrollStateChange(int n) {
        if (n != this.mLastScrollState && this.mOnScrollListener != null) {
            this.mOnScrollListener.onScrollStateChanged(this, n);
            this.mLastScrollState = n;
        }
    }

    public void smoothScrollToPosition(int n) {
        if (this.mPositionScroller == null) {
            this.mPositionScroller = new PositionScroller();
        }
        this.mPositionScroller.start(n);
    }

    public void smoothScrollToPosition(int n, int n2) {
        if (this.mPositionScroller == null) {
            this.mPositionScroller = new PositionScroller();
        }
        this.mPositionScroller.start(n, n2);
    }

    public void smoothScrollBy(int n, int n2) {
        if (this.mFlingRunnable == null) {
            this.mFlingRunnable = new FlingRunnable();
        } else {
            this.mFlingRunnable.endFling();
        }
        this.mFlingRunnable.startScroll(n, n2);
    }

    private void createScrollingCache() {
        if (this.mScrollingCacheEnabled && !this.mCachingStarted) {
            this.setChildrenDrawnWithCacheEnabled(true);
            this.setChildrenDrawingCacheEnabled(true);
            this.mCachingStarted = true;
        }
    }

    private void clearScrollingCache() {
        if (this.mClearScrollingCache == null) {
            this.mClearScrollingCache = new Runnable(){

                @Override
                public void run() {
                    if (PLA_AbsListView.this.mCachingStarted) {
                        PLA_AbsListView.this.mCachingStarted = false;
                        PLA_AbsListView.this.setChildrenDrawnWithCacheEnabled(false);
                        int n = PLA_AbsListView.this.getPersistentDrawingCache();
                        if ((n & 2) == 0) {
                            PLA_AbsListView.this.setChildrenDrawingCacheEnabled(false);
                        }
                        if (!PLA_AbsListView.this.isAlwaysDrawnWithCacheEnabled()) {
                            PLA_AbsListView.this.invalidate();
                        }
                    }
                }
            };
        }
        this.post(this.mClearScrollingCache);
    }

    boolean trackMotionScroll(int n, int n2) {
        int n3;
        int n4 = this.getChildCount();
        if (n4 == 0) {
            return true;
        }
        int n5 = this.getScrollChildTop();
        int n6 = this.getScrollChildBottom();
        Rect rect = this.mListPadding;
        int n7 = this.getHeight() - rect.bottom;
        int n8 = rect.top - this.getFillChildTop();
        int n9 = this.getFillChildBottom() - n7;
        int n10 = this.getHeight() - this.getPaddingBottom() - this.getPaddingTop();
        n = n < 0 ? Math.max(-(n10 - 1), n) : Math.min(n10 - 1, n);
        n2 = n2 < 0 ? Math.max(-(n10 - 1) / 2, n2) : Math.min((n10 - 1) / 2, n2);
        int n11 = this.mFirstPosition;
        if (n11 == 0 && n5 >= rect.top && n >= 0) {
            return true;
        }
        if (n11 + n4 == this.mItemCount && n6 <= n7 && n <= 0) {
            return true;
        }
        boolean bl = n2 < 0;
        int n12 = this.getHeaderViewsCount();
        int n13 = this.mItemCount - this.getFooterViewsCount();
        int n14 = 0;
        int n15 = 0;
        if (bl) {
            View view;
            n3 = rect.top - n2;
            for (int i = 0; i < n4 && (view = this.getChildAt(i)).getBottom() < n3; ++i) {
                ++n15;
                int n16 = n11 + i;
                if (n16 < n12 || n16 >= n13) continue;
                this.mRecycler.addScrapView(view);
            }
        } else {
            View view;
            n3 = this.getHeight() - rect.bottom - n2;
            for (int i = n4 - 1; i >= 0 && (view = this.getChildAt(i)).getTop() > n3; --i) {
                n14 = i;
                ++n15;
                int n17 = n11 + i;
                if (n17 < n12 || n17 >= n13) continue;
                this.mRecycler.addScrapView(view);
            }
        }
        this.mMotionViewNewTop = this.mMotionViewOriginalTop + n;
        this.mBlockLayoutRequests = true;
        if (n15 > 0) {
            this.detachViewsFromParent(n14, n15);
        }
        this.tryOffsetChildrenTopAndBottom(n2);
        if (bl) {
            this.mFirstPosition += n15;
        }
        this.invalidate();
        n3 = Math.abs(n2);
        if (n8 < n3 || n9 < n3) {
            this.fillGap(bl);
        }
        this.mBlockLayoutRequests = false;
        this.invokeOnItemScrollListener();
        this.awakenScrollBars();
        return false;
    }

    protected void tryOffsetChildrenTopAndBottom(int n) {
        int n2 = this.getChildCount();
        for (int i = 0; i < n2; ++i) {
            View view = this.getChildAt(i);
            view.offsetTopAndBottom(n);
        }
    }

    int getHeaderViewsCount() {
        return 0;
    }

    int getFooterViewsCount() {
        return 0;
    }

    abstract void fillGap(boolean var1);

    int reconcileSelectedPosition() {
        int n = this.mSelectedPosition;
        if (n < 0) {
            n = this.mResurrectToPosition;
        }
        n = Math.max(0, n);
        n = Math.min(n, this.mItemCount - 1);
        return n;
    }

    abstract int findMotionRow(int var1);

    int findClosestMotionRow(int n) {
        int n2 = this.getChildCount();
        if (n2 == 0) {
            return -1;
        }
        int n3 = this.findMotionRow(n);
        return n3 != -1 ? n3 : this.mFirstPosition + n2 - 1;
    }

    public void invalidateViews() {
        this.mDataChanged = true;
        this.rememberSyncState();
        this.requestLayout();
        this.invalidate();
    }

    @Override
    protected void handleDataChanged() {
        int n = this.mItemCount;
        if (n > 0) {
            if (this.mNeedSync) {
                this.mNeedSync = false;
                if (this.mTranscriptMode == 2 || this.mTranscriptMode == 1 && this.mFirstPosition + this.getChildCount() >= this.mOldItemCount) {
                    this.mLayoutMode = 3;
                    return;
                }
                switch (this.mSyncMode) {
                    case 1: {
                        this.mLayoutMode = 5;
                        this.mSyncPosition = Math.min(Math.max(0, this.mSyncPosition), n - 1);
                        return;
                    }
                }
            }
            if (!this.isInTouchMode()) {
                int n2 = this.getSelectedItemPosition();
                if (n2 >= n) {
                    n2 = n - 1;
                }
                if (n2 < 0) {
                    n2 = 0;
                }
                int n3 = this.lookForSelectablePosition(n2, true);
                n3 = this.lookForSelectablePosition(n2, false);
                if (n3 >= 0) {
                    return;
                }
            } else if (this.mResurrectToPosition >= 0) {
                return;
            }
        }
        this.mLayoutMode = this.mStackFromBottom ? 3 : 1;
        this.mNeedSync = false;
    }

    protected void onLayoutSync(int n) {
    }

    protected void onLayoutSyncFinished(int n) {
    }

    static int getDistance(Rect rect, Rect rect2, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        switch (n) {
            case 66: {
                n5 = rect.right;
                n4 = rect.top + rect.height() / 2;
                n3 = rect2.left;
                n2 = rect2.top + rect2.height() / 2;
                break;
            }
            case 130: {
                n5 = rect.left + rect.width() / 2;
                n4 = rect.bottom;
                n3 = rect2.left + rect2.width() / 2;
                n2 = rect2.top;
                break;
            }
            case 17: {
                n5 = rect.left;
                n4 = rect.top + rect.height() / 2;
                n3 = rect2.right;
                n2 = rect2.top + rect2.height() / 2;
                break;
            }
            case 33: {
                n5 = rect.left + rect.width() / 2;
                n4 = rect.top;
                n3 = rect2.left + rect2.width() / 2;
                n2 = rect2.bottom;
                break;
            }
            default: {
                throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
            }
        }
        int n6 = n3 - n5;
        int n7 = n2 - n4;
        return n7 * n7 + n6 * n6;
    }

    public void onGlobalLayout() {
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new LayoutParams(layoutParams);
    }

    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof LayoutParams;
    }

    public void setTranscriptMode(int n) {
        this.mTranscriptMode = n;
    }

    public int getTranscriptMode() {
        return this.mTranscriptMode;
    }

    public int getSolidColor() {
        return this.mCacheColorHint;
    }

    public void setCacheColorHint(int n) {
        if (n != this.mCacheColorHint) {
            this.mCacheColorHint = n;
            int n2 = this.getChildCount();
            for (int i = 0; i < n2; ++i) {
                this.getChildAt(i).setDrawingCacheBackgroundColor(n);
            }
            this.mRecycler.setCacheColorHint(n);
        }
    }

    public int getCacheColorHint() {
        return this.mCacheColorHint;
    }

    public void reclaimViews(List<View> list) {
        int n = this.getChildCount();
        RecyclerListener recyclerListener = this.mRecycler.mRecyclerListener;
        for (int i = 0; i < n; ++i) {
            View view = this.getChildAt(i);
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            if (layoutParams == null || !this.mRecycler.shouldRecycleViewType(layoutParams.viewType)) continue;
            list.add(view);
            if (recyclerListener == null) continue;
            recyclerListener.onMovedToScrapHeap(view);
        }
        this.mRecycler.reclaimScrapViews(list);
        this.removeAllViewsInLayout();
    }

    public void setRecyclerListener(RecyclerListener recyclerListener) {
        this.mRecycler.mRecyclerListener = recyclerListener;
    }

    private void dispatchFinishTemporaryDetach(View view) {
        if (view == null) {
            return;
        }
        view.onFinishTemporaryDetach();
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n = viewGroup.getChildCount();
            for (int i = 0; i < n; ++i) {
                this.dispatchFinishTemporaryDetach(viewGroup.getChildAt(i));
            }
        }
    }

    protected int modifyFlingInitialVelocity(int n) {
        return n;
    }

    protected int getScrollChildTop() {
        int n = this.getChildCount();
        if (n == 0) {
            return 0;
        }
        return this.getChildAt(0).getTop();
    }

    protected int getFirstChildTop() {
        int n = this.getChildCount();
        if (n == 0) {
            return 0;
        }
        return this.getChildAt(0).getTop();
    }

    protected int getFillChildTop() {
        int n = this.getChildCount();
        if (n == 0) {
            return 0;
        }
        return this.getChildAt(0).getTop();
    }

    protected int getFillChildBottom() {
        int n = this.getChildCount();
        if (n == 0) {
            return 0;
        }
        return this.getChildAt(n - 1).getBottom();
    }

    protected int getScrollChildBottom() {
        int n = this.getChildCount();
        if (n == 0) {
            return 0;
        }
        return this.getChildAt(n - 1).getBottom();
    }

    class RecycleBin {
        private RecyclerListener mRecyclerListener;
        private int mFirstActivePosition;
        private View[] mActiveViews = new View[0];
        private Stack<View>[] mScrapViews;
        private int mViewTypeCount;
        private Stack<View> mCurrentScrap;

        RecycleBin() {
        }

        public void setViewTypeCount(int n) {
            if (n < 1) {
                throw new IllegalArgumentException("Can't have a viewTypeCount < 1");
            }
            Stack[] stackArray = new Stack[n];
            for (int i = 0; i < n; ++i) {
                stackArray[i] = new Stack();
            }
            this.mViewTypeCount = n;
            this.mCurrentScrap = stackArray[0];
            this.mScrapViews = stackArray;
        }

        public void markChildrenDirty() {
            if (this.mViewTypeCount == 1) {
                Stack<View> stack = this.mCurrentScrap;
                int n = stack.size();
                for (int i = 0; i < n; ++i) {
                    ((View)stack.get(i)).forceLayout();
                }
            } else {
                int n = this.mViewTypeCount;
                for (int i = 0; i < n; ++i) {
                    Stack<View> stack = this.mScrapViews[i];
                    int n2 = stack.size();
                    for (int j = 0; j < n2; ++j) {
                        ((View)stack.get(j)).forceLayout();
                    }
                }
            }
        }

        public boolean shouldRecycleViewType(int n) {
            return n >= 0;
        }

        void clear() {
            if (this.mViewTypeCount == 1) {
                Stack<View> stack = this.mCurrentScrap;
                int n = stack.size();
                for (int i = 0; i < n; ++i) {
                    PLA_AbsListView.this.removeDetachedView((View)stack.remove(n - 1 - i), false);
                }
            } else {
                int n = this.mViewTypeCount;
                for (int i = 0; i < n; ++i) {
                    Stack<View> stack = this.mScrapViews[i];
                    int n2 = stack.size();
                    for (int j = 0; j < n2; ++j) {
                        PLA_AbsListView.this.removeDetachedView((View)stack.remove(n2 - 1 - j), false);
                    }
                }
            }
        }

        void fillActiveViews(int n, int n2) {
            if (this.mActiveViews.length < n) {
                this.mActiveViews = new View[n];
            }
            this.mFirstActivePosition = n2;
            View[] viewArray = this.mActiveViews;
            for (int i = 0; i < n; ++i) {
                View view = PLA_AbsListView.this.getChildAt(i);
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                if (layoutParams == null || layoutParams.viewType == -2) continue;
                viewArray[i] = view;
            }
        }

        View getActiveView(int n) {
            int n2 = n - this.mFirstActivePosition;
            View[] viewArray = this.mActiveViews;
            if (n2 >= 0 && n2 < viewArray.length) {
                View view = viewArray[n2];
                viewArray[n2] = null;
                return view;
            }
            return null;
        }

        View getScrapView(int n) {
            int n2;
            Stack<View> stack;
            if (PLA_AbsListView.this.getHeaderViewsCount() > n) {
                return null;
            }
            if (this.mViewTypeCount == 1) {
                stack = this.mCurrentScrap;
            } else {
                n2 = PLA_AbsListView.this.mAdapter.getItemViewType(n);
                if (n2 >= 0 && n2 < this.mScrapViews.length) {
                    stack = this.mScrapViews[n2];
                } else {
                    return null;
                }
            }
            n2 = stack.size();
            for (int i = n2 - 1; i >= 0; --i) {
                LayoutParams layoutParams = (LayoutParams)((View)stack.get(i)).getLayoutParams();
                if (layoutParams.scrappedFromPosition != n) continue;
                return (View)stack.remove(i);
            }
            if (n2 > 0) {
                return (View)stack.remove(0);
            }
            return null;
        }

        void addScrapView(View view) {
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            if (layoutParams == null) {
                return;
            }
            int n = layoutParams.viewType;
            if (!this.shouldRecycleViewType(n)) {
                if (n != -2) {
                    PLA_AbsListView.this.removeDetachedView(view, false);
                }
                return;
            }
            if (this.mViewTypeCount == 1) {
                PLA_AbsListView.this.dispatchFinishTemporaryDetach(view);
                this.mCurrentScrap.add(view);
            } else {
                PLA_AbsListView.this.dispatchFinishTemporaryDetach(view);
                this.mScrapViews[n].push(view);
            }
            if (this.mRecyclerListener != null) {
                this.mRecyclerListener.onMovedToScrapHeap(view);
            }
        }

        void scrapActiveViews() {
            View[] viewArray = this.mActiveViews;
            boolean bl = this.mRecyclerListener != null;
            boolean bl2 = this.mViewTypeCount > 1;
            Stack<View> stack = this.mCurrentScrap;
            int n = viewArray.length;
            for (int i = n - 1; i >= 0; --i) {
                View view = viewArray[i];
                if (view == null) continue;
                int n2 = ((LayoutParams)view.getLayoutParams()).viewType;
                viewArray[i] = null;
                if (!this.shouldRecycleViewType(n2)) {
                    if (n2 == -2) continue;
                    PLA_AbsListView.this.removeDetachedView(view, false);
                    continue;
                }
                if (bl2) {
                    stack = this.mScrapViews[n2];
                }
                PLA_AbsListView.this.dispatchFinishTemporaryDetach(view);
                stack.add(view);
                if (!bl) continue;
                this.mRecyclerListener.onMovedToScrapHeap(view);
            }
            this.pruneScrapViews();
        }

        private void pruneScrapViews() {
            int n = this.mActiveViews.length;
            int n2 = this.mViewTypeCount;
            Stack<View>[] stackArray = this.mScrapViews;
            for (int i = 0; i < n2; ++i) {
                Stack<View> stack = stackArray[i];
                int n3 = stack.size();
                int n4 = n3 - n;
                --n3;
                for (int j = 0; j < n4; ++j) {
                    PLA_AbsListView.this.removeDetachedView((View)stack.remove(n3--), false);
                }
            }
        }

        void reclaimScrapViews(List<View> list) {
            if (this.mViewTypeCount == 1) {
                list.addAll(this.mCurrentScrap);
            } else {
                int n = this.mViewTypeCount;
                Stack<View>[] stackArray = this.mScrapViews;
                for (int i = 0; i < n; ++i) {
                    Stack<View> stack = stackArray[i];
                    list.addAll(stack);
                }
            }
        }

        void setCacheColorHint(int n) {
            int n2;
            if (this.mViewTypeCount == 1) {
                View[] viewArray = this.mCurrentScrap;
                n2 = viewArray.size();
                for (int i = 0; i < n2; ++i) {
                    ((View)viewArray.get(i)).setDrawingCacheBackgroundColor(n);
                }
            } else {
                int n3 = this.mViewTypeCount;
                for (n2 = 0; n2 < n3; ++n2) {
                    Stack<View> stack = this.mScrapViews[n2];
                    int n4 = stack.size();
                    for (int i = 0; i < n4; ++i) {
                        ((View)stack.get(n2)).setDrawingCacheBackgroundColor(n);
                    }
                }
            }
            for (View view : this.mActiveViews) {
                if (view == null) continue;
                view.setDrawingCacheBackgroundColor(n);
            }
        }
    }

    public static interface RecyclerListener {
        public void onMovedToScrapHeap(View var1);
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams {
        @ViewDebug.ExportedProperty(mapping={@ViewDebug.IntToString(from=-1, to="ITEM_VIEW_TYPE_IGNORE"), @ViewDebug.IntToString(from=-2, to="ITEM_VIEW_TYPE_HEADER_OR_FOOTER")})
        public int viewType;
        public int scrappedFromPosition;
        @ViewDebug.ExportedProperty
        public boolean recycledHeaderFooter;
        @ViewDebug.ExportedProperty
        public boolean forceAdd;

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public LayoutParams(int n, int n2) {
            super(n, n2);
        }

        public LayoutParams(int n, int n2, int n3) {
            super(n, n2);
            this.viewType = n3;
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }
    }

    class PositionScroller
    implements Runnable {
        private static final int SCROLL_DURATION = 400;
        private static final int MOVE_DOWN_POS = 1;
        private static final int MOVE_UP_POS = 2;
        private static final int MOVE_DOWN_BOUND = 3;
        private static final int MOVE_UP_BOUND = 4;
        private int mMode;
        private int mTargetPos;
        private int mBoundPos;
        private int mLastSeenPos;
        private int mScrollDuration;
        private final int mExtraScroll;

        PositionScroller() {
            this.mExtraScroll = ViewConfiguration.get((Context)PLA_AbsListView.this.getContext()).getScaledFadingEdgeLength();
        }

        void start(int n) {
            int n2 = PLA_AbsListView.this.mFirstPosition;
            int n3 = n2 + PLA_AbsListView.this.getChildCount() - 1;
            int n4 = 0;
            if (n <= n2) {
                n4 = n2 - n + 1;
                this.mMode = 2;
            } else if (n >= n3) {
                n4 = n - n3 + 1;
                this.mMode = 1;
            } else {
                return;
            }
            this.mScrollDuration = n4 > 0 ? 400 / n4 : 400;
            this.mTargetPos = n;
            this.mBoundPos = -1;
            this.mLastSeenPos = -1;
            PLA_AbsListView.this.post(this);
        }

        void start(int n, int n2) {
            if (n2 == -1) {
                this.start(n);
                return;
            }
            int n3 = PLA_AbsListView.this.mFirstPosition;
            int n4 = n3 + PLA_AbsListView.this.getChildCount() - 1;
            int n5 = 0;
            if (n <= n3) {
                int n6 = n4 - n2;
                if (n6 < 1) {
                    return;
                }
                int n7 = n6 - 1;
                int n8 = n3 - n + 1;
                if (n7 < n8) {
                    n5 = n7;
                    this.mMode = 4;
                } else {
                    n5 = n8;
                    this.mMode = 2;
                }
            } else if (n >= n4) {
                int n9 = n2 - n3;
                if (n9 < 1) {
                    return;
                }
                int n10 = n9 - 1;
                int n11 = n - n4 + 1;
                if (n10 < n11) {
                    n5 = n10;
                    this.mMode = 3;
                } else {
                    n5 = n11;
                    this.mMode = 1;
                }
            } else {
                return;
            }
            this.mScrollDuration = n5 > 0 ? 400 / n5 : 400;
            this.mTargetPos = n;
            this.mBoundPos = n2;
            this.mLastSeenPos = -1;
            PLA_AbsListView.this.post(this);
        }

        void stop() {
            PLA_AbsListView.this.removeCallbacks(this);
        }

        @Override
        public void run() {
            int n = PLA_AbsListView.this.getHeight();
            int n2 = PLA_AbsListView.this.mFirstPosition;
            switch (this.mMode) {
                case 1: {
                    int n3 = PLA_AbsListView.this.getChildCount() - 1;
                    int n4 = n2 + n3;
                    if (n3 < 0) {
                        return;
                    }
                    if (n4 == this.mLastSeenPos) {
                        PLA_AbsListView.this.post(this);
                        return;
                    }
                    View view = PLA_AbsListView.this.getChildAt(n3);
                    int n5 = view.getHeight();
                    int n6 = view.getTop();
                    int n7 = n - n6;
                    int n8 = n4 < PLA_AbsListView.this.mItemCount - 1 ? this.mExtraScroll : PLA_AbsListView.this.mListPadding.bottom;
                    PLA_AbsListView.this.smoothScrollBy(n5 - n7 + n8, this.mScrollDuration);
                    this.mLastSeenPos = n4;
                    if (n4 >= this.mTargetPos) break;
                    PLA_AbsListView.this.post(this);
                    break;
                }
                case 3: {
                    int n9 = PLA_AbsListView.this.getChildCount();
                    if (n2 == this.mBoundPos || n9 <= 1 || n2 + n9 >= PLA_AbsListView.this.mItemCount) {
                        return;
                    }
                    int n10 = n2 + 1;
                    if (n10 == this.mLastSeenPos) {
                        PLA_AbsListView.this.post(this);
                        return;
                    }
                    View view = PLA_AbsListView.this.getChildAt(1);
                    int n11 = view.getHeight();
                    int n12 = view.getTop();
                    int n13 = this.mExtraScroll;
                    if (n10 < this.mBoundPos) {
                        PLA_AbsListView.this.smoothScrollBy(Math.max(0, n11 + n12 - n13), this.mScrollDuration);
                        this.mLastSeenPos = n10;
                        PLA_AbsListView.this.post(this);
                        break;
                    }
                    if (n12 <= n13) break;
                    PLA_AbsListView.this.smoothScrollBy(n12 - n13, this.mScrollDuration);
                    break;
                }
                case 2: {
                    if (n2 == this.mLastSeenPos) {
                        PLA_AbsListView.this.post(this);
                        return;
                    }
                    View view = PLA_AbsListView.this.getChildAt(0);
                    if (view == null) {
                        return;
                    }
                    int n14 = view.getTop();
                    int n15 = n2 > 0 ? this.mExtraScroll : PLA_AbsListView.this.mListPadding.top;
                    PLA_AbsListView.this.smoothScrollBy(n14 - n15, this.mScrollDuration);
                    this.mLastSeenPos = n2;
                    if (n2 <= this.mTargetPos) break;
                    PLA_AbsListView.this.post(this);
                    break;
                }
                case 4: {
                    int n16 = PLA_AbsListView.this.getChildCount() - 2;
                    if (n16 < 0) {
                        return;
                    }
                    int n17 = n2 + n16;
                    if (n17 == this.mLastSeenPos) {
                        PLA_AbsListView.this.post(this);
                        return;
                    }
                    View view = PLA_AbsListView.this.getChildAt(n16);
                    int n18 = view.getHeight();
                    int n19 = view.getTop();
                    int n20 = n - n19;
                    this.mLastSeenPos = n17;
                    if (n17 > this.mBoundPos) {
                        PLA_AbsListView.this.smoothScrollBy(-(n20 - this.mExtraScroll), this.mScrollDuration);
                        PLA_AbsListView.this.post(this);
                        break;
                    }
                    int n21 = n - this.mExtraScroll;
                    int n22 = n19 + n18;
                    if (n21 <= n22) break;
                    PLA_AbsListView.this.smoothScrollBy(-(n21 - n22), this.mScrollDuration);
                    break;
                }
            }
        }
    }

    private class FlingRunnable
    implements Runnable {
        private final Scroller mScroller;
        private int mLastFlingY;

        FlingRunnable() {
            this.mScroller = new Scroller(PLA_AbsListView.this.getContext());
        }

        void start(int n) {
            int n2;
            this.mLastFlingY = n2 = (n = PLA_AbsListView.this.modifyFlingInitialVelocity(n)) < 0 ? Integer.MAX_VALUE : 0;
            this.mScroller.fling(0, n2, 0, n, 0, Integer.MAX_VALUE, 0, Integer.MAX_VALUE);
            PLA_AbsListView.this.mTouchMode = 4;
            PLA_AbsListView.this.post(this);
        }

        void startScroll(int n, int n2) {
            int n3;
            this.mLastFlingY = n3 = n < 0 ? Integer.MAX_VALUE : 0;
            this.mScroller.startScroll(0, n3, 0, n, n2);
            PLA_AbsListView.this.mTouchMode = 4;
            PLA_AbsListView.this.post(this);
        }

        private void endFling() {
            this.mLastFlingY = 0;
            PLA_AbsListView.this.mTouchMode = -1;
            PLA_AbsListView.this.reportScrollStateChange(0);
            PLA_AbsListView.this.clearScrollingCache();
            PLA_AbsListView.this.removeCallbacks(this);
            if (PLA_AbsListView.this.mPositionScroller != null) {
                PLA_AbsListView.this.removeCallbacks(PLA_AbsListView.this.mPositionScroller);
            }
            this.mScroller.forceFinished(true);
        }

        @Override
        public void run() {
            int n;
            switch (PLA_AbsListView.this.mTouchMode) {
                default: {
                    return;
                }
                case 4: 
            }
            if (PLA_AbsListView.this.mItemCount == 0 || PLA_AbsListView.this.getChildCount() == 0) {
                this.endFling();
                return;
            }
            Scroller scroller = this.mScroller;
            boolean bl = scroller.computeScrollOffset();
            int n2 = scroller.getCurrY();
            int n3 = this.mLastFlingY - n2;
            if (n3 > 0) {
                PLA_AbsListView.this.mMotionPosition = PLA_AbsListView.this.mFirstPosition;
                PLA_AbsListView.this.mMotionViewOriginalTop = PLA_AbsListView.this.getScrollChildTop();
                n3 = Math.min(PLA_AbsListView.this.getHeight() - PLA_AbsListView.this.getPaddingBottom() - PLA_AbsListView.this.getPaddingTop() - 1, n3);
            } else {
                n = PLA_AbsListView.this.getChildCount() - 1;
                PLA_AbsListView.this.mMotionPosition = PLA_AbsListView.this.mFirstPosition + n;
                PLA_AbsListView.this.mMotionViewOriginalTop = PLA_AbsListView.this.getScrollChildBottom();
                n3 = Math.max(-(PLA_AbsListView.this.getHeight() - PLA_AbsListView.this.getPaddingBottom() - PLA_AbsListView.this.getPaddingTop() - 1), n3);
            }
            n = PLA_AbsListView.this.trackMotionScroll(n3, n3) ? 1 : 0;
            if (bl && n == 0) {
                PLA_AbsListView.this.invalidate();
                this.mLastFlingY = n2;
                PLA_AbsListView.this.post(this);
            } else {
                this.endFling();
            }
        }
    }

    final class CheckForTap
    implements Runnable {
        CheckForTap() {
        }

        @Override
        public void run() {
            if (PLA_AbsListView.this.mTouchMode == 0) {
                PLA_AbsListView.this.mTouchMode = 1;
                View view = PLA_AbsListView.this.getChildAt(PLA_AbsListView.this.mMotionPosition - PLA_AbsListView.this.mFirstPosition);
                if (view != null && !view.hasFocusable()) {
                    PLA_AbsListView.this.mLayoutMode = 0;
                    if (!PLA_AbsListView.this.mDataChanged) {
                        Drawable drawable;
                        PLA_AbsListView.this.layoutChildren();
                        view.setPressed(true);
                        PLA_AbsListView.this.positionSelector(view);
                        PLA_AbsListView.this.setPressed(true);
                        int n = ViewConfiguration.getLongPressTimeout();
                        boolean bl = PLA_AbsListView.this.isLongClickable();
                        if (PLA_AbsListView.this.mSelector != null && (drawable = PLA_AbsListView.this.mSelector.getCurrent()) != null && drawable instanceof TransitionDrawable) {
                            if (bl) {
                                ((TransitionDrawable)drawable).startTransition(n);
                            } else {
                                ((TransitionDrawable)drawable).resetTransition();
                            }
                        }
                        if (!bl) {
                            PLA_AbsListView.this.mTouchMode = 2;
                        }
                    } else {
                        PLA_AbsListView.this.mTouchMode = 2;
                    }
                }
            }
        }
    }

    private class PerformClick
    extends WindowRunnnable
    implements Runnable {
        View mChild;
        int mClickMotionPosition;

        private PerformClick() {
        }

        @Override
        public void run() {
            if (PLA_AbsListView.this.mDataChanged) {
                return;
            }
            ListAdapter listAdapter = PLA_AbsListView.this.mAdapter;
            int n = this.mClickMotionPosition;
            if (listAdapter != null && PLA_AbsListView.this.mItemCount > 0 && n != -1 && n < listAdapter.getCount() && this.sameWindow()) {
                PLA_AbsListView.this.performItemClick(this.mChild, n, listAdapter.getItemId(n));
            }
        }
    }

    private class WindowRunnnable {
        private int mOriginalAttachCount;

        private WindowRunnnable() {
        }

        public void rememberWindowAttachCount() {
            this.mOriginalAttachCount = PLA_AbsListView.this.getWindowAttachCount();
        }

        public boolean sameWindow() {
            return PLA_AbsListView.this.hasWindowFocus() && PLA_AbsListView.this.getWindowAttachCount() == this.mOriginalAttachCount;
        }
    }

    public static interface OnScrollListener {
        public static final int SCROLL_STATE_IDLE = 0;
        public static final int SCROLL_STATE_TOUCH_SCROLL = 1;
        public static final int SCROLL_STATE_FLING = 2;

        public void onScrollStateChanged(PLA_AbsListView var1, int var2);

        public void onScroll(PLA_AbsListView var1, int var2, int var3, int var4);
    }
}

