/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.components.impl.android.\u7011\u5e03\u6d41\u5217\u8868\u6846\u7c7b\u5e93;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.SparseIntArray;
import android.view.View;
import com.e4a.runtime.components.impl.android.\u7011\u5e03\u6d41\u5217\u8868\u6846\u7c7b\u5e93.PLA_ListView;

public class MultiColumnListView
extends PLA_ListView {
    private static final String TAG = "MultiColumnListView";
    private static final int DEFAULT_COLUMN_NUMBER = 2;
    private int mColumnNumber = 2;
    private Column[] mColumns = null;
    private Column mFixedColumn = null;
    private SparseIntArray mItems = new SparseIntArray();
    private int mColumnPaddingLeft = 0;
    private int mColumnPaddingRight = 0;
    private Rect mFrameRect = new Rect();

    public MultiColumnListView(Context context) {
        super(context);
    }

    public MultiColumnListView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public MultiColumnListView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
    }

    public void init(int n, int n2, int n3, int n4) {
        this.getWindowVisibleDisplayFrame(this.mFrameRect);
        int n5 = n2;
        int n6 = n;
        this.mColumnNumber = this.mFrameRect.width() > this.mFrameRect.height() && n5 != -1 ? n5 : (n6 != -1 ? n6 : 2);
        this.mColumnPaddingLeft = n3;
        this.mColumnPaddingRight = n4;
        this.mColumns = new Column[this.mColumnNumber];
        for (int i = 0; i < this.mColumnNumber; ++i) {
            this.mColumns[i] = new Column(i);
        }
        this.mFixedColumn = new FixedColumn();
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        super.onLayout(bl, n, n2, n3, n4);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        int n3 = (this.getMeasuredWidth() - this.mListPadding.left - this.mListPadding.right - this.mColumnPaddingLeft - this.mColumnPaddingRight) / this.mColumnNumber;
        for (int i = 0; i < this.mColumnNumber; ++i) {
            this.mColumns[i].mColumnWidth = n3;
            this.mColumns[i].mColumnLeft = this.mListPadding.left + this.mColumnPaddingLeft + n3 * i;
        }
        this.mFixedColumn.mColumnLeft = this.mListPadding.left;
        this.mFixedColumn.mColumnWidth = this.getMeasuredWidth();
    }

    @Override
    protected void onMeasureChild(View view, int n, int n2, int n3) {
        if (this.isFixedView(view)) {
            view.measure(n2, n3);
        } else {
            view.measure(0x40000000 | this.getColumnWidth(n), n3);
        }
    }

    @Override
    protected int modifyFlingInitialVelocity(int n) {
        return n;
    }

    @Override
    protected void onItemAddedToList(int n, boolean bl) {
        super.onItemAddedToList(n, bl);
        if (!this.isHeaderOrFooterPosition(n)) {
            Column column = this.getNextColumn(bl, n);
            this.mItems.append(n, column.getIndex());
        }
    }

    @Override
    protected void onLayoutSync(int n) {
        for (Column column : this.mColumns) {
            column.save();
        }
    }

    @Override
    protected void onLayoutSyncFinished(int n) {
        for (Column column : this.mColumns) {
            column.clear();
        }
    }

    @Override
    protected void onAdjustChildViews(boolean bl) {
        int n = this.getFirstVisiblePosition();
        if (!bl && n == 0) {
            int n2 = this.mColumns[0].getTop();
            for (Column column : this.mColumns) {
                int n3 = column.getTop();
                column.offsetTopAndBottom(n2 - n3);
            }
        }
        super.onAdjustChildViews(bl);
    }

    @Override
    protected int getFillChildBottom() {
        int n = Integer.MAX_VALUE;
        for (Column column : this.mColumns) {
            int n2 = column.getBottom();
            n = n > n2 ? n2 : n;
        }
        return n;
    }

    @Override
    protected int getFillChildTop() {
        int n = Integer.MIN_VALUE;
        for (Column column : this.mColumns) {
            int n2 = column.getTop();
            n = n < n2 ? n2 : n;
        }
        return n;
    }

    @Override
    protected int getScrollChildBottom() {
        int n = Integer.MIN_VALUE;
        for (Column column : this.mColumns) {
            int n2 = column.getBottom();
            n = n < n2 ? n2 : n;
        }
        return n;
    }

    @Override
    protected int getScrollChildTop() {
        int n = Integer.MAX_VALUE;
        for (Column column : this.mColumns) {
            int n2 = column.getTop();
            n = n > n2 ? n2 : n;
        }
        return n;
    }

    @Override
    protected int getItemLeft(int n) {
        if (this.isHeaderOrFooterPosition(n)) {
            return this.mFixedColumn.getColumnLeft();
        }
        return this.getColumnLeft(n);
    }

    @Override
    protected int getItemTop(int n) {
        if (this.isHeaderOrFooterPosition(n)) {
            return this.mFixedColumn.getBottom();
        }
        int n2 = this.mItems.get(n, -1);
        if (n2 == -1) {
            return this.getFillChildBottom();
        }
        return this.mColumns[n2].getBottom();
    }

    @Override
    protected int getItemBottom(int n) {
        if (this.isHeaderOrFooterPosition(n)) {
            return this.mFixedColumn.getTop();
        }
        int n2 = this.mItems.get(n, -1);
        if (n2 == -1) {
            return this.getFillChildTop();
        }
        return this.mColumns[n2].getTop();
    }

    private Column getNextColumn(boolean bl, int n) {
        int n2 = this.mItems.get(n, -1);
        if (n2 != -1) {
            return this.mColumns[n2];
        }
        int n3 = Math.max(0, n = Math.max(0, n - this.getHeaderViewsCount()));
        if (n3 < this.mColumnNumber) {
            return this.mColumns[n3];
        }
        if (bl) {
            return this.gettBottomColumn();
        }
        return this.getTopColumn();
    }

    private boolean isHeaderOrFooterPosition(int n) {
        int n2 = this.mAdapter.getItemViewType(n);
        return n2 == -2;
    }

    private Column getTopColumn() {
        Column column = this.mColumns[0];
        for (Column column2 : this.mColumns) {
            column = column.getTop() > column2.getTop() ? column2 : column;
        }
        return column;
    }

    private Column gettBottomColumn() {
        Column column = this.mColumns[0];
        for (Column column2 : this.mColumns) {
            column = column.getBottom() > column2.getBottom() ? column2 : column;
        }
        return column;
    }

    private int getColumnLeft(int n) {
        int n2 = this.mItems.get(n, -1);
        if (n2 == -1) {
            return 0;
        }
        return this.mColumns[n2].getColumnLeft();
    }

    private int getColumnWidth(int n) {
        int n2 = this.mItems.get(n, -1);
        if (n2 == -1) {
            return 0;
        }
        return this.mColumns[n2].getColumnWidth();
    }

    private class FixedColumn
    extends Column {
        public FixedColumn() {
            super(Integer.MAX_VALUE);
        }

        @Override
        public int getBottom() {
            return MultiColumnListView.this.getScrollChildBottom();
        }

        @Override
        public int getTop() {
            return MultiColumnListView.this.getScrollChildTop();
        }
    }

    private class Column {
        private int mIndex;
        private int mColumnWidth;
        private int mColumnLeft;
        private int mSynchedTop = 0;
        private int mSynchedBottom = 0;

        public Column(int n) {
            this.mIndex = n;
        }

        public int getColumnLeft() {
            return this.mColumnLeft;
        }

        public int getColumnWidth() {
            return this.mColumnWidth;
        }

        public int getIndex() {
            return this.mIndex;
        }

        public int getBottom() {
            int n = Integer.MIN_VALUE;
            int n2 = MultiColumnListView.this.getChildCount();
            for (int i = 0; i < n2; ++i) {
                View view = MultiColumnListView.this.getChildAt(i);
                if (view.getLeft() != this.mColumnLeft && !MultiColumnListView.this.isFixedView(view)) continue;
                n = n < view.getBottom() ? view.getBottom() : n;
            }
            if (n == Integer.MIN_VALUE) {
                return this.mSynchedBottom;
            }
            return n;
        }

        public void offsetTopAndBottom(int n) {
            if (n == 0) {
                return;
            }
            int n2 = MultiColumnListView.this.getChildCount();
            for (int i = 0; i < n2; ++i) {
                View view = MultiColumnListView.this.getChildAt(i);
                if (view.getLeft() != this.mColumnLeft && !MultiColumnListView.this.isFixedView(view)) continue;
                view.offsetTopAndBottom(n);
            }
        }

        public int getTop() {
            int n = Integer.MAX_VALUE;
            int n2 = MultiColumnListView.this.getChildCount();
            for (int i = 0; i < n2; ++i) {
                View view = MultiColumnListView.this.getChildAt(i);
                if (view.getLeft() != this.mColumnLeft && !MultiColumnListView.this.isFixedView(view)) continue;
                n = n > view.getTop() ? view.getTop() : n;
            }
            if (n == Integer.MAX_VALUE) {
                return this.mSynchedTop;
            }
            return n;
        }

        public void save() {
            this.mSynchedTop = 0;
            this.mSynchedBottom = this.getTop();
        }

        public void clear() {
            this.mSynchedTop = 0;
            this.mSynchedBottom = 0;
        }
    }
}

