// ==UserScript==
// @name         电子科技大学挂机宝
// @namespace    www.qqkzw.com
// @version      1.1.3
// @description  电子科技大学（网络教育）自动在线学习&自动考试
// @author       Horjer
// @require      https://cdn.bootcss.com/jquery/1.8.3/jquery.min.js
// @require      https://cdn.bootcdn.net/ajax/libs/layer/3.1.1/layer.js
// @resource     layer http://cdn.bootcdn.net/ajax/libs/layer/3.1.1/theme/default/layer.css
// @grant        GM_getValue
// @grant        GM_setValue
// @grant        GM_addStyle
// @grant        GM_getResourceText
// @match        https://student.uestcedu.com/console/main.html*
// @match        https://student.uestcedu.com/console/apply/student/student_learn.jsp*
// @match        http://learning.uestcedu.com/learning3/*
// @match        http://ispace.uestcedu.com/ispace2_sync/scormplayer/index_sco.jsp*
// @match        http://ispace.uestcedu.com/ispace2_upload/scormplayer/index_sco.jsp*
// @match        http://ispace.uestcedu.com/ispace2_upload/*/ch_index.html*

// ***********************************特此声明***********************************************
// 该脚本完全免费，仅供学习使用，严谨倒卖！！！ 如果您是通过购买所得，请找卖家退款！！！
// 尊重作者权益，请勿在未经允许的情况下擅自修改代码和发布到其他平台!
// 作者: Horjer
// 更新时间: 2020年12月17日
// 版本: v1.1.3
// ****************************************************************************************
// ==/UserScript==

GM_addStyle(GM_getResourceText('layer'));
GM_addStyle(".site-dir{display:none;}.site-dir li{line-height:26px;overflow:visible;list-style-type:disc;}.site-dir li a{display:block;text-decoration:none}.site-dir li a:active{color:#01AAED;}.site-dir li a.layui-this{color:#01AAED;}body .layui-layer-dir{box-shadow:none;border:1px solid #d2d2d2;}body .layui-layer-dir .layui-layer-content{padding:10px;}.site-dir a em{padding-left:5px;font-size:12px;color:#c2c2c2;font-style:normal;}");
GM_addStyle(".layui-layer-ico16,.layui-layer-loading.layui-layer-loading2{width:32px;height:32px;background:url(https://cdn.bootcdn.net/ajax/libs/layer/3.1.1/theme/default/loading-2.gif)no-repeat;}.layui-layer-ico{background: url(https://cdn.bootcdn.net/ajax/libs/layer/3.1.1/theme/default/icon.png) no-repeat;}");

//初始化调用
(function() {
    console.log("===================" + GetUrlRelativePath())
    if(GetUrlRelativePath() === "/learning3/course/course_learning.jsp"){
        openCoursesDir(getUrlParam("course_id"));
        window.top.localStorage.setItem("scanLearningProgress", "false");
        autoConfirm(3000, '是否开始学习本课程?（3秒后无操作，将默认学习）', function(){
            layer.msg('执行自动学习', {offset: 'b'});
            window.top.localStorage.setItem("scanLearningProgress", "true");
            startLookCurriculum();
        });
    }
    if(GetUrlRelativePath() === '/learning3/console/'){
        console.log("===========执行自动学习监听=================");
        monitorLogin();
        setInterval(monitorCourseLearningProgress, 1000*10); //扫描
    }
    if(GetUrlRelativePath() === "/ispace2_sync/scormplayer/index_sco.jsp"){
        updateLoadInterval();
    }
    if(GetUrlRelativePath().indexOf("/ch_index.html") != -1){
        videoPage()
    }
    if(GetUrlRelativePath() === "/learning3/scorm/scoplayer/load_sco.jsp"){
        videoProgress();
    }
    if(GetUrlRelativePath() === "/learning3/scorm/scoplayer/code.htm"){
        window.top.localStorage.setItem("scanLearningProgress", "true"); // 进入到该页面，就可以开始监控
    }
    if(GetUrlRelativePath() === "/learning3/exam/portal/exam_info.jsp"){
        layer.msg('请稍等，正在检查考试状况', {offset: 'b'});
        //setTimeout(function() {
        //    examInfo();
        //}, 1000);
        $(document).ready(function(){
           examInfo();
        });
    }
    if(GetUrlRelativePath() === "/learning3/exam/portal/exam.jsp"){
        layer.msg('进入考试页面', {offset: 'b'});
        setTimeout(function() {
            exam();
        }, 1000);
    }
    if(GetUrlRelativePath() === "/learning3/exam/portal/view_answer.jsp"){
        layer.msg('进入查看试卷页面', {offset: 'b'});
        setTimeout(function() {
            viewAnswer();
        }, 1000);
    }
    if(GetUrlRelativePath() === "/console/apply/student/student_learn.jsp"){
        studentLearn();
    }
    if(GetUrlRelativePath() === "/console/main.html"){
        studentLogin()
    }
})();

// 学生管理平台登录
function studentLogin(){
    $.ajax({
        url:"https://student.uestcedu.com/console/user_info.jsp?" +  Math.random(),
        dataType: "json",
        success:function (data){
            if(!data.user_name){
                if(window.invalidLayer){
                    layer.close(window.invalidLayer)
                }
                window.invalidLayer = layer.confirm('检测到登录已失效，是否去登录?', {icon: 3, title:'提示'}, function(index){
                    window.location.href = "https://student.uestcedu.com/console/";
                });
            }
        }
    });
    setTimeout(studentLogin, 1000 * 60);
}

// 学生管理平台在线学习
function studentLearn(){
    layer.open({
        type: 1,
        skin: 'layui-layer-rim', //加上边框
        area: ['420px', '360px'], //宽高
        offset: 'rb',
        shade :0,
        content: '<div style="padding: 10px;">该插件仅供学习使用，严谨倒卖<br/>如插件失效，可加微信联系作者进行适配<img src="data:image/jpeg;base64,/9j/4AAQSkZJRgABAQAAAQABAAD/2wBDAAgGBgcGBQgHBwcJCQgKDBQNDAsLDBkSEw8UHRofHh0aHBwgJC4nICIsIxwcKDcpLDAxNDQ0Hyc5PTgyPC4zNDL/2wBDAQkJCQwLDBgNDRgyIRwhMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjL/wAARCAEAAQADASIAAhEBAxEB/8QAHAAAAwEBAQEBAQAAAAAAAAAAAAYHCAUEAwIB/8QAVxAAAQMDAwICAgoOBwQIBgMAAQIDBAUGEQAHEiExE0EUUQgVFyI3YXSUstIYMlJUVVZxc4GRk6Gz0RYjNUJ1krFictPiJSczNkVGU8IkKDR2tMFEY2T/xAAYAQEBAQEBAAAAAAAAAAAAAAAAAgMBBP/EAB0RAQADAAIDAQAAAAAAAAAAAAABAhESMQMhQVH/2gAMAwEAAhEDEQA/AL/o0aNAaNGdGR69AaNGR69GR69AaNGR69GdAaNGdGdAaNGdGRoDRo0Z0Bo0ZGjI9egNGjOjOgNGjRkevQGjRkevRnQGjRozoDRo0ZGgNGjI9ejI9egNGjI9ejOgNGjRoDQe2jQe2gzTududeNB3Fq9LplaXHhsLbDTQZbVxy2gnqUk9ydLHutbk/huT8za+pr+btfDNV/z7H8NvWqbguCnWvR3arVXlNRGlJStaUFZBUcDoOvc6DK/utbk/huT8za+po91rcn8NyfmbX1NXb3c7B/Cr/wAzd+rr9s73WI++2y3VHitxQSkeiOjqTgeWggi93dxm08l12QlPrMRoD6GrRsfdtcuyj1Z+uT1S3GH0IbUptCeIKSSPegeevVvz8F8r5Sx9LS37G7+wK78qb+gdAo7gbpXpRr8rNOp9ccYiR5JQ02GGjxTgdMlJOuztBuPdNx3wINbrJkQ/RXV8FtNoHIYwchIPr1Nt0/hPuH5Wr/QaT9Borey/7iti4KbHoFXMZh2IXHEobbWCrmRnKgfIaQre3dvmZctLjSrgWuO9MZbdSWGgCkrAIzx9ROlu19vLkvGE/LosNt9lhzw1lT6EYVjPZRHkdcKq0yVRarKps1ARKiuFp1IUFAKHcZHQ6DVu8NzVS37MbmW/O8GaZrbZU2lLh4FK8jBB8wNebZi6qxcVrzpNxTy9KbmlttTqENkI4IOMADzJ1ENnropVpXm7Uay+piMqG40FJbUs8ipBAwkE+R16d57to943RBm0WQp9hqEGlqU0pGFc1nGFAeRGg6N4boX5TrxrcWDWX24Uea82yExm1JSgKIHUoORjzzpf92bcD8YnPm7P1NVakbkWxO2yiWixNcVWZNJTTW2SwsAvqa8MJ5Y4gciBnONRu59trntCmt1CtQm2I7joZSpL6FkrIJxhJPkk6DROyly1i6rMlTq3NVLkonraS4pCU4QEIIGEgDuT+vU2jbl3gveRNDVWVmm+3pi+B4LePC8Yp45457dM5zpz9jn8Hs7/ABRz+G3pLlbdXLRdy5F4zoTbdEi1ZdSefD6FFLCXSsq4g8iePXGM6Ckb13JXbZtaBKoEtyNJcmhtakNpWSjgs4woHzA1Dfda3J/Dcn5m19TWkrX3Gtq8J70KizHH32WvGWlTC0YTkDOVAeZGmvQZC91rcn8NyfmbX1NU7ZS9bque4KlGr9QdkstRA42lbCEYVzAz71I8s6t+uDdF4UWzojEqtSVsNPueGgpaUvKsZ7JB8hoOy4+yhXFbqEq6dCoA6znbG5l31DdiLR5FaW7Tl1FbJZ8FsAoClYGQnPkPPX5vm16ruvcRuS0GEzKWWURw644lk80Z5Disg9MjrjX4sPaK8qFfNHqc+nNNxY0gLdWJTaiE4PkDk6B/3wu2uWpR6S/RJ6ojj760OKS2hXIBIIHvgfPUXRu7uM4nkiuyFJ9YiNEfQ1TvZJf2BQ/lTn0Bpk2G+C+L8pf+loIf7rW5P4bk/M2vqaPda3J/Dcn5m19TV5e3usRh5xlyqPhbailQ9EdOCDg+Wvx7udg/hV/5m79XQQn3Wtyfw3J+ZtfU0z7Y7nXlXtxaRTKnWlyIb63A60WW08sNrI6hIPcDWgbfuCnXPR2qrSnlOxHVKShakFBJScHoevcayttL8M1I/Pv/AMNzQa+0aPLRoDQe2jQe2gyFu18M1X/Psfw29XbfP4KKn+dY/ip1Cd2vhmq/59j+G3q873Muv7WVJtltbiy6xhKEkk/1qfIaDImvZSf7Yhfn2/pDR7U1H7wlfsVfy166VSqgmrwyYMkAPt9Syr7ofFoNN78fBdK+Us/T0t+xt60GufKm/oHTJvx8F0r5Sz9PS37Gz+wa58qb+gdB9r42QjVao1q5FVx5tbock+AIwIBCc4zy+L1azYQdbxlSqc8l2FJkxyHAWltKdAJyMEYznz1GN39urcodjmXQqGhmZ6U0jmzzUric56En4tB6fY3/APdOsfLh/DTr43zsjFmya/cxrjqXFh6b6OI4IBCSrjnl8XfGvp7H1xFNterNzlJirVNCkpfPAkeGOoBxpYr15Xe/uXLpHthLXQHal6OpsNAtKjqWEqHLj9rxJ650CJtxZTd9XMukuzVw0pjLf8RLYWfelIxgkfda++5liNWDXYtOZnrmh+KHytbQQR79ScYBP3P79acty0LNodTVKoMKGzMLamypl4qVwJGRgqPqGvXXrGtq55jcus0pmY+234SFrUoEJyTjoR5k6DF9GqCqPXKfU0teKqHJbkBsnAVwUFYz5Zxp+3B3dkX7QGaU7R24aWpKZHiIfKySEqTjBSPuv3avvuRWH+Lcb/O59bU03usW2bYsuJNo1JZiSVz0NKcQpRJSULJHUnzA/VoEzb7d2RYVAepbVHamJdkqkeIp8oIJSlOMBJ+5/fpvb3qk3y4m03aG1DbrREBUhMgrLQd94VBJSM4znGRr6bI2LbNz2XLm1mksy5KJ62kuLUoEJCEEDoR5k/r033FZNlUCgVOpUSnwo9Zgx3Hoa2nipxt9AJQQkqOSFAdMaBTk0BGwLYuOJINZXOPoBYdT4IQD/Wcsgqz9pjGPPXl+yVm/izH+dq+rqa16471ueG3ErL8+Yw254qELj4AVgjPRI8idVrZvbu3q7ZTsuv0ND0wTXEBT3NKuASjAxkeZOg8H2Ss38WWPnavqaTdw915F/wBKiQnqQ3CEd8vBaHyvl70pxgpHr1eFbbbZoUUqpNNCgcEGSoEH/PqYb12taVAt+mv29DiMPuSyhxTDpWSngTg++PnjQcGw95JNj22KQ1RWpaQ8t7xVSCg++x0wEn1a1JTZZn0uJMKAgvsodKQc45JBx+/UK2hs+y63Ywl12DCemGU6jm88Uq4jjgYCh6zq4xJdNbbZiRZUbihIbbbQ6knAGAB19Q0Ec9kn/YND+VOfQGmPYf4Lovyl76elz2Sf9g0P5U59AaY9h/gui/KXvp6DLVW/tib+fc+kdePXXqtKqCqvMIgySC+51DKvuj8WvJ7U1H7wlfsVfy0GrNjPgppn51/+KrUJ2l+Gakfn3/4bmrzsiy6xtbTW3m1trDr+UrSQR/Wq8jqDbS/DNSPz7/8ADc0GvfLRo8tGgNB7aNGgyBu8sN7xVlavtUvMk/sm9XL3ebG++5nzRevLdux1Puy6JtcerMphyUpJLaGkkJwgJ6En/Z1xfsbaSP8AzBN/YI/noGT3eLG+/JnzRej3eLG+/JnzRelr7G2k/jDM/YI/nr+/Y20n8YZn7BH89Bzt1N1LXuyxn6XS5EhcpbzSwlcdSBhKsnqddH2N39gV35U39A6PsbaSP/ME39gj+en7b/b+LYEGbGiz3ZaZTiXCpxATxwnGOmgzteXw5zf8Xb+kjWormuimWjSPbOrOOIjeKlvLaCs8lZx0H5NZcvL4c5v+Lt/SRrS98WgxfFvGjyJbkZHjJd8RtIUcpz0wfy6CO3zTJO81Ri1azkpkRILRjPqkK8EhZUV4AV36EaYYd9UOlWciwJTzya+3DNKU0lolHpBSUAc+2ORHXTvt/YMawaZLgxprstMh4PFTqAkg8QnHT8mlubslAm3su5lViUl5U4TfBDSeIIUFcc5zjpoEWyrbqW0FcVcl3NtsU1bCoYXHWHleIsggcU9cYQrrq32peNIvOnPTqO464wy74Ky42UHlgHsfiI15r7s2PfVARSZExyKhMhL/AIjaQo5SFDGD/vaktQrzmwbybdprCKq1OT6cp6SS2pKifD4gJ6YwgH9OgpK92rUbuc28qRJ9sBL9C4+jq4+Jy445dsZ89LPsjPg9g/4m3/Dc1xRtxElQPdQNQeTMU37fehBCfD5geN4fLvjIxnvry0+5nt+Xza9SjIpTMZPtgH4yi4pSk+844V0xhwn9GgZPY5/B7O/xRz+G3qQwz/8AMEn/AO5j/wDkHWkrBsmPYdCepcaY7KQ7JVIK3EhJBKUpx0/3dZZrFUcoe7dSqzbIdXDrbshKFEgKKXicH9Wg1ldd30izKezOrDrrbDzvgoLbZWeWCew+IHX7te6qXeFJVUqQ445GS8WSXGyg8gAT0P5RrMN/7sTb+o0anSaWxEQxID4W24pRJ4qTjr/vasPsefg4e/xF36Legz/VqZKrW5FRpkJKVSZVUeaaCiACouqxk+Wvvde3Nw2ZCjy6www20+54SC28lZKsZ8viGurQvh7Y/wAfV/GVrRl/2HFv+lxIUmc7ETHe8YKaQFEniU46/l0GZbY2uue7aQKnSo8dcYuKay4+lB5DGeh/Lr9bbR3Ie7VEivAB1mf4awOvUcgf9Najsez2LIt0UiPLclIDy3fEcSEnKsdMD8ms0Wb8OkL/ABdz6S9BTPZJf2BQvlLn0BrnbVbqWvaljMUuqSJCJSHnVlLcdSxhSsjqNU7cDb+LuBBhRpM92ImK4pwFpAVyynGOukL7G6k/jDN/YI/noGT3eLG+/JnzRej3eLG+/JnzRelv7GylfjBN/YI/noPsbaSO9wTf2CP56Bk93mxvvuZ80XqG7RLDm8dGWn7VTzxH7JzVO+xtpP4wzf2CP567VpbH061LohVxisypDkVSilpbSQFZQpPcH/a0FX8tGjRoDRo0HtoPC/WaXGfUw/UYbTySAW1voSoZ+InOlPd6r1Ch7cz59MluRZTbjIS62cKALiQf3anN+bQ3RcW4lQrcEQvQ33WlI8R/irCUIByMetJ0875/BRU/zrH8VOgzv7qd8fjLP/zj+WuvSr43IlSYjvtnWXIq3EkrDZKCnl168cY76nI76v1n7vWvRNt4VClmb6Y1FcaVwYynkSrHXPxjQPW6NzPtWS+u2KqldTDzfAQXUuOceXvsBOTjHfXh2Tq1yVakVZdxvTXXUPoDRloKSE8euMgeeoTtdc9PtK9mKtUy6IqGXEHwkclZUnA6a1JZ980e9osqRSDI8OMsIc8ZvgckZGOp0GZ9yaZWEbnVydFgTeKJhdQ8hhRAwAeQOMdMactmL4ua4L9EKq1mVLjeiOr8JxQI5Djg9vj093ju9a9NVWaBIM0TW23Y6uLGU8yggdc9uo1Ctqbqptn3mKpVC8IwjONf1SOSuRxjp+jQbG1zbhdkMW1VHYhWJKIbymigZUFhBIx8ecan32QFlfdVH5r/AM2n2LcUGZaybha8X0FUUyxlOF8Akq7evA7aCNbOXBe1UvRyPcMmqOwhCcUEymylHPkjHUgdcE65fshaXUJ1501yJBkyEJpwSVNMqWAfEX0yBp7G/wDZP3VS+a/82j3f7JP96pfNf+bQRC2r0uQVmkW7UKvKRSTIZhSIbxCUBgqCFIUCOg45B1U9xIVKtagMztu248arrlJadXS1Bx0sFKioEAn3vII8u+NRKtrTdm4c1VM7VWpq9G8X3v8A2jnveXq7jVx2i2vuKyrsk1GrCII7kJbCfBe5HkVoPbA6YSdAzbL1Kv1WzpT9xOy3ZiZy0IVKQUq4cEEYyB0yTr2ybO25nVV4yKfRnZ77yi4FOpK1OE9cjlnOc9NPGshwz/8AMEn/AO5j/wDkHQUPeqwKPSrXgPW5b6GpSpoS4YjSlK4cFnrjPTIGu3sZKj0WwnYtVfagyDPcWGpSw0spKUYOFYOOh6/Fp9u+86VZNNYnVcvhl57wU+C3zPLiVdsjyB1l/dq7KbeV4N1Okl4x0w22T4zfE8gpRPTJ9Y0HBrdRfg35U6jT5BbeaqLzrLzZBwfEUQQddmJuLuHOWpEOt1aQpIypLQ5kD1nA19pW0F0RLXXcLohegpiiWcP++4FIV2x3we2vVs9elJsmu1CXVy+Gn4waR4LfM8uYPrHkNBeNoahW6nY4kV92U5N9KcTykpKV8RjHcDp31miqxq9Rrrn1eJFnRVx5jrqJIYUAj3599kjHnrQf2QFk/dVL5r/za51d3Pt2/wCiS7UoplmpVRsx4/js8Ecz16qycDpoI5E3E3EnKUmHW6tIKBlQZHPA+PCdev8Aplulg/8Ax9e7f+ir6unizYD2yMuVUbu4hipIDDHoZ8Y8knkcjpgYOnD3f7J+6qXzb/m0FHjSksUdiTNeS2AyhTjjqgkA4Gck9uupFvffEykwqMq268GluOuh70R5KiQAnGcZ9Z14r+3ltW47GqtIgGd6VJaCW/Ej8U55JPU59QOs8E5OgfY997mTGUvRqpWnmlEgLbbKknHxhOmLa6/7srG5VHp1SrkyRFdW4HGXFDCsNLIz09YGu5tju3bFqWLCpFSM30plx1SvCY5JwpZUOufUdIe0Kw5vFRlp7KeeI/ZOaDX+jR5aNAaD20aD20ENvve+sWpelSokalwXmYqkBLjql8lZQlXXBx/e1P7w3oq15W3IokqmQmGnlIUXGisqHFQV5nHlr+7uW7W5u6NbkRKPUH2Fra4uNRVrSr+qQOhAweuv5tTZcuVuBBar1uyVU8tu+IJkRYbz4ZxnkMd8aCZ4OjB9WrhvdYzMKdRhbFuFCFNu+P6BEJBPJOOXEfl0xWjb9jt7cw261BorddEVwOty+CZAcyriFJUeXL7XHTPbQRnbi1It53ezR5kh5hlbTjhWzjkClOR36a1FYW38GwYUyNCmSJKZTiXFF4JBBAx0wNZWplJvOiThMplLrcSSlJSHWYrqVAEYIzx1oTZObc82kVZVzOVJbyX0Bn09KwQnj148h2zoPzcWxVFuO4Z1YkVae07LdLikNpRxSenQZHxanm5Wz1Ksi0zV4dSmyHfSG2uDwQE4VnPYZ8tfO6r2ueJvDLpseuz2oSam22lhD5CAnknpj1a0hVKPTq5C9DqkJmZH5hfhPI5JyOxxoMy7WbV02/KNOnTZ8uM5HkBpKWQkgjiFZOR8eu+7uLPo1UO2jMKM5TmnfacSllXiltR8Pn348sKz2xq70igUmgMOMUmnx4TTiua0MICQo4xk/o0nXRTbGS3V5bbVE/pClDq21BbfpHpPElOBnlz5Yx55xoFf7G+gfhupf5W/5ak+6diw7DuCHToUp+S2/FD6lPBOQeak46Dt73VI2cqV8y71cauN2tqhCE4QJqHAjnyRj7YYz3/fqp3LTbKmTml3K1Rlyw1hszloC+GT25HOM50EjoW0lLptm0++m6jMVNiQUVZMdQR4anEI8UJPTPHIx68aZtrt26nflzSKXNp0OM21EVIC2SskkLQnHU9vfHUtumbfPtxV6bRTW1W8XnWIjUVtxUcxskJSjiMFHHoMdMa62xsSTbV6y5ldju0uKunraS/OQWEKWXGyEhS8DOATj4joH3dHduqWHc0elwqdDktuREyCt4ryCVLGOh7e91xlbc0+LSjuembJVUks+33ohCfB8UjxuGccuOTjvnGkzf8AqMKpX5DegTI8poU1CSth1K0g+I50yD36jXwsuXfU+s0GmTfbx63nnmGHWXG3DHXGJAKT0xw4/oxoPDfm61Tv2kR6dNp0SM2xID4UyVkk8SnHU9vfan4B9R1tT3NbK/Fil/N06Pc1sr8WKX83GgIVHar+10KkvuraamUlplS0Y5JBaSMjOoDuptZTLCo0GbBqEuSuRJLSkvBOAOJORgfFrQN7uuUbbmsrpq1RFxKevwFMniWuKcJ447Y1kCsXXX6+yhirVeZNabXzQh90qCVYxkfo0FL212epN7WmKvMqUyO6ZDjXBkI44TjB6jPnqiW5sVRbcuGDWI9XnOuxHQ6lDgRxUcHocD49ZzpV5XJQ4XodLrc6HG5FfhMvFKcnuca93ulXr+M9U+cK0Fk9kl/YNDx99OfQGlnbnZuk3naDNYl1ObHeW642UNBHHCTgdxnU6lVW7rzSlh+RVawI58QIwt7w89M4AOPVrp0t/ciiwkwqY3ccSMklQaZYdSkE9zjGgr32N9v/AIbqX+Vv+Wj7G+gfhupf5W/5alEm5t0YcdciTOuVlhsZW46l1KUjt1JGBqi7IX3MmzayLnuQrQltrwPT5QAByrPHkfyaCT7iWvHs68pdFiPuvssobUHHQOR5ICj26eeuls0CN2qDkf33f4K9dbd2mVCvbjT6jR4MmownG2QiTDZU82ohsAgKSCDgjB660RRrHtmlPRZ8KgwI0xpIKXm2AlaSU4PX8hOgZfLRo0aA0HoNGg9tBPLg3ktm3LkkUKazUVS2FoQstMpKMqSCMEqHkoeWmm6bmg2jQXqzUUvqjMqQlQZSFKypQSMAkeZ9essbwrLW79bcSASl1kjPxNI167u3nrt426/RZtPpzLDykKUthKwocVBQxlRHloNF2Zf9HvxiY7SW5aExFJS56Q2EZKgSMYUfUdZt3H+GypfL2f8ARGqN7Gv+zbh/PMfRXplunZyh1Wuz7oen1BMtR9J8JCkeHyQkYHVOce9HnoHa6rogWfQl1epIfVGQ4lBDCQpWVHA6EjSEfZDWbgjwKv8ANkfX0nUW+KhvNUU2dXY0aHBfSX1PQQoOBTY5DHMqGM9+mmX7HC2PwtWP8zX1NBF6rWYtw7sGrQg4I0qptONh1OFY5p7jJ1swdtSKF7Hq2oM+PLbqtWUth1LiQpTeCUkHr7z4tNe5t3TbJtE1ansR3nvSG2uEgKKcKznsQc9NB/Lz3OoVjz48KqtTVOyGi6gx2kqGM465UPMakMnb6s1i5VbjRnIgojskVdKFuEP+AFeIRx445YSemcZ89degUhnfmO7WriccgSKev0RpFOwlKkkc8q58jnJ8iNWGHbUWFZyLaQ88YqIZhhxRHPiUlOe2M4Pq0HGs7cqjXs7KTS4tQQ1FQFvPyWkobTnsM8j17n8gOkq+Hdr7xrLcurVect+O14CVQkqLZSFE9+Bz1J6g69VyWjD272erNPpMmQtMmQ2XXninmQpSElOUgdMD951F4za1MJKUkgnAI1pSkW7XSsT2vtM3PsKhUeHS49Slejw2UsN84rpVxSMDJCe/TXKum8tttwKY3SqjU5/gtPCQnwI7iFcgCnuUHphR1BH/APtnAfJR1+6YnD6/L3h89dikacYUtNn7PKcLYqVc5ceWOKu3b/09VGm39aFKpcOnR5sksRGUMN84zhPFKQkZPHvgaz9T/wD69Q//AKh/rrrdPLThDlozpeWdybXedS37YKb5HHJ1haEj8pIwNfG8NyqPZD0VNUi1BbUpBWy/HaSttWO4zyHXsfyEahuqjT7Qg7gbX0qnVZ+Q2iPJWpt1njzSEqWkJyoHpg/uGptXEl68N8LVrtn1elRGamJEuKtlsuMJCeRGBk8z01nQ99NFNtqJM3Latpx54RFVMwy4kjnwCynPbGcD1act1trKRYdEgTadNnPuSJBaUJCkEAcSenFI69NQJKBnVTibBXfNhsSmn6V4bzaXE8pCwcKAIz7z49S0D/TWzqjW5FubVe3EVtpx+JTGnEJdBKSeCe+CD5+vQSu06e9sXJkVG7Cl1mpIEdkU8+KoKSeR5cuOBg/Hpr+yGsz73q/zdH19RK+90KtfsSJGqMOEwmK4pxBjhYJJGOvJR0jgf6aDYe6ryJO0VafRng5FQtOe+CtB1mWy7ArF9vzGqS5EQqIlKnPSHCnIUSBjAPqOtZz6DHuixhRZbrrTEuK2ha2iOQACT0yCPLXLsXbOlWBImvU6ZMfVLShKxJKCBxJIxxSPXoEa3L7pO0lFZs640SnKnDKnHFQmw40Q4StOCSk9lDPTTXbm89sXRX4lGgM1FMqUVBBdYSlPRJUckKPkD5ahm+fwrVP80x/CTqzWhsrQbZrtPr8So1J2RHBWlt1TZQSpBSc4SD/ePnoKjo0aNAaNGg9tAm1qNtuuryFVxNsGpEjx/TFMeLnAxy5de2O/ljU73Wj7eN7fTlW+m2xUQ414foJZ8XHMcscevbOfi1NN4UF3d6ttpxlTrIGfjaRr73Xs1cVn2+/WahMpjkZlSEqSw4srPJQSMAoA7n16Bz9j5XaRSKfXk1OqwYSnHWSgSZCGyrCV5xyIzpT3GvmvOX9WI9GuWc5TluhDKIkxSmlAoSMJCTgjOe2uNZG2lZv1ia9S5MFpMRSEuCStSSeQJGOKT6tc2bQZVsXwKNNcZckRZTaFqZJKCcpPQkA+fq0Hop1u33R5gl06iXDDkpBSHWIjyFAHoRkDOtA7Ju3S7SKsboNXL3jo8H2yDnLjx68efln1ad7tuqDZtBcrFRakOx0OJbKY6QVZUcDoSB+/U++yMtD7wrX7Br/iaBEv6TuWi+6ymkKun2vEk+B6KH/C44H2vHpj8mvdtlCu6u3cId7Q61NpHo7ivCq7Tq2PEGOJw4OPLvjz76dIfsgrTnTY8RqBWA4+4lpJUy2ACogDP9Z266eLwu6BZVD9tqizJdj+KlrjHSFKyrOOhIGOnr0A25aNmAxEPUaieP8A1vg824/Py5YyM+rOv3/Ta1Pxno3z9r62ovc1Ikb7y2q1a6m4kant+iOpqRLa1LJ55SEBYxgjuR18tRWuUiRQK5NpMpbS34bymXFNElJIODjIBx+jQal3XqUKrbVVKRTJsaYz6QwjxI7qXE8vFRkZSSM9dZtK3458NRWjHlqpWbL9B9j3NkhSk8Kuk8kdx75oaTKpGjSn1Px1+I0rqFga18fTSldgvkcuvcnqdeiI2Ur7dDr8paKneKQSnPTp317W0paWlK1fr66pWPbDQVS1BPQ+EPP49e1LikuIbHXHTp114IscOT1f1y8eFn3px566Lj7ccJKyVYOOXn+nRNofdDiVlQH904Omy5atUKPsPAlUydIhyPbMp8WO4UK4lTmRkeXQaRTlxwKbXxSVe+z0JOmu8+X2PEDkAD7anpn/AGndTfpGJdGt+9DMbq8WjV4yVLEhuW3Fd5FR98FhQHc5zn49e6qQNyK4yhmqwLonNNq5oRJYfcCTjGQCPVrUtOq8egbZQatKQ6tiHSmXnEtAFRAaSTjJAz+nSR9kZaH3hWv2Lf8AxNZOPxtBYVMdsYKuO14xn+lO9Z8EB3j0x9sM47412tyLjttW3FcpsOtUpTyYqmURmpTZUCCBxCQc5GMY+LXI+yMtA/8Ah9a9f/YNf8TSHJ2HuitynatGm0lLE1ZktpcecCglZ5AHCD1wRnQSmn0ep1hxxFMp0uapsclpjMKcKQTjJ4g41f8AbOkWZT7MYYvGFQ4lYS84pbVXQ02+EFXvSQ5hWMdvLGudbNOd2GkP1K6VIls1NIjspphLikqSeRKufDAwfLOvNX7Iqe8lUXeFuvRY1PfSGEtz1qQ6FNjiSQhKhjPbr+rQfOxX9wDuXTkTlXH7S+kryHg96P4fFXHv73j9rjy7ad973brahUY2sawHC474/taHM44pxy4fpxnVRgsKjQI7CyCptpKCR2yABr0aDE9Qty+atMXMqNEuCXJWAFPPxHlrIAwMkjPbVF2yf3GVuDSG60bmFM5LDwlpfDOPDVjly6d8d/PGqdde8tu2fcD9FqEOpuSGUoUpTDSFIPJIUMErB7H1a+ds72W3dVwxKLBh1RuTKKghTzSAgYSVHJCyeyT5aCk6NGjQGg9tGjQY+3hWWt3q24nGUuskZ+JpGnOg39Vd4Ks3ZlwMQ41NmBTjjkBCkOgtgrTgrUoYykZ6dvVq51S1aBUDIlSqDTZMtxJ5OuxG1rUeOBkkZPYDWctrKFVrTv6DWLipsuk01pt0OS5zKmWkFTZSkFSgAMkgD4zoGe5pK9hXY8S1gmW3Vgpx81P+sKS3gJ48OGB785zny10abt3SL7obe4FUkTWqtMbMtxqMtKWAtGQAEqSVY94M5UT366p7ZtC9MuoTRq36L73nxbkeFy64z1xnH7teOqXJaNCpsyjJq1HgLYZW2IYfba8MlJPEIyMd+3x6CQUC96nvJVU2fcLMWNT30qfU5T0KQ6FNjkACtShjPfppU3bsGlWHU6bGpb8x1EllbizJWlRBCsdMJGkygIrjlVQm3fT/AGw4K4+gFfi8ce+xx64x313aha24tXcbXU6Pck1TY4oVJZecKRnOByzjQUy1NobffsSn3aqXUhPRF9NDYcR4fNGVAY4ZxlI8/wBOvLb94VDemp/0SuNmNFgFBl+JT0qQ7zR2GVlQx7456Z+PVPtmHJgbLR4syO7HkNUpxLjTqClSDxV0IPUaiGwHwlp+RPf+3QM1y1eRsRLZotroblRqg36W6qpAuLSsHhhJQUDGAO4PXz1Fa5V5Ffrk2rSkNofmPKecS0CEgk5OMknH6dbIuZ6yWpbIuc0ISS2fC9sQ0V8M/wB3n1xnWdplmVKfukZtMt2Q/b7tVQtp2PDKoy2C4OqSBxKMZ7dMaBitQcvY51Ed/wDpUfSa0qx5MhsiK022pCzklQ6g9umr5f1IhQNvpkOmQY8RlUhpXhR2ktpJ8ROThIAz00m2NaEKeXpE5aEqbWkISpQGcjP6daVnI1t4/VdTpmjvCa2lJJClgEH8uvmiMGnCJDR48iOSR/8ArVrqFqU6m1lp4yEstLX4nF77UYxnCvL8mlX+jkOpuuCmz47klDi+ccOp5LQScKTnofya0ras+1Wz4QOEWPOJQ4kNqZ6knAB5dtfye1lsBKEpSnryB6n4sf8A70yXTTKPQPDflISXCChTaU+OkHJPHIOAQOpIz30sPramtR5EVX9Q4OKR9yR5H1aibbLlo9bD4toVLebbyAEf3QOnq1cKVZEG69rYFDqjkhllMtTxMVQCshSvNQI/vHy1JI1JlRHAojjnqFEZBGqBcK7il7MQlW+ioCo+2PUU4r8TiFLB+0647amennmZmxaY3Eq9Zr6dtpEeEmjOyDR1PNoUJAZB8MKCiop54SOvHGfLTh9jpaB//n1r9s3/AMPUKsuSYG5tIk1d/wABTNRQqU7KVxKCFe+Kyrsc5znVg3rvyI7b1NFsXQ2ZAlHxfa6d7/hwP23A5xnHfUOur9jpaA/8QrXq/wC2a/4euDam7twP33T7SVFpogIlehBwNr8XgjKQc88ZwkeWPi057HVGdVNvRIqEyRLf9MdT4kh1TisDjgZJJ02vUK1aOpdYepNHhqYJeVMVGbbLZ81FeOh698+eglfskv7Bofypz6A0x7D/AAXxflL309LG9T7N8UmlR7UdRXHo761vN00+kKbSUgAqCM4BPTJ1FV1O7rUV7Vqn1qklv+s9F8d1jjy6545GM+vQWi0t6Ljru4kO35USmIiPSXGVLbaWF8UhWMErIz0Hlq7A9NYriWffceU3UIVCrzUgHxESGY7qV5PmFAZ657/Hr7VWp7jUJDSqtUbngpdJDZkyH2wojvjJ69xoNFXXs1bt33C/WqhLqbch5KEqQw6hKAEpCRjKCew9eoJtC2Gt4qKhOcJeeAz8TTmvPTn9z6tDTMp0m65cZZIS8w7IWkkHBwQfXrVtMtagwFx5cehU2PMQkEPNxEIcSSME8gM56n9eg7flo0aNAaD0GjQe2gmN0b3UG1LkmUSZTqk6/FKQtbKWyk5SFdMqB7K0s1i/6dvDTXLLokWVDnzClxD00JDSQ2eZyUFR7JOOnfUz3ebDu8VaQrsp5kHHxtN6qNxWJSNpKM9eNuLlOVOGpLbaZrgcaw4QhWQAk9lHHXQM20u3tTsCJVWqjKiSDLW2pBjFRwEhQOeQHr1n/d34VK/+fT/DTq97P3/WL6h1Z2rIipVEcbS36O2U9FBROck+oahm57CZO8lXYXng5MbQrB64KUDQeDbW64dmXizWJzD7zDbLiChgJKsqTgdyBrUdjbgU6/YcyTTosphEVxLaxICQSSM9OJOlL7HmzP8A16v84R9TSrdc97YyTHptphDrFTQX3zUB4qgpJ4jjx44GD8egbro3gorFYqNoqgVAzVKVCDoSjw+axxB+2zjKh5a5u2Wz9bsm7RV586nvMiO40UMKWVZVjHdIGOmvtbe2tDvWLTr3qjk1FVnlE11MdwJaDgV2CSkkD3o89Ne6d11CzLONVpiWFSPSW2sPoKk4VnPQEerQSL2SH/eyj/IT/EVq1ba/BrbvyBr/AE1lC8r5qt8z40yqoiodjteEj0dspBHIq65J69dMtG3wuqhUWHSojNMMeIyllsuMKKikdsnmOug0ffTrke0ZslqIZZYKHSyFYyAoZOfiHX9GoQqVVZsr0gKZhZORwytQ/Jnpps2t3WuK9brdpdTYgejiG48QwyUkkFIxkqPT3x08S7NtZx9TjlJlNKV1KWXFoSPyAKxqqzi63yMSYRm31+JPlPzHPW+6VD9WvYJEdlAQlCUpHYAdNP8AOtez6bTZM5+mVLwIzS3nCl1wnikEnHvvUNLVsT9tbwqbkCmU6sqfbZLyvEWsDiCB5LPmoa1jyxHw5F2qTm6ilCZay8lv7QKPQa4ikU6OlQaYbRyOTxHc6ebpk7ZWnUm6fVaZWQ+4yHgG3FkcSSPNY+5Ouw5bNgoto19VJqnoIiemZ8Vzl4fHl2598ambx+O8/wBS+NV3op4oVzbz9oo5Gqyze0CydtqVV6pDe4S5CvDYjhIWQoqUFYUR0wM9/Ma4dmPbZXRV3I9HotRekR2vHKJZUUYCgOxWQepHcaR/ZA1Ca9eEGnuLKIjEJDjUcdEoKlKBP5cJA/RqJtqJzdhMa3ObqdeqM9pKktyZLryUq7gKUVAHHn1127GsOoX7UJMKnyYrDkdkOqMgqAI5AdOIPr14LPpMeu3hSaVLLgjy5SGXC2cK4k9cH16tV1UmPsbCYrFqFx2VPc9FdFQPipCAOfQJCcHIHnqXH0ol4wtk6f8A0Sr0eRNmhapXiwAkt8V9hlZSc+9Oemn/AHGlonbQ1mW2lSUP08OpCu4CuJGf16RLZtCnbzUj+ldzLkNVArVF4wVhtvgjscKCjn3x89VqpW5CqlrO28+p4Q3I4jlSFAL4gADrjGeg8tBl3ae/6bYNTqUmoxZb6ZLKW0COEkghWevIjThWrHqG81RXeNCkxYcF9AYSzOKg4FNjic8AoYz2664+7+2tDsamU2TSXJqnJL60L9IdChgJyMYSNcG1N3rjtChIpFNap6oza1uAvMqUrKjk9Qof6aDUdYrDFn2e5U5rbjzUBhHiJZAKlY4p6Zx5nUeuCUjf5DES3AYC6SpTrxqPvQsOYA48OX3BznGrFU6TGu60V02olxLM6OjxSyeKhnCuhIOOo1y7L24oliPzHqS5MUqWlKXPSHAoYSSRjCR6zoJ3R7/p2ztNbsutxZUyfDKnFvQgktEOHmMFZSeyhnp30z2vvdQbruSHRIdOqTUiUVBC3kt8RhJV1wonsnXsujZ+2rtr71YqLtRTJeShKgy8lKcJSEjAKT5D16gG0KA1vFRkJzhLzwGfiac0GwNGjy0aA0aNB7aBIuGrbfRqhMaqz9BTVEp/rBJQ34oVxBTkkZzjGP0ahO0VUqFf3GgU+sTpNRhONvFcaY8p5tRDZIJSokHBGR01y94UF3d+ttg4KnWR+tpvTxTNv5uzk9F61WZHnQ4QLa2IoUHFFweGMcgB0Ks6D978LVbE+iN0BRpSH23VPJgHwA4QU4KgjGcZPf16oO2tKpNR25o9WqsCHKmLZU49LlMpccUQtXvlLUCSQAOpPlqF7r7hwb/l0t2FDkxhDQ4lYfKTy5FJGMH4tN1m7yUmlWVT7Xcps1clLKoxdSUcOS1Kwe+ce+Ggddxrqi3LaD1Os2spm1hTra0M018l4oByojic4A768e0NtVN+l1M3rSn5EhLyBHNWa8VSUcevErzgZ9XnpZpdjTdmZqbxq0tifEYSY6mIgUFkue9BHIAYGqxYW4EG/oM2TChyIyYriW1B4pJJIz0wdBn2669UKNu3LhRqpKhUyNUkJTHakKbZbbCkkgJBwE9+mNUPeu8bcrdgKh0utwZkn0xpXhMvBSsDlk4HlqP7p/CfcPytX+g14rKtCVe9f9qIklmO74K3eb2SnCcdOn5dAujuNa8sSg257mlEnz6TTDinodefeitk4CclSiR+/Us+xvrw6+3dM/yufy0wNbjQKNSxto9CkuVFpr2nMpBT4RcUPD59+XHKs9s6D47r3FaTNotrs6oUtip+loCl0tSW3fD4q5AlGDxzxyPya+uy190uJa09FzXE0mUZpLYnySV8OCO3I5xnOuD9jfXz/wCN03/K5/LU/vuxplhVePTpstiQt9gPhTAUAByKcdfP3ug+l63TUJl314Q63Ldpr0x8NJblLLSmio4AGccSPLtjSzCqE2nPF6DLfjOlPErYcKCR6sg9ug1UqJsHWq5QoFVZq9Pbbmx0PpQtLnJIUAQDgd+uuPfW0lTsSiM1SbUYcht2QmOEMhYIJSpWeo7e90CLMqE2ovB6bLfkuhPELfcKyB6sk9up0zro+4At4yVsV72n9F5lRW54Pgcc57448f0Y0n62ZApTlc2ahUplaG3ZlBbYQtecJKmAATjy66DHkKozqa6p2DMkRXFJ4qUw6pBI74JB7dNaV2SgxLjsV2bXIrNTlpnONh+a2H1hASghPJeTgZPT4zpL+xur/wCG6Z/lc/lqwbY2bLsa1XKTMksyHVSlv82QeOCEjHUf7OgytVY0v3QZ8ajtuplipOojIi5SoK8RQSEY7H1Y1151oblVNpDc+lXDKbQeSUvhxwA+sAk6rFO2Uq8Pchq5l1SCqOmpKmFoBfPiVlWO2M9dUK/L7hWDTYsybDfkokPeCEslIIPEnJz+TQJW1NaptkWYKRdE5ikVH0lx30aasNucFYwrB8jg/q13Lxvai1m0apTrdr8aTWJDBRFZhyMvLXkYCMdc9+2s77l3fFva7DV4cd6O0Y7bXB4jllOcnoceev5tYf8ArPt75Wn/AEOg9E+z9yaohKJ9KuCWhBKkJfDjgST5jJONKlUpNQok1UKpw3oklKQotPJ4qAPUHGthX5f8GwIUKTNhSJKZTim0hkpBBAz1ydZe3GuuLed3vViJHeYaWy22EO45ApTg9umg9MqHuTTaWqfJNxx4LSAovLedShKegHXPbqNPOyF8swptZNz3GpCFNteB6fLUQTyVnjyP5NUzccf9SdS+QM/6o1kQ9zoLVuGLxuO85VTs92sTKK4hsMv051wsqUEAKxxOMhQIPx6UdnQobu0MLzy8R3Oe+fCXpu283opFnWbEosumTX3mVuKLjRRxPJZUMZOfPSntAsO7w0VwDAU88QPytOaDYHlo0eWjQGg9tGg9tBkLdr4Zqv8An2P4betS3NbcC7KE9SKl4vorqkqV4S+KspUFDrj1jWfdybBuqrbp1OpQKHLkQ3XmSh5CQUqAbQD5+sH9WtNaCVnYCyQPtal86/5dZ9vilRrU3BqNPpvMMQn0+D4quR+1SrqfPqdXHe+iXZVp1GVbceoOobadD3oiykAkpxnBHx6kUbba+nqwxJm2/UXSXkKccdHIkZGSST16aBxta86ru3XEWpcxYNMeQt9YiN+Gvk2OScKyemdWq0LHo9kRJUekCRwkrDi/Gc5nIGBjoNcDdG2X3rJfTbFKCamX2+JhNJbc48vfYKcHGO+oR/Q3dL7xr37dX1tBzd0/hPuH5Wr/AEGmTYDpuWPkT3/t0kxoc6Ne8WJV23RMTOaRIQ+eSs805Cs5zrakWkU2G940anxWHcEc2mUpOD5ZA0Ht7jSDK2gteXdC7hdE305UoSzh/CeYUFdsdsjtpird429bklqPWKtGhuuo5oQ6ogqTnGe3r11IM6NUoLE2G8l6M+gONuI7KSexGgS927sqdmWe3U6UWRIVMQyfGRzHEpUT0z8Q0i2bRYm9lMfr12+IZsN4w2vQ1eCnwwkL6jr1ys9dN29tCqlw2K1DpMJ2ZJE5twttDJ4hKwT+8aWNpqjD25tyZTLwkIo02RLMhpmUeKltlCU8hjPTKVD9Gg4ULc24KFuDFsmGYvtRDqaKW0Fs8nPBS4GxlWequPnjVsu60KXetKbptWD/AKO28H0+CvgeQBHfB6YUdZFud41jcmqvUdwvql1RxURbJ6rKnDwKT8eRjVS2y9v7IuWRUr6dnU+luRFMNuz3VFBeKkkJHU9eKVfqOgSN3rQpdlXZGptJD3o7kJD6vGc5nkVrB647YSNMdhbv3Q5W7btxRhegF6PC6Me/8PIR3z3x565O+VfpVxXtEmUiczMjop6G1ONHICgtwkfqI/Xqkx69ZsvbFilUyTTVXI7SER2G2WwHzKLQAAOM8+XnnvoGXeC86rZVtQp9ILAeemBlXjN8xx4KV2yPMDX32lu2p3lZ7lTqpZMhMxbI8FviOICSOmT90dIez9qXQxcs1V3U2YuEYZDQqH9ajxOaewUSM4z+jOljfOVIol+sxaU+7BjmC2stRVlpHIqXk4TgZ6Dr8WgYKXu/dEvdNq3nTC9BVVVRDhjC/DDhT3z3wNdX2R/W1KP8uP8ADVqKLsq8YsE19VKntx0t+lemZxhJHLnyznzznVE2Dddrly1RmruLntNwwpCJai6lKuYGQFZwcaCJgfk/XrRz+3NBs2zE3pShKFXgw0TGfFd5t+IUjunHUe+PTOn2sVbb+gT/AEGqqo0STxSvw3Y6AeJ7H7X4tZYmTazX7ilUymzJktuVJcQxHQ8opWkqPEBOcYxjpoKrZs97e6VKp13cSxTUB9j0MeEeSjxOT1yMDTj7gFk4+1qXzn/l1DIm3e4kFSlQ6JVo5WMKLJ4ZHx4Vr1/0N3T+8a9+3V9bQaB3WZRH2jrbDeeDcVCE59QWgahmzliUa95lXarAkFMVtpTfgO8OqioHPQ+oa8O2c+pTdzaPT6lLlSGFSFIejyHVLQrCFdFJJIPUfu1Wt47WrL8OkCz6Y8hwOO+ke1yQ0SMJ48uOM9c40ET3OtyBal9TKRTQ6IrLbSk+KvkrKkBR6/lOtFWvtBa9u1WDXIIm+mMDmjxH+ScqQUnpj1KOsr16DV6dV3Y1cbktz0pSVpkqKlgEAjJJPljW5on/ANGx+bT/AKDQfbRo0aA0HoNGg9tBKLt3wp1qXRNoj9GlSHIqkguodSArKArsR/ta4v2SdK/F+b+3R/LUx3eQHN4qyhX2qnmQf2Terl7g1i/ecz52vQLf2SVJP/l+b+3R/LR9klSfxemft0fy0x+4PYv3nM+dr0e4PYv3nM+dr0C59klSvxfm/t0fy0/bf7gRdwIM2TGgOxBFcS2Q4sK5ZGc9NTDdTau17UsZ+qUuPIRKQ80gKXIUsYUrB6HXR9jb/YNc+VN/QOg/l1bOzn7wqF3iqxgwiR6d6P4SuXFGFFOe2Tx1/fskqV+L839uj+WrXKjtTIj0V4EtvIU2sDp0Iwf9dTj3BrG+9JnztWgSqjSHN/HUVumvJpTdOT6IpuSC4Vk+/wAgp8uuNeyNvHB2/jt2jJpUmW/R0iGuQ06lKXCjoVAHqAdVW1LMo9lwn4lHadbafc8VYccKzywB3PxDSdeu0tqSodeuB2NJM9TL8oqEhQT4gQVZx6sjtoPRYm8EG+q+ukx6VIjLTHU/4jjqVDCSkYwP97Uv9kd/33pmOn/Ro/iuamtrXVVLOqyqlSHG25KmlMkuNhY4kgnofyDVvsejw95qTIrl4oXInRH/AENpUdRZAbCQvBCe5ytXXQcaxdkqg6u3LoFYihkqjz/ALSuXHKV8c9s+WqzudZEi/LbYpcaY1EW1LTILjiCoEBKk46f737tSWJuTcdD3GjWZCfYTRolVRTGm1MBSwwl0NgFXcnj560dn8v6tBiy/rJkWHXWaXJmNSluxkyAttJSACpScdf8Ad/fp+oG0823qZTL+dqjD0WCy1V1RUtqC1ISkOcAT0zjpnXl9kZ8IUL/DG/4jmvHau5Nx1yTRrMmvsKo0tTNMdbSwErLCsNkBXcHj56B7+ySpI/8AL839uj+WuZULTe30kC7KdKbpbLaRB8CQkuKKke+Ksp6YPiD9Wnb3B7F+85nztenK17Vpdn0lVNpDbjcZTpeIccKzyOAep/INBIl7jRK1BO2bdPeamOt+0wmqWC2FpHh8+PfGU5xrzU6jr2DdXW6k6mqt1FPoiW4w8MoI9/klXl0xpEoXw9sf4+r+MrVS9kf1tOj/AC4/w1aDjT7Nkb3Sf6XU+Y3TGCBE9HkJK1Zb7nKemDy1PNu4hg7v0eIpQWpioloqHYlPIZ/dq57AdNtE/Lnv/bqLWb8OkL/F3PpL0GitwNwIu38GDJkwHZaZTimwGlhPHAznrr32VdbF6W21WWIi4yFurbDbigojicZyNF12VRb1ixmKy0843HWVthtwowSMHtr123bdNtSjIpVLbcRFQtSwHFlZyo5PU6DIlBr7Vr7jtVp5hb7cSW6tTaCAVZ5DoT+XWl9vdzom4D85mNTX4phoQpRdcSrlyJHTH5NZvtSiw7h3TjUqoIUuJJmupcShRSSPfnuPjGtR2lt/QLJdlO0Zl9tUpKUueI8V5CSSO/budBnHfP4Vqn+aY/hJ1XrM3tp9z3DTrfZo8ph2QCgOrdSUjigq7D/d0w3HtRat01p6rVSNJXLdSlKih9SBhIwOg+Ia/NA2itO263Gq9OjSUS4xUW1LkKUBlJSeh+InQPejRo0BoPbRoPbQZC3a+Gar/n2P4berzvc86xtZUnGXFtrDrGFIUQR/Wp8xqDbtfDNV/wA+x/Db1dt8/goqf51j+KnQZT9tqj9/yv2yv569dKqtQVV4YM6SQX2+heV90Pj1yNeyk/2xC/Pt/SGg1Nvx8F0r5Sz9PS37G7+wK78qb+gdMm/HwXSvlLP09Lfsbv7Arvypv6B0E8vCfMRvdMaTLfS37bNjgHFAY5I8s61DW6/S7cp3p9XmIixeYR4iwSOR7DoD6tZVvL4dJv8Ai7f0katO/wD8GivlrP8A7tAn7mIqe41YhVCxVv1OFFYLMhyK4WwhzkVYIUU5OCDpkbvm36Ptiu26tV22a5HpS4j8ZwKK0veGUlJIBBOenfUw2y3WYsGkTIL1JdmmTIDwWl8I4+9CcdQfVpqd2bk7guKu5qtNQm6yfTUxlxystBfXiVBQzj14Gggumi2rUu+vQHZFvQ5j8ZDvBamHggBeAcY5DrgjTNf2zsixLeRVnay1LSqQhjw0xyg++CjnJUfuf36pfscP+5FT/wASP8JGgj52o3BL3jG35hd5cufio5Z9eeXfXkr1tXvbMFE2ssVCJHW4GkuLkZBUQSB0UfIH9Wrw7vdFav02saE6VipCB6R6QMZ8Thy48f04zpm3Lsdy/bcYpTU5ENTUpMjxFNlYOEqTjAI+6/doMtUizbsvCIqoU2nSqgy2ssl3xAcKAB4++Vn+8P169MvbK9qTDeqMihyY7MVBecd8RHvEpGSeis9Pi1pzbSx3LCtx+lOzkTFOylSPES2UAApSnGCT9z+/XfuOkmu21U6Sh0MqmxXI4cKchHJJGceffQY2oEC6bnmORKMZ0x9tvxVoQ+QQnIGeqh5ka01s5Rq3Q7KdiV5h9mYZriwl5YUrgUowc5PqOuftntK/YFdl1F2rNTUvxSwEIYKMe+SrOST9zqpdtBkyv7X30/ddUmw6DKKHJrzrTqHEDIKyQR77PY6oOzdm3NSq9UXLopr6Yy4oS16UtLiefMHoMnrjOu1B3ujTb5btgUJ1C1zzC8cyQQCFlPLHH4u2dVgaDPu7NkXfUr1Mi26ZKVA9GbTmM4ltHMZz05Dr21PEbUbgoeDyKBMS6DyCw6gHPrzy1db83kj2PcZpDtFdlqDCHvFTICB77PTBSfVpxrFzIpNkPXKYhdQ1ETJ8ALAJyAcZx8fq0GS6/Qbztdhl6tNT4bbyihtS5GeRAyR0Udfei2pfdw05FQpMWoSoqlFKXEScAkHr3UDqnSqin2QAFMiNGimln0guOnxw5z97jA44xjOv3HvtrZVn+hkiAuquMZkelNuhkK8T32OJB7du+gUrLsq5LNvKnXHcVLeg0qE4XJMp1SSG0lJTk4JJ6qHl56dNz6g5uRFprNhyXKm9CW4uWmKstltKgAknlxzkpV+rVSuejKvKxpdMaeTFVUGEYcUnlwyUq7DGe2pFGin2PqlS5a/boVj+qSloeB4Xh++yc8s55/F20CF7nG5v4KqfzkfX1riMlSYzSVjCggA59eNcKybpbvO141bbhqipfWtIaUsLI4qKe+B6tJFq73xrou+Jb6KG9HXIWtAeVJCgnilSu3Efc/v0FZ0aNGgNB7aNHloMg7tfDNV/z7H8NvWqbgt+nXPR3aVVWVOxHVJUtCVlBJScjqOvcaz9udtjeVe3Fq9TplFXIhvrbLToebTyw2gHoVA9wdLHuS7k/gST88a+voLr7hlg/gp/5479bX0Z2RsRh9t5ulvhbagpJ9LdPUHI89Qb3JdyfwJJ+eNfX0e5LuT+BJPzxr6+guG/PwXyvlLH0tLfsbf7Brg//wBTf0DqYr2i3HcTxXQpCk+oy2iPp6tGx1pVy06RVma5AVEcfkIW2lTiFcgEkE+9J0DFO2ptGo3A5XJMB1U9x8PqcElwDmCCDgHHkNd25LZpd10r2tq7CnoviJc4pcUg8hnHUdfPXY0g7wUGr3FY5g0SMuRM9KaXwQ4lB4jOTkkD1aDze4ZYPf2qf+eO/W00y47dr2PKZpKSyinQHPRgo8+PBBKc579vPSbspbNetm36lHr8NyM+7KDjaVupWSngBnKSfMaQavt3esndp6rNUp5dLVV0v+L6Q3xLXiAk8eWcYHbGgnty7l3RdtLTTazObfjJcS6EpYQg8gCAcpAPmdfi19xbls+A9Cos1thh13xlpUwheVYAzlQ9QGtF7yWrUbkspuFQqcmRLE1twoQUIPEJWCckgeY15tlLQqls2tPiV+miNIcmlxCVlCyUcEDOUk+YOg5jVj0GRYo3AcirNxmnGsGT4ygn0oN+Lz4Z445jPHGPLUr93O/vwqx8za+rrUN0Qnp1n1mBDa5vvwH2WWxgclKbUAOvQdSNRnZfbu5bavGVMr1HMaKuAtpK1uNrBWVoIGEqJ7A6BF93O/vwqx8za+ro93O/vwqx8za+rp63o27uW5bxizaDRzJiogIaUtDjaAFhayRhSgexGrDa9J9BtKjRJcRtEliCw08gpSSlaUAKGR36g6DMnu539+FWPmbX1dHu538f/FWPmbX1dax9Ejf+g1/kGj0ON97tf5BoJ/a+2lruik3UuC4au6hqet70heC8pIWpXHOPtiTjtr4b0XhWrOoFOlUSShh16UW1lTSV5TwJxhQPmNUwAJAAGAOgA1Lt77Vrd129TY1EgqlvMyy4tKVpThPAjPviPPQZquO5qpdlVNSq76XpXhpb5JbSgcRnHQdPPXdnbq3dUbfcocmoNKgOMhhTYjtg8AAAMgZ8hr7jZrcD8XXPnDP19avo1NRHokBiRGbS83GbQsFIOFBABH6xoMaWtedcs2RIfoslDDkhAQ4VNJcyAcj7YHGrtZNpUfdK22rnuyOqZVXnVsrdQ6pkFCDxSOKCB0Hxa9+9tmVi56RSmaBTBJcZkLW6EKQjAKQB9sRrvbRUCqW3YMenVeKY0tL7q1NlSVYBVkHKSRoJfY26F11HcinW/JntqpxkrYLYjoB4JSrA5AZ/ujVqumyqFebUVutxVvpjFSmgl1TeCoAH7UjPYazRO2hv9dUkvsUB3ip5akKElodCo4P2+vl7ku5P4Ek/O2vr6DVNv2/TrXo7VKpTKmYjSlKQhSysgqJJ6nr3Osr7S/DNSPz7/wDDc0e5LuT+BJPzxr6+mfbHbG8qDuLSKpVKKuPDYW4XXS82rjltYHQKJ7kaDS3lo0aNAaNGjQGjRo0Bo0aNAaNGjQGjRo0Bo0aNAaNGjQGjRo0Bo0aNAaNGjQGjRo0Bo0aNAaNGjQGjRo0Bo0aNAaNGjQf/2Q==" alt=""/></div>'
    });

    var loginName = $("input[name='txtLoginName']").val();
    var password = $("input[name='txtPassword']").val();
    var txtSiteId = $("input[name='txtSiteId']").val();
    var coursesElement = $("#tblDataList").find("a:contains('开始学习')");
    var userData = {'account':loginName, 'password' : password};
    var courses = [];

    for (let i = 0; i < coursesElement.length; i++) {
        var courseElement = $(coursesElement[i]);
        var trElement = courseElement.parent().parent();
        var courseId = courseElement.attr("onclick").split('\'')[1];
        var courseName = trElement.children("td:eq(1)").text();
        courses[i] = {'courseName' : courseName, 'courseId' : courseId, 'state' : '等待学习'};
    }
    layer.confirm('一切已准备就绪，开始自动学习全部课程?（您也可以手动点击某个课程进行学习）', {icon: 3, title:'提示'}, function(index){
        layer.close(index);
        GM_setValue("userData",userData);
        GM_setValue("courses",courses);
        GM_setValue("txtSiteId",txtSiteId);
        window.open(getCoursePage(courses[0].courseId));
    });
}

// 获取课程页面
function getCoursePage(courseId){
    return "http://learning.uestcedu.com/learning3/console/?urlto=http://learning.uestcedu.com/learning3/course/course_learning.jsp?course_id=" + courseId + "&course_name=" + Math.random()
}

// 打开考试确认页面
function examInfo(){
    var win = window.parent.parent.document.getElementById("w_lms_content").contentWindow.document.getElementById("w_sco").contentWindow;
    var contentId = getUrlParam("content_id");
    var datas = window.localStorage.getItem(contentId);  // 试题和答案
    var btnExam = win.document.getElementById("btnExam");
    var lookButton = btnExam.nextSibling.nextSibling;

    if(btnExam.value === '继续考试'){
        autoConfirm(5000, '当前处于考试中，是否继续完成考试?（5秒后无操作，将默认继续考试。注意：部分课程不是选择题，无法自动考试，请自行考试）', function(){
            btnExam.click();
        });
        return;
    }

    var succeedColor = win.document.getElementsByTagName("font")[1].color; // 考试是否通过，绿色就通过
    if(succeedColor == 'green'){
        autoConfirm(3000, '该作业已完成，是否退出?（3秒后无操作，将默认退出）', function(){
            top.window.location.reload();
        });
        return;
    }
    if(lookButton == undefined || datas){
        autoConfirm(10000, '是否开始考试?（10秒后无操作，将默认开始考试。注意：部分课程不是选择题，无法自动考试，请自行考试）', function(){
            // win.frames["w_exam"].location.href = win.$api.fn.getActionURL("com.lemon.learning.exam.StudentExamAction?op=before_exam&exam_id=3163&reexam=" + (win.sExamStatus=="reexamine"?"1":"0")+"&script=parent.afterCheckExam()");
            win.sExamStatus = ''; // 不是重考
            btnExam.click();
        });
    }else{
        lookButton.click();
    }
}

// 考试答题页面
function exam(){
    layer.msg('开始自动做题', {offset: 'b'});
    var contentId = getUrlParam("content_id");
    var datas = window.localStorage.getItem(contentId);  // 试题和答案
    if(datas){
        datas = JSON.parse(datas);
    }
    var dataTr = $("#tblDataList tr");
    for (let i = 0; i < dataTr.length; i++) {
        const dataTrElement = $(dataTr[i]);
        var item = dataTrElement.find("table[isitem='1']"); // 题目table
        var timu = $(item.find("tr td")[0]).html(); // 题目内容
        console.log(timu);

        var temoption = item.find("table[isitemoption='1']"); // 答案table
        var optiontype = temoption.attr("optiontype"); // 答案类型，单选：radio， 多选：
        var tds = temoption.find("tr td");
        var input = $(tds[0]); // 答题input

        if(!datas){
            // 目前还没有答案
            $(tds.find("input")[0]).attr("checked", "checked"); // 全部选择A选项
        }else{
            // 有答案了
            for (const data of datas) {
                if(data.timu === timu){
                    var temoption = item.find("table[isitemoption='1']"); // 答案选项
                    var answersElement = temoption.find("label"); // 可选择的答案
                    for (let j = 0; j < answersElement.length; j++) {
                        const $answer = $(answersElement[j]);
                        for (const answer of data.answer) {
                            if(answer == $answer.html()){
                                var $input = $answer.parent().prev().prev().find("input")
                                $input.attr("checked", "checked")
                            }
                        }
                    }
                }
            }
            // 填写后，清楚已保存的答案。避免下次重考答案是错的
            window.localStorage.removeItem(contentId);
        }
    }

    layer.msg('正在等待提交试卷中\t(需要15秒时间等待，否则提交试卷成绩不作数。\t 如果成绩一直无法更新，可以尝试手动点击重考)', {
        icon: 16,
        shade: 0.3,
        time: -1
    });

    // 交卷
    setTimeout(function() {
        parent.frames["w_right"].doSubmit(true,"console.log('您已经选择交卷，请点击确定退出考试！');");
        // setTimeout(function() {
        //     $("#cboxClose")[0].click()
        // }, 3000);
    }, 15000);
}

// 查看试卷
function viewAnswer(){
    var trs = $("form[name='form1']").find("table tr");
    var testQuestions = []; // 所有题目和答案
    for (let i = 0; i < trs.length; i++) {
        const dataTrElement = $(trs[i]);
        var item = dataTrElement.find("table[isitem='1']"); // 题目table
        var timu = $(item.find("tr td")[0]).html(); // 题目内容
        if(!timu){
            continue;
        }
        var data = {"timu": timu}
        var temoption = item.find("table[isitemoption='1']"); // 答案选项
        var answer = item.find("tr td div:last").text().replace("[参考答案：", "").split("]")[0]; // 正确答案选项
        data.answer = [];
        for (var j=0; j<answer.length; j++){
            var answerText = temoption.find("td:contains('(" +  answer.charAt(j) + ")')").next().find("label").html(); // 正确答案内容
            data.answer.splice(j, 0, answerText);
        }
        testQuestions.splice(i, 0, data);
    }
    console.log(testQuestions);
    var contentId = getUrlParam("content_id");
    window.localStorage.setItem(contentId, JSON.stringify(testQuestions));  // 试题和答案
    //window.history.back(-1);
    autoConfirm(3000, '答案已搜集完毕，是否返回?（3秒后无操作，将默认返回）', function(){
       doReturn();
    });
}

// 修改获取最新学习进度的时间间隔
function updateLoadInterval(){
    console.log("=========修改最新学习的时间间隔==========")
    clearAllInterval();
    window.setInterval("window_onunload()","5000");
    window.onbeforeunload = function(e){
        console.log("=========删除获取学习进度任务==========")
        clearAllInterval();
    }
}

// 删除所有定时任务
function clearAllInterval(){
    for(var i = 1; i < 1000; i++) {
        clearInterval(i);
    }
}

// 课程最少学习时间
function videoProgress(){
    var td = $(".scorm.incomplete").parent();
    var text = td.text();
    text = text.substring(text.indexOf("。最少要求学习")+1, text.length -3);
    var s = text.split("习")[1].split("秒")[0];
    td.parent().parent().append("<tr><td align='center' style='background-color: beige'>挂机插件提醒您：本课程最少需学习：" + secondsFormat(s) +"</td></tr>")
}

// 格式化时间
function secondsFormat( s ) {
    var day = Math.floor( s/ (24*3600) ); // Math.floor()向下取整
    var hour = Math.floor( (s - day*24*3600) / 3600);
    var minute = Math.floor( (s - day*24*3600 - hour*3600) /60 );
    var second = s - day*24*3600 - hour*3600 - minute*60;
    return day + "天"  + hour + "时" + minute + "分" + second + "秒";
}

// 查找未学习的课程
function startLookCurriculum(){
    setTimeout(function(){
        console.log("查找还未读完的课程")
        layer.msg('查找还未读完的课程', {offset: 'b'});
        if($("#frame_user_score").length == 0){
            // 课程没有被确认过
            autoConfirm(10000, '加载课程可能发生失败，是否尝试重新加载?（10秒后无操作，将默认重新加载，如一直无法加载成功，请检查网站本身是否正常，也可联系作者查看）', function(){
               enterCourse(getUrlParam("course_id"));
            });
            return;
        }
        var success = false;
        var divs = $(".scorm.incomplete,.notattempt");
        for(var i = 0; i < divs.length; i++) {
            var a = $(divs[i]).parent().parent().find("a");
            var href = a.attr("href");
            //if(href && href.indexOf("scorm_content") != -1){
            if(href){
                success = true;
                window.top.localStorage.setItem("scanLearningProgress", "true"); // 开始监控
                a[0].click();
                break;
            }
        }
        if(!success){
            var courses =  GM_getValue("courses") || [];
            var course;
            for(var j = 0; j < courses.length; j++) {
                if(courses[j].state === '等待学习'){
                    course = courses[j];
                    break;
                }
            }
            if(course != undefined){
                course.state = '学习完毕';  // 修改学习状态
                GM_setValue("courses", courses);
                autoConfirm(3000, '本课程已学完，是否自动学习下个课程?（3秒后无操作，将默认学习）', function(){
                    window.top.location.href = getCoursePage(course.courseId);
                });
            }else{
                var retry = setTimeout(function(){
                    startLookCurriculum();
                }, 3000);
                layer.alert('课程已全部学习完毕', {icon: 3, title:'提示'}, function(index){
                    window.clearInterval(retry);
                    layer.close(index);
                });
            }
        }
    }, 5000);
}

// 显示课程目录
function openCoursesDir(currentCourseId){
    var courses =  GM_getValue("courses") || [];
    if(courses.length <= 0){
        return;
    }

    var siteDir = '<ul class="site-dir layui-layer-wrap" style="display: block;">';
    for(var j = 0; j < courses.length; j++) {
        siteDir += '<li><a href="javascript:void(0);" onclick="window.top.location.href = \'' + getCoursePage(courses[j].courseId) + '\'"';
        if(currentCourseId === courses[j].courseId){
            siteDir +=  'class="layui-this"';
        }
        siteDir +=  '>' + courses[j].courseName  + '<em>' + courses[j].state + '</em></a></li>';
    }
    siteDir += '</ul>';

    layer.open({
        type: 1
        ,content: siteDir
        ,skin: 'layui-layer-dir'
        ,area: 'auto'
        ,maxHeight: $(window).height() - 300
        ,title: '课程目录'
        //,closeBtn: false
        ,offset: 'r'
        ,shade: false
        ,success: function(layero, index){
            layer.style(index, {
                marginLeft: -15
            });
        }
    });

}

// 查看视频的页面处理方法
function videoPage(){
    console.log("进入课程页面");
    $(".chapter span:last").click(); // 先点击一下最后一个PPT
}

// 监听课程学习进度
function monitorCourseLearningProgress(){
    if(window.localStorage.getItem("scanLearningProgress") === 'true'){
        console.log("扫描学习情况");
        layer.msg('扫描学习情况', {offset: 'b'});
        try{
            var aa = window.document.getElementsByTagName('iframe')[1].contentWindow.document.getElementsByTagName('frame')[1].contentWindow.document.getElementsByTagName('td')[1].innerText;
            if((aa.indexOf("学习完毕")!= -1) || (aa.indexOf("你已累计获取10.00分")!= -1)){
                console.log("学习完毕")
                window.localStorage.setItem("scanLearningProgress", "false")
                autoConfirm(3000, '学习完毕，是否自动学习下一节课?（3秒后无操作，将默认学习）', function(){
                    window.location.reload();
                });
            }else{
                window.errorCount = window.errorCount || 0; // 错误次数计数器
                if(aa === window.txtInfo){
                    console.log("第" + ++window.errorCount + "次检测到学习时间没发生变化：" + aa)
                    if(window.errorCount > 10){
                        window.localStorage.setItem("scanLearningProgress", "false")
                        window.location.reload();
                    }
                }else{
                    window.errorCount = 0;
                }
                window.txtInfo = aa;
            }
        }catch(err){}
    }
}

// 自动确认
function autoConfirm(time, content, fun, fun2){
    var timeoutIndex = setTimeout(function(){
        window.clearInterval(timeoutIndex);
        fun();
    }, time);
    layer.confirm(content, {icon: 3, title:'提示'}, function(index){
        window.clearInterval(timeoutIndex);
        fun();
    }, function(index){
        window.clearInterval(timeoutIndex);
        if(fun2 != undefined){
            fun2();
        }
    });
}

// 监听登录状态
function monitorLogin(){
    console.log("监听登录状态");
    layer.msg('监听登录状态', {offset: 'b'});
    if(!validLogin()){
        var userData = GM_getValue("userData");
        if(!userData){
            layer.confirm('无效登录状态。本地没有您的账号信息，无法完成自动登录，需要进行手动登录?', {icon: 3, title:'提示'}, function(index){
                window.location.href = "https://student.uestcedu.com/console/";
            });
        }else{
            layer.msg('无效登录状态，正在尝试自动登录', {offset: 'b'});
            login(userData);
            window.location.reload();
        }
    }
    setTimeout(monitorLogin, 1000 * 60); // 1分监听一次登录状态
}

// 校验网络学习平台登录状态
function validLogin(){
    var login = true;
    $.ajax({
        url: "http://learning.uestcedu.com/learning3/json/login_info.jsp",
        async: false,
        dataType:"json",
        success:function(data){
            if(data.username === ''){
                console.log("无效登录状态");
                login = false;
            }else{
                layer.msg('当前登录状态有效', {offset: 'b'});
            }
        }
    })
    return login;
}

// 登录网络学习平台
function login(userData){
    $.ajax({
        url: "http://learning.uestcedu.com/learning3/servlet/com.lemon.web.ActionServlet?handler=com%2euestc%2euser%2eUserLoginAction&op=login&type=to_learning&op=execscript&urlto=&script=parent.afterAction()&_no_html=1&" + Math.random(),
        headers : {
            'Referer': 'http://learning.uestcedu.com/learning3/'
        },
        type: "POST",
        data: {
            "txtLoginName": userData.account,
            "txtPassword": userData.password,
            "txtCourseId": "2894",
            "ran": "0.3607649358110765"
        },
        success:function(data){
            console.log(data);

            var body = document.getElementsByTagName("body");
            var div = document.createElement("div");
            div.innerHTML = '<iframe id="idFrame" name="idFrame" src="http://learning.uestcedu.com/learning3/" height = "0" width = "0" frameborder="0" scrolling="auto" style = "display:none;visibility:hidden" ></iframe>';
            document.body.appendChild(div)
        }
    })
}

// 获取当前窗口相对路径
function GetUrlRelativePath(){
    var url = document.location.toString();

    var arrUrl = url.split("//");

    var start = arrUrl[1].indexOf("/");

    var relUrl = arrUrl[1].substring(start);//stop省略，截取从start开始到结尾的所有字符

    if(relUrl.indexOf("?") != -1){

        relUrl = relUrl.split("?")[0];

    }
    return relUrl;
}

//获取url中的参数
function getUrlParam(name) {
    var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)"); //构造一个含有目标参数的正则表达式对象
    var r = window.location.search.substr(1).match(reg);  //匹配目标参数
    if (r != null) return unescape(r[2]); return null; //返回参数值
}

// 进入课程
function enterCourse(txtCourseId){
    $.ajax({
        url: "http://learning.uestcedu.com/learning3/course/enter_in_course.jsp?" + Math.random(),
        headers : {
            'Referer': 'http://learning.uestcedu.com/learning3/uestc_login.jsp?' + Math.random()
        },
        type: "POST",
        data: {
            "txtLoginName": "userData.account",
            "txtPassword": "userData.password",
            "txtCourseId": txtCourseId,
            "txtUserType": "student",
            "txtClassId": "txtClassName",
            "txtSiteId": GM_getValue("txtSiteId")
        },
        success:function(data){
            window.top.location.href = getCoursePage(txtCourseId);
        }
    })
}
