<?php
/*
Plugin Name: 大漠图片本地化
Version: 2.0
Plugin URL: http://www.idamo.top/
Description: 大漠图片本地化
Author: 大漠资源网
Author URL: http://www.idamo.top/
*/
ini_set('max_execution_time', 60);

include('getImage.php');

function img2local($logid) {
    global $logData;
    $Log_Model = new Log_Model();
    $isImg2local = isset($_POST['img2local']) ? trim($_POST['img2local']) : false;
    if(!$isImg2local) { return; }
	$logData['content'] = stripslashes($logData['content']);
	$logData['content'] = preg_replace_callback("/<a([^>]+)href=\"([^>\"]+)\"?([^>]*)><img([^>]+)src=\"([^>\"]+)\"?([^>]*)>/i","aandimage2local", $logData['content']);
    $logData['content'] = preg_replace_callback("/<img([^>]+)src=\"([^>\"]+)\"?([^>]*)>/i","image2local", $logData['content']);
	$logData['content'] = addslashes($logData['content']);
    $Log_Model->updateLog($logData,$logid);
}
addAction('save_log', 'img2local');

/**
 * Author: DYBOY
 * Email: dyboy2017@qq.com
 * webseite: http://www.top15.cn
 */
function image2local($matches)
{
	$url = parse_url($matches[2]);
	$host = $_SERVER['HTTP_HOST'];
	$domain = BLOG_URL;
	// 当请求的url和当前网站域名不一致时候，才本地化
	if(isset($url['host']) && $url['host'] != $host) {
		// 图片文件名
		$imgName = md5(addslashes($matches[2])).'.jpg';
		// 保存网络图片
		// 保存图片的文件夹
		$uppath = '../content/top15img/'.gmdate('Ym') . '/';
		$fname = md5($imgName.gmdate('YmdHis'))  .'.jpg';
		$save_img_url = getImage($matches[2], $uppath, $fname, 0, $domain);
		
		return "<img{$matches[1]}src=\"{$save_img_url}\"{$matches[3]}>";
	} else {
		return "<img{$matches[1]}src=\"{$matches[2]}\"{$matches[3]}>";
	}
}

function aandimage2local($matches) {
	$url = parse_url($matches[5]);
	$host = $_SERVER['HTTP_HOST'];
	$domain = BLOG_URL;
	// 当请求的url和当前网站域名不一致时候，才本地化
	if(isset($url['host']) && $url['host'] != $host) {
		// 图片文件名
		$imgName = md5(addslashes($matches[5])).'.jpg';
		// 保存网络图片
		// 保存图片的文件夹
		$uppath = '../content/top15img/'.gmdate('Ym') . '/';
		$fname = md5($imgName.gmdate('YmdHis'))  .'.jpg';
		$save_img_url = getImage($matches[5], $uppath, $fname, 0, $domain);
		
		return "<a{$matches[1]}href=\"{$save_img_url}\"{$matches[3]}><img{$matches[4]}src=\"{$save_img_url}\"{$matches[6]}>";
	} else {
		return "<a{$matches[1]}href=\"{$matches[2]}\"{$matches[3]}><img{$matches[4]}src=\"{$matches[5]}\"{$matches[6]}>";
	}
}

function img2local_option()
{
?>
<input type="checkbox" value="1" name="img2local" checked="checked" />图片本地化（<span style="color:red;">仅将远程图片保存到自己服务器</span>）
<?php
}
addAction('adm_writelog_head', 'img2local_option');