<?php
/*
 *功能：php完美实现下载远程图片保存到本地
 *参数：文件url,保存文件目录,保存文件名称，使用的下载方式
 *当保存文件名称为空时则使用远程文件原来的名称
 */

function getImage($url, $save_dir = 'img/', $filename = 'error.png', $type = 0, $domain = 'http://www.top15.cn/')
{
    if (trim($url) == '') {
        return 'https://api.top15.cn/static/img/errorImg.png';
    }
    if (trim($save_dir) == '') {
        $save_dir = './';
    }
    if (trim($filename) == '') { //保存文件名
        $ext = strrchr($url, '.');
        if ($ext != '.gif' && $ext != '.jpg') {
            return 'https://api.top15.cn/static/img/errorImg.png';
        }
        $filename = time() . $ext;
    }
    if (0 !== strrpos($save_dir, '/')) {
        $save_dir .= '/';
    }
    //创建保存目录
    if (!file_exists($save_dir) && !mkdir($save_dir, 0777, true)) {
        return 'https://api.top15.cn/static/img/errorImg.png';
    }
    //获取远程文件所采用的方法
    if ($type) {
        $ch = curl_init();
        $timeout = 12;
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $timeout);
        $img = curl_exec($ch);
        curl_close($ch);
    } else {
        $img = file_get_contents($url);
    }
    $save_ok = file_put_contents($save_dir . $filename, $img);
    if($save_ok) {
        $save_dir = substr($save_dir, 3);
        return $domain . $save_dir . $filename;
    } else {
        return 'https://api.top15.cn/static/img/qq.png';
    }
}
