var host = require("../../host");
var expect = require("expect.js");


function testService(){
    return "test";
}

describe("test host",function(){
    beforeEach(function(){
        host.clearRegisters();
    })

    it("should register service successful",function(){
        host.register("testService",testService);
        expect(!!host.getServiceByName("testService")).to.be(true);
    })

    it("should return error when register a service that has been registered",function(){
        host.register("testService",testService);
        var err = host.register("testService",testService);
        expect(err.message).to.be("service has been registered:testService");
    })

    it("should correctly run when sub window call the register service",function(done){
        var test = "";
        function testService(){
            test =  "test";
        }
        var gui = window._require('nw.gui');
        var new_win = gui.Window.open('./client.html');
        host.register("testService",testService);
        new_win.on("loaded",function(){
            expect(test).to.be("test");
            done();
        })
    })


})