"use strict";

var fs = require('fs-extra');
var path = require('path');
var tmp = require('tmp');
var Download = require('@ali/ding-download').Download;
var version = require('../package.json').version;
var appRemoteUrl = require('../package.json').appRemoteUrl.replace('%version%', version);
var spawn = require('child_process').spawn;

console.log(appRemoteUrl);

tmp.dir(function(err, zipTmpPath){

    var tmpFilePath = path.join(zipTmpPath, 'result.zip');

    var d = new Download(appRemoteUrl, tmpFilePath);

    setTimeout(function(){
        console.log(tmpFilePath);
    },10000);
    d.addListener(d.EventsName.finish, function(){
        unzipFile(tmpFilePath, path.join(__dirname, '../bin/'))
    })
    d.addListener(d.EventsName.error, function(err){
        console.log(err);
    })
})

function unzipFile(zipfile, destPath) {
    var unzip = spawn('ditto', ['-x', '-k', zipfile, destPath]);
}
