function SearchResult() {
	this.docs_found = 0;
	this.docs_return = 0;
	this.table_result = [];
}

function TableResult() {
	this.db_name = "";
	this.table_name = "";
	this.key_field = "";
	this.docs_found = 0;
	this.docs_return = 0;
	this.row_result = [];
}

function RowResult() {
	this.pkey = 0;
	this.field_id = 0;
}

SearchResult.prototype.parseSearchResult = function(search_result) {
	var search_result_object = JSON.parse(search_result);
	this.docs_found = search_result_object['docs_found'];
	this.docs_return = search_result_object['docs_return'];
	var table_result_array = search_result_object['table_result'];
	for (var j = 0; j < table_result_array.length; ++j) {
		var table_result_object = table_result_array[j];
		var tableResult = new TableResult();
		tableResult.db_name = table_result_object['db_name'];
		tableResult.table_name = table_result_object['table_name'];
		tableResult.key_field = table_result_object['key_field'];
		tableResult.docs_found = table_result_object['docs_found'];
		tableResult.docs_return = table_result_object['docs_return'];
		var row_result_array = table_result_object['row_result'];
		for (var i = 0; i < row_result_array.length; ++i) {
			var row_result_object = row_result_array[i];
			var rowResult = new RowResult();
			rowResult.pkey = row_result_object['pkey'];
			rowResult.field_id = row_result_object['field_id'];
			tableResult.row_result.push(rowResult);
		}

		this.table_result.push(tableResult);
	}
}

// {
//   "docs_found": 73,
//   "docs_return": 10,
//   "table_result": [
//     {
//       "db_name": "main",
//       "table_name": "chats",
//       "key_field": "rowid",
//       "docs_found": 73,
//       "docs_return": 10,
//       "row_result": [
//         {
//           "pkey": "41",
//           "field_id": 0
//         },
//         {
//           "pkey": "71",
//           "field_id": 0
//         },
//         {
//           "pkey": "61",
//           "field_id": 0
//         },
//         {
//           "pkey": "51",
//           "field_id": 0
//         },
//         {
//           "pkey": "31",
//           "field_id": 0
//         },
//         {
//           "pkey": "21",
//           "field_id": 0
//         },
//         {
//           "pkey": "11",
//           "field_id": 0
//         },
//         {
//           "pkey": "8",
//           "field_id": 0
//         },
//         {
//           "pkey": "9",
//           "field_id": 0
//         },
//         {
//           "pkey": "7",
//           "field_id": 0
//         }
//       ]
//     }
//   ]
// }

module.exports = SearchResult;