# 接口请求

## 相关配置

我们在 [vue-element-admin](https://panjiachen.github.io/vue-element-admin-site/zh/) 项目对axios配置的基础上，添加了一些增强性的更改与扩展，这些更改都是在 **src/utils/request.js**中完成的。

* 常量配置：
    * **BASE_URL**：接口基础路径，对应后端的context-path配置；
    * **JWT_HEADER_KEY**：登录成功后请求头中携带token的字段，后端默认为**authtoken**；
    * **TOKEN_REFRESH_EXPIRE**：token超时自动刷新的重试间隔时间（分钟），建议设置为 后端设置的登录过期时间的 1/8；

* axios相关配置：
    * 在请求拦截器与响应拦截器中，我们已经对token相关流程以及文件下载和遇到请求异常提示错误消息等做了处理，如果您需要对其进行自定义，更改这些配置即可；

## 接口扩展

我们对axios的默认调用方式进行了一些扩展，主要包括了常用的一些接口请求函数。

* 调用方式如下：
```javascript
import { dibootApi } from '@/utils/request'
async getData() {
  const params = {name: 'xxx'}
  const res = await dibootApi.get(`/test/getData`, params)
  if (res.code === 0) {
    ...
  } else {
    ...
  }
}
// 或
getData() {
  const params = {name: 'xxx'}
  dibootApi.get(`/test/getData`, params).then(res => {
    if (res.code === 0) {
      ...
    } else {
      ...
    }
  })
}
```
* 已有函数：
    * **dibootApi.get**
        * GET方式请求接口，传入 {} 类型对象
    * **dibootApi.post**
        * POST方式请求接口，传入 {} 类型数据
        * 以JSON格式提交
    * **dibootApi.put**
        * PUT方式请求接口，传入 {} 类型数据
        * 以JSON格式提交
    * **dibootApi.delete**
        * DELETE方式请求接口，传入 {} 类型数据
        * 以JSON格式提交
    * **dibootApi.upload**
        * POST方式请求接口，传入 formData 对象
    * **dibootApi.download**
        * GET方式请求接口，传入 {} 类型对象
        * 返回arraybuffer类型数据
    * **dibootApi.postDownload**
        * POST方式请求接口，传入 {} 类型对象
        * 返回arraybuffer类型数据
        * 常用语复杂参数提交导出