# 开始使用diboot-antd-admin

## 新建项目

从Github仓库中clone最新的项目到本地

```bash
git clone https://github.com/dibo-software/diboot-antd-admin my-admin
cd my-admin
```

## 安装依赖

项目根目录下执行以下命令，安装项目所需依赖

```bash
yarn
# OR
npm install
```

## 检查接口前缀与代理配置

对于axios和vue.config.js的devServer的proxy配置中，接口前缀需要与后端一致，项目默认为 /api，如果您的后端context-path也是 /api，那么axios和vue.config.js中的接口前缀不必改动。

默认后端接口端口为8080，如果您的后端端口不是8080，需要更改vue.config.js中关于devServer的proxy配置。

若需更改axios中接口前缀，需在**src/utils/request.js**文件中更改常量BASE_URL的值，如下：

```javascript
const BASE_URL = '/api'
```

若需更改项目接口代理，需更改项目根目录下**vue.config.js**文件中的devServer配置项，如下：

```javascript
devServer: {
  port: 9000,
  proxy: {
    '/api': {
      target: 'http://localhost:8080',
      ws: true,
      changeOrigin: true,
      pathRewrite: {
        '^/api': '/api'
      }
    }
  }
}
```

## 启动项目

执行以下命令启动项目

```bash
yarn serve
# OR
npm run serve
```

运行完成后，点击命令行提示出的地址，打开页面成功，项目启动就完成了。

