/**
 * Created by xiaoqiang on 31/07/2018.
 */
var Store = {
    items: {},
    init: function () {
        var _this = this;
        //let defer = Q.defer();
        return bridge.readFile('store.json').then(function (data) {
            if (data != null) {
                _this.items = JSON.parse(data.toString());
            }
            else {
                _this.flush();
            }
            return Q.promise;
        }, function () {
            _this.flush();
            return Q.promise;
        });
    },
    clean: function () {
        return bridge.deleteFile('store.json');
    },
    getValue: function (key) {
        if (this.items[key]) {
            return this.items[key]['value'];
        }
        return null;
    },
    getTimestamp: function (key) {
        if (this.items[key]) {
            return this.items[key]['timestamp'];
        }
        return null;
    },
    save: function (key, value) {
        this.items[key] = { key: key, value: value, timestamp: (new Date()).getTime() };
        this.flush();
    },
    flush: function () {
        bridge.writeFile('store.json', JSON.stringify(this.items));
    }
};
