/**
 * Created by xiaoqiang on 2018/7/27.
 */
function setupWebViewJavascriptBridge(callback) {
    if (window.WebViewJavascriptBridge) {
        return callback(window.WebViewJavascriptBridge);
    }
    if (window.WVJBCallbacks) {
        return window.WVJBCallbacks.push(callback);
    }
    window.WVJBCallbacks = [callback];
    var WVJBIframe = document.createElement('iframe');
    WVJBIframe.style.display = 'none';
    WVJBIframe.src = 'wvjbscheme://__BRIDGE_LOADED__';
    document.documentElement.appendChild(WVJBIframe);
    setTimeout(function () { document.documentElement.removeChild(WVJBIframe); }, 0);
}
var Bridge = /** @class */ (function () {
    function Bridge() {
    }
    Bridge.prototype.call = function (cmd, param, callback) {
        setupWebViewJavascriptBridge(function (b) {
            b.callHandler(cmd, param, callback);
        });
    };
    Bridge.prototype.listen = function (cmd, callback) {
        setupWebViewJavascriptBridge(function (b) {
            b.registerHandler(cmd, callback);
        });
    };
    Bridge.prototype.writeFile = function (name, data) {
        this.call('save_file', { file: name, data: data }, function () { });
    };
    Bridge.prototype.readFile = function (name) {
        var defer = Q.defer();
        this.call("load_file", name, function (result) {
            if (result == 'null') {
                defer.reject(false);
            }
            else {
                defer.resolve(result);
            }
        });
        return defer.promise;
    };
    Bridge.prototype.deleteFile = function (name) {
        var defer = Q.defer();
        this.call("delete_file", name, function (result) {
            defer.resolve();
        });
        return defer.promise;
    };
    Bridge.prototype.debug = function (msg, prefix) {
        if (prefix === void 0) { prefix = 'Logger'; }
        console.log(msg, prefix);
    };
    Bridge.prototype.error = function (msg, prefix) {
        if (prefix === void 0) { prefix = 'Logger'; }
        console.error(msg, prefix);
    };
    Bridge.prototype.showToast = function (text, timeout) {
        timeout = (timeout == undefined) ? 2000 : timeout;
        $('#toast').html('<span>' + text + '</span>').show().animate({ top: '150px' }, 'fast', 'swing', function () {
            setTimeout(function () {
                $('#toast').animate({ top: '-30px' }, 'fast', 'swing', function () {
                    $(this).hide();
                });
            }, timeout);
        });
    };
    Bridge.prototype.openURL = function (url) {
        bridge.call('open_browser', url, function () { });
    };
    Bridge.prototype.checkUpdate = function (uid) {
        var deffer = Q.defer();
        var url = 'https://www.cutterman.cn/client/checkupdate';
        $.post(url, { app: APP_NAME, version: VERSION_CODE, uid: uid, locale: LC_LANG }, function (result) {
            if (result.errno == 0) {
                if (result.update > 0) {
                    deffer.resolve(result);
                }
                else {
                    deffer.reject("");
                }
            }
        });
        return deffer.promise;
    };
    Bridge.prototype.download = function (pid, name) {
        var deffer = Q.defer();
        var url = IMAGE_URL + '/svg/' + pid + '.svg';
        var xhr = new XMLHttpRequest();
        xhr.open("GET", url, true);
        xhr.addEventListener("load", function () {
            if (xhr.status === 200) {
                //console.log(xhr.response);
                bridge.call('save_file', { file: pid + '.svg', data: xhr.response }, function () {
                    bridge.debug('download svg success');
                    bridge.call('action', { action: 'load', pid: pid, name: name }, function () { });
                    deffer.resolve();
                });
            }
            else {
                deffer.reject('download svg failed');
            }
        }, false);
        xhr.send();
        return deffer.promise;
    };
    return Bridge;
}());
var bridge = new Bridge();
