/**
 * Created by xiaoqiang on 6/24/16.
 */

var Module =  angular.module('PsMirror', []);
Module.controller('RootController', ['$scope', function($s){

    var socket = null;
    $s.documents = {};
    $s.artboard = {};
    $s.timestamp = 0;
    $s.isFullscreen = false;

    function init() {
        socket = io.connect(location.host);
        socket.on('login', function (data) {
            console.log('user login');
            if (data.success == 1) {
                socket.emit('get_document_list', { });
            } else {
                console.log('login failed');
            }
        });
        socket.on('document_list', function (data) {
            $s.artboard = data.documents.current;
            if ($s.artboard.docId != undefined) {
                $s.artboard['path'] = $s.artboard.docId + "_" + $s.artboard.id;
            } else {
                $s.artboard['path'] = $s.artboard.id;
            }
            $s.timestamp = (new Date()).getTime();
            $s.$apply();
        });
    }

    init();

}]);
