/**
 * Created by xiaoqiang on 6/20/16.
 */

var Module =  angular.module('PsMirror', []);
Module.controller('RootController', ['$scope', function($s){
    
    var socket = null;
    $s.documents = {};
    $s.artboard = {};
    $s.isTouch = false;
    $s.timestamp = 0;
    $s.isFullscreen = false;
    
    function init() {
        socket = io.connect('127.0.0.1:42200');
        socket.on('login', function (data) {
            console.log('user login');
            if (data.success == 1) {
                socket.emit('get_document_list', { });
            } else {
                console.log('login failed');
            }
        });
        socket.on('document_list', function (data) {
            console.log(data.documents);
            $s.documents = data.documents;
            $s.artboard = $s.documents.current;
            if ($s.artboard.docId != undefined) {
                $s.artboard['path'] = $s.artboard.docId + "_" + $s.artboard.id;
            } else {
                $s.artboard['path'] = $s.artboard.id;
            }
            $s.timestamp = (new Date()).getTime();
            $s.$apply();
        });
        
    }
    
    $s.select = function (docId, artId) {
        $s.isTouch = !$s.isTouch;
        socket.emit('select_document', {docId: docId, artId: artId});
    };
    
    $s.toggleFullscreen = function () {
        if ($s.isFullscreen) {
            exitFullscreen();
            $('.document-list').show();
        } else {
            $('.document-list').hide();
            fullscreen();
        }
        $s.isFullscreen = !$s.isFullscreen;
    }

    function fullscreen(){
        elem=document.body;
        if(elem.webkitRequestFullScreen){
            elem.webkitRequestFullScreen();
        }else if(elem.mozRequestFullScreen){
            elem.mozRequestFullScreen();
        }else if(elem.requestFullScreen){
            elem.requestFullscreen();
        }else{
            //浏览器不支持全屏API或已被禁用  
        }
    }
    function exitFullscreen (){
        var elem=document;
        if(elem.webkitCancelFullScreen){
            elem.webkitCancelFullScreen();
        }else if(elem.mozCancelFullScreen){
            elem.mozCancelFullScreen();
        }else if(elem.cancelFullScreen){
            elem.cancelFullScreen();
        }else if(elem.exitFullscreen){
            elem.exitFullscreen();
        }else{
            //浏览器不支持全屏API或已被禁用  
        }
    }

    init();
    
}]);
