// ==UserScript==
// @name         超星学习通作业提取助手
// @namespace    139site
// @version      2.1.6
// @description  超星学习通作业提取助手，作业提取，题库,生成Excel，学习助手
// @author       139site
// @connect      cdn.jsdelivr.net
// @match        *://*.chaoxing.com/*
// @match        *://*.edu.cn/*
// @resource     buildcss https://gitee.com/code-139site/speed-pages/raw/master/work_helper/Build.css
// @resource     getInfo https://gitee.com/code-139site/speed-pages/raw/master/work_helper/getInfo.json
// @run-at       document-end
// @grant        unsafeWindow
// @grant        GM_xmlhttpRequest
// @grant        GM_setClipboard
// @grant        GM_addStyle
// @grant        GM_getResourceText
// @license      MIT
// ==/UserScript==

var setting={
	auto:true, //章节任务作业题目是否自动化导出
	autoTime:5E3, //自动化间歇时间
};

{
var helper={
	version:[2,1,5],
	url:location.pathname,
	AZ:{A:0,B:1,C:2,D:3,E:4,F:5,G:6,H:7,I:8,J:9,K:10,L:11,M:12,N:13},
	az:"ABCDEFGHIJKLMNOPQRSTUVWXYZ",
	info:JSON.parse(GM_getResourceText('getInfo')),
	sheetFilter:["id","type","title","answer"],
	sheetHeader:["题号","题型","题目","答案"],
	maxOptionNum:0
}; //容器变量全部存在这里
var buildcss = GM_getResourceText('buildcss');
//去掉字符串内的html标签
String.prototype.toText=function (){
	return this.toString().replace(/<[^>]+>/g,"").replace(/&nbsp;/g," ").replace(/&lt;/g,"<").replace(/&gt;/g,">");
}
}

if( helper.url==="/work/selectWorkQuestionYiPiYue" || helper.url==="/work/record-detail" ){
	errorHelper(helper.info.all.isPop,helper.info.all.popInfo)
	helper.parentElement=document.querySelector(".ZyBottom");
	helper.isAnswer=checkAnswer(helper.parentElement);
	var TiMu=getTiMuList(getTiMu(helper.parentElement));
	helper.TiMu=TiMu;
	if( sessionStorage.working==1 ){ autoGet(helper.TiMu); }
}else if( helper.url==="/exam/test/reVersionPaperMarkContentNew" ){
	helper.parentElement=getExamParent();
	helper.isAnswer=checkAnswer(helper.parentElement[1]);
	var TiMu=getExamTiMuList(getTiMu(helper.parentElement,1));
	helper.TiMu=TiMu;
}else if( helper.url==="/mycourse/studentstudy" && sessionStorage && setting.auto  && ( sessionStorage.clear()  || confirm("是否开始自动化提取题目?") ) ){
	console.log("开始自动化了");
	sessionStorage.setItem("working",1);
}else if( helper.url==="/knowledge/cards" ){
	if( sessionStorage.match===location.search.replace(/\s/g,"") ){
		console.log("执行完毕");
		sessionStorage.removeItem("working");
		sessionStorage.removeItem("match");
		helper.TiMu=autoTiMu();
	}else if( sessionStorage.working ){
		setTimeout(function(){
			sessionStorage.setItem("match",location.search.replace(/\s/g,""));
			window.top.document.querySelector(".orientationright").click();
		},setting.autoTime);
	}
}else if( helper.url==="/widget/pcvote/goStudentVotePage"  && window.pptActive.activeType===42 && window.pptActive.status===2 ){
	var TiMu=getTestAnswer(window.questionlist);
	helper.TiMu=TiMu;
}
window.TiMu?console.log(TiMu):null;
if( helper.TiMu  && helper.TiMu.length ){
	//添加选项展示
	//version 2.1.3
	if( helper.maxOptionNum ){
		helper.sheetFilter.push("空");
		helper.sheetHeader.push("空");
		for(var i =0;i<helper.maxOptionNum;i++){
			helper.sheetFilter.push("option"+i);
			helper.sheetHeader.push("选项"+helper.az[i]);
		}
	}
	showAnswer(helper.TiMu);
}

//自动化程序
function autoGet(TiMu){
	sessionStorage.setItem(enc,JSON.stringify(TiMu));
}

function autoTiMu(){
	var TiMu=[]
	for(var i=0;i<sessionStorage.length;i++){
		var temp=JSON.parse(sessionStorage[sessionStorage.key(i)]);
		for(var j=0;j<temp.length;j++){
			temp[j].id=TiMu.length+1;
			TiMu.push(temp[j]);
		}
	}
	console.log(TiMu);
	return TiMu;
}

//获取题目组
function getTiMuList(TiMuList){
	var TiMu=[];
	for(var i=0;i<TiMuList.length;i++){
		var temp={ id:i+1, static:1, type:TiMuList[i].type };
		temp.titleHTML=getTitle(TiMuList[i],helper.isIn);
		temp.title=temp.titleHTML.toText();
		temp.isTrue=checkTrue(TiMuList[i],helper.isAnswer);
		if ( temp.type==="单选题" || temp.type==="多选题" ){
			temp.optionsHTML=getOptions(TiMuList[i]);
			temp.options=[];
			temp.optionsHTML.forEach(function(e){temp["option"+temp.options.length]=e.toText();temp.options.push(e.toText());});
			//题目组中，最大的选项数是多少
			if(temp.options.length>helper.maxOptionNum){ helper.maxOptionNum=temp.options.length; }
			temp.key=getOptionkey(TiMuList[i],helper.isAnswer);
			temp.answerHTML=getOptionX(temp.optionsHTML,temp.key);
			temp.answer=[];
			temp.answerHTML.forEach(function(e){temp.answer.push(e.toText());});
		}else if( temp.type==="判断题" ){
			temp.answerHTML=getOptionkey(TiMuList[i],helper.isAnswer);
			temp.answer=temp.answerHTML;
		}else if( temp.type==="填空题" ){
			temp.answerHTML=getFillAnswer(TiMuList[i],helper.isAnswer);
			temp.answer=[];
			temp.answerHTML.forEach(function(e){temp.answer.push(e.toText());});
		}else if( temp.type==="简答题" ){
			//version 2.1.3
			temp.answerHTML=getEasy(TiMuList[i],true);
			temp.answer=[];
			temp.answerHTML.forEach(function(e){temp.answer.push(e.toText());});
		}else{
			temp.static=0;
		}
		if( temp.static ){
			delete temp.static;
			if( !temp.isTrue ){ temp.answer="无";temp.answerHTML="无"; }
			TiMu.push(temp)
		}else{
			
		}
	}
	return TiMu;
}

//获取考试题目组
function getExamTiMuList(TiMuList){
	var TiMu=[];
	for(var i=0;i<TiMuList.length;i++){
		var temp={ id:i+1, static:1, type:TiMuList[i].type };
		temp.titleHTML=getExamTitle(TiMuList[i],helper.isIn);
		temp.title=temp.titleHTML.toText();
		temp.isTrue=checkTrue(TiMuList[i],helper.isAnswer,1);
		if ( temp.type==="单选题" || temp.type==="多选题" ){
			temp.optionsHTML=getExamOptions(TiMuList[i]);
			temp.options=[];
			temp.optionsHTML.forEach(function(e){temp["option"+temp.options.length]=e.toText();temp.options.push(e.toText());});
			//题目组中，最大的选项数是多少
			if(temp.options.length>helper.maxOptionNum){ helper.maxOptionNum=temp.options.length; }
			temp.key=getOptionkey(TiMuList[i],helper.isAnswer);
			temp.answerHTML=getOptionX(temp.optionsHTML,temp.key);
			temp.answer=[];
			temp.answerHTML.forEach(function(e){temp.answer.push(e.toText());});
		}else if( temp.type==="判断题" ){
			temp.answerHTML=getOptionkey(TiMuList[i],helper.isAnswer);
			temp.answer=temp.answerHTML;
		}else if( temp.type==="填空题" ){
			temp.answerHTML=getFillAnswer(TiMuList[i],true);
			temp.answer=[];
			temp.answerHTML.forEach(function(e){temp.answer.push(e.toText());});
		}else{
			temp.static=0;
		}
		if( temp.static ){
			delete temp.static;
			if( !temp.isTrue ){ temp.answer="无";temp.answerHTML="无"; }
			TiMu.push(temp)
		}else{
			
		}
	}
	return TiMu;
}

//随堂测验
function getTestAnswer(TiMuList){
	var TiMu=[];
	var typeList={0:"单选题",1:"多选题",2:"填空题",4:"简答题",16:"判断题"};
	for( var i=0;i<TiMuList.length;i++ ){
		var temp={type:typeList[TiMuList[i].type],static:1,id:i+1};
		temp.titleHTML=TiMuList[i].content;
		temp.title=temp.titleHTML.toText();
		if( temp.type==="单选题" || temp.type==="多选题" ){
			//单选题
			temp.optionsHTML=[];
			TiMuList[i].answer.forEach(function(e){ temp.optionsHTML.push(e["content"]); });
			temp.options=[];
			temp.optionsHTML.forEach(function(e){temp["option"+temp.options.length]=e.toText();temp.options.push(e.toText());});
			//题目组中，最大的选项数是多少
			if(temp.options.length>helper.maxOptionNum){ helper.maxOptionNum=temp.options.length; }
			if( TiMuList[i].rightAnswer ){
				temp.key=TiMuList[i].rightAnswer.split("");
				temp.answerHTML=getOptionX(temp.optionsHTML,temp.key);
				temp.answer=[];
				temp.answerHTML.forEach(function(e){temp.answer.push(e.toText());});
			}else{
				temp.answerHTML=temp.answer=["无"];
			}
		}else if( temp.type==="判断题" ){
			// 判断题
			if( TiMuList[i].rightAnswer ){
				temp.answerHTML=temp.answer=TiMuList[i].rightAnswer.split("");
			}else{
				temp.answerHTML=temp.answer=["无"];
			}
		}else if( temp.type==="填空题" ){
			// 填空题
			if( TiMuList[i].rightAnswer ){
				temp.answerHTML=TiMuList[i].rightAnswer.match(/<p>[^>]+<\/p>/g);
				temp.answer=[];
				temp.answerHTML.forEach(function(e){temp.answer.push(e.toText());});
			}else{
				temp.answerHTML=temp.answer=["无"];
			}
		}else if( temp.type==="简答题" ){
			temp.static=0;
		}
		if( temp.static ){
			temp.isTrue=true;
			delete temp.static;
			TiMu.push(temp);
		}
	}
	return TiMu;
}

/* 题型判断,这个是进行题目分析前的工作
* @param{Element}输入题目的父元素
* @param{form} 数字类型，是什么地方的题目
* 0->平时的作业什么的，1->考试的
* @return {Array} 返回数组类型的题目
*/
function getTiMu(parentElement,from=0){
	var TiMu=Array.isArray(parentElement)?parentElement:parentElement.children;
	var TiMuArray=[];
	if( /api=1/.test(location.search) ){
		//题目类型包裹在题目内的情况
		helper.isIn=true;
		for(var i=0;i<TiMu.length;i++){
			var temp=TiMu[i].querySelector(".Zy_TItle").innerText.match(/【.+】/);
			TiMu[i].type=temp?temp[0].replace(/[【】]/g,""):null;
			TiMuArray.push(TiMu[i]);
		}
	}else if( from===1 || parentElement.querySelector(".Cy_TItle1") ){
		//题目类型不在在题目内的情况
		helper.isIn=false;
		var tempType="";
		for(var i=0;i<TiMu.length;i++){
		    if( /[\.、].+（[共题]/.test(TiMu[i].innerText)  && TiMu[i].className!=="TiMu" ){
		        tempType=TiMu[i].innerText.replace(/\s/g,"").match(/[\.、].+（/)[0].replace(/[\.、（]/g,"");
		    }else if( TiMu[i].className==="TiMu" ){
		        TiMu[i].type=tempType;
				TiMuArray.push(TiMu[i]);
		    }
		}
	}
	return TiMuArray;
}

// 选择获取什么类型的答案
function checkAnswer(parentElement){
	var temp1=parentElement.querySelector(".Py_answer")?/正确答案/.test(parentElement.querySelector(".Py_answer").innerText):false;
	var temp2=parentElement.querySelector(".Py_tk")?/正确答案/.test(parentElement.querySelector(".Py_tk").innerText):false;
	if( temp1 || temp2 ){
		return true;
	}else{
		return false;
	}
}

//检测自己的答案正误
function checkTrue(ti,isAnswer,from=0){
	if( isAnswer ){
		return true;
	}else{
		if( from===1 ){
			var temp=ti.querySelector(".font18");
			return temp?temp.innerText.trim()==="0.0"?false:true:false;
		}else{
			return ti.querySelector(".bandui,.cuo")?false:true;
		}
	}
}

//获取题目
function getTitle(ti,isIn){
	var temp=ti.querySelector("div.Zy_TItle ").querySelector("div.clearfix").querySelector("div").innerHTML.trim();
	if( isIn ){
		return temp.replace(/【.+】/,"");
	}else{
		return temp;
	}
}


//获取选项
function getOptions(ti){
	var beforeOptions=ti.querySelector("ul.Zy_ulTop").children;
	var Options=[];
	for(var i=0;i<beforeOptions.length;i++){
		Options.push(beforeOptions[i].querySelector("a").innerHTML.trim());
	}
	return Options;
}

//选择题&判断题 || 考试选择题&判断题
function getOptionkey(ti,isAnswer){
	var reg=isAnswer?/正确答案：[A-Z√×]+/:/我的答案：[A-Z√×]+/;
	var temp=ti.querySelector("div.Py_answer").innerText.replace(/\s/g,"").match(reg);
	return temp?temp[0].replace(/[^A-Z√×]+/,"").split(""):null;
}

//填空题
function getFillAnswer(ti,isAnswer){
	//选择器
	var selector=isAnswer?"div.Py_tk":"div.Py_answer";
    if( helper.url==="/work/record-detail" ){
        var tempList=ti.querySelector(selector).querySelector("div,span").parentElement.querySelectorAll("span.font14");
        console.log(tempList);
    }else{
        var tempList=ti.querySelector(selector).querySelector("div,span").children;
        console.log(tempList);
    }
	var temp=[];
	for(var i=0,length=tempList.length;i<length;i++){
		temp.push(tempList[i].querySelector("div").innerHTML.trim());
	}
	return temp;
}

/*简答题
*version 2.1.3
*/
function getEasy(ti,isAnswer){
	return [ti.querySelector(".Py_tk").querySelector("div,span").children[0].innerHTML.trim()];
}

//获取考试的内容架构
function getExamParent(){
	var tempListBefore=[];
	document.querySelector(".CeYan").querySelectorAll("div.Cy_TItle1").forEach(function(e){tempListBefore.push(e)});
	document.querySelector(".CeYan").querySelectorAll("div.CyBottom").forEach(function(e){tempListBefore.push(e)});
	var tempList=[];
	for( var i=0,lenght=tempListBefore.length/2;i<lenght;i++){
		tempList.push(tempListBefore[i]);
		tempListBefore[i+lenght].querySelectorAll(".TiMu").forEach(function(e){tempList.push(e);});
	}
	return tempList;
}

//获取考试题目
function getExamTitle(ti){
	return ti.querySelector("div.Cy_TItle ").querySelector("div.clearfix").innerHTML.trim().replace(/（\d+.\d+分）/,"");
}

//获取考试选项
function getExamOptions(ti){
	var beforeOptions=ti.querySelector("ul.Cy_ulTop").querySelector("form").querySelectorAll("li");
	var Options=[];
	for(var i=0;i<beforeOptions.length;i++){
		Options.push(beforeOptions[i].querySelector("a").innerHTML.trim());
	}
	return Options;
}

function getOptionX(optionList,keys){
	var temp=[];
	for(var i=0;i<keys.length;i++){
		temp.push(optionList[helper.AZ[keys[i]]]);
	}
	return temp;
}


// 展示答案
function showAnswer(TiMu){
	var showDiv=document.createElement("div");
	        showDiv.innerHTML='<div id="createDiv">'+
	'    <div class="divShow">'+
	'        <table border="1" class="tableShow" cellpadding="0" cellspacing="0">'+
	'            <thead>'+
	'            <tr>'+
	'                <th style="width: 25px; min-width: 25px;">题号</th>'+
	'                <th style="width: 60%; min-width: 130px;">题目</th>'+
	'                <th style="min-width: 130px;">答案</th>'+
	'                <th style="min-width: 50px;">题型</th>'+
	'            </tr>'+
	'            <tr>'+
	'                <td colspan="4" id="helper_notic">'+
	'                </td>'+
	'            </tr>'+
	'            </thead>'+
	'            <tbody id="showTable">'+
	'            <tr>'+
	'                <td colspan="4">'+
	'                    <button id="download_excel">点击下载Excel文档</button>'+
	'                </td>'+
	'            </tr>'+
	'            </tbody>'+
	'        </table>'+
	'    </div>'+
	'</div>';
	        document.body.appendChild(showDiv);
	  //       startScript();
			// createButton();
			GM_addStyle(buildcss);
	        var showTable=document.getElementById("showTable");
			var xu=0;
	        for(var i=0;i<TiMu.length;i++){
	            var tr=document.createElement("tr");
				var temp=TiMu[i];
	            var td="<td>"+(i+1)+"</td><td>"+temp.titleHTML+"</td><td>"+temp.answerHTML+"</td><td>"+temp.type+"</td>";
	            tr.innerHTML=td;
	            showTable.appendChild(tr);
				xu=i;
	        }
			createButton();
			startScript(TiMu);
			if( helper.info.all.version>helper.version ){ document.querySelector("#helper_notic").innerHTML+="<p style='color: red;'>发现一个新版本version-"+helper.info.all.version.join(".")+"，马上去<a style='color: blue;' href='https://greasyfork.org/zh-CN/scripts/404395-%E8%B6%85%E6%98%9F%E5%AD%A6%E4%B9%A0%E9%80%9A%E4%BD%9C%E4%B8%9A%E6%8F%90%E5%8F%96%E5%8A%A9%E6%89%8B'>更新</a></p>"; }
			if( helper.info[helper.version.join(".")].static ){ document.querySelector("#helper_notic").innerHTML+=helper.info[helper.version.join(".")].notic; }
}

function startScript(){
    // JSON转Excel方法加载
    var getScript = document.createElement("script");
    getScript.setAttribute("type", "text/javascript");
    getScript.setAttribute("src", "https://cdn.jsdelivr.net/gh/Mark-Cheng123/Blog/JsonExportExcelmin.js");
    document.body.appendChild(getScript);
// Excel下载
    getScript.onload=function (){
        var download_excel=document.getElementById("download_excel");
        download_excel.style.display="block";
        download_excel.onclick=function(){
            var excelFile={};
            excelFile.fileName = document.title+Date.now();
			excelFile.datas=[
                {
                    sheetData:helper.TiMu,
                    sheetName:"普通题型题目",
                    sheetFilter:helper.sheetFilter,
                    sheetHeader:helper.sheetHeader,
                }
            ];
            var toExcel=new ExportJsonExcel(excelFile);
            toExcel.saveExcel();
        }
    }

}

// 显示隐藏按钮
function createButton(){
		var createDiv=document.getElementById("createDiv");
		var newButton=document.createElement("button");
		newButton.id="midbtn";
		newButton.style.right="-114px";
		newButton.style.top=document.documentElement.clientHeight/2-newButton.style.height/2+"px";
		newButton.innerText="隐藏题目列表";
		newButton.state=true;
		newButton.onclick=function () {
			if(newButton.state){
				newButton.innerText="显示题目列表";
				createDiv.style.display="none";
				newButton.state=false;
			}else{
				newButton.innerText="隐藏题目列表";
				createDiv.style.display="block";
				newButton.state=true;
			}
		}
		document.body.appendChild(newButton);
		newButton.onmouseover=function () {
			moveTo(2,5);
		}
		newButton.onmouseleave=function () {
			moveTo(-114,-5);
		}
		
		var movetoTime;
		function moveTo(end,speed){
			clearInterval(movetoTime);
			movetoTime=setInterval(function () {
				newButton.style.right=parseInt(newButton.style.right)+speed+"px";
				if(( speed<0 && parseInt(newButton.style.right)+speed<=end ) || ( speed>0 && parseInt(newButton.style.right)+speed>=end ) ){newButton.style.right=end+"px";clearInterval(movetoTime);}
			},15);
		}
}

//错误警告系统
function errorHelper(state,info){
	if( state===true ){
		if( info.type===0 ){
			alert(info.info);
			window.open(info.url,"_blank");
		}else if( info.type===1 ){
			confirm(info.info)?window.open(info.url,"_blank"):null;
		}
		return true;
	}
	return false;
}

/*签到系统
* versin 2.1.3 Building
* 未完成
*/
function checkIn(){
	//cookie过于重要，只能保存在局部，防止泄露
	var cookie=document.cookie;
}
