// ==UserScript==
// @name         超星网盘外链助手
// @namespace    ChaoXingHelper
// @version      1.0.0.1
// @description  批量获取图片和mp3外链以及其他文件的分享链接
// @author       福生
// @match        http*://pan-yz.chaoxing.com/*
// @grant        none
// ==/UserScript==
(function () {
    'use strict';
    var div = document.getElementsByClassName('ypActionBar')[0];
    if (div) {
        var download_btn = document.createElement("button");
        download_btn.innerText = '获取链接';
        download_btn.setAttribute('class', 'fl download opt_btn copyBtn');
        download_btn.setAttribute('id', 'copy_direct_url_btn');
        download_btn.setAttribute('onclick', 'res.copy_direct_url();');
        download_btn.setAttribute('data-clipboard-text', '');
        download_btn.setAttribute('data-clipboard-action', 'copy');
        div.append(download_btn);
        document.getElementById('container').setAttribute('onclick', 'document.getElementById(\'copy_direct_url_btn\').setAttribute(\'style\',\'\');');
        res.copy_direct_url = function () {
            function createXmlHttpRequest() {
                try {
                    return new XMLHttpRequest();
                } catch (e) {
                    return new ActiveXObject("Microsoft.XMLHTTP");
                }
            }
            function matchResult(str, list) {
                var count = 0;
                for (var i = 0; i < list.length; i++) {
                    if (str.indexOf(list[i]) > -1) {
                        count++;
                    }
                }
                if (count > 0) {
                    return true;
                } else {
                    return false;
                }
            }
            function getHtml(url) {
                var html = "";
                var xmlHttp = createXmlHttpRequest();
                xmlHttp.open("get", url, false);
                xmlHttp.send();
                if (xmlHttp.readyState == 4 && xmlHttp.status == 200) {
                    html = xmlHttp.responseText;
                }
                return html;
            }
            function copyToClipboard(str) {
                var input = document.createElement('textarea');
                input.value = str;
                document.body.appendChild(input);
                input.select();
                document.execCommand('copy');
                document.body.removeChild(input);
                alert("链接已复制到剪贴板");
            }
            if (res.choosedlen > 0) {
                var failedFilenames = new Array();
                var failedUrlsAmount = 0;
                var succeededUrls = new Array();
                var succeededFilenames = new Array();
                var succeededUrlsAmount = 0;
                var flag = new Array();
                var filenodes = new Array();
                for (var filenode in res.choosed) {
                    filenodes.push(filenode);
                    var shareLink = "https://pan-yz.chaoxing.com/external/m/file/" + filenode;
                    var html_source = getHtml(shareLink);
                    if (html_source != "") {
                        flag.push(html_source.match(/\.(\S*)<\/title>/)[1]);
                        var download_url = html_source.match(/http:\/\/d0.*(?=')/)[0];
                        var filename = res.choosed[filenode]['name'];
                        succeededUrls[succeededUrlsAmount] = download_url;
                        succeededFilenames[succeededUrlsAmount] = filename;
                        succeededUrlsAmount = succeededUrlsAmount + 1;
                    } else {
                        failedFilenames[failedUrlsAmount] = res.choosed[filenode]['name'];
                        failedUrlsAmount = failedUrlsAmount + 1;
                    }
                }
                if (succeededUrlsAmount > 0) {
                    var results = new Array();
                    var str = succeededUrls[0];
                    for (var i = 0; i < succeededUrlsAmount; i++) {
                        str = succeededUrls[i];
                        var imgExt = new Array("png", "jpg", "jpeg", "gif");
                        if (matchResult(flag[i], imgExt)) {
                            var headStr = 'https://p.ananas.chaoxing.com/star3/origin/';
                            var id = str.match(/download\/(\S*)\?fn/)[1];
                            var imgUrl = headStr + id + '.' + flag[i];
                            results.push(imgUrl);
                        } else if (flag[i] == 'mp3') {
                            var id = str.match(/download\/(\S*)\?fn/)[1];
                            var previewUrl = 'https://pan-yz.chaoxing.com/preview/showpreview_' + filenodes[i] + '.html';
                            var html = getHtml(previewUrl);
                            var mp3Url = html.match(/https:\/\/s1.*.mp3/)[0];
                            results.push(mp3Url);
                        } else {
                            results.push(shareLink);
                        };
                    }
                    var finalResult = results.join("\r\n");
                    copyToClipboard(finalResult);
                }
                if (failedUrlsAmount > 0) {
                    alert(failedFilenames.toString() + '的链接请求失败！(不支持文件夹)')
                }
            } else {
                alert('未选中任何文件！');
            }
        }
    }
})
();