@rem
@rem Copyright 2015 the original author or authors.
@rem
@rem Licensed under the Apache License, Version 2.0 (the "License");
@rem you may not use this file except in compliance with the License.
@rem You may obtain a copy of the License at
@rem
@rem      https://www.apache.org/licenses/LICENSE-2.0
@rem
@rem Unless required by applicable law or agreed to in writing, software
@rem distributed under the License is distributed on an "AS IS" BASIS,
@rem WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@rem See the License for the specific language governing permissions and
@rem limitations under the License.
@rem

@if "%DEBUG%" == "" @echo off
@rem ##########################################################################
@rem
@rem  crate-node startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%" == "" set DIRNAME=.
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Resolve any "." and ".." in APP_HOME to make it shorter.
for %%i in ("%APP_HOME%") do set APP_HOME=%%~fi

@rem Add default JVM options here. You can also use JAVA_OPTS and CRATE_NODE_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS=

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if "%ERRORLEVEL%" == "0" goto execute

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto execute

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\main;%APP_HOME%\lib\main;%APP_HOME%\lib\crate-azure-discovery.jar;%APP_HOME%\lib\crate-dns-discovery.jar;%APP_HOME%\lib\es-discovery-ec2.jar;%APP_HOME%\lib\es-repository-url.jar;%APP_HOME%\lib\es-repository-s3.jar;%APP_HOME%\lib\es-repository-azure.jar;%APP_HOME%\lib\es-analysis-common.jar;%APP_HOME%\lib\es-analysis-phonetic.jar;%APP_HOME%\lib\users-4.4.1.jar;%APP_HOME%\lib\ssl-impl-4.4.1.jar;%APP_HOME%\lib\functions-4.4.1.jar;%APP_HOME%\lib\license-4.4.1.jar;%APP_HOME%\lib\lang-js-4.4.1.jar;%APP_HOME%\lib\crate-server.jar;%APP_HOME%\lib\xbean-finder-4.5.jar;%APP_HOME%\lib\crate-dex.jar;%APP_HOME%\lib\es-x-content.jar;%APP_HOME%\lib\crate-pgwire.jar;%APP_HOME%\lib\crate-sql-parser.jar;%APP_HOME%\lib\crate-shared.jar;%APP_HOME%\lib\crate-cli.jar;%APP_HOME%\lib\crate-guice.jar;%APP_HOME%\lib\netty-codec-http-4.1.58.Final.jar;%APP_HOME%\lib\netty-resolver-dns-4.1.58.Final.jar;%APP_HOME%\lib\netty-handler-4.1.58.Final.jar;%APP_HOME%\lib\netty-codec-dns-4.1.58.Final.jar;%APP_HOME%\lib\netty-codec-4.1.58.Final.jar;%APP_HOME%\lib\netty-transport-native-epoll-4.1.58.Final-linux-x86_64.jar;%APP_HOME%\lib\netty-transport-native-unix-common-4.1.58.Final.jar;%APP_HOME%\lib\netty-transport-4.1.58.Final.jar;%APP_HOME%\lib\netty-buffer-4.1.58.Final.jar;%APP_HOME%\lib\netty-resolver-4.1.58.Final.jar;%APP_HOME%\lib\netty-common-4.1.58.Final.jar;%APP_HOME%\lib\lucene-suggest-8.7.0.jar;%APP_HOME%\lib\lucene-analyzers-phonetic-8.7.0.jar;%APP_HOME%\lib\lucene-analyzers-common-8.7.0.jar;%APP_HOME%\lib\lucene-backward-codecs-8.7.0.jar;%APP_HOME%\lib\lucene-grouping-8.7.0.jar;%APP_HOME%\lib\lucene-join-8.7.0.jar;%APP_HOME%\lib\lucene-misc-8.7.0.jar;%APP_HOME%\lib\lucene-queries-8.7.0.jar;%APP_HOME%\lib\lucene-sandbox-8.7.0.jar;%APP_HOME%\lib\lucene-spatial-extras-8.7.0.jar;%APP_HOME%\lib\lucene-spatial3d-8.7.0.jar;%APP_HOME%\lib\lucene-core-8.7.0.jar;%APP_HOME%\lib\spatial4j-0.7.jar;%APP_HOME%\lib\jts-core-1.15.0.jar;%APP_HOME%\lib\log4j-core-2.11.1.jar;%APP_HOME%\lib\log4j-api-2.11.1.jar;%APP_HOME%\lib\jna-5.6.0.jar;%APP_HOME%\lib\t-digest-3.2.jar;%APP_HOME%\lib\HdrHistogram-2.1.9.jar;%APP_HOME%\lib\hppc-0.8.2.jar;%APP_HOME%\lib\azure-storage-8.6.0.jar;%APP_HOME%\lib\azure-keyvault-core-1.0.0.jar;%APP_HOME%\lib\guava-30.0-jre.jar;%APP_HOME%\lib\aws-java-sdk-s3-1.11.789.jar;%APP_HOME%\lib\commons-math3-3.6.1.jar;%APP_HOME%\lib\jackson-dataformat-csv-2.11.0.jar;%APP_HOME%\lib\aws-java-sdk-ec2-1.11.789.jar;%APP_HOME%\lib\aws-java-sdk-kms-1.11.789.jar;%APP_HOME%\lib\aws-java-sdk-core-1.11.789.jar;%APP_HOME%\lib\jackson-dataformat-smile-2.11.0.jar;%APP_HOME%\lib\jackson-dataformat-yaml-2.11.0.jar;%APP_HOME%\lib\jackson-dataformat-cbor-2.11.0.jar;%APP_HOME%\lib\jmespath-java-1.11.789.jar;%APP_HOME%\lib\jackson-databind-2.11.0.jar;%APP_HOME%\lib\jaxb-api-2.2.2.jar;%APP_HOME%\lib\jsr305-3.0.1.jar;%APP_HOME%\lib\httpclient-4.5.12.jar;%APP_HOME%\lib\httpcore-4.4.12.jar;%APP_HOME%\lib\commons-logging-1.1.3.jar;%APP_HOME%\lib\commons-codec-1.10.jar;%APP_HOME%\lib\jackson-annotations-2.11.0.jar;%APP_HOME%\lib\xbean-bundleutils-4.5.jar;%APP_HOME%\lib\slf4j-api-1.6.2.jar;%APP_HOME%\lib\js-20.3.0.jar;%APP_HOME%\lib\regex-20.3.0.jar;%APP_HOME%\lib\truffle-api-20.3.0.jar;%APP_HOME%\lib\graal-sdk-20.3.0.jar;%APP_HOME%\lib\jackson-core-2.11.0.jar;%APP_HOME%\lib\antlr4-runtime-4.9.1.jar;%APP_HOME%\lib\jopt-simple-5.0.2.jar;%APP_HOME%\lib\s2-geometry-library-java-1.0.0.jar;%APP_HOME%\lib\failureaccess-1.0.1.jar;%APP_HOME%\lib\listenablefuture-9999.0-empty-to-avoid-conflict-with-guava.jar;%APP_HOME%\lib\checker-qual-3.5.0.jar;%APP_HOME%\lib\error_prone_annotations-2.3.4.jar;%APP_HOME%\lib\j2objc-annotations-1.3.jar;%APP_HOME%\lib\stax-api-1.0-2.jar;%APP_HOME%\lib\activation-1.1.jar;%APP_HOME%\lib\ion-java-1.0.2.jar;%APP_HOME%\lib\joda-time-2.10.1.jar;%APP_HOME%\lib\commons-lang3-3.5.jar;%APP_HOME%\lib\icu4j-67.1.jar;%APP_HOME%\lib\snakeyaml-1.26.jar;%APP_HOME%\lib\crate-app.jar


@rem Execute crate-node
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %CRATE_NODE_OPTS%  -classpath "%CLASSPATH%" org.elasticsearch.cluster.coordination.NodeToolCli %*

:end
@rem End local scope for the variables with windows NT shell
if "%ERRORLEVEL%"=="0" goto mainEnd

:fail
rem Set variable CRATE_NODE_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
if  not "" == "%CRATE_NODE_EXIT_CONSOLE%" exit 1
exit /b 1

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
