/*
 * Decompiled with CFR 0.152.
 */
package io.crate.license;

import com.google.common.annotations.VisibleForTesting;
import io.crate.license.CryptoUtils;
import io.crate.license.License;
import io.crate.license.LicenseConverter;
import io.crate.license.LicenseData;
import io.crate.license.LicenseKey;
import java.io.IOException;

final class TrialLicense
implements License {
    private final int version;
    private final LicenseData licenseData;

    static LicenseKey createLicenseKey(int version, LicenseData licenseData) {
        return TrialLicense.createLicenseKey(version, LicenseConverter.toJson(licenseData));
    }

    @VisibleForTesting
    static LicenseKey createLicenseKey(int version, byte[] decryptedContent) {
        byte[] encryptedContent = TrialLicense.encrypt(decryptedContent);
        return LicenseKey.encode(License.Type.TRIAL, version, encryptedContent);
    }

    private static byte[] encrypt(byte[] data) {
        return CryptoUtils.encryptAES(data);
    }

    private static byte[] decrypt(byte[] encryptedContent) {
        return CryptoUtils.decryptAES(encryptedContent);
    }

    TrialLicense(int version, byte[] encryptedContent) throws IOException {
        this.version = version;
        this.licenseData = LicenseConverter.fromJson(TrialLicense.decrypt(encryptedContent), version);
    }

    @Override
    public License.Type type() {
        return License.Type.TRIAL;
    }

    @Override
    public int version() {
        return this.version;
    }

    @Override
    public LicenseData licenseData() {
        return this.licenseData;
    }
}

