/*
 * Decompiled with CFR 0.152.
 */
package io.crate.license;

import io.crate.common.unit.TimeValue;
import io.crate.license.License;
import io.crate.license.LicenseKey;
import io.crate.license.SetLicenseRequest;
import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

@Singleton
public class TransportSetLicenseAction
extends TransportMasterNodeAction<SetLicenseRequest, AcknowledgedResponse> {
    @Inject
    public TransportSetLicenseAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("internal:crate:sql/set_license", transportService, clusterService, threadPool, SetLicenseRequest::new, indexNameExpressionResolver);
    }

    protected String executor() {
        return "generic";
    }

    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    protected void masterOperation(Task task, final SetLicenseRequest request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) {
        final LicenseKey metadata = request.licenseMetadata();
        this.clusterService.submitStateUpdateTask("register license with key [" + metadata.licenseKey() + "]", (ClusterStateTaskConfig)new ClusterStateUpdateTask(){

            public ClusterState execute(ClusterState currentState) throws Exception {
                Metadata currentMetadata = currentState.metadata();
                if (TransportSetLicenseAction.ignoreNewTrialLicense(metadata, currentMetadata)) {
                    return currentState;
                }
                Metadata.Builder mdBuilder = Metadata.builder((Metadata)currentMetadata);
                mdBuilder.putCustom("license", (Metadata.Custom)metadata);
                return ClusterState.builder((ClusterState)currentState).metadata(mdBuilder).build();
            }

            public TimeValue timeout() {
                return request.masterNodeTimeout();
            }

            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse((Object)new AcknowledgedResponse(true));
            }

            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }
        });
    }

    protected ClusterBlockException checkBlock(SetLicenseRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    static boolean ignoreNewTrialLicense(LicenseKey newLicenseKey, Metadata currentMetadata) throws Exception {
        LicenseKey previousLicenseKey = (LicenseKey)currentMetadata.custom("license");
        if (previousLicenseKey != null) {
            License newLicense = LicenseKey.decode(newLicenseKey);
            return newLicense.type() == License.Type.TRIAL;
        }
        return false;
    }
}

