/*
 * Decompiled with CFR 0.152.
 */
package io.crate.license;

import io.crate.license.CryptoUtils;
import io.crate.license.License;
import io.crate.license.LicenseConverter;
import io.crate.license.LicenseData;
import io.crate.license.LicenseKey;
import io.crate.types.DataTypes;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.elasticsearch.common.logging.LogConfigurator;
import org.elasticsearch.common.settings.Settings;

public class LicenseTool {
    public static void main(String[] args) throws Exception {
        int maxNodes;
        String issuedTo;
        long expirationDate;
        String keyPath;
        LogConfigurator.configureWithoutConfig((Settings)Settings.EMPTY);
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec keyArg = parser.accepts("key", "Path to private key").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec expirationDateArg = parser.accepts("expiration-date").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec issuedToArg = parser.accepts("issued-to").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec maxNodesArg = parser.accepts("max-nodes").withRequiredArg().ofType(Integer.class);
        try {
            OptionSet optionSet = parser.parse(args);
            keyPath = (String)keyArg.value(optionSet);
            expirationDate = DataTypes.TIMESTAMPZ.implicitCast(expirationDateArg.value(optionSet));
            issuedTo = (String)issuedToArg.value(optionSet);
            maxNodes = (Integer)maxNodesArg.value(optionSet);
            if (maxNodes <= 0) {
                throw new IllegalArgumentException("max-nodes needs to be a positive number");
            }
        }
        catch (Exception e) {
            parser.printHelpOn((OutputStream)System.err);
            System.exit(1);
            return;
        }
        byte[] keyBytes = Files.readAllBytes(Paths.get(keyPath, new String[0]));
        PrivateKey privateKey = KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(keyBytes));
        byte[] licenseData = LicenseConverter.toJson(new LicenseData(expirationDate, issuedTo, maxNodes));
        byte[] encryptedLicenseData = CryptoUtils.crypto("RSA", 1, privateKey, licenseData);
        LicenseKey licenseKey = LicenseKey.encode(License.Type.ENTERPRISE, 2, encryptedLicenseData);
        System.out.println(licenseKey.licenseKey());
    }
}

