/*
 * Decompiled with CFR 0.152.
 */
package io.crate.license;

import io.crate.license.EnterpriseLicense;
import io.crate.license.License;
import io.crate.license.TrialLicense;
import io.crate.license.exception.InvalidLicenseException;
import io.crate.license.exception.LicenseMetadataParsingException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.EnumSet;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class LicenseKey
extends AbstractNamedDiffable<Metadata.Custom>
implements Metadata.Custom {
    public static final String WRITEABLE_TYPE = "license";
    static final int VERSION = 2;
    static final int MAX_LICENSE_CONTENT_LENGTH = 256;
    private String licenseKey;

    public LicenseKey(String licenseKey) {
        this.licenseKey = licenseKey;
    }

    public LicenseKey(StreamInput in) throws IOException {
        this.readFrom(in);
    }

    String licenseKey() {
        return this.licenseKey;
    }

    public static License decode(LicenseKey licenseKey) throws IOException {
        int contentLength;
        int version;
        License.Type type;
        ByteBuffer byteBuffer;
        byte[] keyBytes = Base64.getDecoder().decode(licenseKey.licenseKey());
        try {
            byteBuffer = ByteBuffer.wrap(keyBytes);
            type = License.Type.of(byteBuffer.getInt());
            version = byteBuffer.getInt();
            contentLength = byteBuffer.getInt();
        }
        catch (InvalidLicenseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidLicenseException("The provided license key has an invalid format", e);
        }
        if (contentLength > 256) {
            throw new InvalidLicenseException("The provided license key exceeds the maximum length of 256");
        }
        byte[] contentBytes = new byte[contentLength];
        byteBuffer.get(contentBytes);
        switch (type) {
            case ENTERPRISE: {
                return new EnterpriseLicense(version, contentBytes);
            }
        }
        return new TrialLicense(version, contentBytes);
    }

    static LicenseKey encode(License.Type type, int version, byte[] content) {
        byte[] bytes = new byte[12 + content.length];
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        byteBuffer.putInt(type.value()).putInt(version).putInt(content.length).put(content);
        return new LicenseKey(Base64.getEncoder().encodeToString(bytes));
    }

    public void readFrom(StreamInput in) throws IOException {
        this.licenseKey = in.readString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.licenseKey);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject(WRITEABLE_TYPE).field("license_key", this.licenseKey).endObject();
    }

    public static LicenseKey fromXContent(XContentParser parser) throws IOException {
        String licenseKey = null;
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.FIELD_NAME || !Objects.equals(parser.currentName(), WRITEABLE_TYPE)) {
            throw new LicenseMetadataParsingException("license FIELD_NAME expected but got " + parser.currentToken());
        }
        if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
            throw new LicenseMetadataParsingException("license START_OBJECT expected but got " + parser.currentToken());
        }
        while ((token = parser.nextToken()) == XContentParser.Token.FIELD_NAME) {
            if ("license_key".equals(parser.currentName())) {
                licenseKey = LicenseKey.parseStringField(parser);
                continue;
            }
            throw new LicenseMetadataParsingException("unexpected FIELD_NAME " + parser.currentToken());
        }
        if (parser.currentToken() != XContentParser.Token.END_OBJECT) {
            throw new LicenseMetadataParsingException("expected the license object token at the end");
        }
        if (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            throw new LicenseMetadataParsingException("expected an object token at the end");
        }
        return new LicenseKey(licenseKey);
    }

    private static String parseStringField(XContentParser parser) throws IOException {
        parser.nextToken();
        return parser.textOrNull();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LicenseKey licenseKey = (LicenseKey)((Object)o);
        return Objects.equals(this.licenseKey, licenseKey.licenseKey);
    }

    public int hashCode() {
        return Objects.hash(this.licenseKey);
    }

    public EnumSet<Metadata.XContentContext> context() {
        return EnumSet.of(Metadata.XContentContext.GATEWAY, Metadata.XContentContext.SNAPSHOT);
    }

    public String getWriteableName() {
        return WRITEABLE_TYPE;
    }

    public Version getMinimalSupportedVersion() {
        return Version.V_3_0_1;
    }
}

