/*
 * Decompiled with CFR 0.152.
 */
package io.crate.license;

import io.crate.license.LicenseData;
import java.time.Duration;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public enum LicenseExpiryNotification {
    VALID{

        @Override
        public String message(long millisToExpiration) {
            return LicenseExpiryNotification.LICENSE_VALID;
        }
    }
    ,
    SEVERE{

        @Override
        public String message(long millisToExpiration) {
            if (millisToExpiration >= Duration.ofHours(1L).toMillis()) {
                return String.format(Locale.ENGLISH, LicenseExpiryNotification.LICENSE_NOTIFICATION_TEMPLATE, TimeUnit.MILLISECONDS.toHours(millisToExpiration), "hours");
            }
            if (millisToExpiration >= Duration.ofMinutes(1L).toMillis()) {
                return String.format(Locale.ENGLISH, LicenseExpiryNotification.LICENSE_NOTIFICATION_TEMPLATE, TimeUnit.MILLISECONDS.toMinutes(millisToExpiration), "minutes");
            }
            return String.format(Locale.ENGLISH, LicenseExpiryNotification.LICENSE_NOTIFICATION_TEMPLATE, TimeUnit.MILLISECONDS.toSeconds(millisToExpiration), "seconds");
        }
    }
    ,
    MODERATE{

        @Override
        public String message(long millisToExpiration) {
            return String.format(Locale.ENGLISH, LicenseExpiryNotification.LICENSE_NOTIFICATION_TEMPLATE, TimeUnit.MILLISECONDS.toDays(millisToExpiration), "days");
        }
    }
    ,
    EXPIRED{

        @Override
        public String message(long millisToExpiration) {
            return LicenseExpiryNotification.LICENSE_EXPIRED_MESSAGE;
        }
    };

    public static final String LICENSE_EXPIRED_MESSAGE = "Your CrateDB license has expired. For more information on Licensing please visit: https://crate.io/license-update/?license=expired";
    public static final String LICENSE_NOTIFICATION_TEMPLATE = "Your CrateDB license will expire in %d %s. For more information on Licensing please visit: https://crate.io/license-update";
    public static final String LICENSE_VALID = "Your CrateDB license is valid. Enjoy CrateDB!";

    public static LicenseExpiryNotification of(LicenseData licenseData) {
        long millisToExpiration = licenseData.millisToExpiration();
        if (millisToExpiration < 0L) {
            return EXPIRED;
        }
        if (millisToExpiration < TimeUnit.DAYS.toMillis(1L)) {
            return SEVERE;
        }
        if (millisToExpiration < TimeUnit.DAYS.toMillis(15L)) {
            return MODERATE;
        }
        return VALID;
    }

    public abstract String message(long var1);
}

