/*
 * Decompiled with CFR 0.152.
 */
package io.crate.license;

import io.crate.license.LicenseData;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;

final class LicenseConverter {
    static final String EXPIRY_DATE_IN_MS = "expiryDateInMs";
    static final String ISSUED_TO = "issuedTo";
    private static final String MAX_NUMBER_OF_NODES = "maxNumberOfNodes";

    LicenseConverter() {
    }

    static byte[] toJson(LicenseData licenseData) {
        try {
            XContentBuilder contentBuilder = XContentFactory.contentBuilder((XContentType)XContentType.JSON);
            contentBuilder.startObject().field(EXPIRY_DATE_IN_MS, licenseData.expiryDateInMs()).field(ISSUED_TO, licenseData.issuedTo()).field(MAX_NUMBER_OF_NODES, licenseData.maxNumberOfNodes()).endObject();
            return Strings.toString((XContentBuilder)contentBuilder).getBytes(StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    static LicenseData fromJson(byte[] jsonBytes, int version) throws IOException {
        try (XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, jsonBytes);){
            XContentParser.Token token;
            long expiryDate = Long.MAX_VALUE;
            String issuedTo = null;
            int maxNumberOfNodes = -1;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token != XContentParser.Token.FIELD_NAME) continue;
                String currentFieldName = parser.currentName();
                parser.nextToken();
                if (currentFieldName.equals(EXPIRY_DATE_IN_MS)) {
                    expiryDate = parser.longValue();
                    continue;
                }
                if (currentFieldName.equals(ISSUED_TO)) {
                    issuedTo = parser.text();
                    continue;
                }
                if (!currentFieldName.equals(MAX_NUMBER_OF_NODES)) continue;
                maxNumberOfNodes = parser.intValue();
            }
            if (maxNumberOfNodes == -1) {
                if (version == 1) {
                    maxNumberOfNodes = 10;
                } else if (version == 2) {
                    throw new IllegalStateException("LicenseKey v2 should have a valid value for maxNumberOfNodes");
                }
            }
            LicenseData licenseData = new LicenseData(expiryDate, issuedTo, maxNumberOfNodes);
            return licenseData;
        }
    }
}

