/*
 * Decompiled with CFR 0.152.
 */
package io.crate.license;

import io.crate.license.LicenseData;
import io.crate.license.exception.InvalidLicenseException;

public interface License {
    public Type type();

    public int version();

    public LicenseData licenseData();

    public static enum Type {
        TRIAL(0),
        ENTERPRISE(1);

        private final int value;

        private Type(int value) {
            this.value = value;
        }

        static Type of(int value) {
            switch (value) {
                case 0: {
                    return TRIAL;
                }
                case 1: {
                    return ENTERPRISE;
                }
            }
            throw new InvalidLicenseException("Invalid License Type of value: " + value);
        }

        int value() {
            return this.value;
        }
    }
}

