/*
 * Decompiled with CFR 0.152.
 */
package io.crate.license;

import com.google.common.annotations.VisibleForTesting;
import io.crate.action.FutureActionListener;
import io.crate.license.License;
import io.crate.license.LicenseData;
import io.crate.license.LicenseExpiryNotification;
import io.crate.license.LicenseKey;
import io.crate.license.LicenseService;
import io.crate.license.SetLicenseRequest;
import io.crate.license.TransportSetLicenseAction;
import io.crate.license.TrialLicense;
import io.crate.license.exception.InvalidLicenseException;
import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportService;

public class EnterpriseLicenseService
implements LicenseService,
ClusterStateListener {
    static final long UNLIMITED_EXPIRY_DATE_IN_MS = Long.MAX_VALUE;
    static final int MAX_NODES_FOR_V1_LICENSES = 10;
    private static final int MAX_NODES_FOR_V2_LICENSES = 3;
    private final Logger logger;
    private final TransportService transportService;
    private final TransportSetLicenseAction transportSetLicenseAction;
    private Boolean isBoundToLocalhost = null;
    private final AtomicReference<LicenseData> currentLicense = new AtomicReference();
    private final AtomicBoolean isMaxNumberOfNodesExceeded = new AtomicBoolean(false);

    @Inject
    public EnterpriseLicenseService(TransportService transportService, TransportSetLicenseAction transportSetLicenseAction) {
        this.transportService = transportService;
        this.transportSetLicenseAction = transportSetLicenseAction;
        this.logger = LogManager.getLogger(this.getClass());
    }

    public LicenseService.Mode getMode() {
        return LicenseService.Mode.ENTERPRISE;
    }

    public CompletableFuture<Long> registerLicense(String licenseKey) {
        return this.registerLicense(new LicenseKey(licenseKey));
    }

    private CompletableFuture<Long> registerLicense(LicenseKey licenseKey) {
        FutureActionListener listener = new FutureActionListener(r -> 1L);
        if (EnterpriseLicenseService.verifyLicense(licenseKey)) {
            this.transportSetLicenseAction.execute((TransportRequest)new SetLicenseRequest(licenseKey), (ActionListener)listener);
        } else {
            listener.onFailure((Exception)new InvalidLicenseException("Unable to register the provided license key"));
        }
        return listener;
    }

    static boolean verifyLicense(LicenseKey licenseKey) {
        try {
            License decodedLicense = LicenseKey.decode(licenseKey);
            return !EnterpriseLicenseService.isLicenseExpired(decodedLicense.licenseData());
        }
        catch (IOException e) {
            return false;
        }
    }

    private static boolean isLicenseExpired(@Nullable LicenseData licenseData) {
        return licenseData != null && licenseData.isExpired();
    }

    public LicenseService.LicenseState getLicenseState() {
        if (this.boundToLocalhost()) {
            return LicenseService.LicenseState.VALID;
        }
        if (this.isMaxNumberOfNodesExceeded()) {
            return LicenseService.LicenseState.MAX_NODES_VIOLATED;
        }
        if (EnterpriseLicenseService.isLicenseExpired(this.currentLicense())) {
            return LicenseService.LicenseState.EXPIRED;
        }
        return LicenseService.LicenseState.VALID;
    }

    private boolean boundToLocalhost() {
        if (this.isBoundToLocalhost == null) {
            BoundTransportAddress boundTransportAddress = this.transportService.boundAddress();
            if (boundTransportAddress == null) {
                return false;
            }
            Predicate<TransportAddress> isLoopbackAddress = t -> t.address().getAddress().isLoopbackAddress();
            this.isBoundToLocalhost = Arrays.stream(boundTransportAddress.boundAddresses()).allMatch(isLoopbackAddress) && isLoopbackAddress.test(boundTransportAddress.publishAddress());
        }
        return this.isBoundToLocalhost;
    }

    @Nullable
    public LicenseData currentLicense() {
        return this.currentLicense.get();
    }

    @Nullable
    public ClusterStateListener clusterStateListener() {
        return this;
    }

    boolean isMaxNumberOfNodesExceeded() {
        return this.isMaxNumberOfNodesExceeded.get();
    }

    private LicenseKey getLicenseMetadata(ClusterState clusterState) {
        return (LicenseKey)clusterState.getMetadata().custom("license");
    }

    private void registerTrialLicense(ClusterState clusterState) {
        DiscoveryNodes nodes = clusterState.getNodes();
        if (nodes != null && nodes.isLocalNodeElectedMaster()) {
            LicenseData licenseData = new LicenseData(Long.MAX_VALUE, "Trial-" + clusterState.getClusterName().value(), 3);
            LicenseKey licenseKey = TrialLicense.createLicenseKey(2, licenseData);
            this.registerLicense(licenseKey).whenComplete((ignored, t) -> {
                if (t != null) {
                    this.logger.error("Unable to register license", t);
                }
            });
        }
    }

    public void clusterChanged(ClusterChangedEvent event) {
        ClusterState currentState = event.state();
        if (currentState.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        LicenseKey previousLicenseKey = this.getLicenseMetadata(event.previousState());
        LicenseKey newLicenseKey = this.getLicenseMetadata(currentState);
        if (previousLicenseKey == null && newLicenseKey == null) {
            this.registerTrialLicense(currentState);
        } else if (newLicenseKey != null && !newLicenseKey.equals((Object)previousLicenseKey)) {
            try {
                LicenseExpiryNotification expiryNotification;
                LicenseData licenseData = LicenseKey.decode(newLicenseKey).licenseData();
                if (previousLicenseKey == null) {
                    long expiryDateInMs = licenseData.expiryDateInMs();
                    this.logger.info("License loaded. issuedTo={} maxNodes={} expiration={}", (Object)licenseData.issuedTo(), (Object)licenseData.maxNumberOfNodes(), expiryDateInMs == Long.MAX_VALUE ? "None" : Instant.ofEpochMilli(expiryDateInMs));
                }
                if ((expiryNotification = LicenseExpiryNotification.of(licenseData)) != null) {
                    long millisToExpiration = licenseData.millisToExpiration();
                    if (expiryNotification.equals((Object)LicenseExpiryNotification.EXPIRED)) {
                        this.logger.error(expiryNotification.message(millisToExpiration));
                    } else if (expiryNotification.equals((Object)LicenseExpiryNotification.SEVERE)) {
                        this.logger.error(expiryNotification.message(millisToExpiration));
                    } else if (expiryNotification.equals((Object)LicenseExpiryNotification.MODERATE)) {
                        this.logger.warn(expiryNotification.message(millisToExpiration));
                    }
                }
                this.currentLicense.set(licenseData);
            }
            catch (IOException e) {
                this.logger.error("Received invalid license. Unable to read the license data.");
            }
        }
        this.onUpdatedLicense(currentState, this.currentLicense());
    }

    @VisibleForTesting
    void onUpdatedLicense(ClusterState clusterState, @Nullable LicenseData currentLicense) {
        if (currentLicense == null) {
            this.isMaxNumberOfNodesExceeded.set(false);
        } else {
            this.isMaxNumberOfNodesExceeded.set(clusterState.nodes().getSize() > currentLicense.maxNumberOfNodes());
        }
    }
}

