/*
 * Decompiled with CFR 0.152.
 */
package io.crate.license;

import io.crate.license.CryptoUtils;
import io.crate.license.EnterpriseLicenseService;
import io.crate.license.License;
import io.crate.license.LicenseConverter;
import io.crate.license.LicenseData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.elasticsearch.common.io.Streams;

final class EnterpriseLicense
implements License {
    private final int version;
    private final LicenseData licenseData;

    private static byte[] decrypt(byte[] encryptedContent) {
        return CryptoUtils.decryptRSAUsingPublicKey(encryptedContent, EnterpriseLicense.publicKey());
    }

    private static byte[] publicKey() {
        byte[] byArray;
        block9: {
            InputStream is = EnterpriseLicenseService.class.getResourceAsStream("/public.key");
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                Streams.copy((InputStream)is, (OutputStream)out);
                byArray = out.toByteArray();
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new IllegalStateException(ex);
                }
                catch (NullPointerException e) {
                    throw new IllegalStateException("The CrateDB distribution is missing its public key", e);
                }
            }
            is.close();
        }
        return byArray;
    }

    EnterpriseLicense(int version, byte[] encryptedContent) throws IOException {
        this.version = version;
        this.licenseData = LicenseConverter.fromJson(EnterpriseLicense.decrypt(encryptedContent), version);
    }

    @Override
    public License.Type type() {
        return License.Type.ENTERPRISE;
    }

    @Override
    public int version() {
        return this.version;
    }

    @Override
    public LicenseData licenseData() {
        return this.licenseData;
    }
}

