/*
 * Decompiled with CFR 0.152.
 */
package io.crate.license;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

final class CryptoUtils {
    static final String RSA_CIPHER_ALGORITHM = "RSA";
    private static final int KEY_SIZE = 2048;
    private static final String PASSPHRASE = "crate_passphrase";
    private static final String AES_CIPHER_ALGORITHM = "AES";
    private static final Key AES_KEY_SPEC = new SecretKeySpec("crate_passphrase".getBytes(StandardCharsets.UTF_8), "AES");

    private CryptoUtils() {
    }

    static KeyPair generateRSAKeyPair() {
        try {
            SecureRandom random = new SecureRandom();
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance(RSA_CIPHER_ALGORITHM);
            keyGen.initialize(2048, random);
            return keyGen.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    static byte[] getPublicKeyBytes(PublicKey publicKey) {
        X509EncodedKeySpec encodedKeySpec = new X509EncodedKeySpec(publicKey.getEncoded());
        return encodedKeySpec.getEncoded();
    }

    static byte[] getPrivateKeyBytes(PrivateKey privateKey) {
        PKCS8EncodedKeySpec encodedKeySpec = new PKCS8EncodedKeySpec(privateKey.getEncoded());
        return encodedKeySpec.getEncoded();
    }

    static byte[] encryptAES(byte[] data) {
        return CryptoUtils.crypto(AES_CIPHER_ALGORITHM, 1, AES_KEY_SPEC, data);
    }

    static byte[] decryptAES(byte[] data) {
        return CryptoUtils.crypto(AES_CIPHER_ALGORITHM, 2, AES_KEY_SPEC, data);
    }

    static byte[] decryptRSAUsingPublicKey(byte[] data, byte[] publicKeyBytes) {
        return CryptoUtils.crypto(RSA_CIPHER_ALGORITHM, 2, CryptoUtils.getPublicKey(publicKeyBytes), data);
    }

    private static PublicKey getPublicKey(byte[] publicKeyBytes) {
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(publicKeyBytes);
        try {
            return KeyFactory.getInstance(RSA_CIPHER_ALGORITHM).generatePublic(publicKeySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IllegalStateException(e);
        }
    }

    static PrivateKey getPrivateKey(byte[] privateKeyBytes) {
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(privateKeyBytes);
        try {
            return KeyFactory.getInstance(RSA_CIPHER_ALGORITHM).generatePrivate(privateKeySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IllegalStateException(e);
        }
    }

    static byte[] crypto(String cipherAlgorithm, int mode, Key key, byte[] data) {
        try {
            Cipher cipher = Cipher.getInstance(cipherAlgorithm);
            cipher.init(mode, key);
            return cipher.doFinal(data);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new IllegalStateException(e);
        }
    }
}

