/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.sys.check.cluster;

import io.crate.expression.reference.sys.check.AbstractSysCheck;
import io.crate.expression.reference.sys.check.SysCheck;
import io.crate.license.LicenseData;
import io.crate.license.LicenseExpiryNotification;
import io.crate.license.LicenseService;
import java.time.Duration;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;

@Singleton
public class LicenseCheck
implements SysCheck {
    private static final int ID = 6;
    private final ClusterService clusterService;
    private final LicenseService licenseService;
    private String description = "Your CrateDB license is valid. Enjoy CrateDB!";
    private SysCheck.Severity severity = SysCheck.Severity.LOW;

    @Inject
    public LicenseCheck(LicenseService licenseService, ClusterService clusterService) {
        this.clusterService = clusterService;
        this.licenseService = licenseService;
    }

    public boolean isValid() {
        LicenseData currentLicense = this.licenseService.currentLicense();
        if (currentLicense == null) {
            return true;
        }
        LicenseService.LicenseState licenseState = this.licenseService.getLicenseState();
        switch (licenseState) {
            case VALID: {
                if (currentLicense.millisToExpiration() <= Duration.ofDays(1L).toMillis()) {
                    this.description = this.buildDescription(currentLicense);
                    this.severity = SysCheck.Severity.HIGH;
                    return false;
                }
                if (currentLicense.millisToExpiration() <= Duration.ofDays(15L).toMillis()) {
                    this.description = this.buildDescription(currentLicense);
                    this.severity = SysCheck.Severity.MEDIUM;
                    return false;
                }
                this.description = "Your CrateDB license is valid. Enjoy CrateDB!";
                this.severity = SysCheck.Severity.LOW;
                return true;
            }
            case EXPIRED: {
                this.description = this.buildDescription(currentLicense);
                this.severity = SysCheck.Severity.HIGH;
                return false;
            }
            case MAX_NODES_VIOLATED: {
                this.description = this.buildMaxNodeViolatedDescription(currentLicense, this.clusterService.state().getNodes().getSize());
                this.severity = SysCheck.Severity.HIGH;
                return false;
            }
        }
        throw new AssertionError((Object)("Illegal license state: " + licenseState));
    }

    private String buildDescription(LicenseData license) {
        LicenseExpiryNotification licenseExpiryNotification = LicenseExpiryNotification.of(license);
        return AbstractSysCheck.getLinkedDescription((int)6, (String)licenseExpiryNotification.message(license.millisToExpiration()), (String)"For more information on Cluster Checks please visit: https://cr8.is/d-cluster-check-");
    }

    private String buildMaxNodeViolatedDescription(LicenseData license, int clusterSize) {
        return AbstractSysCheck.getLinkedDescription((int)6, (String)String.format(Locale.ENGLISH, "The license is limited to %d nodes, but there are %d nodes in the cluster. To upgrade your license visit https://crate.io/license-update/", license.maxNumberOfNodes(), clusterSize), (String)"For more information visit: https://cr8.is/d-cluster-check-");
    }

    public CompletableFuture<?> computeResult() {
        return CompletableFuture.completedFuture(null);
    }

    public int id() {
        return 6;
    }

    public String description() {
        return this.description;
    }

    public SysCheck.Severity severity() {
        return this.severity;
    }
}

