/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.hdfs;

import io.crate.analyze.repositories.TypeSettings;
import io.crate.common.SuppressForbidden;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.GenericProperty;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.hdfs.protocolPB.ClientNamenodeProtocolPB;
import org.apache.hadoop.security.KerberosInfo;
import org.apache.hadoop.security.SecurityUtil;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.RepositoryPlugin;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.hdfs.HdfsRepository;
import org.elasticsearch.threadpool.ThreadPool;

public final class HdfsPlugin
extends Plugin
implements RepositoryPlugin {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressForbidden(reason="Needs a security hack for hadoop on windows, until HADOOP-XXXX is fixed")
    private static Void evilHadoopInit() {
        Path hadoopHome;
        block11: {
            String oldValue;
            block10: {
                hadoopHome = null;
                oldValue = null;
                try {
                    hadoopHome = Files.createTempDirectory("hadoop", new FileAttribute[0]).toAbsolutePath();
                    oldValue = System.setProperty("hadoop.home.dir", hadoopHome.toString());
                    Class.forName("org.apache.hadoop.security.UserGroupInformation");
                    Class.forName("org.apache.hadoop.util.StringUtils");
                    Class.forName("org.apache.hadoop.util.ShutdownHookManager");
                    Class.forName("org.apache.hadoop.conf.Configuration");
                    if (oldValue != null) break block10;
                }
                catch (IOException | ClassNotFoundException e) {
                    try {
                        throw new RuntimeException(e);
                    }
                    catch (Throwable throwable) {
                        if (oldValue == null) {
                            System.clearProperty("hadoop.home.dir");
                        } else {
                            System.setProperty("hadoop.home.dir", oldValue);
                        }
                        try {
                            if (hadoopHome == null) throw throwable;
                            Files.delete(hadoopHome);
                            throw throwable;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                System.clearProperty("hadoop.home.dir");
                break block11;
            }
            System.setProperty("hadoop.home.dir", oldValue);
        }
        try {
            if (hadoopHome == null) return null;
            Files.delete(hadoopHome);
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static Void eagerInit() {
        ClassLoader oldCCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(HdfsRepository.class.getClassLoader());
            KerberosInfo info = SecurityUtil.getKerberosInfo(ClientNamenodeProtocolPB.class, null);
            if (info == null) {
                throw new RuntimeException("Could not initialize SecurityUtil: Unable to find services for [org.apache.hadoop.security.SecurityInfo]");
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCCL);
        }
        return null;
    }

    public Map<String, Repository.Factory> getRepositories(final Environment env, final NamedXContentRegistry namedXContentRegistry, final ThreadPool threadPool) {
        return Collections.singletonMap("hdfs", new Repository.Factory(){

            public TypeSettings settings() {
                Map optionalSettings = Map.ofEntries(Map.entry("uri", Setting.simpleString((String)"uri", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope})), Map.entry("security.principal", Setting.simpleString((String)"security.principal", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope})), Map.entry("path", Setting.simpleString((String)"path", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope})), Map.entry("load_defaults", Setting.boolSetting((String)"load_defaults", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope})), Map.entry("compress", Setting.boolSetting((String)"compress", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope})), Map.entry("chunk_size", Setting.simpleString((String)"chunk_size", (Setting.Property[])new Setting.Property[0])));
                return new TypeSettings(Map.of(), optionalSettings){

                    public GenericProperties<?> dynamicProperties(GenericProperties<?> genericProperties) {
                        if (genericProperties.isEmpty()) {
                            return genericProperties;
                        }
                        GenericProperties dynamicProperties = new GenericProperties();
                        for (Map.Entry entry : genericProperties.properties().entrySet()) {
                            String key = (String)entry.getKey();
                            if (!key.startsWith("conf.")) continue;
                            dynamicProperties.add(new GenericProperty(key, entry.getValue()));
                        }
                        return dynamicProperties;
                    }
                };
            }

            public Repository create(RepositoryMetadata metadata) throws Exception {
                return new HdfsRepository(metadata, env, namedXContentRegistry, threadPool);
            }
        });
    }

    static {
        AccessController.doPrivileged(HdfsPlugin::evilHadoopInit);
        AccessController.doPrivileged(HdfsPlugin::eagerInit);
    }
}

