/*
 * Decompiled with CFR 0.152.
 */
package io.crate.beans;

import io.crate.beans.ConnectionsMBean;
import io.crate.protocols.ConnectionStats;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.elasticsearch.http.HttpStats;

public final class Connections
implements ConnectionsMBean {
    public static final String NAME = "io.crate.monitoring:type=Connections";
    private final Supplier<HttpStats> httpStats;
    private final Supplier<ConnectionStats> psqlStats;
    private final LongSupplier transportConnections;

    public Connections(Supplier<HttpStats> httpStats, Supplier<ConnectionStats> psqlStats, LongSupplier transportConnections) {
        this.httpStats = httpStats;
        this.psqlStats = psqlStats;
        this.transportConnections = transportConnections;
    }

    @Override
    public long getHttpOpen() {
        HttpStats httpStats = this.httpStats.get();
        return httpStats == null ? 0L : httpStats.getServerOpen();
    }

    @Override
    public long getHttpTotal() {
        HttpStats httpStats = this.httpStats.get();
        return httpStats == null ? 0L : httpStats.getTotalOpen();
    }

    @Override
    public long getPsqlOpen() {
        return this.psqlStats.get().open();
    }

    @Override
    public long getPsqlTotal() {
        return this.psqlStats.get().total();
    }

    @Override
    public long getTransportOpen() {
        return this.transportConnections.getAsLong();
    }
}

