/*
 * Decompiled with CFR 0.152.
 */
package io.crate.scalar.systeminformation;

import io.crate.data.Input;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.scalar.UsersScalarFunctionModule;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import javax.annotation.Nullable;

public class UserFunction
extends Scalar<String, Object> {
    public static final String CURRENT_USER_FUNCTION_NAME = "current_user";
    public static final String SESSION_USER_FUNCTION_NAME = "session_user";
    private final Signature signature;
    private final Signature boundSignature;

    public static void register(UsersScalarFunctionModule module) {
        module.register(Signature.scalar((String)CURRENT_USER_FUNCTION_NAME, (TypeSignature[])new TypeSignature[]{DataTypes.STRING.getTypeSignature()}), UserFunction::new);
        module.register(Signature.scalar((String)SESSION_USER_FUNCTION_NAME, (TypeSignature[])new TypeSignature[]{DataTypes.STRING.getTypeSignature()}), UserFunction::new);
    }

    public UserFunction(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    public Signature signature() {
        return this.signature;
    }

    public Signature boundSignature() {
        return this.boundSignature;
    }

    public String evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object> ... args) {
        assert (args.length == 0) : "number of args must be 0";
        return txnCtx.sessionSettings().userName();
    }

    public Symbol normalizeSymbol(Function symbol, @Nullable TransactionContext txnCtx, NodeContext nodeCtx) {
        if (txnCtx == null) {
            return Literal.NULL;
        }
        return Literal.of((String)txnCtx.sessionSettings().userName());
    }
}

