/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.http;

import com.google.common.annotations.VisibleForTesting;
import io.crate.auth.AuthSettings;
import io.crate.auth.Authentication;
import io.crate.auth.AuthenticationMethod;
import io.crate.auth.Protocol;
import io.crate.auth.user.User;
import io.crate.common.collections.Tuple;
import io.crate.protocols.SSL;
import io.crate.protocols.http.Headers;
import io.crate.protocols.postgres.ConnectionProperties;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.util.Locale;
import javax.annotation.Nullable;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.http.netty4.Netty4HttpServerTransport;

public class HttpAuthUpstreamHandler
extends SimpleChannelInboundHandler<Object> {
    private static final Logger LOGGER = LogManager.getLogger(HttpAuthUpstreamHandler.class);
    @VisibleForTesting
    static final String WWW_AUTHENTICATE_REALM_MESSAGE = "Basic realm=\"CrateDB Authenticator\"";
    private final Authentication authService;
    private final Settings settings;
    private String authorizedUser = null;

    public HttpAuthUpstreamHandler(Settings settings, Authentication authService) {
        super(false);
        this.settings = settings;
        this.authService = authService;
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            this.handleHttpRequest(ctx, (HttpRequest)msg);
        } else if (msg instanceof HttpContent) {
            this.handleHttpChunk(ctx, (HttpContent)msg);
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    private void handleHttpRequest(ChannelHandlerContext ctx, HttpRequest request) {
        SSLSession session = SSL.getSession((Channel)ctx.channel());
        Tuple<String, SecureString> credentials = HttpAuthUpstreamHandler.credentialsFromRequest(request, session, this.settings);
        String username = (String)credentials.v1();
        SecureString password = (SecureString)credentials.v2();
        if (username.equals(this.authorizedUser)) {
            ctx.fireChannelRead((Object)request);
            return;
        }
        InetAddress address = this.addressFromRequestOrChannel(request, ctx.channel());
        ConnectionProperties connectionProperties = new ConnectionProperties(address, Protocol.HTTP, session);
        AuthenticationMethod authMethod = this.authService.resolveAuthenticationType(username, connectionProperties);
        if (authMethod == null) {
            String errorMessage = String.format(Locale.ENGLISH, "No valid auth.host_based.config entry found for host \"%s\", user \"%s\", protocol \"%s\"", address.getHostAddress(), username, Protocol.HTTP.toString());
            HttpAuthUpstreamHandler.sendUnauthorized(ctx.channel(), errorMessage);
        } else {
            try {
                User user = authMethod.authenticate(username, password, connectionProperties);
                if (user != null && LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Authentication succeeded user \"{}\" and method \"{}\".", (Object)username, (Object)authMethod.name());
                }
                this.authorizedUser = username;
                ctx.fireChannelRead((Object)request);
            }
            catch (Exception e) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Password authentication failed for user={} from connection={}", (Object)username, (Object)connectionProperties.address());
                }
                HttpAuthUpstreamHandler.sendUnauthorized(ctx.channel(), e.getMessage());
            }
        }
    }

    private void handleHttpChunk(ChannelHandlerContext ctx, HttpContent msg) {
        if (this.authorizedUser == null) {
            msg.release();
            HttpAuthUpstreamHandler.sendUnauthorized(ctx.channel(), null);
        } else {
            ctx.fireChannelRead((Object)msg);
        }
    }

    @VisibleForTesting
    static void sendUnauthorized(Channel channel, @Nullable String body) {
        DefaultFullHttpResponse response;
        if (body != null) {
            if (!((String)body).endsWith("\n")) {
                body = (String)body + "\n";
            }
            response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.UNAUTHORIZED, Unpooled.copiedBuffer((CharSequence)body, (Charset)StandardCharsets.UTF_8));
            HttpUtil.setContentLength((HttpMessage)response, (long)((String)body).length());
        } else {
            response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.UNAUTHORIZED);
        }
        response.headers().set((CharSequence)HttpHeaderNames.WWW_AUTHENTICATE, (Object)WWW_AUTHENTICATE_REALM_MESSAGE);
        channel.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    @VisibleForTesting
    boolean authorized() {
        return this.authorizedUser != null;
    }

    @VisibleForTesting
    static Tuple<String, SecureString> credentialsFromRequest(HttpRequest request, @Nullable SSLSession session, Settings settings) {
        String username = null;
        if (request.headers().contains(HttpHeaderNames.AUTHORIZATION.toString())) {
            return Headers.extractCredentialsFromHttpBasicAuthHeader((String)request.headers().get(HttpHeaderNames.AUTHORIZATION.toString()));
        }
        if (session != null) {
            try {
                Certificate certificate = session.getPeerCertificates()[0];
                username = SSL.extractCN((Certificate)certificate);
            }
            catch (ArrayIndexOutOfBoundsException | SSLPeerUnverifiedException exception) {
                // empty catch block
            }
        }
        if (username == null) {
            username = (String)AuthSettings.AUTH_TRUST_HTTP_DEFAULT_HEADER.setting().get(settings);
        }
        return new Tuple(username, null);
    }

    private InetAddress addressFromRequestOrChannel(HttpRequest request, Channel channel) {
        if (request.headers().contains("X-Real-Ip")) {
            return InetAddresses.forString((String)request.headers().get("X-Real-Ip"));
        }
        return Netty4HttpServerTransport.getRemoteAddress((Channel)channel);
    }
}

