/*
 * Decompiled with CFR 0.152.
 */
package io.crate.plugin;

import io.crate.metadata.UsersMetadata;
import io.crate.metadata.UsersPrivilegesMetadata;
import io.crate.plugin.AuthenticationModule;
import io.crate.plugin.UserManagementModule;
import io.crate.scalar.UsersScalarFunctionModule;
import io.crate.user.UserExtension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;

public class EnterpriseUsersExtension
implements UserExtension {
    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        ArrayList<NamedWriteableRegistry.Entry> entries = new ArrayList<NamedWriteableRegistry.Entry>(4);
        entries.add(new NamedWriteableRegistry.Entry(Metadata.Custom.class, "users", UsersMetadata::new));
        entries.add(new NamedWriteableRegistry.Entry(NamedDiff.class, "users", in -> UsersMetadata.readDiffFrom(Metadata.Custom.class, (String)"users", (StreamInput)in)));
        entries.add(new NamedWriteableRegistry.Entry(Metadata.Custom.class, "users_privileges", UsersPrivilegesMetadata::new));
        entries.add(new NamedWriteableRegistry.Entry(NamedDiff.class, "users_privileges", in -> UsersPrivilegesMetadata.readDiffFrom(Metadata.Custom.class, (String)"users_privileges", (StreamInput)in)));
        return entries;
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        ArrayList<NamedXContentRegistry.Entry> entries = new ArrayList<NamedXContentRegistry.Entry>(2);
        entries.add(new NamedXContentRegistry.Entry(Metadata.Custom.class, new ParseField("users", new String[0]), UsersMetadata::fromXContent));
        entries.add(new NamedXContentRegistry.Entry(Metadata.Custom.class, new ParseField("users_privileges", new String[0]), UsersPrivilegesMetadata::fromXContent));
        return entries;
    }

    public Collection<Module> getModules(Settings settings) {
        return Arrays.asList(new Module[]{new UserManagementModule(), new AuthenticationModule(settings), new UsersScalarFunctionModule()});
    }
}

