/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.sys;

import io.crate.analyze.user.Privilege;
import io.crate.auth.user.User;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.RelationName;
import io.crate.metadata.SystemTable;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.util.stream.StreamSupport;

public class SysPrivilegesTableInfo {
    private static final RelationName IDENT = new RelationName("sys", "privileges");

    public static SystemTable<PrivilegeRow> create() {
        return SystemTable.builder((RelationName)IDENT).add("grantee", (DataType)DataTypes.STRING, x -> x.grantee).add("grantor", (DataType)DataTypes.STRING, x -> x.privilege.grantor()).add("state", (DataType)DataTypes.STRING, x -> x.privilege.state().toString()).add("type", (DataType)DataTypes.STRING, x -> x.privilege.ident().type().toString()).add("class", (DataType)DataTypes.STRING, x -> x.privilege.ident().clazz().toString()).add("ident", (DataType)DataTypes.STRING, x -> x.privilege.ident().ident()).setPrimaryKeys(new ColumnIdent[]{new ColumnIdent("grantee"), new ColumnIdent("state"), new ColumnIdent("type"), new ColumnIdent("class"), new ColumnIdent("ident")}).build();
    }

    public static Iterable<PrivilegeRow> buildPrivilegesRows(Iterable<User> users) {
        return () -> StreamSupport.stream(users.spliterator(), false).flatMap(u -> StreamSupport.stream(u.privileges().spliterator(), false).map(p -> new PrivilegeRow(u.name(), (Privilege)p))).iterator();
    }

    public static class PrivilegeRow {
        private final String grantee;
        private final Privilege privilege;

        PrivilegeRow(String grantee, Privilege privilege) {
            this.grantee = grantee;
            this.privilege = privilege;
        }
    }
}

