/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import com.google.common.annotations.VisibleForTesting;
import io.crate.analyze.user.Privilege;
import io.crate.analyze.user.PrivilegeIdent;
import io.crate.metadata.RelationName;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class UsersPrivilegesMetadata
extends AbstractNamedDiffable<Metadata.Custom>
implements Metadata.Custom {
    public static final String TYPE = "users_privileges";
    private final Map<String, Set<Privilege>> usersPrivileges;

    public static UsersPrivilegesMetadata copyOf(@Nullable UsersPrivilegesMetadata oldMetadata) {
        if (oldMetadata == null) {
            return new UsersPrivilegesMetadata();
        }
        HashMap<String, Set<Privilege>> userPrivileges = new HashMap<String, Set<Privilege>>(oldMetadata.usersPrivileges.size());
        for (Map.Entry<String, Set<Privilege>> entry : oldMetadata.usersPrivileges.entrySet()) {
            userPrivileges.put(entry.getKey(), new HashSet(entry.getValue()));
        }
        return new UsersPrivilegesMetadata(userPrivileges);
    }

    @Nullable
    public static UsersPrivilegesMetadata maybeCopyAndReplaceTableIdents(UsersPrivilegesMetadata oldMetadata, String sourceIdent, String targetIdent) {
        boolean privilegesChanged = false;
        HashMap<String, Set<Privilege>> userPrivileges = new HashMap<String, Set<Privilege>>(oldMetadata.usersPrivileges.size());
        for (Map.Entry<String, Set<Privilege>> entry : oldMetadata.usersPrivileges.entrySet()) {
            HashSet<Privilege> privileges = new HashSet<Privilege>(entry.getValue().size());
            for (Privilege privilege : entry.getValue()) {
                PrivilegeIdent privilegeIdent = privilege.ident();
                if (!privilegeIdent.clazz().equals((Object)Privilege.Clazz.TABLE)) {
                    privileges.add(privilege);
                    continue;
                }
                String ident = privilegeIdent.ident();
                assert (ident != null) : "ident must not be null for privilege class 'TABLE'";
                if (ident.equals(sourceIdent)) {
                    privileges.add(new Privilege(privilege.state(), privilegeIdent.type(), privilegeIdent.clazz(), targetIdent, privilege.grantor()));
                    privilegesChanged = true;
                    continue;
                }
                privileges.add(privilege);
            }
            userPrivileges.put(entry.getKey(), privileges);
        }
        if (privilegesChanged) {
            return new UsersPrivilegesMetadata(userPrivileges);
        }
        return null;
    }

    @VisibleForTesting
    public UsersPrivilegesMetadata() {
        this.usersPrivileges = new HashMap<String, Set<Privilege>>();
    }

    @VisibleForTesting
    public UsersPrivilegesMetadata(Map<String, Set<Privilege>> usersPrivileges) {
        this.usersPrivileges = usersPrivileges;
    }

    public static UsersPrivilegesMetadata swapPrivileges(UsersPrivilegesMetadata usersPrivileges, RelationName source, RelationName target) {
        HashMap<String, Set<Privilege>> privilegesByUser = new HashMap<String, Set<Privilege>>();
        for (Map.Entry<String, Set<Privilege>> userPrivileges : usersPrivileges.usersPrivileges.entrySet()) {
            String user = userPrivileges.getKey();
            Set<Privilege> privileges = userPrivileges.getValue();
            HashSet<Privilege> updatedPrivileges = new HashSet<Privilege>();
            for (Privilege privilege : privileges) {
                PrivilegeIdent ident = privilege.ident();
                if (ident.clazz() == Privilege.Clazz.TABLE) {
                    if (source.fqn().equals(ident.ident())) {
                        updatedPrivileges.add(new Privilege(privilege.state(), ident.type(), ident.clazz(), target.fqn(), privilege.grantor()));
                        continue;
                    }
                    if (target.fqn().equals(ident.ident())) {
                        updatedPrivileges.add(new Privilege(privilege.state(), ident.type(), ident.clazz(), source.fqn(), privilege.grantor()));
                        continue;
                    }
                    updatedPrivileges.add(privilege);
                    continue;
                }
                updatedPrivileges.add(privilege);
            }
            privilegesByUser.put(user, updatedPrivileges);
        }
        return new UsersPrivilegesMetadata(privilegesByUser);
    }

    public long applyPrivileges(Collection<String> userNames, Iterable<Privilege> newPrivileges) {
        long affectedPrivileges = 0L;
        for (String userName : userNames) {
            affectedPrivileges += this.applyPrivilegesToUser(userName, newPrivileges);
        }
        return affectedPrivileges;
    }

    private long applyPrivilegesToUser(String userName, Iterable<Privilege> newPrivileges) {
        Set<Privilege> userPrivileges = this.usersPrivileges.get(userName);
        assert (userPrivileges != null) : "privileges must not be null for user=" + userName;
        long affectedCount = 0L;
        for (Privilege newPrivilege : newPrivileges) {
            Iterator<Privilege> iterator = userPrivileges.iterator();
            boolean userHadPrivilegeOnSameObject = false;
            while (iterator.hasNext()) {
                Privilege userPrivilege = iterator.next();
                PrivilegeIdent privilegeIdent = userPrivilege.ident();
                if (!privilegeIdent.equals((Object)newPrivilege.ident())) continue;
                userHadPrivilegeOnSameObject = true;
                if (newPrivilege.state().equals((Object)Privilege.State.REVOKE)) {
                    iterator.remove();
                    ++affectedCount;
                    break;
                }
                if (userPrivilege.equals((Object)newPrivilege)) break;
                iterator.remove();
                userPrivileges.add(newPrivilege);
                ++affectedCount;
                break;
            }
            if (userHadPrivilegeOnSameObject || newPrivilege.state().equals((Object)Privilege.State.REVOKE)) continue;
            ++affectedCount;
            userPrivileges.add(newPrivilege);
        }
        return affectedCount;
    }

    public long dropTableOrViewPrivileges(String tableOrViewIdent) {
        long affectedPrivileges = 0L;
        for (Set<Privilege> privileges : this.usersPrivileges.values()) {
            Iterator<Privilege> privilegeIterator = privileges.iterator();
            while (privilegeIterator.hasNext()) {
                Privilege privilege = privilegeIterator.next();
                PrivilegeIdent privilegeIdent = privilege.ident();
                Privilege.Clazz clazz = privilegeIdent.clazz();
                if (!clazz.equals((Object)Privilege.Clazz.TABLE) && !clazz.equals((Object)Privilege.Clazz.VIEW)) continue;
                String ident = privilegeIdent.ident();
                assert (ident != null) : "ident must not be null for privilege class 'TABLE'";
                if (!ident.equals(tableOrViewIdent)) continue;
                privilegeIterator.remove();
                ++affectedPrivileges;
            }
        }
        return affectedPrivileges;
    }

    @Nullable
    public Set<Privilege> getUserPrivileges(String userName) {
        return this.usersPrivileges.get(userName);
    }

    public void createPrivileges(String userName, Set<Privilege> privileges) {
        this.usersPrivileges.put(userName, privileges);
    }

    public void dropPrivileges(String userName) {
        this.usersPrivileges.remove(userName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        UsersPrivilegesMetadata that = (UsersPrivilegesMetadata)((Object)o);
        return Objects.equals(this.usersPrivileges, that.usersPrivileges);
    }

    public int hashCode() {
        return Objects.hash(this.usersPrivileges);
    }

    public UsersPrivilegesMetadata(StreamInput in) throws IOException {
        int numUsersPrivileges = in.readVInt();
        this.usersPrivileges = new HashMap<String, Set<Privilege>>(numUsersPrivileges);
        for (int i = 0; i < numUsersPrivileges; ++i) {
            String userName = in.readString();
            int numPrivileges = in.readVInt();
            HashSet<Privilege> privileges = new HashSet<Privilege>(numPrivileges);
            for (int j = 0; j < numPrivileges; ++j) {
                privileges.add(new Privilege(in));
            }
            this.usersPrivileges.put(userName, privileges);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.usersPrivileges.size());
        for (Map.Entry<String, Set<Privilege>> entry : this.usersPrivileges.entrySet()) {
            out.writeString(entry.getKey());
            out.writeVInt(entry.getValue().size());
            for (Privilege privilege : entry.getValue()) {
                privilege.writeTo(out);
            }
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        for (Map.Entry<String, Set<Privilege>> entry : this.usersPrivileges.entrySet()) {
            builder.startArray(entry.getKey());
            for (Privilege privilege : entry.getValue()) {
                UsersPrivilegesMetadata.privilegeToXContent(privilege, builder);
            }
            builder.endArray();
        }
        return builder;
    }

    public static UsersPrivilegesMetadata fromXContent(XContentParser parser) throws IOException {
        UsersPrivilegesMetadata metadata = new UsersPrivilegesMetadata();
        while (parser.nextToken() == XContentParser.Token.FIELD_NAME) {
            XContentParser.Token token;
            String userName = parser.currentName();
            Set<Privilege> privileges = metadata.getUserPrivileges(userName);
            if (privileges == null) {
                privileges = new HashSet<Privilege>();
                metadata.createPrivileges(userName, privileges);
            }
            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                if (token != XContentParser.Token.START_OBJECT) continue;
                UsersPrivilegesMetadata.privilegeFromXContent(parser, privileges);
            }
        }
        return metadata;
    }

    public EnumSet<Metadata.XContentContext> context() {
        return EnumSet.of(Metadata.XContentContext.GATEWAY, Metadata.XContentContext.SNAPSHOT);
    }

    private static void privilegeToXContent(Privilege privilege, XContentBuilder builder) throws IOException {
        builder.startObject().field("state", privilege.state().ordinal()).field("type", privilege.ident().type().ordinal()).field("class", privilege.ident().clazz().ordinal()).field("ident", privilege.ident().ident()).field("grantor", privilege.grantor()).endObject();
    }

    private static void privilegeFromXContent(XContentParser parser, Set<Privilege> privileges) throws IOException {
        XContentParser.Token currentToken;
        Privilege.State state = null;
        Privilege.Type type = null;
        Privilege.Clazz clazz = null;
        String ident = null;
        String grantor = null;
        block14: while ((currentToken = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (currentToken == XContentParser.Token.FIELD_NAME) {
                String currentFieldName = parser.currentName();
                currentToken = parser.nextToken();
                switch (currentFieldName) {
                    case "state": {
                        if (currentToken != XContentParser.Token.VALUE_NUMBER) {
                            throw new ElasticsearchParseException("failed to parse privilege, 'state' value is not a number [{}]", new Object[]{currentToken});
                        }
                        state = Privilege.State.values()[parser.intValue()];
                        continue block14;
                    }
                    case "type": {
                        if (currentToken != XContentParser.Token.VALUE_NUMBER) {
                            throw new ElasticsearchParseException("failed to parse privilege, 'type' value is not a number [{}]", new Object[]{currentToken});
                        }
                        type = Privilege.Type.values()[parser.intValue()];
                        continue block14;
                    }
                    case "class": {
                        if (currentToken != XContentParser.Token.VALUE_NUMBER) {
                            throw new ElasticsearchParseException("failed to parse privilege, 'class' value is not a number [{}]", new Object[]{currentToken});
                        }
                        clazz = Privilege.Clazz.values()[parser.intValue()];
                        continue block14;
                    }
                    case "ident": {
                        if (currentToken != XContentParser.Token.VALUE_STRING && currentToken != XContentParser.Token.VALUE_NULL) {
                            throw new ElasticsearchParseException("failed to parse privilege, 'ident' value is not a string or null [{}]", new Object[]{currentToken});
                        }
                        ident = parser.textOrNull();
                        continue block14;
                    }
                    case "grantor": {
                        if (currentToken != XContentParser.Token.VALUE_STRING) {
                            throw new ElasticsearchParseException("failed to parse privilege, 'grantor' value is not a string [{}]", new Object[]{currentToken});
                        }
                        grantor = parser.text();
                        continue block14;
                    }
                }
                throw new ElasticsearchParseException("failed to parse privilege", new Object[0]);
            }
            if (currentToken != XContentParser.Token.END_ARRAY) continue;
            return;
        }
        privileges.add(new Privilege(state, type, clazz, ident, grantor));
    }

    public String getWriteableName() {
        return TYPE;
    }

    public Version getMinimalSupportedVersion() {
        return Version.V_3_0_1;
    }
}

