/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import io.crate.user.SecureHash;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class UsersMetadata
extends AbstractNamedDiffable<Metadata.Custom>
implements Metadata.Custom {
    public static final String TYPE = "users";
    private final Map<String, SecureHash> users;

    public UsersMetadata() {
        this.users = new HashMap<String, SecureHash>();
    }

    public UsersMetadata(Map<String, SecureHash> users) {
        this.users = users;
    }

    public static UsersMetadata newInstance(@Nullable UsersMetadata instance) {
        if (instance == null) {
            return new UsersMetadata();
        }
        return new UsersMetadata(new HashMap<String, SecureHash>(instance.users));
    }

    public boolean contains(String name) {
        return this.users.containsKey(name);
    }

    public void put(String name, @Nullable SecureHash secureHash) {
        this.users.put(name, secureHash);
    }

    public void remove(String name) {
        this.users.remove(name);
    }

    public List<String> userNames() {
        return new ArrayList<String>(this.users.keySet());
    }

    public Map<String, SecureHash> users() {
        return this.users;
    }

    public UsersMetadata(StreamInput in) throws IOException {
        int numUsers = in.readVInt();
        this.users = new HashMap<String, SecureHash>(numUsers);
        for (int i = 0; i < numUsers; ++i) {
            String userName = in.readString();
            SecureHash secureHash = (SecureHash)in.readOptionalWriteable(SecureHash::readFrom);
            this.users.put(userName, secureHash);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.users.size());
        for (Map.Entry<String, SecureHash> user : this.users.entrySet()) {
            out.writeString(user.getKey());
            out.writeOptionalWriteable((Writeable)user.getValue());
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(TYPE);
        for (Map.Entry<String, SecureHash> entry : this.users.entrySet()) {
            builder.startObject(entry.getKey());
            if (entry.getValue() != null) {
                entry.getValue().toXContent(builder, params);
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public static UsersMetadata fromXContent(XContentParser parser) throws IOException {
        HashMap<String, SecureHash> users = new HashMap<String, SecureHash>();
        XContentParser.Token token = parser.nextToken();
        if (token == XContentParser.Token.FIELD_NAME && parser.currentName().equals(TYPE)) {
            token = parser.nextToken();
            if (token == XContentParser.Token.START_ARRAY) {
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY && token != null) {
                    users.put(parser.text(), null);
                }
            } else if (token == XContentParser.Token.START_OBJECT) {
                while (parser.nextToken() == XContentParser.Token.FIELD_NAME) {
                    String userName = parser.currentName();
                    if (parser.nextToken() != XContentParser.Token.START_OBJECT) continue;
                    users.put(userName, SecureHash.fromXContent((XContentParser)parser));
                }
            }
            if (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                throw new ElasticsearchParseException("failed to parse users, expected an object token at the end", new Object[0]);
            }
        }
        return new UsersMetadata(users);
    }

    public EnumSet<Metadata.XContentContext> context() {
        return EnumSet.of(Metadata.XContentContext.GATEWAY, Metadata.XContentContext.SNAPSHOT);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        UsersMetadata that = (UsersMetadata)((Object)o);
        return this.users.equals(that.users);
    }

    public int hashCode() {
        return Objects.hash(this.users);
    }

    public String getWriteableName() {
        return TYPE;
    }

    public Version getMinimalSupportedVersion() {
        return Version.V_3_0_1;
    }
}

